/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.ExperimentConfigData;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ConfigDataResource.class);
    private ExperimentResource experimentResource;
    private boolean airavataAutoSchedule;
    private boolean overrideManualParams;
    private boolean shareExp;

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public boolean isAiravataAutoSchedule() {
        return this.airavataAutoSchedule;
    }

    public void setAiravataAutoSchedule(boolean airavataAutoSchedule) {
        this.airavataAutoSchedule = airavataAutoSchedule;
    }

    public boolean isOverrideManualParams() {
        return this.overrideManualParams;
    }

    public void setOverrideManualParams(boolean overrideManualParams) {
        this.overrideManualParams = overrideManualParams;
    }

    public boolean isShareExp() {
        return this.shareExp;
    }

    public void setShareExp(boolean shareExp) {
        this.shareExp = shareExp;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for config data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for config data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for config data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for config data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            ExperimentConfigData existingConfig = (ExperimentConfigData)em.find(ExperimentConfigData.class, (Object)this.experimentResource.getExpID());
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ExperimentConfigData configData = new ExperimentConfigData();
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            configData.setExpId(this.experimentResource.getExpID());
            configData.setExperiment(experiment);
            configData.setAiravataAutoSchedule(this.airavataAutoSchedule);
            configData.setOverrideManualParams(this.overrideManualParams);
            configData.setShareExp(this.shareExp);
            if (existingConfig != null) {
                existingConfig.setExpId(this.experimentResource.getExpID());
                existingConfig.setExperiment(experiment);
                existingConfig.setAiravataAutoSchedule(this.airavataAutoSchedule);
                existingConfig.setOverrideManualParams(this.overrideManualParams);
                existingConfig.setShareExp(this.shareExp);
                configData = (ExperimentConfigData)em.merge((Object)existingConfig);
            } else {
                em.persist((Object)configData);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

