/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationInput;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationInput_PK;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInputResource.class);
    private TaskDetailResource taskDetailResource;
    private String inputKey;
    private String inputType;
    private String metadata;
    private String value;

    public String getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for application input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for application input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for application input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for application input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            ApplicationInput existingInput = (ApplicationInput)em.find(ApplicationInput.class, (Object)new ApplicationInput_PK(this.inputKey, this.taskDetailResource.getTaskId()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationInput applicationInput = new ApplicationInput();
            TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
            applicationInput.setTask(taskDetail);
            applicationInput.setTaskId(taskDetail.getTaskId());
            applicationInput.setInputKey(this.inputKey);
            applicationInput.setInputKeyType(this.inputType);
            applicationInput.setValue(this.value);
            applicationInput.setMetadata(this.metadata);
            if (existingInput != null) {
                existingInput.setTask(taskDetail);
                existingInput.setTaskId(taskDetail.getTaskId());
                existingInput.setInputKey(this.inputKey);
                existingInput.setInputKeyType(this.inputType);
                existingInput.setValue(this.value);
                existingInput.setMetadata(this.metadata);
                applicationInput = (ApplicationInput)em.merge((Object)existingInput);
            } else {
                em.persist((Object)applicationInput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

