/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorResource.class);
    private String name;
    private String gatewayName;
    private String updatedUser;
    private String content;
    private String hostDescName;
    private String serviceDescName;

    public ApplicationDescriptorResource(String name, String gatewayName) {
        this.setName(name);
        this.gatewayName = gatewayName;
    }

    public ApplicationDescriptorResource() {
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public void setUpdatedUser(String updatedUser) {
        this.updatedUser = updatedUser;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getHostDescName() {
        return this.hostDescName;
    }

    public String getServiceDescName() {
        return this.serviceDescName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setHostDescName(String hostDescName) {
        this.hostDescName = hostDescName;
    }

    public void setServiceDescName(String serviceDescName) {
        this.serviceDescName = serviceDescName;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported operation for application descriptor resource since application descriptors could not create child resources.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported operation for application descriptor resource since application descriptors could not remove child resources.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator queryGenerator = new QueryGenerator("Application_Descriptor", new Object[0][]);
        queryGenerator.setParameter("gateway_name", keys[0]);
        queryGenerator.setParameter("application_descriptor_ID", keys[1]);
        queryGenerator.setParameter("host_descriptor_ID", keys[2]);
        queryGenerator.setParameter("service_descriptor_ID", keys[3]);
        Query q = queryGenerator.selectQuery(em);
        Application_Descriptor applicationDescriptor = (Application_Descriptor)q.getSingleResult();
        ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, applicationDescriptor);
        em.getTransaction().commit();
        em.close();
        list.add(applicationDescriptorResource);
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            Application_Descriptor existingAppDesc = (Application_Descriptor)em.find(Application_Descriptor.class, (Object)new Application_Descriptor_PK(this.gatewayName, this.name));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Application_Descriptor applicationDescriptor = new Application_Descriptor();
            applicationDescriptor.setApplication_descriptor_ID(this.getName());
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
            Users user = (Users)em.find(Users.class, (Object)this.updatedUser);
            applicationDescriptor.setGateway(gateway);
            applicationDescriptor.setUser(user);
            byte[] contentBytes = this.content.getBytes();
            applicationDescriptor.setApplication_descriptor_xml(contentBytes);
            applicationDescriptor.setService_descriptor_ID(this.serviceDescName);
            applicationDescriptor.setHost_descriptor_ID(this.hostDescName);
            if (existingAppDesc != null) {
                existingAppDesc.setUser(user);
                existingAppDesc.setApplication_descriptor_xml(contentBytes);
                existingAppDesc.setHost_descriptor_ID(this.hostDescName);
                existingAppDesc.setService_descriptor_ID(this.serviceDescName);
                applicationDescriptor = (Application_Descriptor)em.merge((Object)existingAppDesc);
            } else {
                em.persist((Object)applicationDescriptor);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        this.name = name;
    }
}

