/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWorkflowResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(PublishWorkflowResource.class);
    private String name;
    private String version;
    private Timestamp publishedDate;
    private String content;
    private GatewayResource gateway;
    private String createdUser;
    private String path;

    public PublishWorkflowResource() {
    }

    public PublishWorkflowResource(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public String getCreatedUser() {
        return this.createdUser;
    }

    public String getPath() {
        return this.path;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Timestamp getPublishedDate() {
        return this.publishedDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPublishedDate(Timestamp publishedDate) {
        this.publishedDate = publishedDate;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
        generator.setParameter("gateway_name", keys[0]);
        generator.setParameter("publish_workflow_name", keys[1]);
        Query q = generator.selectQuery(em);
        Published_Workflow publishedWorkflow = (Published_Workflow)q.getSingleResult();
        PublishWorkflowResource publishWorkflowResource = (PublishWorkflowResource)Utils.getResource(ResourceType.PUBLISHED_WORKFLOW, publishedWorkflow);
        em.getTransaction().commit();
        em.close();
        list.add(publishWorkflowResource);
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Published_Workflow existingWF = (Published_Workflow)em.find(Published_Workflow.class, (Object)new Published_Workflow_PK(this.gateway.getGatewayName(), this.name));
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Published_Workflow publishedWorkflow = new Published_Workflow();
        publishedWorkflow.setPublish_workflow_name(this.getName());
        publishedWorkflow.setPublished_date(this.publishedDate);
        publishedWorkflow.setVersion(this.version);
        byte[] bytes = this.content.getBytes();
        publishedWorkflow.setWorkflow_content(bytes);
        Gateway gateway = new Gateway();
        gateway.setGateway_name(this.gateway.getGatewayName());
        publishedWorkflow.setGateway(gateway);
        Users user = new Users();
        user.setUser_name(this.createdUser);
        publishedWorkflow.setUser(user);
        if (existingWF != null) {
            existingWF.setUser(user);
            existingWF.setPublished_date(this.publishedDate);
            existingWF.setWorkflow_content(bytes);
            existingWF.setVersion(this.version);
            existingWF.setPath(this.path);
            publishedWorkflow = (Published_Workflow)em.merge((Object)existingWF);
        } else {
            em.merge((Object)publishedWorkflow);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public void setName(String name) {
        this.name = name;
    }
}

