/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.server;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.airavata.common.exception.AiravataConfigurationException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataZKUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.cpi.BetterGfacImpl;
import org.apache.airavata.gfac.core.cpi.GFac;
import org.apache.airavata.gfac.core.notification.MonitorPublisher;
import org.apache.airavata.gfac.cpi.GfacService;
import org.apache.airavata.persistance.registry.jpa.impl.RegistryFactory;
import org.apache.airavata.registry.api.AiravataRegistryFactory;
import org.apache.airavata.registry.api.AiravataUser;
import org.apache.airavata.registry.api.Gateway;
import org.apache.airavata.registry.api.exception.RegException;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.thrift.TException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GfacServerHandler
implements GfacService.Iface,
Watcher {
    private static final Logger logger = LoggerFactory.getLogger(GfacServerHandler.class);
    private Registry registry;
    private String registryURL;
    private String gatewayName;
    private String airavataUserName;
    private ZooKeeper zk;
    private boolean connected = false;
    private static Integer mutex = new Integer(-1);
    private MonitorPublisher publisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GfacServerHandler() {
        try {
            String zkhostPort = AiravataZKUtils.getZKhostPort();
            String airavataServerHostPort = ServerSettings.getSetting((String)"gfac.server.host") + ":" + ServerSettings.getSetting((String)"gfac.server.port");
            try {
                this.zk = new ZooKeeper(zkhostPort, 6000, (Watcher)this);
                String gfacServer = ServerSettings.getSetting((String)"gfac-server", (String)"/gfac-server");
                String gfacExperiments = ServerSettings.getSetting((String)"gfac-experiments", (String)"/gfac-experiments");
                Integer n = mutex;
                synchronized (n) {
                    mutex.wait();
                }
                Stat zkStat = this.zk.exists(gfacServer, false);
                if (zkStat == null) {
                    this.zk.create(gfacServer, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                String instanceId = ServerSettings.getSetting((String)"gfac-server-name");
                String instantNode = gfacServer + File.separator + instanceId;
                zkStat = this.zk.exists(instantNode, false);
                if (zkStat == null) {
                    this.zk.create(instantNode, airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                }
                if ((zkStat = this.zk.exists(gfacExperiments, false)) == null) {
                    this.zk.create(gfacExperiments, airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                if ((zkStat = this.zk.exists(gfacExperiments + File.separator + instanceId, false)) == null) {
                    this.zk.create(gfacExperiments + File.separator + instanceId, airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                } else {
                    logger.error(" Zookeeper is inconsistent state  !!!!!");
                }
                logger.info("Finished starting ZK: " + this.zk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
        try {
            this.publisher = new MonitorPublisher(new EventBus());
            BetterGfacImpl.setMonitorPublisher((MonitorPublisher)this.publisher);
            this.registry = RegistryFactory.getDefaultRegistry();
            this.setGatewayProperties();
            BetterGfacImpl.startDaemonHandlers();
            BetterGfacImpl.startStatusUpdators((Registry)this.registry, (ZooKeeper)this.zk, (MonitorPublisher)this.publisher);
        }
        catch (Exception e) {
            logger.error("Error initialising GFAC", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(WatchedEvent watchedEvent) {
        Integer n = mutex;
        synchronized (n) {
            Watcher.Event.KeeperState state = watchedEvent.getState();
            if (state == Watcher.Event.KeeperState.SyncConnected) {
                mutex.notify();
                this.connected = true;
            } else if (state == Watcher.Event.KeeperState.Expired || state == Watcher.Event.KeeperState.Disconnected) {
                try {
                    this.zk = new ZooKeeper(AiravataZKUtils.getZKhostPort(), 6000, (Watcher)this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ApplicationSettingsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getGFACServiceVersion() throws TException {
        return "0.13.0";
    }

    @Override
    public boolean submitJob(String experimentId, String taskId, String gatewayId) throws TException {
        logger.info("GFac Recieved the Experiment: " + experimentId + " TaskId: " + taskId);
        GFac gfac = this.getGfac();
        try {
            return gfac.submitJob(experimentId, taskId, gatewayId);
        }
        catch (GFacException e) {
            throw new TException("Error launching the experiment : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean cancelJob(String experimentId, String taskId) throws TException {
        throw new TException("Operation not supported");
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(String registryURL) {
        this.registryURL = registryURL;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getAiravataUserName() {
        return this.airavataUserName;
    }

    public void setAiravataUserName(String airavataUserName) {
        this.airavataUserName = airavataUserName;
    }

    protected void setGatewayProperties() throws ApplicationSettingsException {
        this.setAiravataUserName(ServerSettings.getSetting((String)"system.user"));
        this.setGatewayName(ServerSettings.getSetting((String)"system.gateway"));
        this.setRegistryURL(ServerSettings.getSetting((String)"airavata.server.url"));
    }

    private GFac getGfac() throws TException {
        try {
            return new BetterGfacImpl(this.registry, null, AiravataRegistryFactory.getRegistry((Gateway)new Gateway(this.getGatewayName()), (AiravataUser)new AiravataUser(this.getAiravataUserName())), this.zk, this.publisher);
        }
        catch (RegException e) {
            throw new TException("Error initializing gfac instance", (Throwable)e);
        }
        catch (AiravataConfigurationException e) {
            throw new TException("Error initializing gfac instance", (Throwable)e);
        }
    }
}

