/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.server;

import org.apache.airavata.common.exception.AiravataConfigurationException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.cpi.GFac;
import org.apache.airavata.gfac.core.cpi.GFacImpl;
import org.apache.airavata.gfac.cpi.GfacService;
import org.apache.airavata.persistance.registry.jpa.impl.RegistryFactory;
import org.apache.airavata.registry.api.AiravataRegistryFactory;
import org.apache.airavata.registry.api.AiravataUser;
import org.apache.airavata.registry.api.Gateway;
import org.apache.airavata.registry.api.exception.RegException;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GfacServerHandler
implements GfacService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(GfacServerHandler.class);
    private Registry registry;
    private String registryURL;
    private String gatewayName;
    private String airavataUserName;

    public GfacServerHandler() {
        try {
            this.registry = RegistryFactory.getDefaultRegistry();
            this.setGatewayProperties();
        }
        catch (Exception e) {
            logger.error("Error initialising GFAC", (Throwable)e);
        }
    }

    @Override
    public String getGFACServiceVersion() throws TException {
        return "0.12.0";
    }

    @Override
    public boolean submitJob(String experimentId, String taskId) throws TException {
        GFac gfac = this.getGfac();
        try {
            return gfac.submitJob(experimentId, taskId);
        }
        catch (GFacException e) {
            throw new TException("Error launching the experiment : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean cancelJob(String experimentId, String taskId) throws TException {
        throw new TException("Operation not supported");
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(String registryURL) {
        this.registryURL = registryURL;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getAiravataUserName() {
        return this.airavataUserName;
    }

    public void setAiravataUserName(String airavataUserName) {
        this.airavataUserName = airavataUserName;
    }

    protected void setGatewayProperties() throws ApplicationSettingsException {
        this.setAiravataUserName(ServerSettings.getProperties().getProperty("system.user"));
        this.setGatewayName(ServerSettings.getProperties().getProperty("system.gateway"));
        this.setRegistryURL(ServerSettings.getProperties().getProperty("airavata.server.url"));
    }

    private GFac getGfac() throws TException {
        try {
            return new GFacImpl(this.registry, null, AiravataRegistryFactory.getRegistry((Gateway)new Gateway(this.getGatewayName()), (AiravataUser)new AiravataUser(this.getAiravataUserName())));
        }
        catch (RegException e) {
            throw new TException("Error initializing gfac instance", (Throwable)e);
        }
        catch (AiravataConfigurationException e) {
            throw new TException("Error initializing gfac instance", (Throwable)e);
        }
    }
}

