/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.logger.AiravataLogger;
import org.apache.airavata.common.logger.AiravataLoggerFactory;
import org.apache.airavata.common.utils.AiravataZKUtils;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerConfig;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.monitor.HostMonitorData;
import org.apache.airavata.gfac.monitor.UserMonitorData;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class CommonUtils {
    private static final AiravataLogger logger = AiravataLoggerFactory.getLogger(CommonUtils.class);

    public static String getChannelID(MonitorID monitorID) {
        return monitorID.getUserName() + "-" + monitorID.getComputeResourceDescription().getHostName();
    }

    public static String getRoutingKey(MonitorID monitorID) {
        return "*." + monitorID.getUserName() + "." + (String)monitorID.getComputeResourceDescription().getIpAddresses().get(0);
    }

    public static String getChannelID(String userName, String hostAddress) {
        return userName + "-" + hostAddress;
    }

    public static String getRoutingKey(String userName, String hostAddress) {
        return "*." + userName + "." + hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMonitortoQueue(BlockingQueue<UserMonitorData> queue, MonitorID monitorID, JobExecutionContext jobExecutionContext) throws AiravataMonitorException {
        BlockingQueue<UserMonitorData> blockingQueue = queue;
        synchronized (blockingQueue) {
            for (UserMonitorData next : queue) {
                if (!next.getUserName().equals(monitorID.getUserName())) continue;
                List<HostMonitorData> monitorIDs = next.getHostMonitorData();
                for (HostMonitorData host : monitorIDs) {
                    if (!CommonUtils.isEqual(host.getComputeResourceDescription(), monitorID.getComputeResourceDescription())) continue;
                    host.addMonitorIDForHost(monitorID);
                    logger.debugId(monitorID.getJobID(), "Added new job to the monitoring queue, experiment {}, task {}", (Object)monitorID.getExperimentID(), (Object)monitorID.getTaskID());
                    return;
                }
                HostMonitorData hostMonitorData = new HostMonitorData(jobExecutionContext);
                hostMonitorData.addMonitorIDForHost(monitorID);
                next.addHostMonitorData(hostMonitorData);
                logger.debugId(monitorID.getJobID(), "Added new job to the monitoring queue, experiment {}, task {}", (Object)monitorID.getExperimentID(), (Object)monitorID.getTaskID());
                return;
            }
            HostMonitorData hostMonitorData = new HostMonitorData(jobExecutionContext);
            hostMonitorData.addMonitorIDForHost(monitorID);
            UserMonitorData userMonitorData = new UserMonitorData(monitorID.getUserName());
            userMonitorData.addHostMonitorData(hostMonitorData);
            try {
                queue.put(userMonitorData);
                logger.debugId(monitorID.getJobID(), "Added new job to the monitoring queue, experiment {}, task {}", (Object)monitorID.getExperimentID(), (Object)monitorID.getTaskID());
            }
            catch (InterruptedException e) {
                throw new AiravataMonitorException(e);
            }
        }
    }

    private static boolean isEqual(ComputeResourceDescription comRes_1, ComputeResourceDescription comRes_2) {
        return comRes_1.getComputeResourceId().equals(comRes_2.getComputeResourceId()) && comRes_1.getHostName().equals(comRes_2.getHostName());
    }

    public static boolean isTheLastJobInQueue(BlockingQueue<MonitorID> queue, MonitorID monitorID) {
        for (MonitorID next : queue) {
            if (!monitorID.getUserName().equals(next.getUserName()) || !CommonUtils.isEqual(monitorID.getComputeResourceDescription(), next.getComputeResourceDescription())) continue;
            return false;
        }
        return true;
    }

    public static void removeMonitorFromQueue(UserMonitorData userMonitorData, MonitorID monitorID) throws AiravataMonitorException {
        if (userMonitorData.getUserName().equals(monitorID.getUserName())) {
            List<HostMonitorData> hostMonitorData = userMonitorData.getHostMonitorData();
            for (HostMonitorData iHostMonitorID : hostMonitorData) {
                if (!CommonUtils.isEqual(iHostMonitorID.getComputeResourceDescription(), monitorID.getComputeResourceDescription())) continue;
                Iterator<MonitorID> iterator2 = iHostMonitorID.getMonitorIDs().iterator();
                while (iterator2.hasNext()) {
                    MonitorID iMonitorID = iterator2.next();
                    if (!iMonitorID.getJobID().equals(monitorID.getJobID()) && !iMonitorID.getJobName().equals(monitorID.getJobName())) continue;
                    iterator2.remove();
                    logger.infoId(monitorID.getJobID(), "Removed the jobId: {} JobName: {} from monitoring last status:{}", new Object[]{monitorID.getJobID(), monitorID.getJobName(), monitorID.getStatus().toString()});
                    return;
                }
            }
        }
        logger.info("Cannot find the given MonitorID in the queue with userName " + monitorID.getUserName() + "  and jobID " + monitorID.getJobID());
        logger.info("This might not be an error because someone else removed this job from the queue");
    }

    public static void invokeOutFlowHandlers(JobExecutionContext jobExecutionContext) throws GFacException {
        List handlers = jobExecutionContext.getGFacConfiguration().getOutHandlers();
        for (GFacHandlerConfig handlerClassName : handlers) {
            GFacHandler handler;
            try {
                Class<GFacHandler> handlerClass = Class.forName(handlerClassName.getClassName().trim()).asSubclass(GFacHandler.class);
                handler = handlerClass.newInstance();
                handler.initProperties(handlerClassName.getProperties());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot load handler class " + handlerClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot instantiate handler class " + handlerClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot instantiate handler class " + handlerClassName, (Throwable)e);
            }
            try {
                handler.invoke(jobExecutionContext);
            }
            catch (Exception e) {
                throw new GFacException("Error Executing a OutFlow Handler", (Throwable)e);
            }
        }
    }

    public static void updateZkWithJobCount(ZooKeeper zk, Map<String, Integer> changeCountMap, boolean isAdd) {
        StringBuilder changeZNodePaths = new StringBuilder();
        try {
            if (zk == null || !zk.getState().isConnected()) {
                try {
                    final CountDownLatch countDownLatch = new CountDownLatch(1);
                    zk = new ZooKeeper(AiravataZKUtils.getZKhostPort(), 6000, new Watcher(){

                        public void process(WatchedEvent event) {
                            countDownLatch.countDown();
                        }
                    });
                    countDownLatch.await();
                }
                catch (ApplicationSettingsException e) {
                    logger.error("Error while reading zookeeper hostport string");
                }
                catch (IOException e) {
                    logger.error("Error while reconnect attempt to zookeeper where zookeeper connection loss state");
                }
            }
            for (String path : changeCountMap.keySet()) {
                byte[] byteData;
                if (isAdd) {
                    CommonUtils.checkAndCreateZNode(zk, path);
                }
                if ((byteData = zk.getData(path, null, null)) == null) {
                    if (isAdd) {
                        zk.setData(path, String.valueOf(changeCountMap.get(path)).getBytes(), -1);
                    } else {
                        logger.warn("Couldn't reduce job count in " + path + " as it returns null data. Hence reset the job count to 0");
                        zk.setData(path, "0".getBytes(), -1);
                    }
                } else {
                    String nodeData = new String(byteData);
                    if (isAdd) {
                        zk.setData(path, String.valueOf(changeCountMap.get(path) + Integer.parseInt(nodeData)).getBytes(), -1);
                    } else {
                        int removeCount;
                        int previousCount = Integer.parseInt(nodeData);
                        if (previousCount >= (removeCount = changeCountMap.get(path).intValue())) {
                            zk.setData(path, String.valueOf(previousCount - removeCount).getBytes(), -1);
                        } else {
                            logger.error("Requested remove job count is " + removeCount + " which is higher than the existing job count " + previousCount + " in  " + path + " path.");
                        }
                    }
                }
                changeZNodePaths.append(path).append(":");
            }
            if (changeCountMap.size() > 0) {
                changeZNodePaths.deleteCharAt(changeZNodePaths.length() - 1);
                zk.setData("/stat", changeZNodePaths.toString().getBytes(), -1);
            }
        }
        catch (KeeperException e) {
            logger.error("Error while writing job count to zookeeper", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Error while writing job count to zookeeper", (Throwable)e);
        }
    }

    public static void increaseZkJobCount(MonitorID monitorID) {
        HashMap<String, Integer> addMap = new HashMap<String, Integer>();
        addMap.put(CommonUtils.getJobCountUpdatePath(monitorID), 1);
        CommonUtils.updateZkWithJobCount(monitorID.getJobExecutionContext().getZk(), addMap, true);
    }

    public static String getJobCountUpdatePath(MonitorID monitorID) {
        return "/" + "stat" + "/" + monitorID.getUserName() + "/" + monitorID.getComputeResourceDescription().getHostName() + "/" + "job";
    }

    private static void checkAndCreateZNode(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        if (zk.exists(path, null) == null) {
            if (path.lastIndexOf("/") > 1) {
                CommonUtils.checkAndCreateZNode(zk, path.substring(0, path.lastIndexOf("/")));
            }
            zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }
}

