/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.push.amqp;

import com.google.common.eventbus.Subscribe;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.gfac.monitor.util.CommonUtils;
import org.apache.airavata.model.messaging.event.JobStatusChangeEvent;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnRegisterWorker {
    private static final Logger logger = LoggerFactory.getLogger(UnRegisterWorker.class);
    private Map<String, Channel> availableChannels;

    public UnRegisterWorker(Map<String, Channel> channels) {
        this.availableChannels = channels;
    }

    @Subscribe
    private boolean unRegisterListener(JobStatusChangeEvent jobStatus, MonitorID monitorID) throws AiravataMonitorException {
        String channelID = CommonUtils.getChannelID(monitorID);
        if (JobState.FAILED.equals((Object)jobStatus.getState()) || JobState.COMPLETE.equals((Object)jobStatus.getState())) {
            Channel channel = this.availableChannels.get(channelID);
            if (channel == null) {
                logger.error("Already Unregistered the listener");
                throw new AiravataMonitorException("Already Unregistered the listener");
            }
            try {
                channel.queueUnbind(channel.queueDeclare().getQueue(), "glue2.computing_activity", CommonUtils.getRoutingKey(monitorID));
                channel.close();
                channel.getConnection().close();
                this.availableChannels.remove(channelID);
            }
            catch (IOException e) {
                logger.error("Error unregistering the listener");
                throw new AiravataMonitorException("Error unregistering the listener");
            }
        }
        return true;
    }
}

