/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.push.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.util.List;
import org.apache.airavata.common.utils.ServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFinishConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleJobFinishConsumer.class);
    private List<String> completedJobsFromPush;

    public SimpleJobFinishConsumer(List<String> completedJobsFromPush) {
        this.completedJobsFromPush = completedJobsFromPush;
    }

    public void listen() {
        try {
            String queueName = ServerSettings.getSetting((String)"gfac.server.port", (String)"8950");
            String uri = "amqp://localhost";
            ConnectionFactory connFactory = new ConnectionFactory();
            connFactory.setUri(uri);
            Connection conn = connFactory.newConnection();
            logger.info("--------Created the connection to Rabbitmq server successfully-------");
            final Channel ch = conn.createChannel();
            logger.info("--------Created the channel with Rabbitmq server successfully-------");
            ch.queueDeclare(queueName, false, false, false, null);
            logger.info("--------Declare the queue " + queueName + " in Rabbitmq server successfully-------");
            final QueueingConsumer consumer = new QueueingConsumer(ch);
            ch.basicConsume(queueName, (Consumer)consumer);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            QueueingConsumer.Delivery delivery = consumer.nextDelivery();
                            String message = new String(delivery.getBody());
                            logger.info("---------------- Job Finish message received:" + message + " --------------");
                            List list = SimpleJobFinishConsumer.this.completedJobsFromPush;
                            synchronized (list) {
                                SimpleJobFinishConsumer.this.completedJobsFromPush.add(message);
                            }
                            ch.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("--------Cannot connect to a RabbitMQ Server--------", (Throwable)ex);
                        return;
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            logger.error("Cannot connect to a RabbitMQ Server: ", (Throwable)ex);
            logger.info("------------- Push monitoring for HPC jobs is disabled -------------");
        }
    }
}

