/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.push.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.airavata.ComputingActivity;
import org.apache.airavata.gfac.monitor.core.MessageParser;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageParser
implements MessageParser {
    private static final Logger logger = LoggerFactory.getLogger(JSONMessageParser.class);

    @Override
    public JobState parseMessage(String message) throws AiravataMonitorException {
        logger.debug(message);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ComputingActivity computingActivity = (ComputingActivity)objectMapper.readValue(message.getBytes(), ComputingActivity.class);
            logger.info(computingActivity.getIDFromEndpoint());
            List<String> stateList = computingActivity.getState();
            JobState jobState = null;
            for (String aState : stateList) {
                jobState = this.getStatusFromString(aState);
            }
            return jobState;
        }
        catch (IOException e) {
            throw new AiravataMonitorException(e);
        }
    }

    private JobState getStatusFromString(String status) {
        logger.info("parsing the job status returned : " + status);
        if (status != null) {
            if ("ipf:finished".equals(status)) {
                return JobState.COMPLETE;
            }
            if ("ipf:pending".equals(status) || "ipf:starting".equals(status)) {
                return JobState.QUEUED;
            }
            if ("ipf:running".equals(status) || "ipf:finishing".equals(status)) {
                return JobState.ACTIVE;
            }
            if ("ipf:held".equals(status) || "ipf:teminating".equals(status) || "ipf:teminated".equals(status)) {
                return JobState.HELD;
            }
            if ("ipf:suspending".equals(status)) {
                return JobState.SUSPENDED;
            }
            if ("ipf:failed".equals(status)) {
                return JobState.FAILED;
            }
            if ("ipf:unknown".equals(status)) {
                return JobState.UNKNOWN;
            }
        }
        return JobState.UNKNOWN;
    }
}

