/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.SecurityContext;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.ssh.security.SSHSecurityContext;
import org.apache.airavata.gsi.ssh.api.ServerInfo;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.authentication.MyProxyAuthenticationInfo;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HPCMonitorID
extends MonitorID {
    private static final Logger logger = LoggerFactory.getLogger(HPCMonitorID.class);
    private AuthenticationInfo authenticationInfo = null;

    public HPCMonitorID(ComputeResourceDescription computeResourceDescription, String jobID, String taskID, String workflowNodeID, String experimentID, String userName, String jobName) {
        super(computeResourceDescription, jobID, taskID, workflowNodeID, experimentID, userName, jobName);
        this.setComputeResourceDescription(computeResourceDescription);
        this.setJobStartedTime(new Timestamp(new Date().getTime()));
        this.setUserName(userName);
        this.setJobID(jobID);
        this.setTaskID(taskID);
        this.setExperimentID(experimentID);
        this.setWorkflowNodeID(workflowNodeID);
    }

    public HPCMonitorID(AuthenticationInfo authenticationInfo, JobExecutionContext jobExecutionContext) {
        super(jobExecutionContext);
        this.authenticationInfo = authenticationInfo;
        if (this.authenticationInfo != null) {
            try {
                String hostAddress = jobExecutionContext.getHostName();
                SecurityContext securityContext = jobExecutionContext.getSecurityContext(hostAddress);
                ServerInfo serverInfo = null;
                if (securityContext != null) {
                    if (securityContext instanceof GSISecurityContext && (serverInfo = ((GSISecurityContext)securityContext).getPbsCluster().getServerInfo()).getUserName() != null) {
                        this.setUserName(serverInfo.getUserName());
                    }
                    if (securityContext instanceof SSHSecurityContext && (serverInfo = ((SSHSecurityContext)securityContext).getPbsCluster().getServerInfo()).getUserName() != null) {
                        this.setUserName(serverInfo.getUserName());
                    }
                }
            }
            catch (GFacException e) {
                logger.error("Error while getting security context", (Throwable)e);
            }
        }
    }

    public HPCMonitorID(ComputeResourceDescription computeResourceDescription, String jobID, String taskID, String workflowNodeID, String experimentID, String userName, AuthenticationInfo authenticationInfo) {
        this.setComputeResourceDescription(computeResourceDescription);
        this.setJobStartedTime(new Timestamp(new Date().getTime()));
        this.authenticationInfo = authenticationInfo;
        if (this.authenticationInfo != null && this.authenticationInfo instanceof MyProxyAuthenticationInfo) {
            this.setUserName(((MyProxyAuthenticationInfo)this.authenticationInfo).getUserName());
        }
        this.setJobID(jobID);
        this.setTaskID(taskID);
        this.setExperimentID(experimentID);
        this.setWorkflowNodeID(workflowNodeID);
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }
}

