/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

public class X509Helper {
    public static KeyStore keyStoreFromPEM(String proxyFile, String keyPassPhrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        return X509Helper.keyStoreFromPEM(proxyFile, proxyFile, keyPassPhrase);
    }

    public static KeyStore keyStoreFromPEM(String certFile, String keyFile, String keyPassPhrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new FileInputStream(certFile));
        BufferedReader reader = new BufferedReader(new FileReader(keyFile));
        String line = null;
        StringBuilder builder = new StringBuilder();
        boolean inKey = false;
        while ((line = reader.readLine()) != null) {
            if (line.contains("-----BEGIN RSA PRIVATE KEY-----")) {
                inKey = true;
            }
            if (inKey) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            if (!line.contains("-----END RSA PRIVATE KEY-----")) continue;
            inKey = false;
        }
        String privKeyPEM = builder.toString();
        PEMReader pemParser = new PEMReader((Reader)new StringReader(privKeyPEM));
        Object object = pemParser.readObject();
        PrivateKey privKey = null;
        if (object instanceof KeyPair) {
            privKey = ((KeyPair)object).getPrivate();
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(privKey, new Certificate[]{cert});
        KeyStore.PasswordProtection prot = new KeyStore.PasswordProtection(keyPassPhrase.toCharArray());
        keyStore.setEntry(cert.getSubjectX500Principal().getName(), entry, prot);
        return keyStore;
    }

    public static KeyStore trustKeyStoreFromCertDir() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, ApplicationSettingsException {
        return X509Helper.trustKeyStoreFromCertDir(ServerSettings.getSetting((String)"trusted.cert.location"));
    }

    public static KeyStore trustKeyStoreFromCertDir(String certDir) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        File dir = new File(certDir);
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".0")) continue;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new FileInputStream(file));
                KeyStore.TrustedCertificateEntry entry = new KeyStore.TrustedCertificateEntry(cert);
                ks.setEntry(cert.getSubjectX500Principal().getName(), entry, null);
            }
            catch (KeyStoreException e) {
            }
            catch (CertificateParsingException e) {
                // empty catch block
            }
        }
        return ks;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

