/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.util;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.SaslConfig;
import java.security.KeyStore;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.airavata.gfac.monitor.util.X509Helper;

public class AMQPConnectionUtil {
    public static Connection connect(List<String> hosts, String vhost, String proxyFile) {
        Collections.shuffle(hosts);
        for (String host : hosts) {
            Connection connection = AMQPConnectionUtil.connect(host, vhost, proxyFile);
            if (host == null) continue;
            System.out.println("connected to " + host);
            return connection;
        }
        return null;
    }

    public static Connection connect(String host, String vhost, String proxyFile) {
        Connection connection;
        try {
            String keyPassPhrase = "test123";
            KeyStore ks = X509Helper.keyStoreFromPEM(proxyFile, keyPassPhrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keyPassPhrase.toCharArray());
            KeyStore tks = X509Helper.trustKeyStoreFromCertDir();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tks);
            SSLContext c = SSLContext.getInstance("SSLv3");
            c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(host);
            factory.setPort(5671);
            factory.useSslProtocol(c);
            factory.setVirtualHost(vhost);
            factory.setSaslConfig((SaslConfig)DefaultSaslConfig.EXTERNAL);
            connection = factory.newConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return connection;
    }
}

