/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.push.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.core.notification.MonitorPublisher;
import org.apache.airavata.gfac.monitor.core.MessageParser;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.gfac.monitor.impl.push.amqp.AMQPMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConsumer
implements Consumer {
    private static final Logger logger = LoggerFactory.getLogger(AMQPMonitor.class);
    private MessageParser parser;
    private MonitorPublisher publisher;

    public BasicConsumer(MessageParser parser, MonitorPublisher publisher) {
        this.parser = parser;
        this.publisher = publisher;
    }

    public void handleCancel(String consumerTag) {
    }

    public void handleCancelOk(String consumerTag) {
    }

    public void handleConsumeOk(String consumerTag) {
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        logger.debug("job update for: " + envelope.getRoutingKey());
        String message = new String(body);
        message = message.replaceAll("(?m)^", "    ");
        logger.debug("************************************************************");
        logger.debug("AMQP Message recieved \n" + message);
        logger.debug("************************************************************");
        try {
            String jobID = envelope.getRoutingKey().split("\\.")[0];
            MonitorID monitorID = new MonitorID(null, jobID, null, null, null, null);
            monitorID.setStatus(this.parser.parseMessage(message));
            this.publisher.publish((Object)monitorID);
        }
        catch (AiravataMonitorException e) {
            e.printStackTrace();
        }
    }

    public void handleRecoverOk(String consumerTag) {
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
    }
}

