/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.pull.qstat;

import com.google.common.eventbus.EventBus;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.cpi.GFac;
import org.apache.airavata.gfac.core.monitor.ExperimentIdentity;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.core.monitor.TaskIdentity;
import org.apache.airavata.gfac.core.monitor.state.ExperimentStatusChangeRequest;
import org.apache.airavata.gfac.core.monitor.state.JobStatusChangeRequest;
import org.apache.airavata.gfac.core.monitor.state.TaskStatusChangeRequest;
import org.apache.airavata.gfac.core.notification.MonitorPublisher;
import org.apache.airavata.gfac.monitor.HostMonitorData;
import org.apache.airavata.gfac.monitor.UserMonitorData;
import org.apache.airavata.gfac.monitor.core.PullMonitor;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.gfac.monitor.impl.pull.qstat.ResourceConnection;
import org.apache.airavata.gfac.monitor.util.CommonUtils;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.model.workspace.experiment.ExperimentState;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.model.workspace.experiment.TaskState;
import org.apache.airavata.schemas.gfac.GsisshHostType;
import org.apache.airavata.schemas.gfac.SSHHostType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HPCPullMonitor
extends PullMonitor {
    private static final Logger logger = LoggerFactory.getLogger(HPCPullMonitor.class);
    private BlockingQueue<UserMonitorData> queue;
    private boolean startPulling = false;
    private Map<String, ResourceConnection> connections;
    private MonitorPublisher publisher;
    private GFac gfac;
    private AuthenticationInfo authenticationInfo;

    public HPCPullMonitor() {
        this.connections = new HashMap<String, ResourceConnection>();
        this.queue = new LinkedBlockingDeque<UserMonitorData>();
        this.publisher = new MonitorPublisher(new EventBus());
    }

    public HPCPullMonitor(MonitorPublisher monitorPublisher, AuthenticationInfo authInfo) {
        this.connections = new HashMap<String, ResourceConnection>();
        this.queue = new LinkedBlockingDeque<UserMonitorData>();
        this.publisher = monitorPublisher;
        this.authenticationInfo = authInfo;
    }

    public HPCPullMonitor(BlockingQueue<UserMonitorData> queue, MonitorPublisher publisher) {
        this.queue = queue;
        this.publisher = publisher;
        this.connections = new HashMap<String, ResourceConnection>();
    }

    public void run() {
        this.startPulling = true;
        while (this.startPulling && !ServerSettings.isStopAllThreads()) {
            try {
                this.startPulling();
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
        for (String next : this.connections.keySet()) {
            ResourceConnection resourceConnection = this.connections.get(next);
            try {
                resourceConnection.getCluster().disconnect();
            }
            catch (SSHApiException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean startPulling() throws AiravataMonitorException {
        UserMonitorData take = null;
        JobStatusChangeRequest jobStatus = new JobStatusChangeRequest();
        MonitorID currentMonitorID = null;
        HostDescription currentHostDescription = null;
        try {
            take = this.queue.take();
            ArrayList<MonitorID> completedJobs = new ArrayList<MonitorID>();
            List<HostMonitorData> hostMonitorData = take.getHostMonitorData();
            for (HostMonitorData iHostMonitorData : hostMonitorData) {
                if (iHostMonitorData.getHost().getType() instanceof GsisshHostType || iHostMonitorData.getHost().getType() instanceof SSHHostType) {
                    currentHostDescription = iHostMonitorData.getHost();
                    String hostName = iHostMonitorData.getHost().getType().getHostAddress();
                    ResourceConnection connection = null;
                    if (this.connections.containsKey(hostName)) {
                        logger.debug("We already have this connection so not going to create one");
                        connection = this.connections.get(hostName);
                    } else {
                        connection = new ResourceConnection(iHostMonitorData, this.getAuthenticationInfo());
                        this.connections.put(hostName, connection);
                    }
                    List<MonitorID> monitorID = iHostMonitorData.getMonitorIDs();
                    Map<String, JobState> jobStatuses = connection.getJobStatuses(monitorID);
                    Iterator<MonitorID> i$ = monitorID.iterator();
                    while (i$.hasNext()) {
                        MonitorID iMonitorID;
                        currentMonitorID = iMonitorID = i$.next();
                        iMonitorID.setStatus(jobStatuses.get(iMonitorID.getJobID()));
                        jobStatus = new JobStatusChangeRequest(iMonitorID);
                        this.publisher.publish((Object)jobStatus);
                        iMonitorID.setLastMonitored(new Timestamp(new Date().getTime()));
                        if (jobStatus.getState().equals((Object)JobState.COMPLETE)) {
                            completedJobs.add(iMonitorID);
                            try {
                                this.gfac.invokeOutFlowHandlers(iMonitorID.getJobExecutionContext());
                            }
                            catch (GFacException e) {
                                this.publisher.publish((Object)new TaskStatusChangeRequest(new TaskIdentity(iMonitorID.getExperimentID(), iMonitorID.getWorkflowNodeID(), iMonitorID.getTaskID()), TaskState.FAILED));
                                this.publisher.publish((Object)new ExperimentStatusChangeRequest(new ExperimentIdentity(iMonitorID.getExperimentID()), ExperimentState.FAILED));
                                logger.info(e.getLocalizedMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        if (iMonitorID.getFailedCount() > 2) {
                            logger.error("Tried to monitor the job with ID " + iMonitorID.getJobID() + " But failed 3 times, so skip this Job from Monitor");
                            iMonitorID.setLastMonitored(new Timestamp(new Date().getTime()));
                            completedJobs.add(iMonitorID);
                            try {
                                logger.error("Launching outflow handlers to check output are genereated or not");
                                this.gfac.invokeOutFlowHandlers(iMonitorID.getJobExecutionContext());
                            }
                            catch (GFacException e) {
                                this.publisher.publish((Object)new TaskStatusChangeRequest(new TaskIdentity(iMonitorID.getExperimentID(), iMonitorID.getWorkflowNodeID(), iMonitorID.getTaskID()), TaskState.FAILED));
                                this.publisher.publish((Object)new ExperimentStatusChangeRequest(new ExperimentIdentity(iMonitorID.getExperimentID()), ExperimentState.FAILED));
                                logger.info(e.getLocalizedMessage(), (Throwable)e);
                            }
                            continue;
                        }
                        iMonitorID.setLastMonitored(new Timestamp(new Date().getTime()));
                    }
                    continue;
                }
                logger.debug("Qstat Monitor doesn't handle non-gsissh hosts");
            }
            this.queue.put(take);
            for (MonitorID completedJob : completedJobs) {
                CommonUtils.removeMonitorFromQueue(this.queue, completedJob);
            }
        }
        catch (InterruptedException e) {
            if (!this.queue.contains(take)) {
                try {
                    this.queue.put(take);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            logger.error("Error handling the job with Job ID:" + currentMonitorID.getJobID());
            throw new AiravataMonitorException(e);
        }
        catch (SSHApiException e) {
            logger.error(e.getMessage());
            if (e.getMessage().contains("Unknown Job Id Error")) {
                jobStatus.setState(JobState.UNKNOWN);
                this.publisher.publish((Object)jobStatus);
            } else if (e.getMessage().contains("illegally formed job identifier")) {
                logger.error("Wrong job ID is given so dropping the job from monitoring system");
            } else if (!this.queue.contains(take)) {
                if (currentMonitorID == null) {
                    logger.error("Monitoring the jobs failed, for user: " + take.getUserName() + " in Host: " + currentHostDescription.getType().getHostAddress());
                } else if (currentMonitorID != null) {
                    if (currentMonitorID.getFailedCount() < 2) {
                        try {
                            currentMonitorID.setFailedCount(currentMonitorID.getFailedCount() + 1);
                            this.queue.put(take);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        logger.error(e.getMessage());
                        logger.error("Tried to monitor the job 3 times, so dropping of the the Job with ID: " + currentMonitorID.getJobID());
                    }
                }
            }
            throw new AiravataMonitorException("Error retrieving the job status", e);
        }
        catch (Exception e) {
            if (currentMonitorID != null) {
                if (currentMonitorID.getFailedCount() < 3) {
                    try {
                        currentMonitorID.setFailedCount(currentMonitorID.getFailedCount() + 1);
                        this.queue.put(take);
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    logger.error(e.getMessage());
                    logger.error("Tryied to monitor the job 3 times, so dropping of the the Job with ID: " + currentMonitorID.getJobID());
                }
            }
            throw new AiravataMonitorException("Error retrieving the job status", e);
        }
        return true;
    }

    @Override
    public boolean stopPulling() {
        this.startPulling = false;
        return true;
    }

    @Override
    public MonitorPublisher getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(MonitorPublisher publisher) {
        this.publisher = publisher;
    }

    public BlockingQueue<UserMonitorData> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<UserMonitorData> queue) {
        this.queue = queue;
    }

    public boolean authenticate() {
        return false;
    }

    public Map<String, ResourceConnection> getConnections() {
        return this.connections;
    }

    public boolean isStartPulling() {
        return this.startPulling;
    }

    public void setConnections(Map<String, ResourceConnection> connections) {
        this.connections = connections;
    }

    public void setStartPulling(boolean startPulling) {
        this.startPulling = startPulling;
    }

    public GFac getGfac() {
        return this.gfac;
    }

    public void setGfac(GFac gfac) {
        this.gfac = gfac;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }
}

