/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.authentication.MyProxyAuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HPCMonitorID
extends MonitorID {
    private static final Logger logger = LoggerFactory.getLogger(HPCMonitorID.class);
    private AuthenticationInfo authenticationInfo = null;

    public HPCMonitorID(HostDescription host, String jobID, String taskID, String workflowNodeID, String experimentID, String userName) {
        super(host, jobID, taskID, workflowNodeID, experimentID, userName);
        this.setHost(host);
        this.setJobStartedTime(new Timestamp(new Date().getTime()));
        this.setUserName(userName);
        this.setJobID(jobID);
        this.setTaskID(taskID);
        this.setExperimentID(experimentID);
        this.setWorkflowNodeID(workflowNodeID);
    }

    public HPCMonitorID(AuthenticationInfo authenticationInfo, JobExecutionContext jobExecutionContext) {
        super(jobExecutionContext);
        this.authenticationInfo = authenticationInfo;
        if (this.authenticationInfo != null && this.authenticationInfo instanceof MyProxyAuthenticationInfo) {
            this.setUserName(((MyProxyAuthenticationInfo)this.authenticationInfo).getUserName());
        }
    }

    public HPCMonitorID(HostDescription host, String jobID, String taskID, String workflowNodeID, String experimentID, String userName, AuthenticationInfo authenticationInfo) {
        this.setHost(host);
        this.setJobStartedTime(new Timestamp(new Date().getTime()));
        this.authenticationInfo = authenticationInfo;
        if (this.authenticationInfo != null && this.authenticationInfo instanceof MyProxyAuthenticationInfo) {
            this.setUserName(((MyProxyAuthenticationInfo)this.authenticationInfo).getUserName());
        }
        this.setJobID(jobID);
        this.setTaskID(taskID);
        this.setExperimentID(experimentID);
        this.setWorkflowNodeID(workflowNodeID);
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }
}

