
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "NetworkInfo",
    "Bandwidth",
    "StorageAccessProtocolID",
    "ComputingServiceID",
    "StorageServiceID"
})
public class ToComputingService_ {

    /**
     * Type of network connections between the Storage and Computing services (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    private String networkInfo;
    /**
     * The normal bandwidth available between the Storage and Computing services (Mb/s)
     * 
     */
    @JsonProperty("Bandwidth")
    private Integer bandwidth;
    /**
     * IDs of the protocols that can be used to access the StorageService
     * 
     */
    @JsonProperty("StorageAccessProtocolID")
    private List<String> storageAccessProtocolID = new ArrayList<String>();
    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    private String computingServiceID;
    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    private String storageServiceID;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Type of network connections between the Storage and Computing services (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    public String getNetworkInfo() {
        return networkInfo;
    }

    /**
     * Type of network connections between the Storage and Computing services (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    public void setNetworkInfo(String networkInfo) {
        this.networkInfo = networkInfo;
    }

    /**
     * The normal bandwidth available between the Storage and Computing services (Mb/s)
     * 
     */
    @JsonProperty("Bandwidth")
    public Integer getBandwidth() {
        return bandwidth;
    }

    /**
     * The normal bandwidth available between the Storage and Computing services (Mb/s)
     * 
     */
    @JsonProperty("Bandwidth")
    public void setBandwidth(Integer bandwidth) {
        this.bandwidth = bandwidth;
    }

    /**
     * IDs of the protocols that can be used to access the StorageService
     * 
     */
    @JsonProperty("StorageAccessProtocolID")
    public List<String> getStorageAccessProtocolID() {
        return storageAccessProtocolID;
    }

    /**
     * IDs of the protocols that can be used to access the StorageService
     * 
     */
    @JsonProperty("StorageAccessProtocolID")
    public void setStorageAccessProtocolID(List<String> storageAccessProtocolID) {
        this.storageAccessProtocolID = storageAccessProtocolID;
    }

    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    public String getComputingServiceID() {
        return computingServiceID;
    }

    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    public void setComputingServiceID(String computingServiceID) {
        this.computingServiceID = computingServiceID;
    }

    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    public String getStorageServiceID() {
        return storageServiceID;
    }

    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    public void setStorageServiceID(String storageServiceID) {
        this.storageServiceID = storageServiceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
