
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Type",
    "Version",
    "MaxStreams",
    "StorageServiceID",
    "ToComputingServiceID"
})
public class StorageAccessProtocol_ {

    /**
     * The type of the protocol - StorageAccessProtocol_t
     * 
     */
    @JsonProperty("Type")
    private String type;
    /**
     * The version of the protocol supported
     * 
     */
    @JsonProperty("Version")
    private String version;
    /**
     * The maximum number of parallel network streams which can be usef for a single transfer
     * 
     */
    @JsonProperty("MaxStreams")
    private Integer maxStreams;
    /**
     * The ID of the StorageService this protocol is available for
     * 
     */
    @JsonProperty("StorageServiceID")
    private String storageServiceID;
    /**
     * The ID(s) ToComputingService objects that describe connectivity to ComputingServices
     * 
     */
    @JsonProperty("ToComputingServiceID")
    private List<String> toComputingServiceID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The type of the protocol - StorageAccessProtocol_t
     * 
     */
    @JsonProperty("Type")
    public String getType() {
        return type;
    }

    /**
     * The type of the protocol - StorageAccessProtocol_t
     * 
     */
    @JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * The version of the protocol supported
     * 
     */
    @JsonProperty("Version")
    public String getVersion() {
        return version;
    }

    /**
     * The version of the protocol supported
     * 
     */
    @JsonProperty("Version")
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * The maximum number of parallel network streams which can be usef for a single transfer
     * 
     */
    @JsonProperty("MaxStreams")
    public Integer getMaxStreams() {
        return maxStreams;
    }

    /**
     * The maximum number of parallel network streams which can be usef for a single transfer
     * 
     */
    @JsonProperty("MaxStreams")
    public void setMaxStreams(Integer maxStreams) {
        this.maxStreams = maxStreams;
    }

    /**
     * The ID of the StorageService this protocol is available for
     * 
     */
    @JsonProperty("StorageServiceID")
    public String getStorageServiceID() {
        return storageServiceID;
    }

    /**
     * The ID of the StorageService this protocol is available for
     * 
     */
    @JsonProperty("StorageServiceID")
    public void setStorageServiceID(String storageServiceID) {
        this.storageServiceID = storageServiceID;
    }

    /**
     * The ID(s) ToComputingService objects that describe connectivity to ComputingServices
     * 
     */
    @JsonProperty("ToComputingServiceID")
    public List<String> getToComputingServiceID() {
        return toComputingServiceID;
    }

    /**
     * The ID(s) ToComputingService objects that describe connectivity to ComputingServices
     * 
     */
    @JsonProperty("ToComputingServiceID")
    public void setToComputingServiceID(List<String> toComputingServiceID) {
        this.toComputingServiceID = toComputingServiceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
