
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * A GLUE 2 Location
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Address",
    "Place",
    "Country",
    "PostalCode",
    "Latitude",
    "Longitude",
    "ServiceID",
    "DomainID"
})
public class Location_ {

    /**
     * A free format street address
     * 
     */
    @JsonProperty("Address")
    private String address;
    /**
     * Name of town/city
     * 
     */
    @JsonProperty("Place")
    private String place;
    /**
     * Name of country
     * 
     */
    @JsonProperty("Country")
    private String country;
    /**
     * Postal code
     * 
     */
    @JsonProperty("PostalCode")
    private String postalCode;
    /**
     * Position north (positive) or south (negative) of the equator in degrees
     * 
     */
    @JsonProperty("Latitude")
    private Double latitude;
    /**
     * Position east (positive) or west (negative) of the primary meridian in degrees
     * 
     */
    @JsonProperty("Longitude")
    private Double longitude;
    /**
     * The IDs of Services at this location
     * 
     */
    @JsonProperty("ServiceID")
    private List<String> serviceID = new ArrayList<String>();
    /**
     * The IDs of Domains at this location
     * 
     */
    @JsonProperty("DomainID")
    private List<String> domainID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A free format street address
     * 
     */
    @JsonProperty("Address")
    public String getAddress() {
        return address;
    }

    /**
     * A free format street address
     * 
     */
    @JsonProperty("Address")
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * Name of town/city
     * 
     */
    @JsonProperty("Place")
    public String getPlace() {
        return place;
    }

    /**
     * Name of town/city
     * 
     */
    @JsonProperty("Place")
    public void setPlace(String place) {
        this.place = place;
    }

    /**
     * Name of country
     * 
     */
    @JsonProperty("Country")
    public String getCountry() {
        return country;
    }

    /**
     * Name of country
     * 
     */
    @JsonProperty("Country")
    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * Postal code
     * 
     */
    @JsonProperty("PostalCode")
    public String getPostalCode() {
        return postalCode;
    }

    /**
     * Postal code
     * 
     */
    @JsonProperty("PostalCode")
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /**
     * Position north (positive) or south (negative) of the equator in degrees
     * 
     */
    @JsonProperty("Latitude")
    public Double getLatitude() {
        return latitude;
    }

    /**
     * Position north (positive) or south (negative) of the equator in degrees
     * 
     */
    @JsonProperty("Latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    /**
     * Position east (positive) or west (negative) of the primary meridian in degrees
     * 
     */
    @JsonProperty("Longitude")
    public Double getLongitude() {
        return longitude;
    }

    /**
     * Position east (positive) or west (negative) of the primary meridian in degrees
     * 
     */
    @JsonProperty("Longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    /**
     * The IDs of Services at this location
     * 
     */
    @JsonProperty("ServiceID")
    public List<String> getServiceID() {
        return serviceID;
    }

    /**
     * The IDs of Services at this location
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(List<String> serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * The IDs of Domains at this location
     * 
     */
    @JsonProperty("DomainID")
    public List<String> getDomainID() {
        return domainID;
    }

    /**
     * The IDs of Domains at this location
     * 
     */
    @JsonProperty("DomainID")
    public void setDomainID(List<String> domainID) {
        this.domainID = domainID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
