
package org.apache.airavata;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Type",
    "Latency",
    "TotalSize",
    "FreeSize",
    "UsedSize"
})
public class DataStore {

    /**
     * The type of storage medium - DataStoreType_t (disk,optical,tape,...)
     * 
     */
    @JsonProperty("Type")
    private String type;
    /**
     * The latency category under normal operating conditions - AccessLatency_t
     * 
     */
    @JsonProperty("Latency")
    private DataStore.Latency latency;
    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    private Integer totalSize;
    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    private Integer freeSize;
    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    private Integer usedSize;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The type of storage medium - DataStoreType_t (disk,optical,tape,...)
     * 
     */
    @JsonProperty("Type")
    public String getType() {
        return type;
    }

    /**
     * The type of storage medium - DataStoreType_t (disk,optical,tape,...)
     * 
     */
    @JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * The latency category under normal operating conditions - AccessLatency_t
     * 
     */
    @JsonProperty("Latency")
    public DataStore.Latency getLatency() {
        return latency;
    }

    /**
     * The latency category under normal operating conditions - AccessLatency_t
     * 
     */
    @JsonProperty("Latency")
    public void setLatency(DataStore.Latency latency) {
        this.latency = latency;
    }

    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public Integer getTotalSize() {
        return totalSize;
    }

    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public void setTotalSize(Integer totalSize) {
        this.totalSize = totalSize;
    }

    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public Integer getFreeSize() {
        return freeSize;
    }

    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public void setFreeSize(Integer freeSize) {
        this.freeSize = freeSize;
    }

    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public Integer getUsedSize() {
        return usedSize;
    }

    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public void setUsedSize(Integer usedSize) {
        this.usedSize = usedSize;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Latency {

        NEARLINE("nearline"),
        OFFLINE("offline"),
        ONLINE("online");
        private final String value;
        private static Map<String, DataStore.Latency> constants = new HashMap<String, DataStore.Latency>();

        static {
            for (DataStore.Latency c: DataStore.Latency.values()) {
                constants.put(c.value, c);
            }
        }

        private Latency(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static DataStore.Latency fromValue(String value) {
            DataStore.Latency constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
