
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * A GLUE 2 Contact
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Detail",
    "Type",
    "ServiceID",
    "DomainID"
})
public class Contact {

    /**
     * A URI embedding the contact information
     * 
     */
    @JsonProperty("Detail")
    private String detail;
    /**
     * closed enumeration ContactType_t
     * 
     */
    @JsonProperty("Type")
    private Contact.Type type;
    /**
     * The IDs of Services associated with this Contact
     * 
     */
    @JsonProperty("ServiceID")
    private List<String> serviceID = new ArrayList<String>();
    /**
     * The IDs of Domains associated with this Contact
     * 
     */
    @JsonProperty("DomainID")
    private List<String> domainID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A URI embedding the contact information
     * 
     */
    @JsonProperty("Detail")
    public String getDetail() {
        return detail;
    }

    /**
     * A URI embedding the contact information
     * 
     */
    @JsonProperty("Detail")
    public void setDetail(String detail) {
        this.detail = detail;
    }

    /**
     * closed enumeration ContactType_t
     * 
     */
    @JsonProperty("Type")
    public Contact.Type getType() {
        return type;
    }

    /**
     * closed enumeration ContactType_t
     * 
     */
    @JsonProperty("Type")
    public void setType(Contact.Type type) {
        this.type = type;
    }

    /**
     * The IDs of Services associated with this Contact
     * 
     */
    @JsonProperty("ServiceID")
    public List<String> getServiceID() {
        return serviceID;
    }

    /**
     * The IDs of Services associated with this Contact
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(List<String> serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * The IDs of Domains associated with this Contact
     * 
     */
    @JsonProperty("DomainID")
    public List<String> getDomainID() {
        return domainID;
    }

    /**
     * The IDs of Domains associated with this Contact
     * 
     */
    @JsonProperty("DomainID")
    public void setDomainID(List<String> domainID) {
        this.domainID = domainID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Type {

        GENERAL("general"),
        SECURITY("security"),
        SYSADMIN("sysadmin"),
        USERSUPPORT("usersupport");
        private final String value;
        private static Map<String, Contact.Type> constants = new HashMap<String, Contact.Type>();

        static {
            for (Contact.Type c: Contact.Type.values()) {
                constants.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Contact.Type fromValue(String value) {
            Contact.Type constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
