
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "MappingQueue",
    "MaxWallTime",
    "MaxMultiSlotWallTime",
    "DefaultWallTime",
    "MaxCPUTime",
    "MaxTotalCPUTime",
    "MinCPUTime",
    "DefaultCPUTime",
    "MaxTotalJobs",
    "MaxRunningJobs",
    "MaxWaitingJobs",
    "MaxPreLRMSWaitingJobs",
    "MaxUserRunningJobs",
    "MaxSlotsPerJob",
    "MaxStageInStreams",
    "MaxStageOutStreams",
    "ScheduingPolicy",
    "MaxMainMemory",
    "GuaranteedMainMemory",
    "MaxVirtualMemory",
    "GuaranteedVirtualMemory",
    "MaxDiskSpace",
    "DefaultStorageServiceID",
    "Preemption",
    "ServingState",
    "TotalJobs",
    "RunningJobs",
    "LocalRunningJobs",
    "WaitingJobs",
    "LocalWaitingJobs",
    "SuspendedJobs",
    "LocalSuspendedJobs",
    "StagingJobs",
    "PreLRMSWaitingJobs",
    "EstimatedAverageWaitingTime",
    "EstimatedWorstWaitingTime",
    "FreeSlots",
    "FreeSlotsWithDuration",
    "UsedSlots",
    "RequestedSlots",
    "ReservationPolicy",
    "Tag"
})
public class ComputingShare {

    /**
     * The name of the queue in the LRMS where jobs in this share are submitted
     * 
     */
    @JsonProperty("MappingQueue")
    private String mappingQueue;
    /**
     * The maximum wall clock time that a single-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxWallTime")
    private Integer maxWallTime;
    /**
     * The maximum wall clock time that a multi-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxMultiSlotWallTime")
    private Integer maxMultiSlotWallTime;
    /**
     * The default wall clock per slot assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultWallTime")
    private Integer defaultWallTime;
    /**
     * The maximum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MaxCPUTime")
    private Integer maxCPUTime;
    /**
     * The maximum amount of CPU time that a job can request across all slots assigned to it (seconds)
     * 
     */
    @JsonProperty("MaxTotalCPUTime")
    private Integer maxTotalCPUTime;
    /**
     * The minimum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MinCPUTime")
    private Integer minCPUTime;
    /**
     * The default CPU time limit assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultCPUTime")
    private Integer defaultCPUTime;
    /**
     * The maximum number of jobs that can be in this Share
     * 
     */
    @JsonProperty("MaxTotalJobs")
    private Integer maxTotalJobs;
    /**
     * The maximum number of jobs that can be running in this Share
     * 
     */
    @JsonProperty("MaxRunningJobs")
    private Integer maxRunningJobs;
    /**
     * The maximum number of jobs that can be waiting in this Share
     * 
     */
    @JsonProperty("MaxWaitingJobs")
    private Integer maxWaitingJobs;
    /**
     * The maximum number of jobs that can be waiting in the Grid layer for this Share
     * 
     */
    @JsonProperty("MaxPreLRMSWaitingJobs")
    private Integer maxPreLRMSWaitingJobs;
    /**
     * The maximum number of jobs that can be running in this Share per user
     * 
     */
    @JsonProperty("MaxUserRunningJobs")
    private Integer maxUserRunningJobs;
    /**
     * The maximum number of slots that can be allocated to a single job in this Share
     * 
     */
    @JsonProperty("MaxSlotsPerJob")
    private Integer maxSlotsPerJob;
    /**
     * The maximum number of streams available to stage files in
     * 
     */
    @JsonProperty("MaxStageInStreams")
    private Integer maxStageInStreams;
    /**
     * The maximum number of streams available to stage files out
     * 
     */
    @JsonProperty("MaxStageOutStreams")
    private Integer maxStageOutStreams;
    /**
     * The scheduling policy used by the share - SchedulingPolicy_t (open enumeration)
     * 
     */
    @JsonProperty("ScheduingPolicy")
    private String scheduingPolicy;
    /**
     * The maximum amount of physical RAM that a job can use (MB)
     * 
     */
    @JsonProperty("MaxMainMemory")
    private Integer maxMainMemory;
    /**
     * The amount of physical RAM that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedMainMemory")
    private Integer guaranteedMainMemory;
    /**
     * The maximum amount memory (RAM+swap) that a job can use (MB)
     * 
     */
    @JsonProperty("MaxVirtualMemory")
    private Integer maxVirtualMemory;
    /**
     * The amount of memory (RAM+swap) that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedVirtualMemory")
    private Integer guaranteedVirtualMemory;
    /**
     * The maximum disk space that a job can use in the working area (GB)
     * 
     */
    @JsonProperty("MaxDiskSpace")
    private Integer maxDiskSpace;
    /**
     * The ID of the default StorageService used to store files
     * 
     */
    @JsonProperty("DefaultStorageServiceID")
    private String defaultStorageServiceID;
    /**
     * Whether jobs can be preempted and resumed (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Preemption")
    private Boolean preemption;
    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    private ComputingShare.ServingState servingState;
    /**
     * The total number of jobs in any state
     * 
     */
    @JsonProperty("TotalJobs")
    private Integer totalJobs;
    /**
     * The number of running jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("RunningJobs")
    private Integer runningJobs;
    /**
     * The number of running jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalRunningJobs")
    private Integer localRunningJobs;
    /**
     * The number of waiting jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("WaitingJobs")
    private Integer waitingJobs;
    /**
     * The number of waiting jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalWaitingJobs")
    private Integer localWaitingJobs;
    /**
     * The number of suspended jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("SuspendedJobs")
    private Integer suspendedJobs;
    /**
     * The number of suspended jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalSuspendedJobs")
    private Integer localSuspendedJobs;
    /**
     * The number of jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    private Integer stagingJobs;
    /**
     * The number of Grid jobs which have not yet been passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    private Integer preLRMSWaitingJobs;
    /**
     * An estimate of the average time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedAverageWaitingTime")
    private Integer estimatedAverageWaitingTime;
    /**
     * An estimate of the worst-case time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedWorstWaitingTime")
    private Integer estimatedWorstWaitingTime;
    /**
     * The number of slots which are currently available for use
     * 
     */
    @JsonProperty("FreeSlots")
    private Integer freeSlots;
    /**
     * The number of slots which are currently available for use and how long they are available
     * 
     */
    @JsonProperty("FreeSlotsWithDuration")
    private String freeSlotsWithDuration;
    /**
     * The number of slots currently in use
     * 
     */
    @JsonProperty("UsedSlots")
    private Integer usedSlots;
    /**
     * The number of slots needd to execute all waiting and staging jobs
     * 
     */
    @JsonProperty("RequestedSlots")
    private Integer requestedSlots;
    /**
     * The policy used for advance reservation - ReservationPolicy_t
     * 
     */
    @JsonProperty("ReservationPolicy")
    private ComputingShare.ReservationPolicy reservationPolicy;
    /**
     * UserDomain-defined tags for this Share
     * 
     */
    @JsonProperty("Tag")
    private List<String> tag = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The name of the queue in the LRMS where jobs in this share are submitted
     * 
     */
    @JsonProperty("MappingQueue")
    public String getMappingQueue() {
        return mappingQueue;
    }

    /**
     * The name of the queue in the LRMS where jobs in this share are submitted
     * 
     */
    @JsonProperty("MappingQueue")
    public void setMappingQueue(String mappingQueue) {
        this.mappingQueue = mappingQueue;
    }

    /**
     * The maximum wall clock time that a single-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxWallTime")
    public Integer getMaxWallTime() {
        return maxWallTime;
    }

    /**
     * The maximum wall clock time that a single-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxWallTime")
    public void setMaxWallTime(Integer maxWallTime) {
        this.maxWallTime = maxWallTime;
    }

    /**
     * The maximum wall clock time that a multi-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxMultiSlotWallTime")
    public Integer getMaxMultiSlotWallTime() {
        return maxMultiSlotWallTime;
    }

    /**
     * The maximum wall clock time that a multi-slot job can run (seconds)
     * 
     */
    @JsonProperty("MaxMultiSlotWallTime")
    public void setMaxMultiSlotWallTime(Integer maxMultiSlotWallTime) {
        this.maxMultiSlotWallTime = maxMultiSlotWallTime;
    }

    /**
     * The default wall clock per slot assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultWallTime")
    public Integer getDefaultWallTime() {
        return defaultWallTime;
    }

    /**
     * The default wall clock per slot assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultWallTime")
    public void setDefaultWallTime(Integer defaultWallTime) {
        this.defaultWallTime = defaultWallTime;
    }

    /**
     * The maximum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MaxCPUTime")
    public Integer getMaxCPUTime() {
        return maxCPUTime;
    }

    /**
     * The maximum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MaxCPUTime")
    public void setMaxCPUTime(Integer maxCPUTime) {
        this.maxCPUTime = maxCPUTime;
    }

    /**
     * The maximum amount of CPU time that a job can request across all slots assigned to it (seconds)
     * 
     */
    @JsonProperty("MaxTotalCPUTime")
    public Integer getMaxTotalCPUTime() {
        return maxTotalCPUTime;
    }

    /**
     * The maximum amount of CPU time that a job can request across all slots assigned to it (seconds)
     * 
     */
    @JsonProperty("MaxTotalCPUTime")
    public void setMaxTotalCPUTime(Integer maxTotalCPUTime) {
        this.maxTotalCPUTime = maxTotalCPUTime;
    }

    /**
     * The minimum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MinCPUTime")
    public Integer getMinCPUTime() {
        return minCPUTime;
    }

    /**
     * The minimum pre-slot CPU time that a job can request (seconds)
     * 
     */
    @JsonProperty("MinCPUTime")
    public void setMinCPUTime(Integer minCPUTime) {
        this.minCPUTime = minCPUTime;
    }

    /**
     * The default CPU time limit assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultCPUTime")
    public Integer getDefaultCPUTime() {
        return defaultCPUTime;
    }

    /**
     * The default CPU time limit assumed by the LRMS if a maximum time is not specified (seconds)
     * 
     */
    @JsonProperty("DefaultCPUTime")
    public void setDefaultCPUTime(Integer defaultCPUTime) {
        this.defaultCPUTime = defaultCPUTime;
    }

    /**
     * The maximum number of jobs that can be in this Share
     * 
     */
    @JsonProperty("MaxTotalJobs")
    public Integer getMaxTotalJobs() {
        return maxTotalJobs;
    }

    /**
     * The maximum number of jobs that can be in this Share
     * 
     */
    @JsonProperty("MaxTotalJobs")
    public void setMaxTotalJobs(Integer maxTotalJobs) {
        this.maxTotalJobs = maxTotalJobs;
    }

    /**
     * The maximum number of jobs that can be running in this Share
     * 
     */
    @JsonProperty("MaxRunningJobs")
    public Integer getMaxRunningJobs() {
        return maxRunningJobs;
    }

    /**
     * The maximum number of jobs that can be running in this Share
     * 
     */
    @JsonProperty("MaxRunningJobs")
    public void setMaxRunningJobs(Integer maxRunningJobs) {
        this.maxRunningJobs = maxRunningJobs;
    }

    /**
     * The maximum number of jobs that can be waiting in this Share
     * 
     */
    @JsonProperty("MaxWaitingJobs")
    public Integer getMaxWaitingJobs() {
        return maxWaitingJobs;
    }

    /**
     * The maximum number of jobs that can be waiting in this Share
     * 
     */
    @JsonProperty("MaxWaitingJobs")
    public void setMaxWaitingJobs(Integer maxWaitingJobs) {
        this.maxWaitingJobs = maxWaitingJobs;
    }

    /**
     * The maximum number of jobs that can be waiting in the Grid layer for this Share
     * 
     */
    @JsonProperty("MaxPreLRMSWaitingJobs")
    public Integer getMaxPreLRMSWaitingJobs() {
        return maxPreLRMSWaitingJobs;
    }

    /**
     * The maximum number of jobs that can be waiting in the Grid layer for this Share
     * 
     */
    @JsonProperty("MaxPreLRMSWaitingJobs")
    public void setMaxPreLRMSWaitingJobs(Integer maxPreLRMSWaitingJobs) {
        this.maxPreLRMSWaitingJobs = maxPreLRMSWaitingJobs;
    }

    /**
     * The maximum number of jobs that can be running in this Share per user
     * 
     */
    @JsonProperty("MaxUserRunningJobs")
    public Integer getMaxUserRunningJobs() {
        return maxUserRunningJobs;
    }

    /**
     * The maximum number of jobs that can be running in this Share per user
     * 
     */
    @JsonProperty("MaxUserRunningJobs")
    public void setMaxUserRunningJobs(Integer maxUserRunningJobs) {
        this.maxUserRunningJobs = maxUserRunningJobs;
    }

    /**
     * The maximum number of slots that can be allocated to a single job in this Share
     * 
     */
    @JsonProperty("MaxSlotsPerJob")
    public Integer getMaxSlotsPerJob() {
        return maxSlotsPerJob;
    }

    /**
     * The maximum number of slots that can be allocated to a single job in this Share
     * 
     */
    @JsonProperty("MaxSlotsPerJob")
    public void setMaxSlotsPerJob(Integer maxSlotsPerJob) {
        this.maxSlotsPerJob = maxSlotsPerJob;
    }

    /**
     * The maximum number of streams available to stage files in
     * 
     */
    @JsonProperty("MaxStageInStreams")
    public Integer getMaxStageInStreams() {
        return maxStageInStreams;
    }

    /**
     * The maximum number of streams available to stage files in
     * 
     */
    @JsonProperty("MaxStageInStreams")
    public void setMaxStageInStreams(Integer maxStageInStreams) {
        this.maxStageInStreams = maxStageInStreams;
    }

    /**
     * The maximum number of streams available to stage files out
     * 
     */
    @JsonProperty("MaxStageOutStreams")
    public Integer getMaxStageOutStreams() {
        return maxStageOutStreams;
    }

    /**
     * The maximum number of streams available to stage files out
     * 
     */
    @JsonProperty("MaxStageOutStreams")
    public void setMaxStageOutStreams(Integer maxStageOutStreams) {
        this.maxStageOutStreams = maxStageOutStreams;
    }

    /**
     * The scheduling policy used by the share - SchedulingPolicy_t (open enumeration)
     * 
     */
    @JsonProperty("ScheduingPolicy")
    public String getScheduingPolicy() {
        return scheduingPolicy;
    }

    /**
     * The scheduling policy used by the share - SchedulingPolicy_t (open enumeration)
     * 
     */
    @JsonProperty("ScheduingPolicy")
    public void setScheduingPolicy(String scheduingPolicy) {
        this.scheduingPolicy = scheduingPolicy;
    }

    /**
     * The maximum amount of physical RAM that a job can use (MB)
     * 
     */
    @JsonProperty("MaxMainMemory")
    public Integer getMaxMainMemory() {
        return maxMainMemory;
    }

    /**
     * The maximum amount of physical RAM that a job can use (MB)
     * 
     */
    @JsonProperty("MaxMainMemory")
    public void setMaxMainMemory(Integer maxMainMemory) {
        this.maxMainMemory = maxMainMemory;
    }

    /**
     * The amount of physical RAM that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedMainMemory")
    public Integer getGuaranteedMainMemory() {
        return guaranteedMainMemory;
    }

    /**
     * The amount of physical RAM that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedMainMemory")
    public void setGuaranteedMainMemory(Integer guaranteedMainMemory) {
        this.guaranteedMainMemory = guaranteedMainMemory;
    }

    /**
     * The maximum amount memory (RAM+swap) that a job can use (MB)
     * 
     */
    @JsonProperty("MaxVirtualMemory")
    public Integer getMaxVirtualMemory() {
        return maxVirtualMemory;
    }

    /**
     * The maximum amount memory (RAM+swap) that a job can use (MB)
     * 
     */
    @JsonProperty("MaxVirtualMemory")
    public void setMaxVirtualMemory(Integer maxVirtualMemory) {
        this.maxVirtualMemory = maxVirtualMemory;
    }

    /**
     * The amount of memory (RAM+swap) that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedVirtualMemory")
    public Integer getGuaranteedVirtualMemory() {
        return guaranteedVirtualMemory;
    }

    /**
     * The amount of memory (RAM+swap) that a job will have available (MB)
     * 
     */
    @JsonProperty("GuaranteedVirtualMemory")
    public void setGuaranteedVirtualMemory(Integer guaranteedVirtualMemory) {
        this.guaranteedVirtualMemory = guaranteedVirtualMemory;
    }

    /**
     * The maximum disk space that a job can use in the working area (GB)
     * 
     */
    @JsonProperty("MaxDiskSpace")
    public Integer getMaxDiskSpace() {
        return maxDiskSpace;
    }

    /**
     * The maximum disk space that a job can use in the working area (GB)
     * 
     */
    @JsonProperty("MaxDiskSpace")
    public void setMaxDiskSpace(Integer maxDiskSpace) {
        this.maxDiskSpace = maxDiskSpace;
    }

    /**
     * The ID of the default StorageService used to store files
     * 
     */
    @JsonProperty("DefaultStorageServiceID")
    public String getDefaultStorageServiceID() {
        return defaultStorageServiceID;
    }

    /**
     * The ID of the default StorageService used to store files
     * 
     */
    @JsonProperty("DefaultStorageServiceID")
    public void setDefaultStorageServiceID(String defaultStorageServiceID) {
        this.defaultStorageServiceID = defaultStorageServiceID;
    }

    /**
     * Whether jobs can be preempted and resumed (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Preemption")
    public Boolean getPreemption() {
        return preemption;
    }

    /**
     * Whether jobs can be preempted and resumed (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Preemption")
    public void setPreemption(Boolean preemption) {
        this.preemption = preemption;
    }

    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    public ComputingShare.ServingState getServingState() {
        return servingState;
    }

    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    public void setServingState(ComputingShare.ServingState servingState) {
        this.servingState = servingState;
    }

    /**
     * The total number of jobs in any state
     * 
     */
    @JsonProperty("TotalJobs")
    public Integer getTotalJobs() {
        return totalJobs;
    }

    /**
     * The total number of jobs in any state
     * 
     */
    @JsonProperty("TotalJobs")
    public void setTotalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
    }

    /**
     * The number of running jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("RunningJobs")
    public Integer getRunningJobs() {
        return runningJobs;
    }

    /**
     * The number of running jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("RunningJobs")
    public void setRunningJobs(Integer runningJobs) {
        this.runningJobs = runningJobs;
    }

    /**
     * The number of running jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalRunningJobs")
    public Integer getLocalRunningJobs() {
        return localRunningJobs;
    }

    /**
     * The number of running jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalRunningJobs")
    public void setLocalRunningJobs(Integer localRunningJobs) {
        this.localRunningJobs = localRunningJobs;
    }

    /**
     * The number of waiting jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("WaitingJobs")
    public Integer getWaitingJobs() {
        return waitingJobs;
    }

    /**
     * The number of waiting jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("WaitingJobs")
    public void setWaitingJobs(Integer waitingJobs) {
        this.waitingJobs = waitingJobs;
    }

    /**
     * The number of waiting jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalWaitingJobs")
    public Integer getLocalWaitingJobs() {
        return localWaitingJobs;
    }

    /**
     * The number of waiting jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalWaitingJobs")
    public void setLocalWaitingJobs(Integer localWaitingJobs) {
        this.localWaitingJobs = localWaitingJobs;
    }

    /**
     * The number of suspended jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("SuspendedJobs")
    public Integer getSuspendedJobs() {
        return suspendedJobs;
    }

    /**
     * The number of suspended jobs submitted through Grid or non-Grid interfaces
     * 
     */
    @JsonProperty("SuspendedJobs")
    public void setSuspendedJobs(Integer suspendedJobs) {
        this.suspendedJobs = suspendedJobs;
    }

    /**
     * The number of suspended jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalSuspendedJobs")
    public Integer getLocalSuspendedJobs() {
        return localSuspendedJobs;
    }

    /**
     * The number of suspended jobs submitted using non-Grid interfaces
     * 
     */
    @JsonProperty("LocalSuspendedJobs")
    public void setLocalSuspendedJobs(Integer localSuspendedJobs) {
        this.localSuspendedJobs = localSuspendedJobs;
    }

    /**
     * The number of jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    public Integer getStagingJobs() {
        return stagingJobs;
    }

    /**
     * The number of jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    public void setStagingJobs(Integer stagingJobs) {
        this.stagingJobs = stagingJobs;
    }

    /**
     * The number of Grid jobs which have not yet been passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    public Integer getPreLRMSWaitingJobs() {
        return preLRMSWaitingJobs;
    }

    /**
     * The number of Grid jobs which have not yet been passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    public void setPreLRMSWaitingJobs(Integer preLRMSWaitingJobs) {
        this.preLRMSWaitingJobs = preLRMSWaitingJobs;
    }

    /**
     * An estimate of the average time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedAverageWaitingTime")
    public Integer getEstimatedAverageWaitingTime() {
        return estimatedAverageWaitingTime;
    }

    /**
     * An estimate of the average time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedAverageWaitingTime")
    public void setEstimatedAverageWaitingTime(Integer estimatedAverageWaitingTime) {
        this.estimatedAverageWaitingTime = estimatedAverageWaitingTime;
    }

    /**
     * An estimate of the worst-case time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedWorstWaitingTime")
    public Integer getEstimatedWorstWaitingTime() {
        return estimatedWorstWaitingTime;
    }

    /**
     * An estimate of the worst-case time a job will wait before it starts to execute (seconds)
     * 
     */
    @JsonProperty("EstimatedWorstWaitingTime")
    public void setEstimatedWorstWaitingTime(Integer estimatedWorstWaitingTime) {
        this.estimatedWorstWaitingTime = estimatedWorstWaitingTime;
    }

    /**
     * The number of slots which are currently available for use
     * 
     */
    @JsonProperty("FreeSlots")
    public Integer getFreeSlots() {
        return freeSlots;
    }

    /**
     * The number of slots which are currently available for use
     * 
     */
    @JsonProperty("FreeSlots")
    public void setFreeSlots(Integer freeSlots) {
        this.freeSlots = freeSlots;
    }

    /**
     * The number of slots which are currently available for use and how long they are available
     * 
     */
    @JsonProperty("FreeSlotsWithDuration")
    public String getFreeSlotsWithDuration() {
        return freeSlotsWithDuration;
    }

    /**
     * The number of slots which are currently available for use and how long they are available
     * 
     */
    @JsonProperty("FreeSlotsWithDuration")
    public void setFreeSlotsWithDuration(String freeSlotsWithDuration) {
        this.freeSlotsWithDuration = freeSlotsWithDuration;
    }

    /**
     * The number of slots currently in use
     * 
     */
    @JsonProperty("UsedSlots")
    public Integer getUsedSlots() {
        return usedSlots;
    }

    /**
     * The number of slots currently in use
     * 
     */
    @JsonProperty("UsedSlots")
    public void setUsedSlots(Integer usedSlots) {
        this.usedSlots = usedSlots;
    }

    /**
     * The number of slots needd to execute all waiting and staging jobs
     * 
     */
    @JsonProperty("RequestedSlots")
    public Integer getRequestedSlots() {
        return requestedSlots;
    }

    /**
     * The number of slots needd to execute all waiting and staging jobs
     * 
     */
    @JsonProperty("RequestedSlots")
    public void setRequestedSlots(Integer requestedSlots) {
        this.requestedSlots = requestedSlots;
    }

    /**
     * The policy used for advance reservation - ReservationPolicy_t
     * 
     */
    @JsonProperty("ReservationPolicy")
    public ComputingShare.ReservationPolicy getReservationPolicy() {
        return reservationPolicy;
    }

    /**
     * The policy used for advance reservation - ReservationPolicy_t
     * 
     */
    @JsonProperty("ReservationPolicy")
    public void setReservationPolicy(ComputingShare.ReservationPolicy reservationPolicy) {
        this.reservationPolicy = reservationPolicy;
    }

    /**
     * UserDomain-defined tags for this Share
     * 
     */
    @JsonProperty("Tag")
    public List<String> getTag() {
        return tag;
    }

    /**
     * UserDomain-defined tags for this Share
     * 
     */
    @JsonProperty("Tag")
    public void setTag(List<String> tag) {
        this.tag = tag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum ReservationPolicy {

        MANDATORY("mandatory"),
        NONE("none"),
        OPTIONAL("optional");
        private final String value;
        private static Map<String, ComputingShare.ReservationPolicy> constants = new HashMap<String, ComputingShare.ReservationPolicy>();

        static {
            for (ComputingShare.ReservationPolicy c: ComputingShare.ReservationPolicy.values()) {
                constants.put(c.value, c);
            }
        }

        private ReservationPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ComputingShare.ReservationPolicy fromValue(String value) {
            ComputingShare.ReservationPolicy constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum ServingState {

        CLOSED("closed"),
        DRAINING("draining"),
        PRODUCTION("production"),
        QUEUEING("queueing");
        private final String value;
        private static Map<String, ComputingShare.ServingState> constants = new HashMap<String, ComputingShare.ServingState>();

        static {
            for (ComputingShare.ServingState c: ComputingShare.ServingState.values()) {
                constants.put(c.value, c);
            }
        }

        private ServingState(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ComputingShare.ServingState fromValue(String value) {
            ComputingShare.ServingState constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
