
package org.apache.airavata;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "TotalJobs",
    "RunningJobs",
    "WaitingJobs",
    "StagingJobs",
    "SuspendedJobs",
    "PreLRMSWaitingJobs"
})
public class ComputingService {

    /**
     * The total number of Grid jobs known to the system
     * 
     */
    @JsonProperty("TotalJobs")
    private Integer totalJobs;
    /**
     * The number of Grid jobs which are running in an ExecutionEnvironment
     * 
     */
    @JsonProperty("RunningJobs")
    private Integer runningJobs;
    /**
     * The number of Grid jobs which are waiting to start executing
     * 
     */
    @JsonProperty("WaitingJobs")
    private Integer waitingJobs;
    /**
     * The number of Grid jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    private Integer stagingJobs;
    /**
     * The number of Grid jobs that started to execute, but are now suspended
     * 
     */
    @JsonProperty("SuspendedJobs")
    private Integer suspendedJobs;
    /**
     * The number of Grid jobs managed by the Grid software, but not yet passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    private Integer preLRMSWaitingJobs;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The total number of Grid jobs known to the system
     * 
     */
    @JsonProperty("TotalJobs")
    public Integer getTotalJobs() {
        return totalJobs;
    }

    /**
     * The total number of Grid jobs known to the system
     * 
     */
    @JsonProperty("TotalJobs")
    public void setTotalJobs(Integer totalJobs) {
        this.totalJobs = totalJobs;
    }

    /**
     * The number of Grid jobs which are running in an ExecutionEnvironment
     * 
     */
    @JsonProperty("RunningJobs")
    public Integer getRunningJobs() {
        return runningJobs;
    }

    /**
     * The number of Grid jobs which are running in an ExecutionEnvironment
     * 
     */
    @JsonProperty("RunningJobs")
    public void setRunningJobs(Integer runningJobs) {
        this.runningJobs = runningJobs;
    }

    /**
     * The number of Grid jobs which are waiting to start executing
     * 
     */
    @JsonProperty("WaitingJobs")
    public Integer getWaitingJobs() {
        return waitingJobs;
    }

    /**
     * The number of Grid jobs which are waiting to start executing
     * 
     */
    @JsonProperty("WaitingJobs")
    public void setWaitingJobs(Integer waitingJobs) {
        this.waitingJobs = waitingJobs;
    }

    /**
     * The number of Grid jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    public Integer getStagingJobs() {
        return stagingJobs;
    }

    /**
     * The number of Grid jobs staging files before or after execution
     * 
     */
    @JsonProperty("StagingJobs")
    public void setStagingJobs(Integer stagingJobs) {
        this.stagingJobs = stagingJobs;
    }

    /**
     * The number of Grid jobs that started to execute, but are now suspended
     * 
     */
    @JsonProperty("SuspendedJobs")
    public Integer getSuspendedJobs() {
        return suspendedJobs;
    }

    /**
     * The number of Grid jobs that started to execute, but are now suspended
     * 
     */
    @JsonProperty("SuspendedJobs")
    public void setSuspendedJobs(Integer suspendedJobs) {
        this.suspendedJobs = suspendedJobs;
    }

    /**
     * The number of Grid jobs managed by the Grid software, but not yet passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    public Integer getPreLRMSWaitingJobs() {
        return preLRMSWaitingJobs;
    }

    /**
     * The number of Grid jobs managed by the Grid software, but not yet passed to the LRMS
     * 
     */
    @JsonProperty("PreLRMSWaitingJobs")
    public void setPreLRMSWaitingJobs(Integer preLRMSWaitingJobs) {
        this.preLRMSWaitingJobs = preLRMSWaitingJobs;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
