
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Distributed",
    "Owner",
    "ServiceID",
    "ChildDomainID",
    "ParentDomainID",
    "ComputingServiceID",
    "StorageServiceID"
})
public class AdminDomain {

    /**
     * true if the services managed by the AdminDomain are geographically distributed
     * 
     */
    @JsonProperty("Distributed")
    private Boolean distributed;
    /**
     * Identification of persons or legal entities that own the resources in this AdminDomain
     * 
     */
    @JsonProperty("Owner")
    private List<String> owner = new ArrayList<String>();
    /**
     * IDs of Services in this AdminDomain
     * 
     */
    @JsonProperty("ServiceID")
    private List<String> serviceID = new ArrayList<String>();
    /**
     * IDs of AdminDomains aggregated by this AdminDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    private List<String> childDomainID = new ArrayList<String>();
    /**
     * The ID of the AdminDomain that this AdminDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    private String parentDomainID;
    /**
     * IDs of ComputingServices in this AdminDomain
     * 
     */
    @JsonProperty("ComputingServiceID")
    private List<String> computingServiceID = new ArrayList<String>();
    /**
     * IDs of StorageServices in this AdminDomain
     * 
     */
    @JsonProperty("StorageServiceID")
    private List<String> storageServiceID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * true if the services managed by the AdminDomain are geographically distributed
     * 
     */
    @JsonProperty("Distributed")
    public Boolean getDistributed() {
        return distributed;
    }

    /**
     * true if the services managed by the AdminDomain are geographically distributed
     * 
     */
    @JsonProperty("Distributed")
    public void setDistributed(Boolean distributed) {
        this.distributed = distributed;
    }

    /**
     * Identification of persons or legal entities that own the resources in this AdminDomain
     * 
     */
    @JsonProperty("Owner")
    public List<String> getOwner() {
        return owner;
    }

    /**
     * Identification of persons or legal entities that own the resources in this AdminDomain
     * 
     */
    @JsonProperty("Owner")
    public void setOwner(List<String> owner) {
        this.owner = owner;
    }

    /**
     * IDs of Services in this AdminDomain
     * 
     */
    @JsonProperty("ServiceID")
    public List<String> getServiceID() {
        return serviceID;
    }

    /**
     * IDs of Services in this AdminDomain
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(List<String> serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * IDs of AdminDomains aggregated by this AdminDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    public List<String> getChildDomainID() {
        return childDomainID;
    }

    /**
     * IDs of AdminDomains aggregated by this AdminDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    public void setChildDomainID(List<String> childDomainID) {
        this.childDomainID = childDomainID;
    }

    /**
     * The ID of the AdminDomain that this AdminDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    public String getParentDomainID() {
        return parentDomainID;
    }

    /**
     * The ID of the AdminDomain that this AdminDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    public void setParentDomainID(String parentDomainID) {
        this.parentDomainID = parentDomainID;
    }

    /**
     * IDs of ComputingServices in this AdminDomain
     * 
     */
    @JsonProperty("ComputingServiceID")
    public List<String> getComputingServiceID() {
        return computingServiceID;
    }

    /**
     * IDs of ComputingServices in this AdminDomain
     * 
     */
    @JsonProperty("ComputingServiceID")
    public void setComputingServiceID(List<String> computingServiceID) {
        this.computingServiceID = computingServiceID;
    }

    /**
     * IDs of StorageServices in this AdminDomain
     * 
     */
    @JsonProperty("StorageServiceID")
    public List<String> getStorageServiceID() {
        return storageServiceID;
    }

    /**
     * IDs of StorageServices in this AdminDomain
     * 
     */
    @JsonProperty("StorageServiceID")
    public void setStorageServiceID(List<String> storageServiceID) {
        this.storageServiceID = storageServiceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
