
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "UserDomainID",
    "EndpointID",
    "ShareID",
    "ResourceID",
    "ActivityID"
})
public class Activity {

    /**
     * An ID
     * 
     */
    @JsonProperty("UserDomainID")
    private String userDomainID;
    /**
     * The ID of the Endpoint managing Activity
     * 
     */
    @JsonProperty("EndpointID")
    private String endpointID;
    /**
     * The ID of the Share servicing this Activity
     * 
     */
    @JsonProperty("ShareID")
    private String shareID;
    /**
     * The ID of the Resource executing this Activity
     * 
     */
    @JsonProperty("ResourceID")
    private String resourceID;
    /**
     * The IDs of other Activities related to this one
     * 
     */
    @JsonProperty("ActivityID")
    private List<String> activityID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * An ID
     * 
     */
    @JsonProperty("UserDomainID")
    public String getUserDomainID() {
        return userDomainID;
    }

    /**
     * An ID
     * 
     */
    @JsonProperty("UserDomainID")
    public void setUserDomainID(String userDomainID) {
        this.userDomainID = userDomainID;
    }

    /**
     * The ID of the Endpoint managing Activity
     * 
     */
    @JsonProperty("EndpointID")
    public String getEndpointID() {
        return endpointID;
    }

    /**
     * The ID of the Endpoint managing Activity
     * 
     */
    @JsonProperty("EndpointID")
    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    /**
     * The ID of the Share servicing this Activity
     * 
     */
    @JsonProperty("ShareID")
    public String getShareID() {
        return shareID;
    }

    /**
     * The ID of the Share servicing this Activity
     * 
     */
    @JsonProperty("ShareID")
    public void setShareID(String shareID) {
        this.shareID = shareID;
    }

    /**
     * The ID of the Resource executing this Activity
     * 
     */
    @JsonProperty("ResourceID")
    public String getResourceID() {
        return resourceID;
    }

    /**
     * The ID of the Resource executing this Activity
     * 
     */
    @JsonProperty("ResourceID")
    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    /**
     * The IDs of other Activities related to this one
     * 
     */
    @JsonProperty("ActivityID")
    public List<String> getActivityID() {
        return activityID;
    }

    /**
     * The IDs of other Activities related to this one
     * 
     */
    @JsonProperty("ActivityID")
    public void setActivityID(List<String> activityID) {
        this.activityID = activityID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
