/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.util;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerConfig;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.monitor.HostMonitorData;
import org.apache.airavata.gfac.monitor.UserMonitorData;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.schemas.gfac.GsisshHostType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static boolean isPBSHost(HostDescription host) {
        return "pbs".equals(((GsisshHostType)host.getType()).getJobManager()) || "".equals(((GsisshHostType)host.getType()).getJobManager());
    }

    public static boolean isSlurm(HostDescription host) {
        return "slurm".equals(((GsisshHostType)host.getType()).getJobManager());
    }

    public static boolean isSGE(HostDescription host) {
        return "sge".equals(((GsisshHostType)host.getType()).getJobManager());
    }

    public static String getChannelID(MonitorID monitorID) {
        return monitorID.getUserName() + "-" + monitorID.getHost().getType().getHostName();
    }

    public static String getRoutingKey(MonitorID monitorID) {
        return "*." + monitorID.getUserName() + "." + monitorID.getHost().getType().getHostAddress();
    }

    public static String getChannelID(String userName, String hostAddress) {
        return userName + "-" + hostAddress;
    }

    public static String getRoutingKey(String userName, String hostAddress) {
        return "*." + userName + "." + hostAddress;
    }

    public static void addMonitortoQueue(BlockingQueue<UserMonitorData> queue, MonitorID monitorID) throws AiravataMonitorException {
        for (UserMonitorData next : queue) {
            if (!next.getUserName().equals(monitorID.getUserName())) continue;
            List<HostMonitorData> monitorIDs = next.getHostMonitorData();
            for (HostMonitorData host : monitorIDs) {
                if (!host.getHost().equals(monitorID.getHost())) continue;
                host.addMonitorIDForHost(monitorID);
                return;
            }
            HostMonitorData hostMonitorData = new HostMonitorData(monitorID.getHost());
            hostMonitorData.addMonitorIDForHost(monitorID);
            next.addHostMonitorData(hostMonitorData);
            return;
        }
        HostMonitorData hostMonitorData = new HostMonitorData(monitorID.getHost());
        hostMonitorData.addMonitorIDForHost(monitorID);
        UserMonitorData userMonitorData = new UserMonitorData(monitorID.getUserName());
        userMonitorData.addHostMonitorData(hostMonitorData);
        try {
            queue.put(userMonitorData);
        }
        catch (InterruptedException e) {
            throw new AiravataMonitorException(e);
        }
    }

    public static boolean isTheLastJobInQueue(BlockingQueue<MonitorID> queue, MonitorID monitorID) {
        for (MonitorID next : queue) {
            if (!monitorID.getUserName().equals(next.getUserName()) || !CommonUtils.isEqual(monitorID.getHost(), next.getHost())) continue;
            return false;
        }
        return true;
    }

    public static void removeMonitorFromQueue(BlockingQueue<UserMonitorData> queue, MonitorID monitorID) throws AiravataMonitorException {
        for (UserMonitorData next : queue) {
            if (!next.getUserName().equals(monitorID.getUserName())) continue;
            List<HostMonitorData> hostMonitorData = next.getHostMonitorData();
            for (HostMonitorData iHostMonitorID : hostMonitorData) {
                if (!iHostMonitorID.getHost().equals(monitorID.getHost())) continue;
                List<MonitorID> monitorIDs = iHostMonitorID.getMonitorIDs();
                for (MonitorID iMonitorID : monitorIDs) {
                    if (!iMonitorID.getJobID().equals(monitorID.getJobID())) continue;
                    monitorIDs.remove(iMonitorID);
                    if (monitorIDs.size() == 0) {
                        hostMonitorData.remove(iHostMonitorID);
                        if (hostMonitorData.size() == 0) {
                            queue.remove(next);
                        }
                    }
                    return;
                }
            }
        }
        throw new AiravataMonitorException("Cannot find the given MonitorID in the queue with userName " + monitorID.getUserName() + "  and jobID " + monitorID.getJobID());
    }

    public static boolean isEqual(HostDescription host1, HostDescription host2) {
        if (host1.getType() instanceof GsisshHostType && host2.getType() instanceof GsisshHostType) {
            GsisshHostType hostType1 = (GsisshHostType)host1.getType();
            GsisshHostType hostType2 = (GsisshHostType)host2.getType();
            if (hostType1.getHostAddress().equals(hostType2.getHostAddress()) && hostType1.getJobManager().equals(hostType2.getJobManager()) && hostType1.getPort() == hostType2.getPort() && hostType1.getMonitorMode().equals(hostType2.getMonitorMode())) {
                return true;
            }
        } else {
            logger.error("This method is only impmlemented to handle Gsissh host types");
        }
        return false;
    }

    public static void invokeOutFlowHandlers(JobExecutionContext jobExecutionContext) throws GFacException {
        List handlers = jobExecutionContext.getGFacConfiguration().getOutHandlers();
        for (GFacHandlerConfig handlerClassName : handlers) {
            GFacHandler handler;
            try {
                Class<GFacHandler> handlerClass = Class.forName(handlerClassName.getClassName().trim()).asSubclass(GFacHandler.class);
                handler = handlerClass.newInstance();
                handler.initProperties(handlerClassName.getProperties());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot load handler class " + handlerClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot instantiate handler class " + handlerClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
                throw new GFacException("Cannot instantiate handler class " + handlerClassName, (Throwable)e);
            }
            try {
                handler.invoke(jobExecutionContext);
            }
            catch (Exception e) {
                throw new GFacException("Error Executing a OutFlow Handler", (Throwable)e);
            }
        }
    }
}

