/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemMessageIdList
implements MessageListener {
    protected static final Log LOG = LogFactory.getLog(MemMessageIdList.class);
    private List<String> messageIds = new ArrayList<String>();
    private Object semaphore;
    private boolean verbose;
    private MessageListener parent;
    private long maximumDuration = 15000L;

    public MemMessageIdList() {
        this(new Object());
    }

    public MemMessageIdList(Object semaphore) {
        this.semaphore = semaphore;
    }

    public boolean equals(Object that) {
        if (that instanceof MemMessageIdList) {
            MemMessageIdList thatListMem = (MemMessageIdList)that;
            return ((Object)this.getMessageIds()).equals(thatListMem.getMessageIds());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.semaphore;
        synchronized (object) {
            return ((Object)this.messageIds).hashCode() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.semaphore;
        synchronized (object) {
            return this.messageIds.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> flushMessages() {
        Object object = this.semaphore;
        synchronized (object) {
            ArrayList<String> answer = new ArrayList<String>(this.messageIds);
            this.messageIds.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> getMessageIds() {
        Object object = this.semaphore;
        synchronized (object) {
            return new ArrayList<String>(this.messageIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        String id = null;
        try {
            id = message.getJMSMessageID();
            Object object = this.semaphore;
            synchronized (object) {
                this.messageIds.add(id);
                this.semaphore.notifyAll();
            }
            if (this.verbose) {
                LOG.info((Object)("Received message: " + message));
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        if (this.parent != null) {
            this.parent.onMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.semaphore;
        synchronized (object) {
            return this.messageIds.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        LOG.info((Object)("Waiting for " + messageCount + " message(s) to arrive"));
        long start = System.currentTimeMillis();
        for (int i = 0; i < messageCount; ++i) {
            try {
                long duration;
                if (this.hasReceivedMessages(messageCount) || (duration = System.currentTimeMillis() - start) >= this.maximumDuration) break;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(this.maximumDuration - duration);
                    continue;
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Caught: " + e));
            }
        }
        long end = System.currentTimeMillis() - start;
        LOG.info((Object)("End of wait for " + end + " millis and received: " + this.getMessageCount() + " messages"));
    }

    public boolean hasReceivedMessage() {
        return this.getMessageCount() == 0;
    }

    public boolean hasReceivedMessages(int messageCount) {
        return this.getMessageCount() >= messageCount;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MessageListener getParent() {
        return this.parent;
    }

    public void setParent(MessageListener parent) {
        this.parent = parent;
    }
}

