/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.tool.MemMessageIdList;

public class MemConsumer
extends MemMessageIdList
implements MessageListener {
    protected Connection connection;
    protected MessageConsumer consumer;
    protected long counter = 0L;
    protected boolean isParent = false;
    protected boolean inOrder = true;
    static long ctr = 0L;

    public MemConsumer() {
    }

    public MemConsumer(ConnectionFactory fac, Destination dest, String consumerName) throws JMSException {
        this.connection = fac.createConnection();
        Session s = this.connection.createSession(false, 1);
        this.consumer = dest instanceof Topic && consumerName != null && consumerName.length() > 0 ? s.createDurableSubscriber((Topic)dest, consumerName) : s.createConsumer(dest);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public MemConsumer(ConnectionFactory fac, Destination dest) throws JMSException {
        this(fac, dest, null);
    }

    public void start() throws JMSException {
        this.connection.start();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public Message receive() throws JMSException {
        return this.consumer.receive();
    }

    public Message receive(long wait) throws JMSException {
        return this.consumer.receive(wait);
    }

    public void onMessage(Message msg) {
        super.onMessage(msg);
        if (this.isParent) {
            try {
                long ctr = msg.getLongProperty("counter");
                if (this.counter != ctr) {
                    this.inOrder = false;
                }
                ++this.counter;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setAsParent(boolean isParent) {
        this.isParent = isParent;
    }

    public boolean isParent() {
        return this.isParent;
    }
}

