/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.tool.MemConsumer;
import org.apache.activemq.tool.MemProducer;
import org.apache.activemq.tool.MemoryMonitoringTool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMemtest {
    private static final Log log = LogFactory.getLog((Class)JMSMemtest.class);
    private static final int DEFAULT_MESSAGECOUNT = 5000;
    protected BrokerService broker;
    protected boolean topic = true;
    protected boolean durable = false;
    protected long messageCount = 0L;
    protected int connectionCheckpointSize;
    protected long connectionInterval;
    protected int consumerCount;
    protected int producerCount;
    protected int checkpointInterval;
    protected int prefetchSize;
    protected int messageSize;
    protected String reportDirectory;
    protected String reportName;
    protected String url = "";
    protected MemProducer[] producers;
    protected MemConsumer[] consumers;
    protected String destinationName;
    protected boolean allMessagesConsumed = true;
    protected MemConsumer allMessagesList = new MemConsumer();
    protected Message payload;
    protected ActiveMQConnectionFactory connectionFactory;
    protected Connection connection;
    protected Destination destination;
    protected boolean createConnectionPerClient = true;
    protected boolean transacted = false;
    protected boolean useEmbeddedBroker = true;
    protected MemoryMonitoringTool memoryMonitoringTool;

    public static void main(String[] args) {
        Properties sysSettings = new Properties();
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].indexOf("=");
            String key = args[i].substring(0, index);
            String val = args[i].substring(index + 1);
            sysSettings.setProperty(key, val);
        }
        JMSMemtest memtest = new JMSMemtest(sysSettings);
        try {
            memtest.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JMSMemtest(Properties settings) {
        this.url = settings.getProperty("url");
        this.topic = new Boolean(settings.getProperty("topic"));
        this.durable = new Boolean(settings.getProperty("durable"));
        this.connectionCheckpointSize = new Integer(settings.getProperty("connectionCheckpointSize"));
        this.producerCount = new Integer(settings.getProperty("producerCount"));
        this.consumerCount = new Integer(settings.getProperty("consumerCount"));
        this.messageCount = new Integer(settings.getProperty("messageCount")).intValue();
        this.messageSize = new Integer(settings.getProperty("messageSize"));
        this.prefetchSize = new Integer(settings.getProperty("prefetchSize"));
        this.checkpointInterval = new Integer(settings.getProperty("checkpointInterval")) * 1000;
        this.producerCount = new Integer(settings.getProperty("producerCount"));
        this.reportName = settings.getProperty("reportName");
        this.destinationName = settings.getProperty("destinationName");
        this.reportDirectory = settings.getProperty("reportDirectory");
        this.connectionInterval = this.connectionCheckpointSize * 1024;
    }

    protected void start() throws Exception {
        log.info((Object)"Starting Monitor");
        this.memoryMonitoringTool = new MemoryMonitoringTool();
        this.memoryMonitoringTool.setTestSettings(this.getSysTestSettings());
        Thread monitorThread = this.memoryMonitoringTool.startMonitor();
        if (this.messageCount == 0L) {
            this.messageCount = 5000L;
        }
        if (this.useEmbeddedBroker && this.broker == null) {
            this.broker = this.createBroker();
        }
        this.connectionFactory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        if (this.prefetchSize > 0) {
            this.connectionFactory.getPrefetchPolicy().setTopicPrefetch(this.prefetchSize);
            this.connectionFactory.getPrefetchPolicy().setQueuePrefetch(this.prefetchSize);
        }
        this.connection = this.connectionFactory.createConnection();
        Session session = this.connection.createSession(this.transacted, 1);
        this.destination = this.topic ? session.createTopic(this.destinationName) : session.createQueue(this.destinationName);
        this.createPayload(session);
        this.publishAndConsume();
        log.info((Object)"Closing resources");
        this.close();
        monitorThread.join();
    }

    protected boolean resetConnection(int counter) {
        long totalMsgSizeConsumed;
        return this.connectionInterval > 0L && this.connectionInterval < (totalMsgSizeConsumed = (long)(counter * 1024));
    }

    protected void publishAndConsume() throws Exception {
        this.createConsumers();
        this.createProducers();
        int counter = 0;
        boolean resetCon = false;
        log.info((Object)"Start sending messages ");
        int i = 0;
        while ((long)i < this.messageCount) {
            if (resetCon) {
                this.closeConsumers();
                this.closeProducers();
                this.createConsumers();
                this.createProducers();
                resetCon = false;
            }
            for (int k = 0; k < this.producers.length; ++k) {
                this.producers[k].sendMessage(this.payload, "counter", counter);
                if (!this.resetConnection(++counter)) continue;
                resetCon = true;
                break;
            }
            ++i;
        }
    }

    protected void close() throws Exception {
        this.connection.close();
        this.broker.stop();
        this.memoryMonitoringTool.stopMonitor();
    }

    protected void createPayload(Session session) throws JMSException {
        byte[] array = new byte[this.messageSize];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)i;
        }
        BytesMessage bystePayload = session.createBytesMessage();
        bystePayload.writeBytes(array);
        this.payload = bystePayload;
    }

    protected void createProducers() throws JMSException {
        this.producers = new MemProducer[this.producerCount];
        for (int i = 0; i < this.producerCount; ++i) {
            this.producers[i] = new MemProducer((ConnectionFactory)this.connectionFactory, this.destination);
            if (this.durable) {
                this.producers[i].setDeliveryMode(2);
            } else {
                this.producers[i].setDeliveryMode(1);
            }
            this.producers[i].start();
        }
    }

    protected void createConsumers() throws JMSException {
        this.consumers = new MemConsumer[this.consumerCount];
        for (int i = 0; i < this.consumerCount; ++i) {
            this.consumers[i] = new MemConsumer((ConnectionFactory)this.connectionFactory, this.destination);
            this.consumers[i].setParent(this.allMessagesList);
            this.consumers[i].start();
        }
    }

    protected void closeProducers() throws JMSException {
        for (int i = 0; i < this.producerCount; ++i) {
            this.producers[i].shutDown();
        }
    }

    protected void closeConsumers() throws JMSException {
        for (int i = 0; i < this.consumerCount; ++i) {
            this.consumers[i].shutDown();
        }
    }

    protected ConnectionFactory createConnectionFactory() throws JMSException {
        if (this.url == null || this.url.trim().equals("") || this.url.trim().equals("null")) {
            return new ActiveMQConnectionFactory("vm://localhost");
        }
        return new ActiveMQConnectionFactory(this.url);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        this.configureBroker(broker);
        broker.start();
        return broker;
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        broker.addConnector("vm://localhost");
        broker.setDeleteAllMessagesOnStartup(true);
    }

    protected Properties getSysTestSettings() {
        Properties settings = new Properties();
        settings.setProperty("domain", this.topic ? "topic" : "queue");
        settings.setProperty("durable", this.durable ? "durable" : "non-durable");
        settings.setProperty("connection_checkpoint_size_kb", new Integer(this.connectionCheckpointSize).toString());
        settings.setProperty("producer_count", new Integer(this.producerCount).toString());
        settings.setProperty("consumer_count", new Integer(this.consumerCount).toString());
        settings.setProperty("message_count", new Long(this.messageCount).toString());
        settings.setProperty("message_size", new Integer(this.messageSize).toString());
        settings.setProperty("prefetchSize", new Integer(this.prefetchSize).toString());
        settings.setProperty("checkpoint_interval", new Integer(this.checkpointInterval).toString());
        settings.setProperty("destination_name", this.destinationName);
        settings.setProperty("report_name", this.reportName);
        settings.setProperty("report_directory", this.reportDirectory);
        settings.setProperty("connection_checkpoint_size", new Integer(this.connectionCheckpointSize).toString());
        return settings;
    }
}

