/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.LinkedNode;
import org.apache.kahadb.util.LinkedNodeList;

class DataFileAppender {
    protected final Journal journal;
    protected final Map<WriteKey, WriteCommand> inflightWrites;
    protected final Object enqueueMutex = new Object(){};
    protected WriteBatch nextWriteBatch;
    protected boolean shutdown;
    protected IOException firstAsyncException;
    protected final CountDownLatch shutdownDone = new CountDownLatch(1);
    protected int maxWriteBatchSize;
    private boolean running;
    private Thread thread;

    public DataFileAppender(Journal dataManager) {
        this.journal = dataManager;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, sync);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            batch = this.enqueue(write);
        }
        location.setLatch(batch.latch);
        if (sync) {
            try {
                batch.latch.await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            IOException exception = batch.exception.get();
            if (exception != null) {
                throw exception;
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        WriteBatch batch;
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        WriteCommand write = new WriteCommand(location, data, onComplete);
        DataFileAppender dataFileAppender = this;
        synchronized (dataFileAppender) {
            batch = this.enqueue(write);
        }
        location.setLatch(batch.latch);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteBatch enqueue(WriteCommand write) throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            block14: {
                if (this.shutdown) {
                    throw new IOException("Async Writter Thread Shutdown");
                }
                if (!this.running) {
                    this.running = true;
                    this.thread = new Thread(){

                        public void run() {
                            DataFileAppender.this.processQueue();
                        }
                    };
                    this.thread.setPriority(10);
                    this.thread.setDaemon(true);
                    this.thread.setName("ActiveMQ Data File Writer");
                    this.thread.start();
                    this.firstAsyncException = null;
                }
                if (this.firstAsyncException != null) {
                    throw this.firstAsyncException;
                }
                do {
                    if (this.nextWriteBatch == null) {
                        DataFile file = this.journal.getCurrentWriteFile();
                        if (file.getLength() > this.journal.getMaxFileLength()) {
                            file = this.journal.rotateWriteFile();
                        }
                        this.nextWriteBatch = new WriteBatch(file, file.getLength(), write);
                        this.enqueueMutex.notify();
                        break block14;
                    }
                    if (this.nextWriteBatch.canAppend(write)) {
                        this.nextWriteBatch.append(write);
                        break block14;
                    }
                    try {
                        while (this.nextWriteBatch != null) {
                            this.enqueueMutex.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                } while (!this.shutdown);
                throw new IOException("Async Writter Thread Shutdown");
            }
            if (!write.sync) {
                this.inflightWrites.put(new WriteKey(write.location), write);
            }
            return this.nextWriteBatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.enqueueMutex;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.running) {
                    this.enqueueMutex.notifyAll();
                } else {
                    this.shutdownDone.countDown();
                }
            }
        }
        try {
            this.shutdownDone.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * Exception decompiling
     */
    protected void processQueue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriteCommand
    extends LinkedNode<WriteCommand> {
        public final Location location;
        public final ByteSequence data;
        final boolean sync;
        public final Runnable onComplete;

        public WriteCommand(Location location, ByteSequence data, boolean sync) {
            this.location = location;
            this.data = data;
            this.sync = sync;
            this.onComplete = null;
        }

        public WriteCommand(Location location, ByteSequence data, Runnable onComplete) {
            this.location = location;
            this.data = data;
            this.onComplete = onComplete;
            this.sync = false;
        }
    }

    public class WriteBatch {
        public final DataFile dataFile;
        public final LinkedNodeList<WriteCommand> writes = new LinkedNodeList();
        public final CountDownLatch latch = new CountDownLatch(1);
        private final int offset;
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset, WriteCommand write) throws IOException {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            DataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.append(write);
        }

        public boolean canAppend(WriteCommand write) {
            int newSize = this.size + write.location.getSize();
            return newSize < DataFileAppender.this.maxWriteBatchSize && this.offset + newSize <= DataFileAppender.this.journal.getMaxFileLength();
        }

        public void append(WriteCommand write) throws IOException {
            this.writes.addLast(write);
            write.location.setDataFileId(this.dataFile.getDataFileId());
            write.location.setOffset(this.offset + this.size);
            int s = write.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            DataFileAppender.this.journal.addToTotalLength(s);
        }

        static /* synthetic */ int access$000(WriteBatch x0) {
            return x0.offset;
        }
    }

    public static class WriteKey {
        private final int file;
        private final long offset;
        private final int hash;

        public WriteKey(Location item) {
            this.file = item.getDataFileId();
            this.offset = item.getOffset();
            this.hash = (int)((long)this.file ^ this.offset);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WriteKey) {
                WriteKey di = (WriteKey)obj;
                return di.file == this.file && di.offset == this.offset;
            }
            return false;
        }
    }
}

