/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class BackupReplicationStartFailedMessage
extends PacketImpl {
    private BackupRegistrationProblem problem;

    private static BackupRegistrationProblem getType(int type) {
        return BackupRegistrationProblem.TYPE_MAP.get(type);
    }

    public BackupReplicationStartFailedMessage(BackupRegistrationProblem registrationProblem) {
        super((byte)116);
        this.problem = Objects.requireNonNull(registrationProblem);
    }

    public BackupReplicationStartFailedMessage() {
        super((byte)116);
    }

    public BackupRegistrationProblem getRegistrationProblem() {
        return this.problem;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.problem.code);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.problem = BackupReplicationStartFailedMessage.getType(buffer.readInt());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BackupReplicationStartFailedMessage)) {
            return false;
        }
        BackupReplicationStartFailedMessage other = (BackupReplicationStartFailedMessage)((Object)obj);
        return Objects.equals((Object)this.problem, (Object)other.problem);
    }

    public int hashCode() {
        return super.hashCode() + Objects.hashCode((Object)this.problem);
    }

    protected String getPacketString() {
        return super.getPacketString() + ", problem=" + (this.problem != null ? this.problem.name() : null);
    }

    public static enum BackupRegistrationProblem {
        EXCEPTION(0),
        AUTHENTICATION(1),
        ALREADY_REPLICATING(2);

        private static final Map<Integer, BackupRegistrationProblem> TYPE_MAP;
        final int code;

        private BackupRegistrationProblem(int code) {
            this.code = code;
        }

        static {
            HashMap<Integer, BackupRegistrationProblem> map = new HashMap<Integer, BackupRegistrationProblem>();
            for (BackupRegistrationProblem type : EnumSet.allOf(BackupRegistrationProblem.class)) {
                map.put(type.code, type);
            }
            TYPE_MAP = Collections.unmodifiableMap(map);
        }
    }
}

