/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNullRefException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.BucketMessageGroups;
import org.apache.activemq.artemis.core.server.impl.DisabledMessageGroups;
import org.apache.activemq.artemis.core.server.impl.GroupFirstMessageReference;
import org.apache.activemq.artemis.core.server.impl.MessageGroups;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.server.impl.QueueConfigurationUtils;
import org.apache.activemq.artemis.core.server.impl.QueueConsumers;
import org.apache.activemq.artemis.core.server.impl.QueueConsumersImpl;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.QueueMessageMetrics;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.impl.SimpleMessageGroups;
import org.apache.activemq.artemis.core.server.impl.TransientQueueManagerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.NamedHierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.BindingsTransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.BooleanUtil;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStoreFactory;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueImpl
extends CriticalComponentImpl
implements Queue {
    protected static final int CRITICAL_PATHS = 5;
    protected static final int CRITICAL_PATH_ADD_TAIL = 0;
    protected static final int CRITICAL_PATH_ADD_HEAD = 1;
    protected static final int CRITICAL_DELIVER = 2;
    protected static final int CRITICAL_CONSUMER = 3;
    protected static final int CRITICAL_CHECK_DEPAGE = 4;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicIntegerFieldUpdater<QueueImpl> dispatchingUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueImpl.class, "dispatching");
    private static final AtomicLongFieldUpdater<QueueImpl> dispatchStartTimeUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "dispatchStartTime");
    private static final AtomicLongFieldUpdater<QueueImpl> consumerRemovedTimestampUpdater = AtomicLongFieldUpdater.newUpdater(QueueImpl.class, "consumerRemovedTimestamp");
    private static final AtomicReferenceFieldUpdater<QueueImpl, Filter> filterUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueImpl.class, Filter.class, "filter");
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 1000;
    public static final int DELIVERY_TIMEOUT = 1000;
    public static final int DEFAULT_FLUSH_LIMIT = 500;
    private volatile Filter filter;
    private final PostOffice postOffice;
    private volatile boolean queueDestroyed = false;
    private volatile boolean pageFlowControlled = false;
    private volatile long pageFlowControlledLastLog = 0L;
    private static final long PAGE_FLOW_CONTROL_PRINT_INTERVAL = Long.parseLong(System.getProperty("ARTEMIS_PAGE_FLOW_CONTROL_PRINT_INTERVAL", "60000"));
    private volatile boolean pageDelivered = false;
    private final PagingStore pagingStore;
    protected final PageSubscription pageSubscription;
    private final ReferenceCounter refCountForConsumers;
    private final PageIterator pageIterator;
    private volatile boolean printErrorExpiring = false;
    private boolean mirrorController;
    private volatile boolean hasUnMatchedPending = false;
    private final MpscUnboundedArrayQueue<MessageReference> intermediateMessageReferences;
    protected final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl(10, MessageReferenceImpl.getSequenceComparator());
    private NodeStoreFactory<MessageReference> nodeStoreFactory;
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    final SizeAwareMetric queueMemorySize = new SizeAwareMetric();
    protected final QueueMessageMetrics pendingMetrics = new QueueMessageMetrics(this, "pending");
    private final QueueMessageMetrics deliveringMetrics = new QueueMessageMetrics(this, "delivering");
    protected final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private final AtomicLong messagesAdded = new AtomicLong(0L);
    private final AtomicLong messagesAcknowledged = new AtomicLong(0L);
    private final AtomicLong ackAttempts = new AtomicLong(0L);
    private final AtomicLong messagesExpired = new AtomicLong(0L);
    private final AtomicLong messagesKilled = new AtomicLong(0L);
    private final AtomicLong messagesReplaced = new AtomicLong(0L);
    private boolean paused;
    private long pauseStatusRecord = -1L;
    private static final int MAX_SCHEDULED_RUNNERS = 1;
    private static final int MAX_DEPAGE_NUM = 1000;
    private final AtomicInteger scheduledRunners = new AtomicInteger(0);
    private final Runnable deliverRunner = new DeliverRunner();
    private final ReentrantLock deliverLock = new ReentrantLock();
    private final ReentrantLock depageLock = new ReentrantLock();
    private volatile boolean depagePending = false;
    private final StorageManager storageManager;
    private volatile AddressSettings cachedAddressSettings;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private ConsumerHolder<Redistributor> redistributor;
    private ScheduledFuture<?> redistributorFuture;
    private volatile long consumerRemovedTimestamp = -1L;
    private final QueueConsumers<ConsumerHolder<? extends Consumer>> consumers = new QueueConsumersImpl<ConsumerHolder<? extends Consumer>>();
    private MessageGroups<Consumer> groups;
    private volatile Consumer exclusiveConsumer;
    private final ArtemisExecutor executor;
    private volatile long lastDirectDeliveryCheck = 0L;
    private volatile boolean directDeliver = true;
    private volatile boolean supportsDirectDeliver = false;
    private HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private HierarchicalRepositoryChangeListener addressSettingsRepositoryListener;
    private final ReusableLatch deliveriesInTransit = new ReusableLatch(0);
    private final AtomicLong queueRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong messagesAddedSnapshot = new AtomicLong(0L);
    private final AtomicLong queueSequence = new AtomicLong(0L);
    private ScheduledFuture slowConsumerReaperFuture;
    private SlowConsumerReaperRunnable slowConsumerReaperRunnable;
    private final AddressInfo addressInfo;
    private final QueueFactory factory;
    public volatile int dispatching = 0;
    public volatile long dispatchStartTime = -1L;
    private volatile boolean swept;
    private volatile long createdTimestamp = -1L;
    private volatile boolean noRouteLogging = true;
    private final int initialQueueBufferSize;
    protected final QueueConfiguration queueConfiguration;
    private final Object directDeliveryGuard = new Object();
    private final ConcurrentHashSet<String> lingerSessionIds = new ConcurrentHashSet();

    private void checkIDSupplier(NodeStoreFactory<MessageReference> nodeStoreFactory) {
        if (this.nodeStoreFactory == null) {
            this.nodeStoreFactory = nodeStoreFactory;
            this.messageReferences.setNodeStore(() -> nodeStoreFactory.newNodeStore().setName(String.valueOf(this.queueConfiguration.getName())));
        }
    }

    @Override
    public boolean isSwept() {
        return this.swept;
    }

    @Override
    public void setSwept(boolean swept) {
        this.swept = swept;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + String.valueOf(this.queueMemorySize));
        for (ConsumerHolder queueImpl : this.consumers) {
            out.println("consumer: " + queueImpl.consumer.debug());
        }
        out.println("Intermediate reference size is " + this.intermediateMessageReferences.size());
        boolean foundRef = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try (LinkedListIterator iter = this.messageReferences.iterator();){
                while (iter.hasNext()) {
                    foundRef = true;
                    out.println("reference = " + String.valueOf(iter.next()));
                }
            }
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    public QueueImpl(final QueueConfiguration queueConfiguration, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super(server.getCriticalAnalyzer(), 5);
        this.createdTimestamp = System.currentTimeMillis();
        this.queueConfiguration = QueueConfiguration.of((QueueConfiguration)queueConfiguration);
        this.mirrorController = queueConfiguration.isMirrorQueue();
        QueueConfigurationUtils.applyStaticDefaults(this.queueConfiguration);
        this.refCountForConsumers = this.queueConfiguration.isTransient() != false ? new TransientQueueManagerImpl(server, this.queueConfiguration.getName()) : new QueueManagerImpl(server, this.queueConfiguration.getName());
        this.addressInfo = postOffice == null ? null : postOffice.getAddressInfo(this.queueConfiguration.getAddress());
        try {
            this.filter = filter == null ? FilterImpl.createFilter(this.queueConfiguration.getFilterString()) : filter;
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e);
        }
        this.pagingStore = pagingStore;
        this.pageSubscription = pageSubscription;
        this.groups = QueueImpl.groupMap(this.queueConfiguration.getGroupBuckets());
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.scheduledExecutor = scheduledExecutor;
        this.server = server;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor, this);
        if (addressSettingsRepository != null) {
            this.addressSettingsRepository = addressSettingsRepository;
            this.addressSettingsRepositoryListener = new NamedHierarchicalRepositoryChangeListener(queueConfiguration.getName()){

                @Override
                public void onChange() {
                    QueueImpl.this.cachedAddressSettings = QueueImpl.this.addressSettingsRepository.getMatch(queueConfiguration.getAddress().toString());
                    QueueImpl.this.checkDeadLetterAddressAndExpiryAddress();
                    QueueImpl.this.configureSlowConsumerReaper();
                }
            };
            this.addressSettingsRepository.registerListener(this.addressSettingsRepositoryListener);
            this.cachedAddressSettings = addressSettingsRepository.getMatch(queueConfiguration.getAddress().toString());
        } else {
            this.cachedAddressSettings = new AddressSettings();
        }
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.factory = factory;
        if (this.addressInfo != null && this.addressInfo.isPaused()) {
            this.pause(false);
        }
        this.initialQueueBufferSize = this.cachedAddressSettings.getInitialQueueBufferSize() == null ? 8192 : this.cachedAddressSettings.getInitialQueueBufferSize();
        this.intermediateMessageReferences = new MpscUnboundedArrayQueue(this.initialQueueBufferSize);
        this.verifyDisabledConfiguration();
    }

    private void verifyDisabledConfiguration() {
        if (this.noRouteLogging && !this.queueConfiguration.isEnabled().booleanValue()) {
            ActiveMQServerLogger.LOGGER.noRouteMessagesWillBeDropped(this.getAddress(), this.getName());
        }
    }

    @Override
    public boolean allowsReferenceCallback() {
        return this.queueConfiguration.isNonDestructive() == false;
    }

    @Override
    public boolean isMirrorController() {
        return this.mirrorController;
    }

    @Override
    public void setMirrorController(boolean mirrorController) {
        this.mirrorController = mirrorController;
    }

    public SimpleString getRoutingName() {
        return this.queueConfiguration.getName();
    }

    public SimpleString getUniqueName() {
        return this.queueConfiguration.getName();
    }

    @Override
    public SimpleString getUser() {
        return this.queueConfiguration.getUser();
    }

    @Override
    public void setUser(SimpleString user) {
        this.queueConfiguration.setUser(user);
    }

    @Override
    public boolean isExclusive() {
        return this.queueConfiguration.isExclusive();
    }

    @Override
    public synchronized void setExclusive(boolean exclusive) {
        this.queueConfiguration.setExclusive(Boolean.valueOf(exclusive));
        if (!exclusive) {
            this.exclusiveConsumer = null;
        }
    }

    @Override
    public int getConsumersBeforeDispatch() {
        return this.queueConfiguration.getConsumersBeforeDispatch();
    }

    @Override
    public synchronized void setConsumersBeforeDispatch(int consumersBeforeDispatch) {
        this.queueConfiguration.setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch));
    }

    @Override
    public long getDelayBeforeDispatch() {
        return this.queueConfiguration.getDelayBeforeDispatch();
    }

    @Override
    public synchronized void setDelayBeforeDispatch(long delayBeforeDispatch) {
        this.queueConfiguration.setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch));
    }

    @Override
    public long getDispatchStartTime() {
        return dispatchStartTimeUpdater.get(this);
    }

    @Override
    public boolean isDispatching() {
        return BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
    }

    @Override
    public synchronized void setDispatching(boolean dispatching) {
        if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((!dispatching ? 1 : 0) != 0), BooleanUtil.toInt((boolean)dispatching))) {
            if (dispatching) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            } else {
                dispatchStartTimeUpdater.set(this, -1L);
            }
        }
    }

    @Override
    public boolean isLastValue() {
        return this.queueConfiguration.isLastValue();
    }

    @Override
    public SimpleString getLastValueKey() {
        return this.queueConfiguration.getLastValueKey();
    }

    @Override
    public boolean isNonDestructive() {
        return this.queueConfiguration.isNonDestructive();
    }

    @Override
    public synchronized void setNonDestructive(boolean nonDestructive) {
        this.queueConfiguration.setNonDestructive(Boolean.valueOf(nonDestructive));
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (!this.queueConfiguration.isEnabled().booleanValue()) {
            if (this.noRouteLogging) {
                this.noRouteLogging = false;
                ActiveMQServerLogger.LOGGER.noRouteDisabledQueue(this.getAddress(), this.getName());
            }
            context.setReusable(false);
            return;
        }
        if (this.queueConfiguration.isPurgeOnNoConsumers().booleanValue()) {
            context.setReusable(false);
            if (this.getConsumerCount() == 0) {
                if (this.noRouteLogging) {
                    this.noRouteLogging = false;
                    ActiveMQServerLogger.LOGGER.noRouteNoConsumers(this.getAddress(), this.getName());
                }
                return;
            }
        }
        this.noRouteLogging = true;
        context.addQueue(this.queueConfiguration.getAddress(), this);
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) {
        context.addQueueWithAck(this.queueConfiguration.getAddress(), this);
    }

    @Override
    public ReferenceCounter getConsumersRefCount() {
        return this.refCountForConsumers;
    }

    @Override
    public boolean isDurable() {
        return this.queueConfiguration.isDurable();
    }

    @Override
    public boolean isDurableMessage() {
        return this.isDurable() && this.isPurgeOnNoConsumers();
    }

    @Override
    public boolean isAutoDelete() {
        return this.queueConfiguration.isAutoDelete();
    }

    @Override
    public long getAutoDeleteDelay() {
        return this.queueConfiguration.getAutoDeleteDelay();
    }

    @Override
    public long getAutoDeleteMessageCount() {
        return this.queueConfiguration.getAutoDeleteMessageCount();
    }

    @Override
    public boolean isTemporary() {
        return this.queueConfiguration.isTemporary();
    }

    @Override
    public boolean isAutoCreated() {
        return this.queueConfiguration.isAutoCreated();
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.queueConfiguration.isPurgeOnNoConsumers();
    }

    @Override
    public synchronized void setPurgeOnNoConsumers(boolean value) {
        this.queueConfiguration.setPurgeOnNoConsumers(Boolean.valueOf(value));
    }

    @Override
    public boolean isEnabled() {
        return this.queueConfiguration.isEnabled();
    }

    @Override
    public synchronized void setEnabled(boolean value) {
        this.queueConfiguration.setEnabled(Boolean.valueOf(value));
        this.verifyDisabledConfiguration();
    }

    @Override
    public int getMaxConsumers() {
        return this.queueConfiguration.getMaxConsumers();
    }

    @Override
    public synchronized void setMaxConsumer(int maxConsumers) {
        this.queueConfiguration.setMaxConsumers(Integer.valueOf(maxConsumers));
    }

    @Override
    public int getGroupBuckets() {
        return this.queueConfiguration.getGroupBuckets();
    }

    @Override
    public synchronized void setGroupBuckets(int groupBuckets) {
        if (this.queueConfiguration.getGroupBuckets() != groupBuckets) {
            this.groups = QueueImpl.groupMap(groupBuckets);
            this.queueConfiguration.setGroupBuckets(Integer.valueOf(groupBuckets));
        }
    }

    @Override
    public boolean isGroupRebalance() {
        return this.queueConfiguration.isGroupRebalance();
    }

    @Override
    public synchronized void setGroupRebalance(boolean groupRebalance) {
        this.queueConfiguration.setGroupRebalance(Boolean.valueOf(groupRebalance));
    }

    @Override
    public boolean isGroupRebalancePauseDispatch() {
        return this.queueConfiguration.isGroupRebalancePauseDispatch();
    }

    @Override
    public synchronized void setGroupRebalancePauseDispatch(boolean groupRebalancePauseDispatch) {
        this.queueConfiguration.setGroupRebalancePauseDispatch(Boolean.valueOf(groupRebalancePauseDispatch));
    }

    @Override
    public SimpleString getGroupFirstKey() {
        return this.queueConfiguration.getGroupFirstKey();
    }

    @Override
    public synchronized void setGroupFirstKey(SimpleString groupFirstKey) {
        this.queueConfiguration.setGroupFirstKey(groupFirstKey);
    }

    @Override
    public boolean isConfigurationManaged() {
        return this.queueConfiguration.isConfigurationManaged();
    }

    @Override
    public synchronized void setConfigurationManaged(boolean configurationManaged) {
        this.queueConfiguration.setConfigurationManaged(Boolean.valueOf(configurationManaged));
    }

    @Override
    public SimpleString getName() {
        return this.queueConfiguration.getName();
    }

    @Override
    public SimpleString getAddress() {
        return this.queueConfiguration.getAddress();
    }

    @Override
    public Long getID() {
        return this.queueConfiguration.getId();
    }

    @Override
    public int durableUp(Message message) {
        return message.durableUp();
    }

    @Override
    public int durableDown(Message message) {
        return message.durableDown();
    }

    @Override
    public void refUp(MessageReference messageReference) {
        int count = messageReference.getMessage().refUp();
        PagingStore owner = (PagingStore)messageReference.getMessage().getOwner();
        if (count == 1 && owner != null) {
            owner.addSize(messageReference.getMessageMemoryEstimate(), false);
            messageReference.getMessage().routed();
        }
        if (this.pagingStore != null) {
            if (this.isMirrorController() && owner != null && this.pagingStore != owner) {
                this.pagingStore.addSize(messageReference.getMessage().getOriginalEstimate(), false, false);
            }
            this.pagingStore.refUp(messageReference.getMessage(), count);
        }
    }

    @Override
    public void refDown(MessageReference messageReference) {
        int count = messageReference.getMessage().refDown();
        PagingStore owner = (PagingStore)messageReference.getMessage().getOwner();
        if (count == 0 && owner != null) {
            owner.addSize(-messageReference.getMessageMemoryEstimate(), false);
        }
        if (this.pagingStore != null) {
            if (this.isMirrorController() && owner != null && this.pagingStore != owner) {
                this.pagingStore.addSize(-messageReference.getMessage().getOriginalEstimate(), false, false);
            }
            this.pagingStore.refDown(messageReference.getMessage(), count);
        }
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pagingStore;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.queueConfiguration.getRoutingType();
    }

    @Override
    public int getInitialQueueBufferSize() {
        return this.initialQueueBufferSize;
    }

    @Override
    public void setRoutingType(RoutingType routingType) {
        if (this.addressInfo.getRoutingTypes().contains(routingType)) {
            this.queueConfiguration.setRoutingType(routingType);
        }
    }

    @Override
    public Filter getFilter() {
        return filterUpdater.get(this);
    }

    @Override
    public void setFilter(Filter filter) {
        filterUpdater.set(this, filter);
    }

    @Override
    public void unproposed(SimpleString groupID) {
        if (groupID.toString().endsWith("." + String.valueOf(this.getName()))) {
            SimpleString groupIDToRemove = (SimpleString)groupID.subSequence(0, groupID.length() - this.getName().length() - 1);
            this.getExecutor().execute(() -> {
                QueueImpl queueImpl = this;
                synchronized (queueImpl) {
                    if (this.groups.remove(groupIDToRemove) != null) {
                        logger.debug("Removing group after unproposal {} from queue {}", (Object)groupID, (Object)this);
                    } else {
                        logger.debug("Couldn't remove Removing group {} after unproposal on queue {}", (Object)groupIDToRemove, (Object)this);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(MessageReference ref, boolean scheduling) {
        if (logger.isTraceEnabled()) {
            logger.trace("AddHead, size = {}, intermediate size = {}, references size = {}\nreference={}", new Object[]{this.queueMemorySize, this.intermediateMessageReferences.size(), this.messageReferences.size(), ref});
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.queueConfiguration.getRingSize() != -1L) {
                    this.enforceRing(ref, scheduling, true);
                }
                if (!ref.isAlreadyAcked()) {
                    if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                        return;
                    }
                    this.internalAddHead(ref);
                    this.directDeliver = false;
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(MessageReference ref, boolean scheduling) {
        if (logger.isTraceEnabled()) {
            logger.trace("addSorted, size = {}, intermediate size = {}, references size = {}\nreference={}", new Object[]{this.queueMemorySize, this.intermediateMessageReferences.size(), this.messageReferences.size(), ref});
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.queueConfiguration.getRingSize() != -1L) {
                    this.enforceRing(ref, false, true);
                }
                if (!ref.isAlreadyAcked()) {
                    if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                        return;
                    }
                    this.internalAddSorted(ref);
                    this.directDeliver = false;
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(List<MessageReference> refs, boolean scheduling) {
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                for (MessageReference ref : refs) {
                    this.addHead(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSorted(List<MessageReference> refs, boolean scheduling) {
        if (refs.size() > 1000) {
            logger.debug("Switching addSorted call to addSortedLargeTX on queue {}", (Object)this.queueConfiguration.getName());
            this.addSortedLargeTX(refs, scheduling);
            return;
        }
        try (CriticalCloseable metric = this.measureCritical(1);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                for (MessageReference ref : refs) {
                    this.addSorted(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSortedLargeTX(List<MessageReference> refs, boolean scheduling) {
        for (MessageReference ref : refs) {
            this.addSorted(ref, scheduling);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("addSortedHugeLoad finished on queue {}", (Object)this.queueConfiguration.getName());
        }
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.resetAllIterators();
            this.deliverAsync();
        }
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        if (!ref.isPaged()) {
            this.incrementMesssagesAdded();
        }
    }

    @Override
    public void reloadSequence(MessageReference ref) {
        ref.setSequence(this.queueSequence.incrementAndGet());
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    @Override
    public void flushOnIntermediate(final Runnable runnable) {
        this.intermediateMessageReferences.add((Object)new MessageReferenceImpl(){

            @Override
            public boolean skipDelivery() {
                runnable.run();
                return true;
            }
        });
        this.deliverAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        try (CriticalCloseable metric = this.measureCritical(0);){
            if (this.scheduleIfPossible(ref)) {
                return;
            }
            if (RefCountMessage.isRefTraceEnabled()) {
                RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"add tail queue {}", (Object[])new Object[]{this.getName()});
            }
            if (direct && this.supportsDirectDeliver && !this.directDeliver && System.currentTimeMillis() - this.lastDirectDeliveryCheck > 1000L) {
                logger.trace("Checking to re-enable direct deliver on queue {}", (Object)this.queueConfiguration.getName());
                this.lastDirectDeliveryCheck = System.currentTimeMillis();
                Object object = this.directDeliveryGuard;
                synchronized (object) {
                    if (this.deliveriesInTransit.getCount() == 0 && this.getExecutor().isFlushed() && this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && this.pageIterator != null && !this.pageIterator.hasNext() && this.pageSubscription != null && !this.pageSubscription.isStorePaging()) {
                        this.directDeliver = this.supportsDirectDeliver;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Setting direct deliverer to {} on queue {}", (Object)this.supportsDirectDeliver, (Object)this.queueConfiguration.getName());
                        }
                    } else {
                        logger.trace("Couldn't set direct deliver back on queue {}", (Object)this.queueConfiguration.getName());
                    }
                }
            }
            if (direct && this.supportsDirectDeliver && this.directDeliver && this.deliveriesInTransit.getCount() == 0 && this.deliverDirect(ref)) {
                return;
            }
            this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
            this.intermediateMessageReferences.add((Object)ref);
            this.directDeliver = false;
            this.deliverAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleIfPossible(MessageReference ref) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (!ref.isPaged()) {
                    this.incrementMesssagesAdded();
                }
            }
            return true;
        }
        return false;
    }

    private boolean flushDeliveriesInTransit() {
        try {
            if (this.deliveriesInTransit.await(1000L)) {
                return true;
            }
            ActiveMQServerLogger.LOGGER.timeoutFlushInTransit(this.getName().toString(), this.getAddress().toString());
            return false;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToFlushDeliveries(e);
            return false;
        }
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isStorePaging()) {
            logger.trace("Force delivery scheduling depage");
            this.scheduleDepage(false);
        }
        logger.trace("Force delivery delivering async");
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        this.deliverAsync(false);
    }

    private void deliverAsync(boolean noWait) {
        if (this.scheduledRunners.get() < 1) {
            this.scheduledRunners.incrementAndGet();
            try {
                this.getExecutor().execute(this.deliverRunner);
            }
            catch (RejectedExecutionException ignored) {
                this.scheduledRunners.decrementAndGet();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.getExecutor().execute(this::cancelRedistributor);
        this.addressSettingsRepository.unRegisterListener(this.addressSettingsRepositoryListener);
    }

    public ArtemisExecutor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isStorePaging()) {
            return this.pageSubscription.getPagingStore().getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        boolean ok = this.internalFlushExecutor(10000L, true);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.errorFlushingExecutorsOnQueue();
        }
        return ok;
    }

    private boolean internalFlushExecutor(long timeout, boolean log) {
        if (!this.getExecutor().flush(timeout, TimeUnit.MILLISECONDS)) {
            if (log) {
                ActiveMQServerLogger.LOGGER.queueBusy(this.queueConfiguration.getName().toString(), timeout);
            }
            return false;
        }
        return true;
    }

    private boolean canDispatch() {
        boolean canDispatch = BooleanUtil.toBoolean((int)dispatchingUpdater.get(this));
        if (canDispatch) {
            return true;
        }
        if (this.inFlightMessages()) {
            return false;
        }
        if (this.getConsumerCount() >= this.queueConfiguration.getConsumersBeforeDispatch()) {
            if (dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)false), BooleanUtil.toInt((boolean)true))) {
                dispatchStartTimeUpdater.set(this, System.currentTimeMillis());
            }
            return true;
        }
        long currentDispatchStartTime = dispatchStartTimeUpdater.get(this);
        if (currentDispatchStartTime != -1L && currentDispatchStartTime < System.currentTimeMillis()) {
            dispatchingUpdater.set(this, BooleanUtil.toInt((boolean)true));
            return true;
        }
        return false;
    }

    private boolean inFlightMessages() {
        return this.consumers.stream().mapToInt(c -> c.consumer().getDeliveringMessages().size()).sum() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws Exception {
        logger.debug("{} adding consumer {}", (Object)this, (Object)consumer);
        this.setSwept(false);
        try (CriticalCloseable metric = this.measureCritical(3);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ConsumerHolder<Consumer> newConsumerHolder;
                if (this.queueConfiguration.getMaxConsumers() != -1 && this.getConsumerCount() >= this.queueConfiguration.getMaxConsumers()) {
                    throw ActiveMQMessageBundle.BUNDLE.maxConsumerLimitReachedForQueue(this.queueConfiguration.getAddress(), this.queueConfiguration.getName());
                }
                if (this.consumers.isEmpty()) {
                    this.supportsDirectDeliver = consumer.supportsDirectDelivery();
                } else if (!consumer.supportsDirectDelivery()) {
                    this.supportsDirectDeliver = false;
                }
                this.cancelRedistributor();
                if (this.queueConfiguration.isGroupRebalance().booleanValue()) {
                    if (this.queueConfiguration.isGroupRebalancePauseDispatch().booleanValue()) {
                        this.stopDispatch();
                    }
                    this.groups.removeAll();
                }
                if (this.consumers.add(newConsumerHolder = new ConsumerHolder<Consumer>(consumer, this))) {
                    if (this.queueConfiguration.getDelayBeforeDispatch() >= 0L) {
                        dispatchStartTimeUpdater.compareAndSet(this, -1L, this.queueConfiguration.getDelayBeforeDispatch() + System.currentTimeMillis());
                    }
                    this.refCountForConsumers.increment();
                }
            }
        }
    }

    @Override
    public void addLingerSession(String sessionId) {
        this.lingerSessionIds.add((Object)sessionId);
    }

    @Override
    public void removeLingerSession(String sessionId) {
        this.lingerSessionIds.remove((Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        logger.debug("Removing consumer {}", (Object)consumer);
        try (CriticalCloseable metric = this.measureCritical(3);){
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                boolean consumerRemoved = false;
                for (ConsumerHolder consumerHolder : this.consumers) {
                    if (consumerHolder.consumer != consumer) continue;
                    if (consumerHolder.iter != null) {
                        consumerHolder.iter.close();
                        consumerHolder.iter = null;
                    }
                    this.consumers.remove(consumerHolder);
                    consumerRemoved = true;
                    break;
                }
                this.supportsDirectDeliver = this.checkConsumerDirectDeliver();
                if (consumerRemoved) {
                    consumerRemovedTimestampUpdater.set(this, System.currentTimeMillis());
                    if (this.refCountForConsumers.decrement() == 0) {
                        this.stopDispatch();
                    }
                }
                if (consumer == this.exclusiveConsumer) {
                    this.storageManager.afterCompleteOperations(new IOCallback(){

                        public void onError(int errorCode, String errorMessage) {
                            QueueImpl.this.releaseExclusiveConsumer();
                        }

                        public void done() {
                            QueueImpl.this.releaseExclusiveConsumer();
                        }
                    });
                }
                this.groups.removeIf(consumer::equals);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExclusiveConsumer() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            this.exclusiveConsumer = null;
            this.resetAllIterators();
        }
        this.deliverAsync();
    }

    private void stopDispatch() {
        boolean stopped = dispatchingUpdater.compareAndSet(this, BooleanUtil.toInt((boolean)true), BooleanUtil.toInt((boolean)false));
        if (stopped) {
            dispatchStartTimeUpdater.set(this, -1L);
        }
    }

    private boolean checkConsumerDirectDeliver() {
        if (this.consumers.isEmpty()) {
            return false;
        }
        boolean supports = true;
        for (ConsumerHolder consumerHolder : this.consumers) {
            if (consumerHolder.consumer.supportsDirectDelivery()) continue;
            supports = false;
        }
        return supports;
    }

    public synchronized Redistributor getRedistributor() {
        return this.redistributor == null ? null : (Redistributor)this.redistributor.consumer;
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        if (this.isInternalQueue()) {
            logger.debug("Queue {} is internal, can't be redistributed!", (Object)this.queueConfiguration.getName());
            return;
        }
        if (this.queueConfiguration.getAddress().startsWith(this.server.getConfiguration().getManagementAddress())) {
            logger.debug("Queue {} is a management address, ignoring it for redistribution", (Object)this.queueConfiguration.getAddress());
            return;
        }
        this.clearRedistributorFuture();
        if (this.redistributor != null) {
            this.deliverAsync();
            return;
        }
        if (delay > 0L) {
            if (this.consumers.isEmpty() || this.hasUnMatchedPending) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.internalAddRedistributor();
        }
    }

    private void clearRedistributorFuture() {
        ScheduledFuture<?> future = this.redistributorFuture;
        this.redistributorFuture = null;
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public synchronized void cancelRedistributor() {
        this.clearRedistributorFuture();
        this.hasUnMatchedPending = false;
        if (this.redistributor != null) {
            try {
                ((Redistributor)this.redistributor.consumer).stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToCancelRedistributor(e);
            }
            finally {
                if (this.redistributor.iter != null) {
                    this.redistributor.iter.close();
                    this.redistributor.iter = null;
                }
                this.consumers.remove(this.redistributor);
                this.redistributor = null;
            }
        }
    }

    @Override
    public int getConsumerCount() {
        return this.refCountForConsumers.getCount();
    }

    @Override
    public long getConsumerRemovedTimestamp() {
        return consumerRemovedTimestampUpdater.get(this);
    }

    @Override
    public long getRingSize() {
        return this.queueConfiguration.getRingSize();
    }

    @Override
    public synchronized void setRingSize(long ringSize) {
        this.queueConfiguration.setRingSize(Long.valueOf(ringSize));
    }

    @Override
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Override
    public long getPendingMessageCount() {
        return this.pendingMetrics.getMessageCount();
    }

    public Set<Consumer> getConsumers() {
        HashSet<Consumer> consumersSet = new HashSet<Consumer>(this.consumers.size());
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumersSet.add((Consumer)consumerHolder.consumer);
        }
        return consumersSet;
    }

    @Override
    public synchronized Map<SimpleString, Consumer> getGroups() {
        return this.groups.toMap();
    }

    @Override
    public synchronized void resetGroup(SimpleString groupId) {
        this.groups.remove(groupId);
    }

    @Override
    public synchronized void resetAllGroups() {
        this.groups.removeAll();
    }

    @Override
    public synchronized int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public boolean hasMatchingConsumer(Message message) {
        for (ConsumerHolder consumerHolder : this.consumers) {
            Object consumer = consumerHolder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter1 = consumer.getFilter();
            if (filter1 == null) {
                return true;
            }
            if (!filter1.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator((LinkedListIterator<MessageReference>)this.messageReferences.iterator());
    }

    public QueueBrowserIterator browserIterator() {
        return new QueueBrowserIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference peekFirstMessage() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.messageReferences != null) {
                return (MessageReference)this.messageReferences.peek();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference peekFirstScheduledMessage() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.scheduledDeliveryHandler != null) {
                return this.scheduledDeliveryHandler.peekFirstScheduledMessage();
            }
        }
        return null;
    }

    @Override
    public synchronized MessageReference removeReferenceWithID(long id1) throws Exception {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id1);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
    }

    @Override
    public long getMessageCount() {
        if (this.pageSubscription != null) {
            long returnValue = (long)this.pendingMetrics.getNonPagedMessageCount() + (long)this.scheduledDeliveryHandler.getNonPagedScheduledCount() + (long)this.deliveringMetrics.getNonPagedMessageCount() + this.pageSubscription.getMessageCount();
            if (logger.isDebugEnabled()) {
                logger.debug("Queue={}/{} returning getMessageCount \n\treturning {}. \n\tpendingMetrics.getMessageCount() = {}, \n\tgetScheduledCount() = {}, \n\tpageSubscription.getMessageCount()={}, \n\tpageSubscription.getCounter().getValue()={}", new Object[]{this.queueConfiguration.getName(), this.queueConfiguration.getId(), returnValue, this.pendingMetrics.getMessageCount(), this.scheduledDeliveryHandler.getNonPagedScheduledCount(), this.pageSubscription.getMessageCount(), this.pageSubscription.getCounter().getValue()});
            }
            return returnValue;
        }
        return (long)this.pendingMetrics.getMessageCount() + (long)this.getScheduledCount() + (long)this.getDeliveringCount();
    }

    @Override
    public long getPersistentSize() {
        if (this.pageSubscription != null) {
            return this.pendingMetrics.getNonPagedPersistentSize() + this.scheduledDeliveryHandler.getNonPagedScheduledSize() + this.deliveringMetrics.getNonPagedPersistentSize() + this.pageSubscription.getPersistentSize();
        }
        return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize();
    }

    @Override
    public long getDurableMessageCount() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return (long)this.pendingMetrics.getNonPagedDurableMessageCount() + (long)this.scheduledDeliveryHandler.getNonPagedDurableScheduledCount() + (long)this.deliveringMetrics.getNonPagedDurableMessageCount() + this.pageSubscription.getMessageCount();
            }
            return (long)this.pendingMetrics.getDurableMessageCount() + (long)this.getDurableScheduledCount() + (long)this.getDurableDeliveringCount();
        }
        return 0L;
    }

    @Override
    public long getDurablePersistentSize() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return this.pendingMetrics.getDurablePersistentSize() + this.scheduledDeliveryHandler.getNonPagedDurableScheduledSize() + this.deliveringMetrics.getNonPagedDurablePersistentSize() + this.pageSubscription.getPersistentSize();
            }
            return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize();
        }
        return 0L;
    }

    @Override
    public int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public long getScheduledSize() {
        return this.scheduledDeliveryHandler.getScheduledSize();
    }

    @Override
    public int getDurableScheduledCount() {
        return this.scheduledDeliveryHandler.getDurableScheduledCount();
    }

    @Override
    public long getDurableScheduledSize() {
        return this.scheduledDeliveryHandler.getDurableScheduledSize();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<MessageReference>> getDeliveringMessages() {
        Iterator consumerHolderIterator;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            consumerHolderIterator = this.consumers.iterator();
        }
        HashMap<String, List<MessageReference>> mapReturn = new HashMap<String, List<MessageReference>>();
        while (consumerHolderIterator.hasNext()) {
            ConsumerHolder holder = (ConsumerHolder)consumerHolderIterator.next();
            List<MessageReference> msgs = holder.consumer.getDeliveringMessages();
            if (msgs == null || msgs.isEmpty()) continue;
            mapReturn.put(holder.consumer.toManagementString(), msgs);
        }
        for (String lingerSessionId : this.lingerSessionIds) {
            ServerSession serverSession = this.server.getSessionByID(lingerSessionId);
            List<MessageReference> refs = serverSession == null ? null : serverSession.getInTxLingerMessages();
            if (refs == null || refs.isEmpty()) continue;
            mapReturn.put(serverSession.toManagementString(), refs);
        }
        return mapReturn;
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringMetrics.getMessageCount();
    }

    @Override
    public long getDeliveringSize() {
        return this.deliveringMetrics.getPersistentSize();
    }

    @Override
    public int getDurableDeliveringCount() {
        return this.deliveringMetrics.getDurableMessageCount();
    }

    @Override
    public long getDurableDeliveringSize() {
        return this.deliveringMetrics.getDurablePersistentSize();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        this.acknowledge(ref, null);
    }

    @Override
    public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        this.acknowledge(ref, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        this.acknowledge(null, ref, reason, consumer, true);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        this.acknowledge(tx, ref, AckReason.NORMAL, null, true);
    }

    @Override
    public void acknowledge(Transaction tx, final MessageReference ref, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        boolean transactional = tx != null;
        RefsOperation refsOperation = null;
        if (transactional) {
            refsOperation = this.getRefsOperation(tx, reason, false, delivering);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("queue.acknowledge serverIdentity={}, queue={} acknowledge tx={} ref={}, reason={}, consumer={}", new Object[]{this.server.getIdentity(), this.getName(), transactional, ref, reason, consumer});
        }
        this.postOffice.preAcknowledge(tx, ref, reason);
        if (this.queueConfiguration.isNonDestructive().booleanValue() && reason == AckReason.NORMAL) {
            if (transactional) {
                refsOperation.addOnlyRefAck(ref);
            } else {
                this.decDelivering(ref);
            }
            logger.debug("acknowledge tx ignored nonDestructive=true and reason=NORMAL");
        } else {
            if (ref.isPaged()) {
                if (transactional) {
                    this.pageSubscription.ackTx(tx, (PagedReference)ref);
                    refsOperation.addAck(ref);
                } else {
                    this.pageSubscription.ack((PagedReference)ref);
                    this.postAcknowledge(ref, reason, delivering);
                }
            } else {
                boolean durableRef;
                Message message = ref.getMessage();
                boolean bl = durableRef = message.isDurable() && this.isDurable();
                if (durableRef) {
                    if (transactional) {
                        this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.queueConfiguration.getId(), message.getMessageID());
                        tx.setContainsPersistent();
                    } else {
                        this.storageManager.storeAcknowledge(this.queueConfiguration.getId(), message.getMessageID());
                    }
                }
                if (transactional) {
                    this.ackAttempts.incrementAndGet();
                    refsOperation.addAck(ref);
                } else {
                    this.postAcknowledge(ref, reason, delivering);
                }
            }
            if (!transactional) {
                this.ackAttempts.incrementAndGet();
            }
            if (AuditLogger.isMessageLoggingEnabled()) {
                String remoteAddress;
                ServerSession session = consumer != null ? this.server.getSessionByID(consumer.getSessionID()) : null;
                final Subject subject = session == null ? null : session.getRemotingConnection().getSubject();
                String string = remoteAddress = session == null ? null : session.getRemotingConnection().getRemoteAddress();
                if (transactional) {
                    AuditLogger.addAckToTransaction((Subject)subject, (String)remoteAddress, (String)this.getName().toString(), (String)ref.getMessage().toString(), (String)tx.toString());
                    tx.addOperation(new TransactionOperationAbstract(){

                        @Override
                        public void afterCommit(Transaction tx) {
                            QueueImpl.this.auditLogAck(subject, remoteAddress, ref, tx);
                        }

                        @Override
                        public void afterRollback(Transaction tx) {
                            AuditLogger.rolledBackTransaction((Subject)subject, (String)remoteAddress, (String)tx.toString(), (String)ref.toString());
                        }
                    });
                } else {
                    this.auditLogAck(subject, remoteAddress, ref, tx);
                }
            }
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.messageAcknowledged(tx, ref, reason, consumer));
            }
        }
    }

    private void auditLogAck(Subject subject, String remoteAddress, MessageReference ref, Transaction tx) {
        AuditLogger.coreAcknowledgeMessage((Subject)subject, (String)remoteAddress, (String)this.getName().toString(), (String)ref.getMessage().toString(), (String)Objects.toString(tx, null));
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        Message message = ref.getMessage();
        if (message.isDurable() && this.isDurable()) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx, AckReason.NORMAL).addAck(ref);
        this.incDelivering(ref);
        this.messagesAcknowledged.incrementAndGet();
    }

    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason) {
        return this.getRefsOperation(tx, ackReason, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefsOperation getRefsOperation(Transaction tx, AckReason ackReason, boolean ignoreRedlieveryCheck, boolean delivering) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = tx.createRefsOperation(this, ackReason);
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            if (ignoreRedlieveryCheck) {
                oper.setIgnoreRedeliveryCheck();
            }
            oper.setDelivering(delivering);
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) {
        this.cancel(tx, reference, false);
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference, boolean ignoreRedeliveryCheck) {
        this.getRefsOperation(tx, AckReason.NORMAL, ignoreRedeliveryCheck, true).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase) throws Exception {
        Pair<Boolean, Boolean> redeliveryResult = this.checkRedelivery(reference, timeBase, false);
        if (((Boolean)redeliveryResult.getA()).booleanValue()) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                this.internalAddSorted(reference);
            }
            this.resetAllIterators();
        } else if (!((Boolean)redeliveryResult.getB()).booleanValue()) {
            this.decDelivering(reference);
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        this.expire(ref, null, true);
    }

    @Override
    public void expire(MessageReference ref, ServerConsumer consumer, boolean delivering) throws Exception {
        this.expire(null, ref, consumer, delivering);
    }

    private void expire(Transaction tx, MessageReference ref, ServerConsumer consumer, boolean delivering) throws Exception {
        AddressSettings settingsToUse = this.getMessageAddressSettings(ref.getMessage());
        SimpleString expiryAddress = settingsToUse.getExpiryAddress();
        if (logger.isDebugEnabled()) {
            logger.debug("expire on {}::{}, consumer={}, expiryAddress={}", new Object[]{this.queueConfiguration.getAddress(), this.queueConfiguration.getName(), consumer, expiryAddress});
        }
        if (expiryAddress != null && !expiryAddress.isEmpty()) {
            String messageAddress = ref.getMessage().getAddress();
            if (messageAddress == null) {
                messageAddress = String.valueOf(this.getAddress());
            }
            this.createExpiryResources(messageAddress, settingsToUse);
            Bindings bindingList = this.postOffice.lookupBindingsForAddress(expiryAddress);
            if (bindingList == null || bindingList.getBindings().isEmpty()) {
                if (!this.printErrorExpiring) {
                    ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoBindings(expiryAddress);
                    this.printErrorExpiring = true;
                }
                this.acknowledge(tx, ref, AckReason.EXPIRED, null, delivering);
            } else {
                this.move(tx, expiryAddress, null, ref, false, AckReason.EXPIRED, consumer, null, delivering);
            }
        } else {
            if (!this.printErrorExpiring) {
                this.printErrorExpiring = true;
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoAddress(this.queueConfiguration.getName());
            }
            this.acknowledge(tx, ref, AckReason.EXPIRED, consumer, delivering);
        }
        this.refCountForConsumers.check();
        if (this.server.hasBrokerMessagePlugins()) {
            if (tx == null) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired(ref, settingsToUse.getExpiryAddress(), consumer));
            } else {
                ExpiryLogger expiryLogger = (ExpiryLogger)tx.getProperty(9);
                if (expiryLogger == null) {
                    expiryLogger = new ExpiryLogger();
                    tx.putProperty(9, expiryLogger);
                    tx.addOperation(expiryLogger);
                }
                expiryLogger.addExpiry(this.queueConfiguration.getAddress(), ref);
                tx.addOperation(new TransactionOperationAbstract(){

                    @Override
                    public void afterCommit(Transaction tx) {
                        QueueImpl.this.refCountForConsumers.check();
                    }
                });
            }
        }
    }

    private AddressSettings getMessageAddressSettings(Message message) {
        if (message.getAddress() == null || message.getAddress().equals(String.valueOf(this.queueConfiguration.getAddress()))) {
            return this.cachedAddressSettings;
        }
        return this.server.getAddressSettingsRepository().getMatch(message.getAddress());
    }

    @Override
    public SimpleString getExpiryAddress() {
        return this.cachedAddressSettings.getExpiryAddress();
    }

    @Override
    public SimpleString getDeadLetterAddress() {
        return this.cachedAddressSettings.getDeadLetterAddress();
    }

    @Override
    public void referenceHandled(MessageReference ref) {
        this.incDelivering(ref);
    }

    @Override
    public void incrementMesssagesAdded() {
        this.messagesAdded.incrementAndGet();
    }

    @Override
    public void deliverScheduledMessages() throws ActiveMQException {
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> true));
    }

    @Override
    public void deliverScheduledMessages(String filterString) throws ActiveMQException {
        Filter filter = filterString == null || filterString.isEmpty() ? null : FilterImpl.createFilter(filterString);
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> filter == null ? true : filter.match(ref.getMessage())));
    }

    @Override
    public void deliverScheduledMessage(long messageId) throws ActiveMQException {
        this.internalDeliverScheduleMessages(this.scheduledDeliveryHandler.cancel(ref -> ref.getMessageID() == messageId));
    }

    private void internalDeliverScheduleMessages(List<MessageReference> scheduledMessages) {
        if (scheduledMessages != null && !scheduledMessages.isEmpty()) {
            for (MessageReference ref : scheduledMessages) {
                ref.getMessage().setScheduledDeliveryTime(Long.valueOf(ref.getScheduledDeliveryTime()));
                ref.setScheduledDeliveryTime(0L);
            }
            this.addHead(scheduledMessages, true);
        }
    }

    @Override
    public long getMessagesAdded() {
        if (this.pageSubscription != null) {
            return this.messagesAdded.get() + this.pageSubscription.getCounter().getValueAdded();
        }
        return this.messagesAdded.get();
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged.get();
    }

    @Override
    public long getAcknowledgeAttempts() {
        return this.ackAttempts.get();
    }

    @Override
    public long getMessagesExpired() {
        return this.messagesExpired.get();
    }

    @Override
    public long getMessagesKilled() {
        return this.messagesKilled.get();
    }

    @Override
    public long getMessagesReplaced() {
        return this.messagesReplaced.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteAllReferences(500);
    }

    @Override
    public int deleteAllReferences(int flushLimit) throws Exception {
        return this.deleteMatchingReferences(flushLimit, null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        return this.deleteMatchingReferences(500, filter);
    }

    @Override
    public int deleteMatchingReferences(int flushLimit, Filter filter1, AckReason ackReason) throws Exception {
        return this.iterQueue(flushLimit, filter1, this.createDeleteMatchingAction(ackReason));
    }

    QueueIterateAction createDeleteMatchingAction(final AckReason ackReason) {
        return new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.incDelivering(ref);
                QueueImpl.this.acknowledge(tx, ref, ackReason, null, true);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int iterQueue(int flushLimit, Filter filter1, QueueIterateAction messageAction) throws Exception {
        int count = 0;
        int txCount = 0;
        this.depagePending = true;
        this.depageLock.lock();
        try {
            TransactionImpl tx = new TransactionImpl(this.storageManager);
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                block29: {
                    LinkedListIterator<MessageReference> iter;
                    block27: {
                        int ref22222;
                        block28: {
                            this.doInternalPoll();
                            iter = this.iterator();
                            while (iter.hasNext() && !messageAction.expectedHitsReached(count)) {
                                MessageReference ref22222 = (MessageReference)iter.next();
                                if (filter1 != null && !filter1.match(ref22222.getMessage())) continue;
                                if (messageAction.actMessage(tx, ref22222)) {
                                    iter.remove();
                                    this.refRemoved(ref22222);
                                }
                                ++txCount;
                                ++count;
                            }
                            if (txCount > 0) {
                                tx.commit();
                                tx = new TransactionImpl(this.storageManager);
                                txCount = 0;
                            }
                            if (!messageAction.expectedHitsReached(count)) break block27;
                            ref22222 = count;
                            if (iter == null) break block28;
                            iter.close();
                        }
                        return ref22222;
                    }
                    List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(ref -> filter1 == null ? true : filter1.match(ref.getMessage()));
                    for (MessageReference messageReference : cancelled) {
                        messageAction.actMessage(tx, messageReference);
                        ++txCount;
                        if (!messageAction.expectedHitsReached(++count)) continue;
                        break;
                    }
                    if (txCount > 0) {
                        tx.commit();
                        tx = new TransactionImpl(this.storageManager);
                        txCount = 0;
                    }
                    break block29;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (iter != null) {
                            iter.close();
                        }
                    }
                }
            }
            if (this.pageIterator != null) {
                while (this.pageIterator.hasNext() && !messageAction.expectedHitsReached(count)) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter1 == null || filter1.match(reference.getMessage())) {
                        ++count;
                        ++txCount;
                        if (!messageAction.actMessage(tx, reference)) {
                            this.addTail(reference, false);
                        }
                    } else {
                        this.addTail(reference, false);
                    }
                    if (txCount <= 0 || txCount % flushLimit != 0) continue;
                    tx.commit();
                    tx = new TransactionImpl(this.storageManager);
                    txCount = 0;
                }
            }
            if (txCount > 0) {
                tx.commit();
            }
            if (this.filter != null && !this.queueDestroyed && this.pageSubscription != null) {
                this.scheduleDepage(false);
            }
            int n = count;
            return n;
        }
        finally {
            this.depageLock.unlock();
            this.depagePending = false;
            this.forceDelivery();
        }
    }

    @Override
    public void destroyPaging() throws Exception {
        if (this.pageSubscription != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Destroying paging for {}", (Object)this.queueConfiguration.getName(), (Object)new Exception("trace"));
            }
            this.pageSubscription.destroy();
            this.pageSubscription.cleanupEntries(true);
        }
    }

    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            if (!deleted) {
                deleted = this.scheduledDeliveryHandler.removeReferenceWithID(messageID, tx) != null;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
    }

    @Override
    public void deleteQueue() throws Exception {
        this.deleteQueue(false);
    }

    @Override
    public void removeAddress() throws Exception {
        this.server.removeAddressInfo(this.getAddress(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(boolean removeConsumers) throws Exception {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.queueDestroyed) {
                return;
            }
            this.queueDestroyed = true;
        }
        BindingsTransactionImpl tx = new BindingsTransactionImpl(this.storageManager);
        try {
            this.deleteAllReferences();
            this.destroyPaging();
            this.postOffice.removeBinding(this.queueConfiguration.getName(), tx, true);
            if (removeConsumers) {
                for (ConsumerHolder consumerHolder : this.consumers) {
                    consumerHolder.consumer.disconnect();
                }
            }
            if (this.isDurable()) {
                this.storageManager.deleteQueueBinding(tx.getID(), this.getID());
                tx.setContainsPersistent();
            }
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (this.factory != null) {
                this.factory.queueRemoved(this);
            }
        }
    }

    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        if (this.isExpiryDisabled()) {
            return false;
        }
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        if (this.isExpiryDisabled()) {
            return 0;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.expire(tx, ref, null, true);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    @Override
    public void expireReferences(Runnable done) {
        if (this.isExpiryDisabled()) {
            if (done != null) {
                done.run();
            }
            return;
        }
        if (!this.queueDestroyed) {
            this.getExecutor().execute((Runnable)new ExpiryScanner(done));
        } else if (done != null) {
            done.run();
        }
    }

    private boolean isExpiryDisabled() {
        SimpleString expiryAddress = this.cachedAddressSettings.getExpiryAddress();
        if (expiryAddress != null && expiryAddress.equals((Object)this.queueConfiguration.getAddress())) {
            logger.trace("Redundant expiration from {} to {}", (Object)this.queueConfiguration.getAddress(), (Object)expiryAddress);
            return true;
        }
        if (this.isMirrorController()) {
            logger.trace("Mirror SNF queues are not supposed to expire messages. Address={}, Queue={}", (Object)this.queueConfiguration.getAddress(), (Object)this.queueConfiguration.getName());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            MessageReference ref;
            while (iter.hasNext()) {
                ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            if (this.pageIterator != null && !this.queueDestroyed) {
                while (this.pageIterator.hasNext()) {
                    ref = (PagedReference)this.pageIterator.next();
                    if (ref.getMessage().getMessageID() != messageID) continue;
                    this.incDelivering(ref);
                    this.sendToDeadLetterAddress(null, ref);
                    this.pageIterator.remove();
                    this.refRemoved(ref);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.incDelivering(ref);
                return QueueImpl.this.sendToDeadLetterAddress(tx, ref);
            }
        });
    }

    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicate) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.incDelivering(ref);
                try {
                    this.move(null, toAddress, binding, ref, rejectDuplicate, AckReason.NORMAL, null, null, true);
                }
                catch (Exception e) {
                    this.decDelivering(ref);
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
        return this.moveReferences(500, filter, toAddress, false, binding);
    }

    @Override
    public int moveReferences(int flushLimit, Filter filter, SimpleString toAddress, boolean rejectDuplicates, Binding binding) throws Exception {
        return this.moveReferences(flushLimit, filter, toAddress, rejectDuplicates, -1, binding);
    }

    @Override
    public int moveReferences(int flushLimit, Filter filter, final SimpleString toAddress, final boolean rejectDuplicates, int messageCount, final Binding binding) throws Exception {
        Integer expectedHits = messageCount > 0 ? Integer.valueOf(messageCount) : null;
        final DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
        return this.iterQueue(flushLimit, filter, new QueueIterateAction(expectedHits){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                byte[] duplicateBytes;
                boolean ignored = false;
                QueueImpl.this.incDelivering(ref);
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    ActiveMQServerLogger.LOGGER.messageWithDuplicateID(ref.getMessage().getDuplicateProperty(), toAddress, QueueImpl.this.queueConfiguration.getAddress(), QueueImpl.this.queueConfiguration.getAddress());
                    QueueImpl.this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    QueueImpl.this.move(null, toAddress, binding, ref, rejectDuplicates, AckReason.NORMAL, null, null, true);
                }
                return true;
            }
        });
    }

    public int moveReferencesBetweenSnFQueues(final SimpleString queueSuffix) throws Exception {
        return this.iterQueue(500, null, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                return QueueImpl.this.moveBetweenSnFQueues(queueSuffix, tx, ref, null);
            }
        });
    }

    @Override
    public synchronized boolean copyReference(long messageID, SimpleString toQueue, Binding binding) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.copy(null, toQueue, binding, ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public synchronized int rerouteMessages(final SimpleString queueName, Filter filter) throws Exception {
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                RoutingContextImpl routingContext = new RoutingContextImpl(tx);
                SimpleString address = QueueImpl.this.server.locateQueue(queueName).getAddress();
                routingContext.setAddress(address);
                Message m = ref.getMessage();
                m.setAddress(address);
                QueueImpl.this.server.getPostOffice().getBinding(queueName).route(m, routingContext);
                QueueImpl.this.postOffice.processRoute(m, routingContext, false);
                return false;
            }
        });
    }

    @Override
    public int retryMessages(Filter filter) throws Exception {
        return this.retryMessages(filter, null);
    }

    @Override
    public int retryMessages(Filter filter, Integer expectedHits) throws Exception {
        final HashMap queues = new HashMap();
        return this.iterQueue(500, filter, new QueueIterateAction(expectedHits){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                String originalMessageAddress = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_ADDRESS);
                String originalMessageQueue = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_QUEUE);
                Binding binding = null;
                if (originalMessageQueue != null) {
                    binding = QueueImpl.this.postOffice.getBinding(SimpleString.of((String)originalMessageQueue));
                }
                if (originalMessageAddress != null && binding != null) {
                    QueueImpl.this.incDelivering(ref);
                    Long targetQueue = null;
                    if (originalMessageQueue != null && !originalMessageQueue.equals(originalMessageAddress) && (targetQueue = (Long)queues.get(originalMessageQueue)) == null && binding instanceof LocalQueueBinding) {
                        LocalQueueBinding localQueueBinding = (LocalQueueBinding)binding;
                        targetQueue = localQueueBinding.getID();
                        queues.put(originalMessageQueue, targetQueue);
                    }
                    QueueImpl.this.move(tx, SimpleString.of((String)originalMessageAddress), null, ref, false, AckReason.NORMAL, null, targetQueue, true);
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("QueueImpl::retryMessages cannot find targetQueue for message {}", (Object)ref.getMessage());
                }
                return false;
            }
        });
    }

    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder consumerHolder : this.consumers) {
            consumerHolder.resetIterator();
        }
    }

    @Override
    public synchronized void pause() {
        this.pause(false);
    }

    @Override
    public synchronized void reloadPause(long recordID) {
        this.paused = true;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
            }
        }
        this.pauseStatusRecord = recordID;
    }

    @Override
    public synchronized void pause(boolean persist) {
        try {
            this.flushDeliveriesInTransit();
            if (persist && this.isDurable()) {
                if (this.pauseStatusRecord >= 0L) {
                    this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
                }
                this.pauseStatusRecord = this.storageManager.storeQueueStatus(this.queueConfiguration.getId(), AddressQueueStatus.PAUSED);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToPauseQueue(e);
        }
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToResumeQueue(e);
            }
            this.pauseStatusRecord = -1L;
        }
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused || this.addressInfo != null && this.addressInfo.isPaused();
    }

    @Override
    public synchronized boolean isPersistedPause() {
        return this.pauseStatusRecord >= 0L;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver && this.supportsDirectDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.queueConfiguration.isInternal();
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.queueConfiguration.setInternal(Boolean.valueOf(internalQueue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueueImpl)) {
            return false;
        }
        QueueImpl other = (QueueImpl)obj;
        return Objects.equals(this.queueConfiguration.getName(), other.queueConfiguration.getName());
    }

    public int hashCode() {
        return this.queueConfiguration.getName().hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + String.valueOf(this.queueConfiguration.getName()) + ", postOffice=" + String.valueOf(this.postOffice) + ", temp=" + this.queueConfiguration.isTemporary() + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        ref.setSequence(this.queueSequence.incrementAndGet());
        this.messageReferences.addTail((Object)ref, this.getPriority(ref));
        this.pendingMetrics.incrementMetrics(ref);
        this.enforceRing(false);
    }

    private void internalAddHead(MessageReference ref) {
        if (RefCountMessage.isRefTraceEnabled()) {
            RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"add head queue {}", (Object[])new Object[]{this.getAddress()});
        }
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addHead((Object)ref, priority);
        ref.setInDelivery(false);
    }

    private void internalAddSorted(MessageReference ref) {
        if (RefCountMessage.isRefTraceEnabled()) {
            RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"add sorted queue {}", (Object[])new Object[]{this.getAddress()});
        }
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addSorted((Object)ref, priority);
        ref.setInDelivery(false);
    }

    private int getPriority(MessageReference ref) {
        if (this.isInternalQueue()) {
            return 4;
        }
        try {
            return ref.getMessage().getPriority();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToGetMessagePriority(e);
            return 4;
        }
    }

    synchronized void doInternalPoll() {
        MessageReference ref;
        int added = 0;
        while ((ref = (MessageReference)this.intermediateMessageReferences.poll()) != null) {
            if (ref.skipDelivery()) continue;
            this.internalAddTail(ref);
            if (!ref.isPaged()) {
                this.incrementMesssagesAdded();
            }
            if (added++ <= 1000) continue;
            this.deliverAsync(true);
            return;
        }
    }

    private void removeMessagesWhileDelivering() throws Exception {
        assert (this.queueDestroyed) : "Method to be used only when the queue was destroyed";
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int txCount = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.isPaged()) continue;
                this.acknowledge(tx, ref, AckReason.KILLED, null, true);
                iter.remove();
                this.refRemoved(ref);
                ++txCount;
            }
            if (txCount > 0) {
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver() {
        if (logger.isTraceEnabled()) {
            logger.trace("Queue {} doing deliver. messageReferences={} with consumers={}", new Object[]{this.queueConfiguration.getName(), this.messageReferences.size(), this.getConsumerCount()});
        }
        this.scheduledRunners.decrementAndGet();
        this.doInternalPoll();
        int noDelivery = 0;
        int numNoMatch = 0;
        int numAttempts = 0;
        int handled = 0;
        long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
        this.consumers.reset();
        while (true) {
            MessageReference ref;
            if (handled == 1000 || System.nanoTime() - timeout > 0L) {
                this.deliverAsync(true);
                return false;
            }
            Consumer handledconsumer = null;
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ConsumerHolder holder;
                if (this.queueDestroyed) {
                    if (this.messageReferences.isEmpty()) {
                        return false;
                    }
                    try {
                        this.removeMessagesWhileDelivering();
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                    return false;
                }
                if (this.isPaused() || !this.canDispatch()) {
                    return false;
                }
                if (this.messageReferences.isEmpty()) {
                    break;
                }
                if (this.consumers.hasNext()) {
                    holder = (ConsumerHolder)this.consumers.next();
                    if (holder == null) {
                        logger.debug("consumers.next() returned null.");
                        this.deliverAsync(true);
                        return false;
                    }
                    if (holder.iter == null) {
                        holder.iter = this.messageReferences.iterator();
                    }
                } else {
                    this.pruneLastValues();
                    break;
                }
                LinkedListIterator<MessageReference> holderIterator = holder.iter;
                Object consumer = holder.consumer;
                Consumer groupConsumer = null;
                if (consumer.isClosed()) {
                    this.deliverAsync(true);
                    return false;
                }
                ref = holderIterator.hasNext() ? (MessageReference)holderIterator.next() : null;
                if (ref == null) {
                    ++noDelivery;
                } else {
                    if (this.checkExpired(ref)) {
                        logger.trace("Reference {} being expired", (Object)ref);
                        this.removeMessageReference(holder, ref);
                        ++handled;
                        this.consumers.reset();
                        continue;
                    }
                    logger.trace("Queue {} is delivering reference {}", (Object)this.queueConfiguration.getName(), (Object)ref);
                    SimpleString groupID = this.extractGroupID(ref);
                    groupConsumer = this.getGroupConsumer(groupID);
                    if (groupConsumer != null) {
                        consumer = groupConsumer;
                    }
                    ++numAttempts;
                    HandleStatus status = this.handle(ref, (Consumer)consumer);
                    if (status == HandleStatus.HANDLED) {
                        noDelivery = 0;
                        numNoMatch = 0;
                        numAttempts = 0;
                        ref = this.handleMessageGroup(ref, (Consumer)consumer, groupConsumer, groupID);
                        this.deliveriesInTransit.countUp();
                        if (!this.queueConfiguration.isNonDestructive().booleanValue()) {
                            this.removeMessageReference(holder, ref);
                        }
                        ref.setInDelivery(true);
                        handledconsumer = (Consumer)consumer;
                        ++handled;
                        this.consumers.reset();
                    } else if (status == HandleStatus.BUSY) {
                        try {
                            holderIterator.repeat();
                        }
                        catch (NoSuchElementException e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                        ++noDelivery;
                        numNoMatch = 0;
                        numAttempts = 0;
                    } else if (status == HandleStatus.NO_MATCH) {
                        this.consumers.reset();
                        if (++numNoMatch == numAttempts && numAttempts == this.consumers.size() && this.redistributor == null) {
                            this.hasUnMatchedPending = true;
                        }
                    }
                }
                if (groupConsumer != null) {
                    if (noDelivery > 0) {
                        this.pruneLastValues();
                        break;
                    }
                    noDelivery = 0;
                } else if (!this.consumers.hasNext()) {
                    if (noDelivery == this.consumers.size()) {
                        this.pruneLastValues();
                        if (handledconsumer != null) {
                            ActiveMQServerLogger.LOGGER.nonDeliveryHandled();
                        } else {
                            logger.debug("{}::All the consumers were busy, giving up now", (Object)this);
                            break;
                        }
                    }
                    noDelivery = 0;
                }
            }
            if (handledconsumer == null) continue;
            this.proceedDeliver(handledconsumer, ref);
        }
        return true;
    }

    protected void pruneLastValues() {
    }

    protected void removeMessageReference(ConsumerHolder<? extends Consumer> holder, MessageReference ref) {
        holder.iter.remove();
        this.refRemoved(ref);
    }

    private void checkDepage() {
        if (this.queueDestroyed) {
            return;
        }
        if (this.pageIterator != null && this.pageSubscription.isStorePaging()) {
            if (logger.isDebugEnabled()) {
                logger.debug("CheckDepage on queue name {}, id={}", (Object)this.queueConfiguration.getName(), (Object)this.queueConfiguration.getId());
            }
            this.pageDelivered = true;
            if (!this.depagePending && this.needsDepage() && this.pageIterator.tryNext() != PageIterator.NextResult.noElements) {
                this.scheduleDepage(false);
            }
        } else {
            this.pageDelivered = false;
        }
    }

    private boolean needsDepage() {
        boolean needsDepageResult;
        int maxReadMessages = this.pageSubscription.getPagingStore().getMaxPageReadMessages();
        int maxReadBytes = this.pageSubscription.getPagingStore().getMaxPageReadBytes();
        int prefetchMessages = this.pageSubscription.getPagingStore().getPrefetchPageMessages();
        int prefetchBytes = this.pageSubscription.getPagingStore().getPrefetchPageBytes();
        if (maxReadMessages <= 0 && maxReadBytes <= 0 && prefetchMessages <= 0 && prefetchBytes <= 0) {
            return this.queueMemorySize.getSize() < this.pageSubscription.getPagingStore().getMaxSize() && this.intermediateMessageReferences.size() + this.messageReferences.size() < 1000;
        }
        boolean bl = needsDepageResult = !(maxReadBytes > 0 && this.queueMemorySize.getSize() + this.deliveringMetrics.getPersistentSize() >= (long)maxReadBytes || prefetchBytes > 0 && this.queueMemorySize.getSize() >= (long)prefetchBytes || maxReadMessages > 0 && this.queueMemorySize.getElements() + (long)this.deliveringMetrics.getMessageCount() >= (long)maxReadMessages || prefetchMessages > 0 && this.queueMemorySize.getElements() >= (long)prefetchMessages);
        if (!needsDepageResult) {
            if (!this.pageFlowControlled && (maxReadBytes > 0 && this.deliveringMetrics.getPersistentSize() >= (long)maxReadBytes || maxReadMessages > 0 && this.deliveringMetrics.getMessageCount() >= maxReadMessages)) {
                if (System.currentTimeMillis() - this.pageFlowControlledLastLog > PAGE_FLOW_CONTROL_PRINT_INTERVAL) {
                    this.pageFlowControlledLastLog = System.currentTimeMillis();
                    ActiveMQServerLogger.LOGGER.warnPageFlowControl(String.valueOf(this.queueConfiguration.getAddress()), String.valueOf(this.queueConfiguration.getName()), this.deliveringMetrics.getMessageCount(), this.deliveringMetrics.getPersistentSize(), maxReadMessages, maxReadBytes);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Message dispatch from paging is blocked. Address {}/Queue{} will not read any more messages from paging until pending messages are acknowledged. There are currently {} messages pending ({} bytes) with max reads at maxPageReadMessages({}) and maxPageReadBytes({}). Either increase reading attributes at the address-settings or change your consumers to acknowledge more often.", new Object[]{this.queueConfiguration.getAddress(), this.queueConfiguration.getName(), this.deliveringMetrics.getMessageCount(), this.deliveringMetrics.getPersistentSize(), maxReadMessages, maxReadBytes});
                }
                this.pageFlowControlled = true;
            }
        } else {
            this.pageFlowControlled = false;
        }
        return needsDepageResult;
    }

    private SimpleString extractGroupID(MessageReference ref) {
        if (this.queueConfiguration.isInternal().booleanValue() || this.queueConfiguration.isExclusive().booleanValue() || this.queueConfiguration.getGroupBuckets() == 0) {
            return null;
        }
        try {
            return ref.getMessage().getGroupID();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupID(e);
            return null;
        }
    }

    private int extractGroupSequence(MessageReference ref) {
        if (this.queueConfiguration.isInternal().booleanValue()) {
            return 0;
        }
        try {
            return ref.getMessage().getGroupSequence();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupSequence(e);
            return 0;
        }
    }

    protected void refRemoved(MessageReference ref) {
        this.queueMemorySize.addSize(-ref.getMessageMemoryEstimate());
        this.pendingMetrics.decrementMetrics(ref);
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void addRefSize(MessageReference ref) {
        this.queueMemorySize.addSize(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage(boolean scheduleExpiry) {
        if (!this.depagePending) {
            logger.trace("Scheduling depage for queue {}", (Object)this.queueConfiguration.getName());
            this.depagePending = true;
            this.pageSubscription.getPagingStore().execute(() -> this.depage(scheduleExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void depage(boolean scheduleExpiry) {
        this.depagePending = false;
        if (!this.depageLock.tryLock()) {
            return;
        }
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.isPaused()) return;
                if (this.pageIterator == null) {
                    return;
                }
            }
            long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
            if (logger.isTraceEnabled()) {
                logger.trace("QueueMemorySize before depage on queue={} is {}", (Object)this.queueConfiguration.getName(), (Object)this.queueMemorySize.getSize());
            }
            this.directDeliver = false;
            int depaged = 0;
            while (timeout - System.nanoTime() > 0L && this.needsDepage()) {
                PageIterator.NextResult status = this.pageIterator.tryNext();
                if (status == PageIterator.NextResult.retry) continue;
                if (status == PageIterator.NextResult.noElements) break;
                ++depaged;
                PagedReference reference = (PagedReference)this.pageIterator.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("Depaging reference {} on queue {} depaged::{}", new Object[]{reference, this.queueConfiguration.getName(), depaged});
                }
                this.addTail(reference, false);
                this.pageIterator.remove();
            }
            if (logger.isDebugEnabled()) {
                int maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
                if (depaged == 0 && this.queueMemorySize.getSize() >= (long)maxSize) {
                    logger.debug("Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Queue Memory Size after depage on queue={} is {} with maxSize = {}. Depaged {} messages, pendingDelivery={}, intermediateMessageReferences= {}, queueDelivering={}", new Object[]{this.queueConfiguration.getName(), this.queueMemorySize.getSize(), maxSize, depaged, this.messageReferences.size(), this.intermediateMessageReferences.size(), this.deliveringMetrics.getMessageCount()});
                }
            }
            this.deliverAsync(true);
            if (depaged <= 0) return;
            if (!scheduleExpiry) return;
            this.expireReferences();
            return;
        }
        finally {
            this.depageLock.unlock();
        }
    }

    @Override
    public synchronized MessageReference removeWithSuppliedID(String serverID, long id, NodeStoreFactory<MessageReference> nodeStore) {
        this.checkIDSupplier(nodeStore);
        this.doInternalPoll();
        MessageReference reference = (MessageReference)this.messageReferences.removeWithID(serverID, id);
        if (reference != null) {
            this.refRemoved(reference);
        }
        return reference;
    }

    private void internalAddRedistributor() {
        if (this.redistributor == null && (this.consumers.isEmpty() || this.hasUnMatchedPending)) {
            logger.trace("QueueImpl::Adding redistributor on queue {}", (Object)this);
            this.redistributor = new ConsumerHolder<Redistributor>(new Redistributor(this, this.storageManager.generateID(), this.postOffice), this);
            ((Redistributor)this.redistributor.consumer).start();
            this.consumers.add(this.redistributor);
            this.hasUnMatchedPending = false;
            this.deliverAsync();
        }
    }

    @Override
    public Pair<Boolean, Boolean> checkRedelivery(MessageReference reference, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
        if (this.queueConfiguration.isInternal().booleanValue()) {
            logger.trace("Queue {} is an internal queue, no checkRedelivery", (Object)this.queueConfiguration.getName());
            this.decDelivering(reference);
            return new Pair((Object)true, (Object)false);
        }
        if (!this.queueConfiguration.isInternal().booleanValue() && reference.isDurable() && this.isDurable() && !reference.isPaged()) {
            this.storageManager.updateDeliveryCount(reference);
        }
        int maxDeliveries = this.cachedAddressSettings.getMaxDeliveryAttempts();
        int deliveryCount = reference.getDeliveryCount();
        if (maxDeliveries > 0 && deliveryCount >= maxDeliveries) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending reference {} to DLA = {} since ref.getDeliveryCount={} and maxDeliveries={} from queue={}", new Object[]{reference, this.cachedAddressSettings.getDeadLetterAddress(), reference.getDeliveryCount(), maxDeliveries, this.queueConfiguration.getName()});
            }
            boolean dlaResult = this.sendToDeadLetterAddress(null, reference, this.cachedAddressSettings.getDeadLetterAddress());
            return new Pair((Object)false, (Object)dlaResult);
        }
        long redeliveryDelay = this.cachedAddressSettings.getRedeliveryDelay();
        if (!ignoreRedeliveryDelay && redeliveryDelay > 0L) {
            redeliveryDelay = this.calculateRedeliveryDelay(this.cachedAddressSettings, deliveryCount);
            if (logger.isTraceEnabled()) {
                logger.trace("Setting redeliveryDelay={} on reference={}", (Object)redeliveryDelay, (Object)reference);
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && reference.isDurable() && this.isDurable()) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.decDelivering(reference);
        return new Pair((Object)true, (Object)false);
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private RoutingStatus move(Transaction originalTX, SimpleString address, Binding binding, MessageReference ref, boolean rejectDuplicate, AckReason reason, ServerConsumer consumer, Long queueID, boolean delivering) throws Exception {
        Transaction tx = originalTX != null ? originalTX : new TransactionImpl(this.storageManager);
        Message copyMessage = this.makeCopy(ref, reason == AckReason.EXPIRED, address);
        Object originalRoutingType = ref.getMessage().getBrokerProperty(Message.HDR_ORIG_ROUTING_TYPE);
        if (originalRoutingType instanceof Byte) {
            Byte originalRoutingTypeByte = (Byte)originalRoutingType;
            copyMessage.setRoutingType(RoutingType.getType((byte)originalRoutingTypeByte));
        }
        if (queueID != null) {
            byte[] encodedBuffer = new byte[8];
            ByteBuffer buffer = ByteBuffer.wrap(encodedBuffer);
            buffer.putLong(0, queueID);
            copyMessage.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), encodedBuffer);
        }
        RoutingContextImpl context = new RoutingContextImpl(tx);
        if (reason == AckReason.EXPIRED) {
            context.setMirrorOption(RoutingContext.MirrorOption.disabled);
        }
        RoutingStatus routingStatus = this.postOffice.route(copyMessage, context, false, rejectDuplicate, binding);
        this.acknowledge(tx, ref, reason, consumer, delivering);
        if (originalTX == null) {
            tx.commit();
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.messageMoved(tx, ref, reason, address, queueID, consumer, copyMessage, routingStatus));
        }
        return routingStatus;
    }

    private RoutingStatus copy(Transaction originalTX, SimpleString address, Binding binding, MessageReference ref) throws Exception {
        Transaction tx = originalTX != null ? originalTX : new TransactionImpl(this.storageManager);
        Message copyMessage = this.makeCopy(ref, false, false, address);
        Object originalRoutingType = ref.getMessage().getBrokerProperty(Message.HDR_ORIG_ROUTING_TYPE);
        if (originalRoutingType != null && originalRoutingType instanceof Byte) {
            Byte byteValue = (Byte)originalRoutingType;
            copyMessage.setRoutingType(RoutingType.getType((byte)byteValue));
        }
        RoutingContextImpl context = new RoutingContextImpl(tx);
        RoutingStatus routingStatus = this.postOffice.route(copyMessage, context, false, false, binding);
        if (originalTX == null) {
            tx.commit();
        }
        return routingStatus;
    }

    private boolean moveBetweenSnFQueues(SimpleString queueSuffix, Transaction tx, MessageReference ref, SimpleString newAddress) throws Exception {
        Message copyMessage = this.makeCopy(ref, false, false, newAddress);
        byte[] oldRouteToIDs = null;
        for (SimpleString propName : copyMessage.getPropertyNames()) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            oldRouteToIDs = (byte[])copyMessage.removeProperty(propName.toString());
            if (!logger.isDebugEnabled()) break;
            String hashcodeToString = oldRouteToIDs.toString();
            logger.debug("Removed property from message: {} = {} ({})", new Object[]{propName, hashcodeToString, ByteBuffer.wrap(oldRouteToIDs).getLong()});
            break;
        }
        ByteBuffer oldBuffer = ByteBuffer.wrap(oldRouteToIDs);
        RoutingContextImpl routingContext = new RoutingContextImpl(tx);
        while (oldBuffer.hasRemaining()) {
            long oldQueueID = oldBuffer.getLong();
            Pair<String, Binding> result = this.locateTargetBinding(queueSuffix, copyMessage, oldQueueID);
            Binding targetBinding = (Binding)result.getB();
            String targetNodeID = (String)result.getA();
            if (targetBinding == null) {
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(targetNodeID);
                continue;
            }
            logger.debug("Routing on binding: {}", (Object)targetBinding);
            targetBinding.route(copyMessage, routingContext);
        }
        this.postOffice.processRoute(copyMessage, routingContext, false);
        ref.handled();
        this.acknowledge(tx, ref);
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorRedistributing(errorCode, errorMessage);
            }

            public void done() {
                QueueImpl.this.deliverAsync();
            }
        });
        return true;
    }

    private Pair<String, Binding> locateTargetBinding(SimpleString queueSuffix, Message copyMessage, long oldQueueID) {
        String targetNodeID = null;
        RemoteQueueBinding targetBinding = null;
        block0: for (RemoteQueueBinding remoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
            if (oldQueueID != remoteQueueBinding.getRemoteQueueID()) continue;
            SimpleString oldQueueName = remoteQueueBinding.getRoutingName();
            String temp = remoteQueueBinding.getQueue().getName().toString();
            targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Message formerly destined for {} with ID: {} on address {} on node {}", new Object[]{oldQueueName, oldQueueID, copyMessage.getAddressSimpleString(), targetNodeID});
            }
            for (RemoteQueueBinding innerRemoteQueueBinding : IterableStream.iterableOf(this.postOffice.getAllBindings().filter(RemoteQueueBinding.class::isInstance).map(RemoteQueueBinding.class::cast))) {
                temp = innerRemoteQueueBinding.getQueue().getName().toString();
                targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
                if (oldQueueName.equals((Object)innerRemoteQueueBinding.getRoutingName()) && targetNodeID.equals(queueSuffix.toString())) {
                    targetBinding = innerRemoteQueueBinding;
                    if (!logger.isDebugEnabled()) continue block0;
                    logger.debug("Message now destined for {} with ID: {} on address {} on node {}", new Object[]{innerRemoteQueueBinding.getRoutingName(), innerRemoteQueueBinding.getRemoteQueueID(), copyMessage.getAddress(), targetNodeID});
                    continue block0;
                }
                logger.debug("Failed to match: {}", (Object)innerRemoteQueueBinding);
            }
        }
        return new Pair(targetNodeID, targetBinding);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, SimpleString newAddress) throws Exception {
        return this.makeCopy(ref, expiry, true, newAddress);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, boolean copyOriginalHeaders, SimpleString newAddress) throws Exception {
        if (ref == null) {
            ActiveMQServerLogger.LOGGER.nullRefMessage();
            throw new ActiveMQNullRefException("Reference to message is null");
        }
        Message message = ref.getMessage();
        long newID = this.storageManager.generateID();
        Message copy = message.copy(newID, true);
        if (newAddress != null) {
            copy.setAddress(newAddress);
        }
        if (copyOriginalHeaders) {
            copy.referenceOriginalMessage(message, ref.getQueue().getName());
        }
        copy.setExpiration(0L);
        copy.setRoutingType(null);
        if (expiry) {
            copy.setBrokerProperty(Message.HDR_ACTUAL_EXPIRY_TIME, (Object)System.currentTimeMillis());
        }
        copy.reencode();
        return LargeServerMessageImpl.checkLargeMessage(copy, this.storageManager);
    }

    @Override
    public boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
        return this.sendToDeadLetterAddress(tx, ref, this.cachedAddressSettings.getDeadLetterAddress());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean sendToDeadLetterAddress(Transaction tx, MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress == null) {
            ActiveMQServerLogger.LOGGER.sendingMessageToDLAnoDLA(ref, this.queueConfiguration.getName());
            ref.acknowledge(tx, AckReason.KILLED, null);
            return false;
        }
        this.createDeadLetterResources();
        Bindings bindingList = this.postOffice.lookupBindingsForAddress(deadLetterAddress);
        if (bindingList != null && !bindingList.getBindings().isEmpty()) {
            ActiveMQServerLogger.LOGGER.sendingMessageToDLA(ref, deadLetterAddress, this.queueConfiguration.getName());
            RoutingStatus status = this.move(tx, deadLetterAddress, null, ref, false, AckReason.KILLED, null, null, true);
            if (!status.equals((Object)RoutingStatus.NO_BINDINGS)) return true;
            if (!this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString()).isAutoCreateDeadLetterResources()) return true;
            ActiveMQServerLogger.LOGGER.noMatchingBindingsOnDLAWithAutoCreateDLAResources(deadLetterAddress, ref.toString());
            return true;
        }
        ActiveMQServerLogger.LOGGER.noBindingsOnDLA(ref, deadLetterAddress);
        ref.acknowledge(tx, AckReason.KILLED, null);
        return false;
    }

    private void createDeadLetterResources() throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(this.getAddress().toString());
        this.createResources(String.valueOf(this.getAddress()), addressSettings.isAutoCreateDeadLetterResources(), addressSettings.getDeadLetterAddress(), addressSettings.getDeadLetterQueuePrefix(), addressSettings.getDeadLetterQueueSuffix());
    }

    private void createExpiryResources(String address, AddressSettings messageAddressSettings) throws Exception {
        this.createResources(address, messageAddressSettings.isAutoCreateExpiryResources(), messageAddressSettings.getExpiryAddress(), messageAddressSettings.getExpiryQueuePrefix(), messageAddressSettings.getExpiryQueueSuffix());
    }

    private void createResources(String address, boolean isAutoCreate, SimpleString destinationAddress, SimpleString prefix, SimpleString suffix) throws Exception {
        if (isAutoCreate && !address.equals(destinationAddress) && destinationAddress != null && !destinationAddress.isEmpty()) {
            SimpleString destinationQueueName = prefix.concat(address).concat(suffix);
            SimpleString filter = SimpleString.of((String)String.format("%s = '%s'", Message.HDR_ORIGINAL_ADDRESS, address));
            try {
                logger.debug("Creating Resource queue {}", (Object)destinationQueueName);
                this.server.createQueue(QueueConfiguration.of((SimpleString)destinationQueueName).setAddress(destinationAddress).setFilterString(filter).setAutoCreated(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(true)), true);
            }
            catch (ActiveMQQueueExistsException e) {
                logger.debug("resource {} already existed, ignoring outcome", (Object)destinationQueueName);
            }
        }
    }

    private boolean deliverDirect(MessageReference ref) {
        if (!this.deliverLock.tryLock()) {
            logger.trace("Cannot perform a directDelivery because there is a running async deliver");
            return false;
        }
        try {
            boolean bl = this.deliver(ref);
            return bl;
        }
        finally {
            this.deliverLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliver(MessageReference ref) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (!this.supportsDirectDeliver) {
                return false;
            }
            if (this.isPaused() || !this.canDispatch()) {
                return false;
            }
            if (this.checkExpired(ref)) {
                return true;
            }
            this.consumers.reset();
            while (this.consumers.hasNext()) {
                HandleStatus status;
                ConsumerHolder holder = (ConsumerHolder)this.consumers.next();
                Object consumer = holder.consumer;
                SimpleString groupID = this.extractGroupID(ref);
                Consumer groupConsumer = this.getGroupConsumer(groupID);
                if (groupConsumer != null) {
                    consumer = groupConsumer;
                }
                if ((status = this.handle(ref, (Consumer)consumer)) == HandleStatus.HANDLED) {
                    MessageReference reference = this.handleMessageGroup(ref, (Consumer)consumer, groupConsumer, groupID);
                    this.incrementMesssagesAdded();
                    this.deliveriesInTransit.countUp();
                    reference.setInDelivery(true);
                    this.proceedDeliver((Consumer)consumer, reference);
                    this.consumers.reset();
                    reference.setSequence(this.queueSequence.incrementAndGet());
                    return true;
                }
                if (groupConsumer == null) continue;
                break;
            }
            logger.trace("Queue {} is out of direct delivery as no consumers handled a delivery", (Object)this.queueConfiguration.getName());
            return false;
        }
    }

    private Consumer getGroupConsumer(SimpleString groupID) {
        Consumer groupConsumer = null;
        if (this.queueConfiguration.isExclusive().booleanValue()) {
            groupConsumer = this.exclusiveConsumer;
        } else if (groupID != null) {
            groupConsumer = this.groups.get(groupID);
        }
        return groupConsumer;
    }

    private MessageReference handleMessageGroup(MessageReference ref, Consumer consumer, Consumer groupConsumer, SimpleString groupID) {
        if (this.queueConfiguration.isExclusive().booleanValue()) {
            if (groupConsumer == null) {
                this.exclusiveConsumer = consumer;
                if (this.queueConfiguration.getGroupFirstKey() != null) {
                    return new GroupFirstMessageReference(this.queueConfiguration.getGroupFirstKey(), ref);
                }
            }
            this.consumers.repeat();
        } else if (groupID != null) {
            if (this.extractGroupSequence(ref) == -1) {
                this.groups.remove(groupID);
                this.consumers.repeat();
            } else if (groupConsumer == null) {
                this.groups.put(groupID, consumer);
                if (this.queueConfiguration.getGroupFirstKey() != null) {
                    return new GroupFirstMessageReference(this.queueConfiguration.getGroupFirstKey(), ref);
                }
            } else {
                this.consumers.repeat();
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedDeliver(Consumer consumer, MessageReference reference) {
        try {
            consumer.proceedDeliver(reference);
        }
        catch (Throwable t) {
            this.errorProcessing(consumer, t, reference);
        }
        finally {
            this.deliveriesInTransit.countDown();
        }
    }

    @Override
    public void errorProcessing(Consumer consumer, Throwable t, MessageReference reference) {
        ActiveMQServerLogger.LOGGER.removingBadConsumer(consumer, reference, t);
        this.executor.execute(() -> consumer.failed(t));
    }

    private boolean checkExpired(MessageReference reference) {
        try {
            if (reference.getMessage().isExpired()) {
                logger.trace("Reference {} is expired", (Object)reference);
                reference.handled();
                try {
                    this.expire(reference);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringRef(e);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToCheckIfMessageExpired(e);
            return false;
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(consumer, reference, t);
            try {
                this.errorProcessing(consumer, t, reference);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        this.postAcknowledge(ref, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason, boolean delivering) {
        QueueImpl queue = (QueueImpl)ref.getQueue();
        try {
            int count;
            boolean durableRef;
            Message message;
            if (delivering) {
                queue.decDelivering(ref);
            }
            if (this.queueConfiguration.isNonDestructive().booleanValue() && reason == AckReason.NORMAL) {
                ref.setInDelivery(false);
                return;
            }
            if (reason == AckReason.EXPIRED) {
                this.messagesExpired.incrementAndGet();
            } else if (reason == AckReason.KILLED) {
                this.messagesKilled.incrementAndGet();
            } else if (reason == AckReason.REPLACED) {
                this.messagesReplaced.incrementAndGet();
            } else {
                this.messagesAcknowledged.incrementAndGet();
            }
            if (ref.isPaged()) {
                return;
            }
            try {
                message = ref.getMessage();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToPerformPostAcknowledge(e);
                message = null;
            }
            if (message == null || this.queueConfiguration.isNonDestructive().booleanValue() && reason == AckReason.NORMAL) {
                return;
            }
            queue.refDown(ref);
            boolean bl = durableRef = message.isDurable() && queue.isDurable();
            if (durableRef && (count = queue.durableDown(message)) == 0) {
                try {
                    this.storageManager.deleteMessage(message.getMessageID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.cannotFindMessageOnJournal(message.getMessageID(), e);
                }
            }
        }
        finally {
            this.postOffice.postAcknowledge(ref, reason);
        }
    }

    void postRollback(LinkedList<MessageReference> refs) {
        if (this.queueConfiguration.isPurgeOnNoConsumers().booleanValue() && this.getConsumerCount() == 0) {
            this.purgeAfterRollback(refs);
            return;
        }
        if (!this.isNonDestructive()) {
            this.addSorted(refs, false);
        }
    }

    private void purgeAfterRollback(LinkedList<MessageReference> refs) {
        try {
            TransactionImpl transaction = new TransactionImpl(this.storageManager);
            for (MessageReference reference : refs) {
                this.incDelivering(reference);
                this.acknowledge(transaction, reference, AckReason.KILLED, null, true);
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private long calculateRedeliveryDelay(AddressSettings addressSettings, int deliveryCount) {
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        long maxRedeliveryDelay = addressSettings.getMaxRedeliveryDelay();
        double redeliveryMultiplier = addressSettings.getRedeliveryMultiplier();
        double collisionAvoidanceFactor = addressSettings.getRedeliveryCollisionAvoidanceFactor();
        int tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0;
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount));
        if (collisionAvoidanceFactor > 0.0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            double variance = (((Random)random).nextBoolean() ? collisionAvoidanceFactor : -collisionAvoidanceFactor) * ((Random)random).nextDouble();
            delay = (long)((double)delay + (double)delay * variance);
        }
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }

    @Override
    public synchronized void resetMessagesAdded() {
        this.messagesAdded.set(0L);
    }

    @Override
    public synchronized void resetMessagesAcknowledged() {
        this.messagesAcknowledged.set(0L);
    }

    @Override
    public synchronized void resetMessagesExpired() {
        this.messagesExpired.set(0L);
    }

    @Override
    public synchronized void resetMessagesKilled() {
        this.messagesKilled.set(0L);
    }

    private float getRate() {
        long locaMessageAdded = this.getMessagesAdded();
        float timeSlice = (float)(System.currentTimeMillis() - this.queueRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messagesAddedSnapshot.getAndSet(locaMessageAdded);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(locaMessageAdded - this.messagesAddedSnapshot.getAndSet(locaMessageAdded)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void recheckRefCount(OperationContext context) {
        final ReferenceCounter refCount = this.refCountForConsumers;
        if (refCount != null) {
            context.executeOnCompletion(new IOCallback(){

                public void done() {
                    refCount.check();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    public static MessageGroups<Consumer> groupMap(int groupBuckets) {
        if (groupBuckets == -1) {
            return new SimpleMessageGroups<Consumer>();
        }
        if (groupBuckets == 0) {
            return DisabledMessageGroups.instance();
        }
        return new BucketMessageGroups<Consumer>(groupBuckets);
    }

    @Override
    public QueueConfiguration getQueueConfiguration() {
        return QueueConfiguration.of((QueueConfiguration)this.queueConfiguration);
    }

    public void incDelivering(MessageReference ref) {
        this.deliveringMetrics.incrementMetrics(ref);
    }

    public void decDelivering(MessageReference reference) {
        this.deliveringMetrics.decrementMetrics(reference);
        if (this.pageDelivered) {
            this.deliverAsync();
        }
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }

    private void configureSlowConsumerReaper() {
        if (this.cachedAddressSettings == null || this.cachedAddressSettings.getSlowConsumerThreshold() == -1L) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
                this.slowConsumerReaperRunnable = null;
                logger.debug("Cancelled slow-consumer-reaper thread for queue \"{}\"", (Object)this.queueConfiguration.getName());
            }
        } else if (this.slowConsumerReaperRunnable == null) {
            this.scheduleSlowConsumerReaper(this.cachedAddressSettings);
        } else if (this.slowConsumerReaperRunnable.checkPeriod != this.cachedAddressSettings.getSlowConsumerCheckPeriod() || this.slowConsumerReaperRunnable.thresholdInMsgPerSecond != (float)this.cachedAddressSettings.getSlowConsumerThreshold() || !this.slowConsumerReaperRunnable.policy.equals((Object)this.cachedAddressSettings.getSlowConsumerPolicy())) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
            }
            this.scheduleSlowConsumerReaper(this.cachedAddressSettings);
        }
    }

    void scheduleSlowConsumerReaper(AddressSettings settings) {
        this.slowConsumerReaperRunnable = new SlowConsumerReaperRunnable(settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerThresholdMeasurementUnit(), settings.getSlowConsumerPolicy());
        this.slowConsumerReaperFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.slowConsumerReaperRunnable, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerCheckPeriod(), TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduled slow-consumer-reaper thread for queue \"{}\"; slow-consumer-check-period={}, slow-consumer-threshold={}, slow-consumer-threshold-measurement-unit={}, slow-consumer-policy={}", new Object[]{this.queueConfiguration.getName(), settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerThresholdMeasurementUnit(), settings.getSlowConsumerPolicy()});
        }
    }

    private void enforceRing(boolean head) {
        if (this.queueConfiguration.getRingSize() != -1L) {
            this.enforceRing(null, false, head);
        }
    }

    private void enforceRing(MessageReference refToAck, boolean scheduling, boolean head) {
        int adjustment;
        int n = adjustment = head ? 1 : 0;
        if (this.getPendingMessageCount() + (long)adjustment > this.queueConfiguration.getRingSize()) {
            MessageReference messageReference = refToAck = refToAck == null ? (MessageReference)this.messageReferences.poll() : refToAck;
            if (refToAck != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Preserving ringSize {} by acking message ref {}", (Object)this.queueConfiguration.getRingSize(), (Object)refToAck);
                }
                this.referenceHandled(refToAck);
                try {
                    refToAck.acknowledge(null, AckReason.REPLACED, null);
                    if (!refToAck.isInDelivery() && !scheduling) {
                        this.refRemoved(refToAck);
                    }
                    refToAck.setAlreadyAcked();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Cannot preserve ringSize {}; message ref is null", (Object)this.queueConfiguration.getRingSize());
            }
        }
    }

    private void checkDeadLetterAddressAndExpiryAddress() {
        if (!(Env.isTestEnv() || this.queueConfiguration.isInternal().booleanValue() || this.queueConfiguration.getAddress().equals((Object)this.server.getConfiguration().getManagementNotificationAddress()))) {
            if (this.cachedAddressSettings.getDeadLetterAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoDLA(this.queueConfiguration.getName());
            }
            if (this.cachedAddressSettings.getExpiryAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoExpiryAddress(this.queueConfiguration.getName());
            }
        }
    }

    protected static class ConsumerHolder<T extends Consumer>
    implements PriorityAware {
        final T consumer;
        final QueueImpl queue;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(T consumer, QueueImpl queue) {
            this.consumer = consumer;
            this.queue = queue;
        }

        private void resetIterator() {
            if (this.iter != null) {
                this.iter.close();
            }
            this.iter = null;
        }

        private Consumer consumer() {
            return this.consumer;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConsumerHolder)) {
                return false;
            }
            ConsumerHolder other = (ConsumerHolder)obj;
            return Objects.equals(this.consumer, other.consumer);
        }

        public int hashCode() {
            return Objects.hashCode(this.consumer);
        }

        public int getPriority() {
            return this.consumer.getPriority();
        }

        public String toString() {
            return "ConsumerHolder::queue=" + String.valueOf(this.queue) + ", consumer=" + String.valueOf(this.consumer);
        }
    }

    private final class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        @Override
        public void run() {
            block18: {
                try {
                    boolean needCheckDepage = false;
                    try (CriticalCloseable metric = QueueImpl.this.measureCritical(2);){
                        QueueImpl.this.deliverLock.lock();
                        try {
                            needCheckDepage = QueueImpl.this.deliver();
                        }
                        finally {
                            QueueImpl.this.deliverLock.unlock();
                        }
                    }
                    if (!needCheckDepage) break block18;
                    metric = QueueImpl.this.measureCritical(4);
                    try {
                        QueueImpl.this.checkDepage();
                    }
                    finally {
                        if (metric != null) {
                            metric.close();
                        }
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDelivering(e);
                }
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final ArtemisExecutor executor1;

        DelayedAddRedistributor(ArtemisExecutor executor) {
            this.executor1 = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor();
                QueueImpl.this.clearRedistributorFuture();
            }
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference removeLastElement() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.removeLastElement();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    private final class QueueBrowserIterator
    implements LinkedListIterator<MessageReference> {
        LinkedListIterator<PagedReference> pagingIterator = null;
        LinkedListIterator<MessageReference> messagesIterator = null;
        LinkedListIterator<? extends MessageReference> lastIterator = null;
        MessageReference cachedNext = null;
        Set<PagePosition> previouslyBrowsed = new HashSet<PagePosition>();

        private LinkedListIterator<PagedReference> getPagingIterator() {
            if (this.pagingIterator == null && QueueImpl.this.pageSubscription != null) {
                this.pagingIterator = QueueImpl.this.pageSubscription.iterator(true);
            }
            return this.pagingIterator;
        }

        private QueueBrowserIterator() {
            this.messagesIterator = new SynchronizedIterator((LinkedListIterator<MessageReference>)QueueImpl.this.messageReferences.iterator());
        }

        public boolean hasNext() {
            PagedReference nextMessage;
            MessageReference nextMessage2;
            if (this.cachedNext != null) {
                return true;
            }
            if (this.messagesIterator != null && (nextMessage2 = this.iterate(this.messagesIterator)) != null) {
                this.cachedNext = nextMessage2;
                this.lastIterator = this.messagesIterator;
                return true;
            }
            LinkedListIterator<PagedReference> pagingIterator = this.getPagingIterator();
            if (pagingIterator != null && (nextMessage = this.iteratePaging(pagingIterator)) != null) {
                this.cachedNext = nextMessage;
                this.lastIterator = pagingIterator;
                return true;
            }
            return false;
        }

        private PagedReference iteratePaging(LinkedListIterator<PagedReference> iterator) {
            while (iterator.hasNext()) {
                PagedReference ref = (PagedReference)iterator.next();
                if (this.previouslyBrowsed.remove(ref.getPosition())) continue;
                return ref;
            }
            return null;
        }

        private MessageReference iterate(LinkedListIterator<MessageReference> iterator) {
            if (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.isPaged()) {
                    this.previouslyBrowsed.add(((PagedReference)ref).getPosition());
                }
                return ref;
            }
            return null;
        }

        public MessageReference next() {
            PagedReference ref;
            MessageReference ref2;
            if (this.cachedNext != null) {
                try {
                    MessageReference messageReference = this.cachedNext;
                    return messageReference;
                }
                finally {
                    this.cachedNext = null;
                }
            }
            if (this.messagesIterator != null && this.messagesIterator.hasNext() && (ref2 = this.iterate(this.messagesIterator)) != null) {
                return ref2;
            }
            LinkedListIterator<PagedReference> pagingIterator = this.getPagingIterator();
            if (pagingIterator != null && (ref = this.iteratePaging(pagingIterator)) != null) {
                return ref;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastIterator != null) {
                this.lastIterator.remove();
            }
        }

        public MessageReference removeLastElement() {
            if (this.lastIterator != null) {
                return (MessageReference)this.lastIterator.removeLastElement();
            }
            return null;
        }

        public void repeat() {
        }

        public void close() {
            if (this.getPagingIterator() != null) {
                this.getPagingIterator().close();
            }
            if (this.messagesIterator != null) {
                this.messagesIterator.close();
            }
        }
    }

    private class ExpiryLogger
    extends TransactionOperationAbstract {
        List<Pair<SimpleString, MessageReference>> expiries = new LinkedList<Pair<SimpleString, MessageReference>>();

        private ExpiryLogger() {
        }

        public void addExpiry(SimpleString address, MessageReference ref) {
            this.expiries.add((Pair<SimpleString, MessageReference>)new Pair((Object)address, (Object)ref));
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Pair<SimpleString, MessageReference> pair : this.expiries) {
                try {
                    QueueImpl.this.server.callBrokerMessagePlugins(plugin -> plugin.messageExpired((MessageReference)pair.getB(), (SimpleString)pair.getA(), null));
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                }
            }
            this.expiries.clear();
        }
    }

    abstract class QueueIterateAction {
        protected Integer expectedHits;

        QueueIterateAction(Integer expectedHits) {
            this.expectedHits = expectedHits;
        }

        QueueIterateAction() {
            this.expectedHits = null;
        }

        public abstract boolean actMessage(Transaction var1, MessageReference var2) throws Exception;

        public boolean expectedHitsReached(int currentHits) {
            return this.expectedHits != null && currentHits >= this.expectedHits;
        }
    }

    class ExpiryScanner
    implements Runnable {
        private final Runnable doneCallback;
        LinkedListIterator<MessageReference> iter = null;

        ExpiryScanner(Runnable doneCallback) {
            this.doneCallback = doneCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean expired = false;
            boolean hasElements = false;
            int elementsIterated = 0;
            int elementsExpired = 0;
            boolean rescheduled = false;
            LinkedList<MessageReference> expiredMessages = new LinkedList<MessageReference>();
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                logger.debug("Scanning for expires on {}", (Object)QueueImpl.this.queueConfiguration.getName());
                if (this.iter == null) {
                    if (QueueImpl.this.server.hasBrokerQueuePlugins()) {
                        try {
                            QueueImpl.this.server.callBrokerQueuePlugins(p -> p.beforeExpiryScan(QueueImpl.this));
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.iter = QueueImpl.this.iterator();
                }
                try {
                    while (!QueueImpl.this.queueDestroyed && QueueImpl.this.postOffice.isStarted() && this.iter.hasNext()) {
                        hasElements = true;
                        MessageReference ref = (MessageReference)this.iter.next();
                        if (ref.getMessage().isExpired()) {
                            ++elementsExpired;
                            QueueImpl.this.incDelivering(ref);
                            expired = true;
                            expiredMessages.add(ref);
                            this.iter.remove();
                        }
                        if (++elementsIterated < 1000) continue;
                        logger.debug("Expiry Scanner on {} ran for {} iteration, scheduling a new one", (Object)QueueImpl.this.getName(), (Object)elementsIterated);
                        rescheduled = true;
                        QueueImpl.this.getExecutor().execute((Runnable)this);
                        break;
                    }
                }
                finally {
                    if (!rescheduled) {
                        logger.debug("Scanning for expires on {} done", (Object)QueueImpl.this.queueConfiguration.getName());
                        if (QueueImpl.this.server.hasBrokerQueuePlugins()) {
                            try {
                                QueueImpl.this.server.callBrokerQueuePlugins(p -> p.afterExpiryScan(QueueImpl.this));
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage(), (Throwable)e);
                            }
                        }
                        this.iter.close();
                        this.iter = null;
                        if (this.doneCallback != null) {
                            this.doneCallback.run();
                        }
                    }
                }
            }
            if (!expiredMessages.isEmpty()) {
                TransactionImpl tx = new TransactionImpl(QueueImpl.this.storageManager);
                for (MessageReference ref : expiredMessages) {
                    try {
                        QueueImpl.this.expire(tx, ref, null, true);
                        QueueImpl.this.refRemoved(ref);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorExpiringReferencesOnQueue(ref, e);
                    }
                }
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCommitTransaction(e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Expired {} references", (Object)elementsExpired);
                }
            }
            if ((!hasElements || expired) && QueueImpl.this.pageIterator != null && QueueImpl.this.pageIterator.tryNext() != PageIterator.NextResult.noElements) {
                QueueImpl.this.scheduleDepage(true);
            }
        }
    }

    private final class SlowConsumerReaperRunnable
    implements Runnable {
        private final SlowConsumerPolicy policy;
        private final float thresholdInMsgPerSecond;
        private final long checkPeriod;

        private SlowConsumerReaperRunnable(long checkPeriod, float slowConsumerThreshold, SlowConsumerThresholdMeasurementUnit unit, SlowConsumerPolicy policy) {
            this.checkPeriod = checkPeriod;
            this.policy = policy;
            this.thresholdInMsgPerSecond = slowConsumerThreshold / (float)unit.getValue();
        }

        @Override
        public void run() {
            int consumerCount;
            float queueRate = QueueImpl.this.getRate();
            long queueMessages = QueueImpl.this.getMessageCount();
            if (logger.isDebugEnabled()) {
                logger.debug("{}:{} has {} message(s) and {} consumer(s) and is receiving messages at a rate of {} msgs/second.", new Object[]{QueueImpl.this.queueConfiguration.getAddress(), QueueImpl.this.queueConfiguration.getName(), queueMessages, QueueImpl.this.getConsumerCount(), Float.valueOf(queueRate)});
            }
            if ((consumerCount = QueueImpl.this.getConsumerCount()) == 0) {
                logger.debug("There are no consumers, no need to check slow consumer's rate");
                return;
            }
            float queueThreshold = this.thresholdInMsgPerSecond * (float)consumerCount;
            if (queueRate < queueThreshold && (float)queueMessages < queueThreshold) {
                logger.debug("Insufficient messages received on queue \"{}\" to satisfy slow-consumer-threshold. Skipping inspection of consumer.", (Object)QueueImpl.this.queueConfiguration.getName());
                return;
            }
            for (ConsumerHolder consumerHolder : QueueImpl.this.consumers) {
                ServerConsumerImpl serverConsumer;
                float consumerRate;
                Consumer consumer = consumerHolder.consumer();
                if (!(consumer instanceof ServerConsumerImpl) || !((consumerRate = (serverConsumer = (ServerConsumerImpl)consumer).getRate()) < this.thresholdInMsgPerSecond) && (consumerRate != 0.0f || this.thresholdInMsgPerSecond != 0.0f)) continue;
                RemotingConnection connection = null;
                ActiveMQServer server = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer();
                RemotingService remotingService = server.getRemotingService();
                for (RemotingConnection potentialConnection : remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(String.valueOf(serverConsumer.getConnectionID()))) continue;
                    connection = potentialConnection;
                }
                serverConsumer.fireSlowConsumer();
                if (connection == null) continue;
                ActiveMQServerLogger.LOGGER.slowConsumerDetected(serverConsumer.getSessionID(), serverConsumer.getID(), QueueImpl.this.getName().toString(), connection.getRemoteAddress(), this.thresholdInMsgPerSecond, consumerRate);
                if (this.policy.equals((Object)SlowConsumerPolicy.KILL)) {
                    connection.killMessage(server.getNodeID());
                    remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(connection.getRemoteAddress()));
                    continue;
                }
                if (!this.policy.equals((Object)SlowConsumerPolicy.NOTIFY)) continue;
                TypedProperties props = new TypedProperties();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, QueueImpl.this.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, QueueImpl.this.queueConfiguration.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.of((String)connection.getRemoteAddress()));
                if (connection.getID() != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.of((String)connection.getID().toString()));
                }
                props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, serverConsumer.getID());
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.of((String)serverConsumer.getSessionID()));
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_SLOW, props);
                ManagementService managementService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getManagementService();
                try {
                    managementService.sendNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendSlowConsumerNotification(notification, e);
                }
            }
        }
    }
}

