/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management.impl;

import io.micrometer.core.instrument.Tag;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.management.impl.AcceptorControlImpl;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.management.impl.AddressControlImpl;
import org.apache.activemq.artemis.core.management.impl.BaseBroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.management.impl.BridgeControlImpl;
import org.apache.activemq.artemis.core.management.impl.BroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.management.impl.BrokerConnectionControlImpl;
import org.apache.activemq.artemis.core.management.impl.ClusterConnectionControlImpl;
import org.apache.activemq.artemis.core.management.impl.ConnectionRouterControlImpl;
import org.apache.activemq.artemis.core.management.impl.DivertControlImpl;
import org.apache.activemq.artemis.core.management.impl.JGroupsChannelBroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.management.impl.JGroupsFileBroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.management.impl.QueueControlImpl;
import org.apache.activemq.artemis.core.management.impl.RemoteBrokerConnectionControlImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.messagecounter.impl.MessageCounterManagerImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RemoteBrokerConnection;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.management.GuardInvocationHandler;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.server.management.impl.HawtioSecurityControlImpl;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouter;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServiceImpl
implements ManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MBeanServer mbeanServer;
    private final boolean jmxManagementEnabled;
    private final Map<String, Object> registry;
    private final NotificationBroadcasterSupport broadcaster;
    private PostOffice postOffice;
    private SecurityStore securityStore;
    private PagingManager pagingManager;
    private StorageManager storageManager;
    private ActiveMQServer messagingServer;
    private HierarchicalRepository<Set<Role>> securityRepository;
    private HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private ActiveMQServerControlImpl messagingServerControl;
    private MessageCounterManager messageCounterManager;
    private final SimpleString managementNotificationAddress;
    private final SimpleString managementAddress;
    private volatile boolean started = false;
    private final boolean messageCounterEnabled;
    private boolean notificationsEnabled;
    private final Set<NotificationListener> listeners = new ConcurrentHashSet();
    private final ObjectNameBuilder objectNameBuilder;
    private final SimpleString managementMessageRbacResourceNamePrefix;
    private final Pattern viewPermissionMatcher;
    private final Set<ObjectName> registeredNames = new ConcurrentHashSet();

    public ManagementServiceImpl(MBeanServer mbeanServer, Configuration configuration) {
        this.mbeanServer = mbeanServer;
        this.jmxManagementEnabled = configuration.isJMXManagementEnabled();
        this.messageCounterEnabled = configuration.isMessageCounterEnabled();
        this.managementAddress = configuration.getManagementAddress();
        this.managementNotificationAddress = configuration.getManagementNotificationAddress();
        this.registry = new ConcurrentHashMap<String, Object>();
        this.broadcaster = new NotificationBroadcasterSupport();
        this.notificationsEnabled = true;
        this.objectNameBuilder = ObjectNameBuilder.create((String)configuration.getJMXDomain(), (String)configuration.getName(), (boolean)configuration.isJMXUseBrokerName());
        this.managementMessageRbacResourceNamePrefix = configuration.isManagementMessageRbac() ? SimpleString.of((String)configuration.getManagementRbacPrefix()).concat('.') : null;
        this.viewPermissionMatcher = Pattern.compile(configuration.getViewPermissionMethodMatchPattern());
    }

    @Override
    public ObjectNameBuilder getObjectNameBuilder() {
        return this.objectNameBuilder;
    }

    @Override
    public MessageCounterManager getMessageCounterManager() {
        return this.messageCounterManager;
    }

    @Override
    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public ActiveMQServerControlImpl registerServer(PostOffice postOffice, SecurityStore securityStore, StorageManager storageManager1, Configuration configuration, HierarchicalRepository<AddressSettings> addressSettingsRepository, HierarchicalRepository<Set<Role>> securityRepository, ResourceManager resourceManager, RemotingService remotingService, ActiveMQServer messagingServer, QueueFactory queueFactory, ScheduledExecutorService scheduledThreadPool, PagingManager pagingManager, boolean backup) throws Exception {
        this.postOffice = postOffice;
        this.securityStore = securityStore;
        this.addressSettingsRepository = addressSettingsRepository;
        this.securityRepository = securityRepository;
        this.storageManager = storageManager1;
        this.messagingServer = messagingServer;
        this.pagingManager = pagingManager;
        this.messageCounterManager = new MessageCounterManagerImpl(scheduledThreadPool, (Executor)messagingServer.getExecutorFactory().getExecutor());
        this.messageCounterManager.setMaxDayCount(configuration.getMessageCounterMaxDayHistory());
        this.messageCounterManager.reschedule(configuration.getMessageCounterSamplePeriod());
        this.messagingServerControl = new ActiveMQServerControlImpl(postOffice, configuration, resourceManager, remotingService, messagingServer, this.messageCounterManager, storageManager1, this.broadcaster);
        ObjectName objectName = this.objectNameBuilder.getActiveMQServerObjectName();
        this.registerInJMX(objectName, this.messagingServerControl);
        this.registerInRegistry("broker", this.messagingServerControl);
        this.registerBrokerMeters();
        return this.messagingServerControl;
    }

    private void registerBrokerMeters() {
        MetricsManager metricsManager = this.messagingServer.getMetricsManager();
        if (metricsManager != null) {
            metricsManager.registerBrokerGauge(builder -> {
                builder.build("connection.count", this.messagingServer, metrics -> this.messagingServer.getConnectionCount(), "Number of clients connected to this server", Collections.emptyList());
                builder.build("total.connection.count", this.messagingServer, metrics -> this.messagingServer.getTotalConnectionCount(), "Total number of clients which have connected to this server since it was started", Collections.emptyList());
                builder.build("session.count", this.messagingServer, metrics -> this.messagingServer.getSessionCount(), "Number of sessions on this server", Collections.emptyList());
                builder.build("total.session.count", this.messagingServer, metrics -> this.messagingServer.getTotalSessionCount(), "Total number of sessions created on this server since it was started", Collections.emptyList());
                builder.build("address.memory.usage", this.messagingServer, metrics -> this.messagingServerControl.getAddressMemoryUsage(), "Memory used by all the addresses on broker for in-memory messages", Collections.emptyList());
                builder.build("address.memory.usage.percentage", this.messagingServer, metrics -> this.messagingServerControl.getAddressMemoryUsagePercentage(), "Memory used by all the addresses on broker as a percentage of the global-max-size", Collections.emptyList());
                builder.build("disk.store.usage", this.messagingServer, metrics -> this.messagingServer.getDiskStoreUsage(), "Fraction of total disk store used", Collections.emptyList());
                builder.build("replica.sync", this.messagingServer, metrics -> this.messagingServer.isReplicaSync() ? 1.0 : 0.0, "If the initial replication synchronization process is complete", Collections.emptyList());
                builder.build("active", this.messagingServer, metrics -> this.messagingServer.isActive() ? 1.0 : 0.0, "If the server is active", Collections.emptyList());
                builder.build("authentication.count", this.securityStore, metrics -> this.securityStore.getAuthenticationSuccessCount(), "Number of successful authentication attempts", Arrays.asList(Tag.of((String)"result", (String)"success")));
                builder.build("authentication.count", this.securityStore, metrics -> this.securityStore.getAuthenticationFailureCount(), "Number of failed authentication attempts", Arrays.asList(Tag.of((String)"result", (String)"failure")));
                builder.build("authorization.count", this.securityStore, metrics -> this.securityStore.getAuthorizationSuccessCount(), "Number of successful authorization attempts", Arrays.asList(Tag.of((String)"result", (String)"success")));
                builder.build("authorization.count", this.securityStore, metrics -> this.securityStore.getAuthorizationFailureCount(), "Number of failed authorization attempts", Arrays.asList(Tag.of((String)"result", (String)"failure")));
            });
        }
    }

    @Override
    public void unregisterServer() throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getActiveMQServerObjectName());
        this.unregisterFromRegistry("broker");
        if (this.messagingServer != null) {
            this.unregisterMeters("broker." + this.messagingServer.getConfiguration().getName());
        }
    }

    @Override
    public void registerAddress(AddressInfo addressInfo) throws Exception {
        AddressControlImpl addressControl = new AddressControlImpl(addressInfo, this.messagingServer, this.pagingManager, this.storageManager, this.securityRepository, this.securityStore, this);
        this.registerInJMX(this.objectNameBuilder.getAddressObjectName(addressInfo.getName()), addressControl);
        this.registerInRegistry("address." + String.valueOf(addressInfo.getName()), addressControl);
        this.registerAddressMeters(addressInfo, addressControl);
    }

    @Override
    public void registerAddressMeters(AddressInfo addressInfo, AddressControl addressControl) {
        MetricsManager metricsManager;
        if (this.messagingServer != null && (metricsManager = this.messagingServer.getMetricsManager()) != null) {
            metricsManager.registerAddressGauge(addressInfo.getName().toString(), builder -> {
                builder.build("routed.message.count", addressInfo, metrics -> addressInfo.getRoutedMessageCount(), "number of messages routed to one or more bindings", Collections.emptyList());
                builder.build("unrouted.message.count", addressInfo, metrics -> addressInfo.getUnRoutedMessageCount(), "number of messages not routed to any bindings", Collections.emptyList());
                builder.build("address.size", addressInfo, metrics -> addressControl.getAddressSize(), "the number of estimated bytes being used by all the queue(s) bound to this address; used to control paging and blocking", Collections.emptyList());
                builder.build("number.of.pages", addressInfo, metrics -> addressControl.getNumberOfPages(), "number of pages used by this address", Collections.emptyList());
                builder.build("limit.percent", addressInfo, metrics -> addressControl.getAddressLimitPercent(), "the % of memory limit (global or local) that is in use by this address", Collections.emptyList());
            });
        }
    }

    @Override
    public void unregisterAddress(SimpleString address) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getAddressObjectName(address));
        this.unregisterFromRegistry("address." + String.valueOf(address));
        this.unregisterMeters("address." + String.valueOf(address));
    }

    @Override
    public void registerQueue(Queue queue, SimpleString address, StorageManager storageManager) throws Exception {
        QueueControlImpl queueControl = new QueueControlImpl(queue, address.toString(), this.messagingServer, storageManager, this.securityStore, this.addressSettingsRepository);
        if (this.messageCounterManager != null) {
            MessageCounter counter = new MessageCounter(queue.getName().toString(), null, queue, false, queue.isDurable(), this.messageCounterManager.getMaxDayCount());
            queueControl.setMessageCounter(counter);
            this.messageCounterManager.registerMessageCounter(queue.getName().toString(), counter);
        }
        this.registerInJMX(this.objectNameBuilder.getQueueObjectName(address, queue.getName(), queue.getRoutingType()), queueControl);
        this.registerInRegistry("queue." + String.valueOf(queue.getName()), queueControl);
        this.registerQueueMeters(queue);
    }

    @Override
    public void unregisterQueue(SimpleString name, SimpleString address, RoutingType routingType) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getQueueObjectName(address, name, routingType));
        this.unregisterFromRegistry("queue." + String.valueOf(name));
        this.unregisterMeters("queue." + String.valueOf(name));
        if (this.messageCounterManager != null) {
            this.messageCounterManager.unregisterMessageCounter(name.toString());
        }
    }

    private void registerQueueMeters(Queue queue) {
        MetricsManager metricsManager;
        if (this.messagingServer != null && (metricsManager = this.messagingServer.getMetricsManager()) != null) {
            metricsManager.registerQueueGauge(queue.getAddress().toString(), queue.getName().toString(), builder -> {
                builder.build("message.count", queue, metrics -> queue.getMessageCount(), "number of messages currently in this queue (includes scheduled, paged, and in-delivery messages)", Collections.emptyList());
                builder.build("durable.message.count", queue, metrics -> queue.getDurableMessageCount(), "number of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)", Collections.emptyList());
                builder.build("persistent.size", queue, metrics -> queue.getPersistentSize(), "persistent size of all messages (including durable and non-durable) currently in this queue (includes scheduled, paged, and in-delivery messages)", Collections.emptyList());
                builder.build("durable.persistent.size", queue, metrics -> queue.getDurablePersistentSize(), "persistent size of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)", Collections.emptyList());
                builder.build("delivering.message.count", queue, metrics -> queue.getDeliveringCount(), "number of messages that this queue is currently delivering to its consumers", Collections.emptyList());
                builder.build("delivering.durable.message.count", queue, metrics -> queue.getDurableDeliveringCount(), "number of durable messages that this queue is currently delivering to its consumers", Collections.emptyList());
                builder.build("delivering.persistent_size", queue, metrics -> queue.getDeliveringSize(), "persistent size of messages that this queue is currently delivering to its consumers", Collections.emptyList());
                builder.build("delivering.durable.persistent.size", queue, metrics -> queue.getDurableDeliveringSize(), "persistent size of durable messages that this queue is currently delivering to its consumers", Collections.emptyList());
                builder.build("scheduled.message.count", queue, metrics -> queue.getScheduledCount(), "number of scheduled messages in this queue", Collections.emptyList());
                builder.build("scheduled.durable.message.count", queue, metrics -> queue.getDurableScheduledCount(), "number of durable scheduled messages in this queue", Collections.emptyList());
                builder.build("scheduled.persistent.size", queue, metrics -> queue.getScheduledSize(), "persistent size of scheduled messages in this queue", Collections.emptyList());
                builder.build("scheduled.durable.persistent.size", queue, metrics -> queue.getDurableScheduledSize(), "persistent size of durable scheduled messages in this queue", Collections.emptyList());
                builder.build("messages.acknowledged", queue, metrics -> queue.getMessagesAcknowledged(), "number of messages acknowledged from this queue since it was created", Collections.emptyList());
                builder.build("messages.added", queue, metrics -> queue.getMessagesAdded(), "number of messages added to this queue since it was created", Collections.emptyList());
                builder.build("messages.killed", queue, metrics -> queue.getMessagesKilled(), "number of messages removed from this queue since it was created due to exceeding the max delivery attempts", Collections.emptyList());
                builder.build("messages.expired", queue, metrics -> queue.getMessagesExpired(), "number of messages expired from this queue since it was created", Collections.emptyList());
                builder.build("consumer.count", queue, metrics -> queue.getConsumerCount(), "number of consumers consuming messages from this queue", Collections.emptyList());
            });
        }
    }

    private void unregisterMeters(String name) {
        MetricsManager metricsManager;
        if (this.messagingServer != null && (metricsManager = this.messagingServer.getMetricsManager()) != null) {
            metricsManager.remove(name);
        }
    }

    @Override
    public void registerDivert(Divert divert) throws Exception {
        DivertControlImpl divertControl = new DivertControlImpl(divert, this.storageManager, this.messagingServer.getInternalNamingPrefix());
        this.registerInJMX(this.objectNameBuilder.getDivertObjectName(divert.getUniqueName().toString(), divert.getAddress().toString()), divertControl);
        this.registerInRegistry("divert." + String.valueOf(divert.getUniqueName()), divertControl);
    }

    @Override
    public void unregisterDivert(SimpleString name, SimpleString address) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getDivertObjectName(name.toString(), address.toString()));
        this.unregisterFromRegistry("divert." + String.valueOf(name));
    }

    @Override
    public void registerAcceptor(Acceptor acceptor, TransportConfiguration configuration) throws Exception {
        AcceptorControlImpl control = new AcceptorControlImpl(acceptor, this.storageManager, configuration);
        this.registerInJMX(this.objectNameBuilder.getAcceptorObjectName(configuration.getName()), control);
        this.registerInRegistry("acceptor." + configuration.getName(), control);
    }

    @Override
    public void unregisterAcceptors() {
        for (String resourceName : new HashSet<String>(this.registry.keySet())) {
            if (!resourceName.startsWith("acceptor.")) continue;
            String name = resourceName.substring("acceptor.".length());
            try {
                this.unregisterAcceptor(name);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToUnregisterAcceptor(name, e);
            }
        }
    }

    public void unregisterAcceptor(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getAcceptorObjectName(name));
        this.unregisterFromRegistry("acceptor." + name);
    }

    @Override
    public void registerBroadcastGroup(BroadcastGroup broadcastGroup, BroadcastGroupConfiguration configuration) throws Exception {
        broadcastGroup.setNotificationService(this);
        BroadcastEndpointFactory endpointFactory = configuration.getEndpointFactory();
        BaseBroadcastGroupControlImpl control = null;
        if (endpointFactory instanceof UDPBroadcastEndpointFactory) {
            UDPBroadcastEndpointFactory factory = (UDPBroadcastEndpointFactory)endpointFactory;
            control = new BroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration, factory);
        } else if (endpointFactory instanceof JGroupsFileBroadcastEndpointFactory) {
            JGroupsFileBroadcastEndpointFactory factory = (JGroupsFileBroadcastEndpointFactory)endpointFactory;
            control = new JGroupsFileBroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration, factory);
        } else if (endpointFactory instanceof ChannelBroadcastEndpointFactory) {
            ChannelBroadcastEndpointFactory factory = (ChannelBroadcastEndpointFactory)endpointFactory;
            control = new JGroupsChannelBroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration, factory);
        } else {
            control = new BaseBroadcastGroupControlImpl(broadcastGroup, this.storageManager, configuration);
        }
        this.registerInJMX(this.objectNameBuilder.getBroadcastGroupObjectName(configuration.getName()), control);
        this.registerInRegistry("broadcastgroup." + configuration.getName(), control);
    }

    @Override
    public void unregisterBroadcastGroup(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getBroadcastGroupObjectName(name));
        this.unregisterFromRegistry("broadcastgroup." + name);
    }

    @Override
    public void registerBrokerConnection(BrokerConnection brokerConnection) throws Exception {
        BrokerConnectionControlImpl control = new BrokerConnectionControlImpl(brokerConnection, this.storageManager);
        this.registerInJMX(this.objectNameBuilder.getBrokerConnectionObjectName(brokerConnection.getName()), control);
        this.registerInRegistry("brokerconnection." + brokerConnection.getName(), control);
    }

    @Override
    public void unregisterBrokerConnection(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getBrokerConnectionObjectName(name));
        this.unregisterFromRegistry("brokerconnection." + name);
    }

    @Override
    public void registerRemoteBrokerConnection(RemoteBrokerConnection brokerConnection) throws Exception {
        String nodeId = brokerConnection.getNodeId();
        String name = brokerConnection.getName();
        Objects.requireNonNull(nodeId, "Remote Node ID must be a non-null value");
        Objects.requireNonNull(name, "Remote connection name must be a non-null value");
        if (nodeId.isBlank()) {
            throw new IllegalArgumentException("Remote node ID must be a non-empty string value");
        }
        if (name.isBlank()) {
            throw new IllegalArgumentException("Remote connection name must be a non-empty string value");
        }
        RemoteBrokerConnectionControlImpl control = new RemoteBrokerConnectionControlImpl(brokerConnection, this.storageManager);
        this.registerInJMX(this.objectNameBuilder.getRemoteBrokerConnectionObjectName(nodeId, name), control);
        this.registerInRegistry("remotebrokerconnection." + nodeId + "." + name, control);
    }

    @Override
    public void unregisterRemoteBrokerConnection(String nodeId, String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getRemoteBrokerConnectionObjectName(nodeId, name));
        this.unregisterFromRegistry("remotebrokerconnection." + nodeId + "." + name);
    }

    @Override
    public void registerBridge(Bridge bridge) throws Exception {
        bridge.setNotificationService(this);
        BridgeControlImpl control = new BridgeControlImpl(bridge, this.storageManager);
        this.registerInJMX(this.objectNameBuilder.getBridgeObjectName(bridge.getConfiguration().getName()), control);
        this.registerInRegistry("bridge." + String.valueOf(bridge.getName()), control);
    }

    @Override
    public void unregisterBridge(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getBridgeObjectName(name));
        this.unregisterFromRegistry("bridge." + name);
    }

    @Override
    public void registerCluster(ClusterConnection cluster, ClusterConnectionConfiguration configuration) throws Exception {
        ClusterConnectionControlImpl control = new ClusterConnectionControlImpl(cluster, this.storageManager, configuration);
        this.registerInJMX(this.objectNameBuilder.getClusterConnectionObjectName(configuration.getName()), control);
        this.registerInRegistry("clusterconnection." + configuration.getName(), control);
    }

    @Override
    public void unregisterCluster(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getClusterConnectionObjectName(name));
        this.unregisterFromRegistry("clusterconnection." + name);
    }

    @Override
    public void registerConnectionRouter(ConnectionRouter router) throws Exception {
        ConnectionRouterControlImpl connectionRouterControl = new ConnectionRouterControlImpl(router, this.storageManager);
        this.registerInJMX(this.objectNameBuilder.getConnectionRouterObjectName(router.getName()), connectionRouterControl);
        this.registerInRegistry("connectionrouter." + router.getName(), connectionRouterControl);
    }

    @Override
    public void unregisterConnectionRouter(String name) throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getConnectionRouterObjectName(name));
        this.unregisterFromRegistry("connectionrouter." + name);
    }

    @Override
    public void registerHawtioSecurity(GuardInvocationHandler guard) throws Exception {
        HawtioSecurityControlImpl control = new HawtioSecurityControlImpl(guard, this.storageManager);
        this.registerInJMX(this.objectNameBuilder.getSecurityObjectName(), control);
        this.registerInRegistry("managementsecurity", control);
    }

    @Override
    public void unregisterHawtioSecurity() throws Exception {
        this.unregisterFromJMX(this.objectNameBuilder.getSecurityObjectName());
        this.unregisterFromRegistry("managementsecurity");
    }

    @Override
    public ICoreMessage handleMessage(SecurityAuth auth, Message message) throws Exception {
        message = message.toCore();
        CoreMessage reply = new CoreMessage(this.storageManager.generateID(), 512);
        reply.setType((byte)3);
        reply.setReplyTo(message.getReplyTo());
        Object correlationID = this.getCorrelationIdentity(message);
        if (correlationID != null) {
            reply.setCorrelationID(correlationID);
        }
        String resourceName = message.getStringProperty(ManagementHelper.HDR_RESOURCE_NAME);
        logger.debug("handling management message for {}", (Object)resourceName);
        String operation = message.getStringProperty(ManagementHelper.HDR_OPERATION_NAME);
        if (operation != null) {
            Object[] params = ManagementHelper.retrieveOperationParameters((Message)message);
            if (params == null) {
                params = new Object[]{};
            }
            try {
                Object result = this.invokeOperation(resourceName, operation, params, auth);
                ManagementHelper.storeResult((CoreMessage)reply, (Object)result);
                reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, true);
            }
            catch (Exception e) {
                String exceptionMessage;
                ActiveMQServerLogger.LOGGER.managementOperationError(operation, resourceName, e);
                reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                    exceptionMessage = invocationTargetException.getTargetException().getMessage();
                } else {
                    exceptionMessage = e.getMessage();
                }
                ManagementHelper.storeResult((CoreMessage)reply, (Object)exceptionMessage);
            }
        } else {
            String attribute = message.getStringProperty(ManagementHelper.HDR_ATTRIBUTE);
            if (attribute != null) {
                try {
                    Object result = this.getAttribute(resourceName, attribute, auth);
                    ManagementHelper.storeResult((CoreMessage)reply, (Object)result);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, true);
                }
                catch (Exception e) {
                    String exceptionMessage;
                    ActiveMQServerLogger.LOGGER.managementAttributeError(attribute, resourceName, e);
                    reply.putBooleanProperty(ManagementHelper.HDR_OPERATION_SUCCEEDED, false);
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException invocationTargetException = (InvocationTargetException)e;
                        exceptionMessage = invocationTargetException.getTargetException().getMessage();
                    } else {
                        exceptionMessage = e.getMessage();
                    }
                    ManagementHelper.storeResult((CoreMessage)reply, (Object)exceptionMessage);
                }
            }
        }
        return reply;
    }

    protected void securityCheck(String controlName, CheckType permission, SecurityAuth auth) throws Exception {
        if (this.managementMessageRbacResourceNamePrefix == null) {
            return;
        }
        SimpleString address = this.managementMessageRbacResourceNamePrefix.concat(controlName);
        this.securityStore.check(address, permission, auth);
    }

    protected CheckType permissionForInvoke(String method) {
        if (this.viewPermissionMatcher.matcher(method).matches()) {
            return CheckType.VIEW;
        }
        return CheckType.EDIT;
    }

    @Override
    public Object getResource(String resourceName) {
        return this.registry.get(resourceName);
    }

    @Override
    public Object[] getResources(Class<?> resourceType) {
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Object entry : new ArrayList<Object>(this.registry.values())) {
            if (!resourceType.isAssignableFrom(entry.getClass())) continue;
            resources.add(entry);
        }
        return resources.toArray(new Object[resources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInJMX(ObjectName objectName, Object managedResource) throws Exception {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            this.unregisterFromJMX(objectName);
            this.mbeanServer.registerMBean(managedResource, objectName);
            this.registeredNames.add(objectName);
        }
        logger.debug("Registered in JMX: {} as {}", (Object)objectName, managedResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFromJMX(ObjectName objectName) throws MBeanRegistrationException, InstanceNotFoundException {
        if (!this.jmxManagementEnabled) {
            return;
        }
        MBeanServer mBeanServer = this.mbeanServer;
        synchronized (mBeanServer) {
            if (this.mbeanServer.isRegistered(objectName)) {
                this.mbeanServer.unregisterMBean(objectName);
                this.registeredNames.remove(objectName);
            }
        }
        logger.debug("Unregistered from JMX: {}", (Object)objectName);
    }

    @Override
    public void registerInRegistry(String resourceName, Object managedResource) {
        Object replaced = this.registry.put(resourceName, managedResource);
        Object addendum = "";
        if (replaced != null) {
            addendum = ". Replaced: " + String.valueOf(replaced);
        }
        logger.debug("Registered in management: {} as {}{}", new Object[]{resourceName, managedResource, addendum});
    }

    @Override
    public void unregisterFromRegistry(String resourceName) {
        Object removed = this.registry.remove(resourceName);
        if (removed != null) {
            logger.debug("Unregistered from management: {} as {}", (Object)resourceName, removed);
        } else {
            logger.debug("Attempted to unregister {} from management, but it was not registered.");
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SimpleString getManagementAddress() {
        return this.managementAddress;
    }

    @Override
    public SimpleString getManagementNotificationAddress() {
        return this.managementNotificationAddress;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.messageCounterEnabled) {
            this.messageCounterManager.start();
        }
        this.messagingServer.registerActivateCallback(new CleaningActivateCallback(){

            @Override
            public void activated() {
                try {
                    ActiveMQServer usedServer = ManagementServiceImpl.this.messagingServer;
                    if (usedServer != null) {
                        usedServer.addAddressInfo(new AddressInfo(ManagementServiceImpl.this.managementNotificationAddress, RoutingType.MULTICAST));
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCreateManagementNotificationAddress(ManagementServiceImpl.this.managementNotificationAddress, e);
                }
            }
        });
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        HashSet<String> resourceNames = new HashSet<String>(this.registry.keySet());
        for (String resourceName : resourceNames) {
            this.unregisterFromRegistry(resourceName);
            this.unregisterMeters(resourceName);
        }
        if (this.jmxManagementEnabled && !this.registeredNames.isEmpty()) {
            ArrayList<String> unexpectedResourceNames = new ArrayList<String>();
            for (String name : resourceNames) {
                if (name.startsWith("address.") || name.startsWith("queue.") || name.startsWith("divert.")) continue;
                unexpectedResourceNames.add(name);
            }
            if (!unexpectedResourceNames.isEmpty()) {
                ActiveMQServerLogger.LOGGER.managementStopError(unexpectedResourceNames.size(), unexpectedResourceNames);
            }
            for (ObjectName on : this.registeredNames) {
                try {
                    this.mbeanServer.unregisterMBean(on);
                }
                catch (Exception exception) {}
            }
        }
        if (this.messageCounterManager != null) {
            this.messageCounterManager.stop();
            this.messageCounterManager.resetAllCounters();
            this.messageCounterManager.resetAllCounterHistories();
            this.messageCounterManager.clear();
        }
        this.listeners.clear();
        this.registry.clear();
        this.messagingServer = null;
        this.securityRepository = null;
        this.addressSettingsRepository = null;
        this.messagingServerControl = null;
        this.messageCounterManager = null;
        this.postOffice = null;
        this.pagingManager = null;
        this.storageManager = null;
        this.registeredNames.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) throws Exception {
        if (this.messagingServerControl == null || !this.notificationsEnabled) {
            return;
        }
        Object object = this.postOffice.getNotificationLock();
        synchronized (object) {
            logger.trace("Sending notification={}", (Object)notification);
            for (NotificationListener listener : this.listeners) {
                try {
                    listener.onNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorCallingNotifListener(e);
                }
            }
            if (this.messagingServer == null || !this.messagingServer.isActive()) {
                logger.debug("ignoring message {} as the server is not initialized", (Object)notification);
                return;
            }
            long messageID = this.storageManager.generateID();
            CoreMessage notificationMessage = new CoreMessage(messageID, 512);
            notificationMessage.setDurable(true);
            notificationMessage.setAddress(this.managementNotificationAddress);
            if (notification.getProperties() != null) {
                TypedProperties props = notification.getProperties();
                props.forEach((arg_0, arg_1) -> ((Message)notificationMessage).putObjectProperty(arg_0, arg_1));
            }
            notificationMessage.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, SimpleString.of((String)notification.getType().toString()));
            long timestamp = System.currentTimeMillis();
            notificationMessage.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, timestamp);
            notificationMessage.setTimestamp(timestamp);
            this.postOffice.route((Message)notificationMessage, false);
        }
    }

    public void enableNotifications(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    @Override
    public Object getAttribute(String resourceName, String attribute, SecurityAuth auth) {
        try {
            Method method;
            Object resource = this.registry.get(resourceName);
            if (resource == null) {
                throw ActiveMQMessageBundle.BUNDLE.cannotFindResource(resourceName);
            }
            String upperCaseAttribute = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            try {
                method = resource.getClass().getMethod("get" + upperCaseAttribute, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = resource.getClass().getMethod("is" + upperCaseAttribute, new Class[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    throw ActiveMQMessageBundle.BUNDLE.noGetterMethod(attribute);
                }
            }
            String methodName = method.getName();
            this.securityCheck(resourceName + "." + methodName, this.permissionForInvoke(methodName), auth);
            return method.invoke(resource, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Problem while retrieving attribute " + attribute, t);
        }
    }

    @Override
    public Object invokeOperation(String resourceName, String operation, Object[] params, SecurityAuth auth) throws Exception {
        Method[] methods;
        Object resource = this.registry.get(resourceName);
        if (resource == null) {
            throw ActiveMQMessageBundle.BUNDLE.cannotFindResource(resourceName);
        }
        Method method = null;
        for (Method m : methods = resource.getClass().getMethods()) {
            if (!m.getName().equals(operation) || m.getParameterTypes().length != params.length) continue;
            boolean match = true;
            Class<?>[] paramTypes = m.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (params[i] == null) continue;
                params[i] = JsonUtil.convertJsonValue((Object)params[i], paramTypes[i]);
                if (paramTypes[i].isAssignableFrom(params[i].getClass()) || paramTypes[i] == Long.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Long.TYPE && params[i].getClass() == Long.class || paramTypes[i] == Double.TYPE && params[i].getClass() == Double.class || paramTypes[i] == Integer.TYPE && params[i].getClass() == Integer.class || paramTypes[i] == Boolean.TYPE && params[i].getClass() == Boolean.class || paramTypes[i] == Object[].class && params[i].getClass() == Object[].class) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw ActiveMQMessageBundle.BUNDLE.noOperation(operation, params.length);
        }
        String methodName = method.getName();
        this.securityCheck(resourceName + "." + methodName, this.permissionForInvoke(methodName), auth);
        return method.invoke(resource, params);
    }

    private Object getCorrelationIdentity(Message request) {
        Object correlationId = request.getCorrelationID();
        if (correlationId == null) {
            correlationId = String.valueOf(request.getStringProperty("NATIVE_MESSAGE_ID") != null ? request.getStringProperty("NATIVE_MESSAGE_ID") : request.getUserID());
        }
        return correlationId;
    }
}

