/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;

public class ReplicationBackupPolicy
implements HAPolicy<ReplicationBackupActivation> {
    private final ReplicationPrimaryPolicy primaryPolicy;
    private final String groupName;
    private final String clusterName;
    private final int maxSavedReplicatedJournalsSize;
    private final long retryReplicationWait;
    private final DistributedPrimitiveManagerConfiguration managerConfiguration;
    private final boolean tryFailback;

    private ReplicationBackupPolicy(ReplicationBackupPolicyConfiguration configuration, ReplicationPrimaryPolicy primaryPolicy) {
        Objects.requireNonNull(primaryPolicy);
        this.clusterName = configuration.getClusterName();
        this.maxSavedReplicatedJournalsSize = configuration.getMaxSavedReplicatedJournalsSize();
        this.groupName = configuration.getGroupName();
        this.retryReplicationWait = configuration.getRetryReplicationWait();
        this.managerConfiguration = configuration.getDistributedManagerConfiguration();
        this.tryFailback = true;
        this.primaryPolicy = primaryPolicy;
    }

    private ReplicationBackupPolicy(ReplicationBackupPolicyConfiguration configuration) {
        this.clusterName = configuration.getClusterName();
        this.maxSavedReplicatedJournalsSize = configuration.getMaxSavedReplicatedJournalsSize();
        this.groupName = configuration.getGroupName();
        this.retryReplicationWait = configuration.getRetryReplicationWait();
        this.managerConfiguration = configuration.getDistributedManagerConfiguration();
        this.tryFailback = false;
        this.primaryPolicy = ReplicationPrimaryPolicy.failoverPolicy(configuration.getInitialReplicationSyncTimeout(), configuration.getGroupName(), configuration.getClusterName(), this, configuration.isAllowFailBack(), configuration.getDistributedManagerConfiguration());
    }

    public boolean isTryFailback() {
        return this.tryFailback;
    }

    public static ReplicationBackupPolicy with(ReplicationBackupPolicyConfiguration configuration) {
        return new ReplicationBackupPolicy(configuration);
    }

    static ReplicationBackupPolicy failback(long retryReplicationWait, int maxSavedReplicatedJournalsSize, String clusterName, String groupName, ReplicationPrimaryPolicy primaryPolicy, DistributedPrimitiveManagerConfiguration distributedManagerConfiguration) {
        return new ReplicationBackupPolicy(ReplicationBackupPolicyConfiguration.withDefault().setRetryReplicationWait(retryReplicationWait).setMaxSavedReplicatedJournalsSize(maxSavedReplicatedJournalsSize).setClusterName(clusterName).setGroupName(groupName).setDistributedManagerConfiguration(distributedManagerConfiguration), primaryPolicy);
    }

    @Override
    public ReplicationBackupActivation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener shutdownOnCriticalIO) throws Exception {
        return new ReplicationBackupActivation(server, DistributedPrimitiveManager.newInstanceOf((String)this.managerConfiguration.getClassName(), this.managerConfiguration.getProperties()), this);
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ReplicationPrimaryPolicy getPrimaryPolicy() {
        return this.primaryPolicy;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    @Override
    public boolean useQuorumManager() {
        return false;
    }
}

