/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyLDAPSecuritySettingPlugin
implements SecuritySettingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 4793109879399750045L;
    public static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String CONNECTION_URL = "connectionURL";
    public static final String CONNECTION_USERNAME = "connectionUsername";
    public static final String CONNECTION_PASSWORD = "connectionPassword";
    public static final String CONNECTION_PROTOCOL = "connectionProtocol";
    public static final String AUTHENTICATION = "authentication";
    public static final String ROLE_ATTRIBUTE = "roleAttribute";
    public static final String FILTER = "filter";
    public static final String DESTINATION_BASE = "destinationBase";
    public static final String ADMIN_PERMISSION_VALUE = "adminPermissionValue";
    public static final String READ_PERMISSION_VALUE = "readPermissionValue";
    public static final String WRITE_PERMISSION_VALUE = "writePermissionValue";
    public static final String ENABLE_LISTENER = "enableListener";
    public static final String REFRESH_INTERVAL = "refreshInterval";
    public static final String MAP_ADMIN_TO_MANAGE = "mapAdminToManage";
    public static final String ALLOW_QUEUE_ADMIN_ON_READ = "allowQueueAdminOnRead";
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String connectionURL = "ldap://localhost:1024";
    private String connectionUsername;
    private String connectionPassword;
    private String connectionProtocol;
    private String authentication = "simple";
    private String destinationBase = "ou=destinations,o=ActiveMQ,ou=system";
    private String filter = "(cn=*)";
    private String roleAttribute = "uniqueMember";
    private String adminPermissionValue = "admin";
    private String readPermissionValue = "read";
    private String writePermissionValue = "write";
    private boolean enableListener = true;
    private int refreshInterval = 0;
    private boolean mapAdminToManage = false;
    private boolean allowQueueAdminOnRead = false;
    private DirContext context;
    private EventDirContext eventContext;
    private Map<String, Set<Role>> securityRoles;
    private HierarchicalRepository<Set<Role>> securityRepository;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduledFuture;

    @Override
    public LegacyLDAPSecuritySettingPlugin init(Map<String, String> options) {
        if (options != null) {
            this.initialContextFactory = this.getOption(options, INITIAL_CONTEXT_FACTORY, this.initialContextFactory);
            this.connectionURL = this.getOption(options, CONNECTION_URL, this.connectionURL);
            this.connectionUsername = this.getOption(options, CONNECTION_USERNAME, this.connectionUsername);
            this.connectionPassword = this.getOption(options, CONNECTION_PASSWORD, this.connectionPassword);
            this.connectionProtocol = this.getOption(options, CONNECTION_PROTOCOL, this.connectionProtocol);
            this.authentication = this.getOption(options, AUTHENTICATION, this.authentication);
            this.destinationBase = this.getOption(options, DESTINATION_BASE, this.destinationBase);
            this.filter = this.getOption(options, FILTER, this.filter);
            this.roleAttribute = this.getOption(options, ROLE_ATTRIBUTE, this.roleAttribute);
            this.adminPermissionValue = this.getOption(options, ADMIN_PERMISSION_VALUE, this.adminPermissionValue);
            this.readPermissionValue = this.getOption(options, READ_PERMISSION_VALUE, this.readPermissionValue);
            this.writePermissionValue = this.getOption(options, WRITE_PERMISSION_VALUE, this.writePermissionValue);
            this.enableListener = this.getOption(options, ENABLE_LISTENER, Boolean.TRUE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
            this.refreshInterval = Integer.parseInt(this.getOption(options, REFRESH_INTERVAL, Integer.valueOf(this.refreshInterval).toString()));
            this.mapAdminToManage = this.getOption(options, MAP_ADMIN_TO_MANAGE, Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
            this.allowQueueAdminOnRead = this.getOption(options, ALLOW_QUEUE_ADMIN_ON_READ, Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
        }
        if (this.refreshInterval > 0) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            logger.debug("Scheduling refresh every {} seconds.", (Object)this.refreshInterval);
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
                logger.debug("Refreshing after {} seconds...", (Object)this.refreshInterval);
                try {
                    this.securityRoles = null;
                    this.securityRepository.swap(this.getSecurityRoles().entrySet());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToRefreshSecuritySettings(e.getMessage());
                    logger.debug("security refresh failure", (Throwable)e);
                }
            }, this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
        }
        return this;
    }

    private String getOption(Map<String, String> options, String key, String defaultValue) {
        String result = options.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public SecuritySettingPlugin setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public LegacyLDAPSecuritySettingPlugin setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getDestinationBase() {
        return this.destinationBase;
    }

    public LegacyLDAPSecuritySettingPlugin setDestinationBase(String destinationBase) {
        this.destinationBase = destinationBase;
        return this;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public LegacyLDAPSecuritySettingPlugin setAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    public String getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionProtocol(String connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        return this;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
        return this;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getAdminPermissionValue() {
        return this.adminPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setAdminPermissionValue(String adminPermissionValue) {
        this.adminPermissionValue = adminPermissionValue;
        return this;
    }

    public String getReadPermissionValue() {
        return this.readPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setReadPermissionValue(String readPermissionValue) {
        this.readPermissionValue = readPermissionValue;
        return this;
    }

    public String getWritePermissionValue() {
        return this.writePermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setWritePermissionValue(String writePermissionValue) {
        this.writePermissionValue = writePermissionValue;
        return this;
    }

    public LegacyLDAPSecuritySettingPlugin setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
        return this;
    }

    public boolean isEnableListener() {
        return this.enableListener;
    }

    public LegacyLDAPSecuritySettingPlugin setEnableListener(boolean enableListener) {
        this.enableListener = enableListener;
        return this;
    }

    public boolean isMapAdminToManage() {
        return this.mapAdminToManage;
    }

    public LegacyLDAPSecuritySettingPlugin setMapAdminToManage(boolean mapAdminToManage) {
        this.mapAdminToManage = mapAdminToManage;
        return this;
    }

    public boolean isAllowQueueAdminOnRead() {
        return this.allowQueueAdminOnRead;
    }

    public LegacyLDAPSecuritySettingPlugin setAllowQueueAdminOnRead(boolean allowQueueAdminOnRead) {
        this.allowQueueAdminOnRead = allowQueueAdminOnRead;
        return this;
    }

    protected boolean isContextAlive() {
        boolean alive = false;
        if (this.context != null) {
            try {
                this.context.getAttributes("");
                alive = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return alive;
    }

    protected void open() throws NamingException {
        if (this.isContextAlive()) {
            return;
        }
        this.context = this.createContext();
        this.eventContext = (EventDirContext)this.context.lookup("");
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{this.roleAttribute});
        searchControls.setSearchScope(2);
        if (this.enableListener) {
            this.eventContext.addNamingListener(this.destinationBase, this.filter, searchControls, (NamingListener)new LDAPNamespaceChangeListener());
        }
    }

    private DirContext createContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.initialContextFactory);
        if (this.connectionUsername == null || "".equals(this.connectionUsername)) {
            throw new NamingException("Empty username is not allowed");
        }
        env.put("java.naming.security.principal", this.connectionUsername);
        if (this.connectionPassword == null || "".equals(this.connectionPassword)) {
            throw new NamingException("Empty password is not allowed");
        }
        env.put("java.naming.security.credentials", this.connectionPassword);
        env.put("java.naming.security.protocol", this.connectionProtocol);
        env.put("java.naming.provider.url", this.connectionURL);
        env.put("java.naming.security.authentication", this.authentication);
        return new InitialDirContext(env);
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        if (this.securityRoles == null) {
            this.populateSecurityRoles();
        }
        return this.securityRoles;
    }

    private LegacyLDAPSecuritySettingPlugin populateSecurityRoles() {
        ActiveMQServerLogger.LOGGER.populatingSecurityRolesFromLDAP(this.connectionURL);
        try {
            this.open();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorOpeningContextForLDAP(e);
            return this;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{this.roleAttribute});
        searchControls.setSearchScope(2);
        this.securityRoles = new HashMap<String, Set<Role>>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing LDAP search: {}\n\tfilter: {}\n\tcontrols:\n\t\treturningAttributes: {}\n\t\tsearchScope: SUBTREE_SCOPE", new Object[]{this.destinationBase, this.filter, this.roleAttribute});
            }
            NamingEnumeration<SearchResult> searchResults = this.context.search(this.destinationBase, this.filter, searchControls);
            while (searchResults.hasMore()) {
                this.processSearchResult(this.securityRoles, searchResults.next());
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorPopulatingSecurityRolesFromLDAP(e);
        }
        return this;
    }

    @Override
    public void setSecurityRepository(HierarchicalRepository<Set<Role>> securityRepository) {
        this.securityRepository = securityRepository;
    }

    private void processSearchResult(Map<String, Set<Role>> securityRoles, SearchResult searchResult) throws NamingException {
        StringBuilder logMessage;
        LdapName searchResultLdapName = new LdapName(searchResult.getName());
        Attributes attrs = searchResult.getAttributes();
        if (attrs == null || attrs.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping LDAP search result \"{}\" with {} attributes", (Object)searchResultLdapName, attrs == null ? "null" : Integer.valueOf(attrs.size()));
            }
            return;
        }
        List<Rdn> rdns = searchResultLdapName.getRdns();
        if (rdns.size() < 3) {
            if (logger.isDebugEnabled()) {
                logger.debug("\tSkipping LDAP search result \"{}\" with {} RDNs.", (Object)searchResultLdapName, (Object)rdns.size());
            }
            return;
        }
        boolean prepareDebugLog = logger.isDebugEnabled();
        StringBuilder stringBuilder = logMessage = prepareDebugLog ? new StringBuilder() : null;
        if (prepareDebugLog) {
            logMessage.append("LDAP search result: ").append(searchResultLdapName);
        }
        Rdn rdn = rdns.get(rdns.size() - 3);
        String rawDestinationType = rdn.getValue().toString();
        String destinationType = "unknown";
        if (rawDestinationType.toLowerCase().contains("queue")) {
            destinationType = "queue";
        } else if (rawDestinationType.toLowerCase().contains("topic")) {
            destinationType = "topic";
        }
        if (prepareDebugLog) {
            logMessage.append("\n\tDestination type: ").append(destinationType);
        }
        rdn = rdns.get(rdns.size() - 2);
        if (prepareDebugLog) {
            logMessage.append("\n\tDestination name: ").append(rdn.getValue());
        }
        String destination = rdn.getValue().toString();
        rdn = rdns.get(rdns.size() - 1);
        if (prepareDebugLog) {
            logMessage.append("\n\tPermission type: ").append(rdn.getValue());
        }
        String permissionType = rdn.getValue().toString();
        if (prepareDebugLog) {
            logMessage.append("\n\tAttributes: ").append(attrs);
        }
        Attribute attr = attrs.get(this.roleAttribute);
        NamingEnumeration<?> e = attr.getAll();
        Set<Role> roles = securityRoles.get(destination);
        boolean exists = false;
        if (roles == null) {
            roles = new HashSet<Role>();
        } else {
            exists = true;
        }
        while (e.hasMore()) {
            String value = (String)e.next();
            LdapName ldapname = new LdapName(value);
            rdn = ldapname.getRdn(ldapname.size() - 1);
            String roleName = rdn.getValue().toString();
            if (prepareDebugLog) {
                logMessage.append("\n\tRole name: ").append(roleName);
            }
            boolean write = permissionType.equalsIgnoreCase(this.writePermissionValue);
            boolean read = permissionType.equalsIgnoreCase(this.readPermissionValue);
            boolean admin = permissionType.equalsIgnoreCase(this.adminPermissionValue);
            Role existingRole = null;
            for (Role role : roles) {
                if (!role.getName().equals(roleName)) continue;
                existingRole = role;
            }
            Role newRole = new Role(roleName, write, read, this.allowQueueAdminOnRead && read || admin, this.allowQueueAdminOnRead && read || admin, this.allowQueueAdminOnRead && read || admin, admin, this.mapAdminToManage ? admin : false, read, admin, admin);
            if (existingRole != null) {
                existingRole.merge(newRole);
                continue;
            }
            roles.add(newRole);
        }
        if (prepareDebugLog) {
            logger.debug(String.valueOf(logMessage));
        }
        if (!exists) {
            securityRoles.put(destination, roles);
        }
    }

    @Override
    public SecuritySettingPlugin stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        try {
            this.eventContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this;
    }

    public void objectAdded(NamingEvent namingEvent) {
        logger.debug("objectAdded:\n\told binding: {}\n\tnew binding: {}", (Object)namingEvent.getOldBinding(), (Object)namingEvent.getNewBinding());
        HashMap<String, Set<Role>> newRoles = new HashMap<String, Set<Role>>();
        try {
            this.processSearchResult(newRoles, (SearchResult)namingEvent.getNewBinding());
            for (Map.Entry newRole : newRoles.entrySet()) {
                String newRoleKey = (String)newRole.getKey();
                Set newRoleValueSet = (Set)newRole.getValue();
                Set<Role> existingRoles = this.securityRepository.getMatch(newRoleKey);
                if (this.securityRepository.containsExactWildcardMatch(newRoleKey) || this.securityRepository.containsExactMatch(newRoleKey) && existingRoles != this.securityRepository.getDefault()) {
                    HashSet<Role> merged = new HashSet<Role>();
                    for (Role existingRole : existingRoles) {
                        for (Role role : newRoleValueSet) {
                            if (!existingRole.getName().equals(role.getName())) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("merging role {} with existing role {} at {}", new Object[]{role, existingRole, newRoleKey});
                            }
                            existingRole.merge(role);
                            merged.add(role);
                        }
                    }
                    for (Role role : newRoleValueSet) {
                        if (merged.contains(role)) continue;
                        logger.debug("add new role {} to existing roles {}", (Object)role, existingRoles);
                        existingRoles.add(role);
                    }
                    continue;
                }
                logger.debug("adding new match {}: {}", (Object)newRoleKey, (Object)newRoleValueSet);
                this.securityRepository.addMatch(newRoleKey, newRoleValueSet);
            }
        }
        catch (NamingException e) {
            ActiveMQServerLogger.LOGGER.failedToProcessEvent(e);
        }
    }

    public void objectRemoved(NamingEvent namingEvent) {
        block11: {
            logger.debug("objectRemoved:\n\told binding: {}\n\tnew binding: {}", (Object)namingEvent.getOldBinding(), (Object)namingEvent.getNewBinding());
            try {
                LdapName ldapName = new LdapName(namingEvent.getOldBinding().getName());
                List<Rdn> rdns = ldapName.getRdns();
                if (rdns.size() < 3) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Skipping old binding name \"{}\" with {} RDNs.", (Object)namingEvent.getOldBinding().getName(), (Object)rdns.size());
                    }
                    return;
                }
                String match = rdns.get(rdns.size() - 2).getValue().toString();
                logger.debug("Destination name: {}", (Object)match);
                if (match == null) break block11;
                Set<Role> roles = this.securityRepository.getMatch(match);
                ArrayList<Role> rolesToRemove = new ArrayList<Role>();
                for (Rdn rdn : ldapName.getRdns()) {
                    if (rdn.getValue().equals(this.writePermissionValue)) {
                        logger.debug("Removing write permission from {}", (Object)match);
                        for (Role role : roles) {
                            if (!role.isSend()) continue;
                            rolesToRemove.add(role);
                        }
                        continue;
                    }
                    if (rdn.getValue().equals(this.readPermissionValue)) {
                        logger.debug("Removing read permission from {}", (Object)match);
                        for (Role role : roles) {
                            if (!role.isConsume()) continue;
                            rolesToRemove.add(role);
                        }
                        continue;
                    }
                    if (!rdn.getValue().equals(this.adminPermissionValue)) continue;
                    logger.debug("Removing admin permission from {}", (Object)match);
                    for (Role role : roles) {
                        if (!role.isCreateDurableQueue() && !role.isCreateNonDurableQueue() && !role.isDeleteDurableQueue() && !role.isDeleteNonDurableQueue()) continue;
                        rolesToRemove.add(role);
                    }
                }
                if (roles.removeAll(rolesToRemove)) {
                    logger.debug("Removed roles: {}. Remaining roles: {}", rolesToRemove, roles);
                }
            }
            catch (NamingException e) {
                ActiveMQServerLogger.LOGGER.failedToProcessEvent(e);
            }
        }
    }

    public void objectRenamed(NamingEvent namingEvent) {
    }

    public void objectChanged(NamingEvent namingEvent) {
        logger.debug("objectChanged:\n\told binding: {}\n\tnew binding: {}", (Object)namingEvent.getOldBinding(), (Object)namingEvent.getNewBinding());
        this.objectRemoved(namingEvent);
        this.objectAdded(namingEvent);
    }

    public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
        this.context = null;
        ActiveMQServerLogger.LOGGER.caughtUnexpectedException(namingExceptionEvent.getException());
    }

    protected class LDAPNamespaceChangeListener
    implements NamespaceChangeListener,
    ObjectChangeListener {
        protected LDAPNamespaceChangeListener() {
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.namingExceptionThrown(evt);
        }

        @Override
        public void objectAdded(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectAdded(evt);
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectRemoved(evt);
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectRenamed(evt);
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectChanged(evt);
        }
    }
}

