/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQAlreadyReplicatingException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupTopologyListener;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.core.server.impl.ServerConnectVoteHandler;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.jboss.logging.Logger;

public class SharedNothingLiveActivation
extends LiveActivation {
    private static final Logger logger = Logger.getLogger(SharedNothingLiveActivation.class);
    private ReplicatedPolicy replicatedPolicy;
    private ActiveMQServerImpl activeMQServer;
    private ReplicationManager replicationManager;
    private final Object replicationLock = new Object();

    public SharedNothingLiveActivation(ActiveMQServerImpl activeMQServer, ReplicatedPolicy replicatedPolicy) {
        this.activeMQServer = activeMQServer;
        this.replicatedPolicy = replicatedPolicy;
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        ReplicationManager localReplicationManager = this.replicationManager;
        if (remotingService != null && localReplicationManager != null) {
            remotingService.freeze(null, localReplicationManager.getBackupTransportConnection());
        } else if (remotingService != null) {
            remotingService.freeze(null, null);
        }
    }

    public void freezeReplication() {
        this.replicationManager.getBackupTransportConnection().fail((ActiveMQException)new ActiveMQDisconnectedException());
    }

    @Override
    public void run() {
        try {
            if (this.replicatedPolicy.isCheckForLiveServer() && this.isNodeIdUsed()) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("@@@ setting up replicatedPolicy.getReplicaPolicy for back start, replicaPolicy::%s, isBackup=%s, server=%s", (Object)this.replicatedPolicy.getReplicaPolicy(), (Object)this.replicatedPolicy.isBackup(), (Object)this.activeMQServer);
                }
                this.replicatedPolicy.getReplicaPolicy().setReplicatedPolicy(this.replicatedPolicy);
                this.activeMQServer.setHAPolicy(this.replicatedPolicy.getReplicaPolicy());
                return;
            }
            logger.trace((Object)"@@@ did not do it now");
            this.activeMQServer.initialisePart1(false);
            this.activeMQServer.getClusterManager().getQuorumManager().registerQuorumHandler(new ServerConnectVoteHandler(this.activeMQServer));
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation(true);
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsLive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    @Override
    public ChannelHandler getActivationChannelHandler(final Channel channel, final Acceptor acceptorUsed) {
        return new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 115) {
                    BackupRegistrationMessage msg = (BackupRegistrationMessage)packet;
                    ClusterConnection clusterConnection = acceptorUsed.getClusterConnection();
                    try {
                        SharedNothingLiveActivation.this.startReplication(channel.getConnection(), clusterConnection, SharedNothingLiveActivation.this.getPair(msg.getConnector(), true), msg.isFailBackRequest());
                    }
                    catch (ActiveMQAlreadyReplicatingException are) {
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.ALREADY_REPLICATING));
                    }
                    catch (ActiveMQException e) {
                        logger.debug((Object)"Failed to process backup registration packet", (Throwable)e);
                        channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.EXCEPTION));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplication(CoreRemotingConnection rc, final ClusterConnection clusterConnection, final Pair<TransportConfiguration, TransportConfiguration> pair, final boolean isFailBackRequest) throws ActiveMQException {
        if (this.replicationManager != null) {
            throw new ActiveMQAlreadyReplicatingException();
        }
        if (!this.activeMQServer.isStarted()) {
            throw new ActiveMQIllegalStateException();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.replicationManager != null) {
                throw new ActiveMQAlreadyReplicatingException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            rc.addCloseListener((CloseListener)listener);
            rc.addFailureListener((FailureListener)listener);
            this.replicationManager = new ReplicationManager(this.activeMQServer, rc, clusterConnection.getCallTimeout(), this.replicatedPolicy.getInitialReplicationSyncTimeout(), this.activeMQServer.getIOExecutorFactory());
            this.replicationManager.start();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SharedNothingLiveActivation.this.activeMQServer.getStorageManager().startReplication(SharedNothingLiveActivation.this.replicationManager, SharedNothingLiveActivation.this.activeMQServer.getPagingManager(), SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), isFailBackRequest && SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack(), SharedNothingLiveActivation.this.replicatedPolicy.getInitialReplicationSyncTimeout());
                        clusterConnection.nodeAnnounced(System.currentTimeMillis(), SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), SharedNothingLiveActivation.this.replicatedPolicy.getGroupName(), SharedNothingLiveActivation.this.replicatedPolicy.getScaleDownGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)pair, true);
                        if (isFailBackRequest && SharedNothingLiveActivation.this.replicatedPolicy.isAllowAutoFailBack()) {
                            BackupTopologyListener listener1 = new BackupTopologyListener(SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), clusterConnection.getConnector());
                            clusterConnection.addClusterTopologyListener(listener1);
                            if (listener1.waitForBackup()) {
                                SharedNothingLiveActivation.this.activeMQServer.fail(true);
                                ActiveMQServerLogger.LOGGER.restartingReplicatedBackupAfterFailback();
                                SharedNothingLiveActivation.this.activeMQServer.setHAPolicy(SharedNothingLiveActivation.this.replicatedPolicy.getReplicaPolicy());
                                SharedNothingLiveActivation.this.activeMQServer.start();
                            } else {
                                ActiveMQServerLogger.LOGGER.failbackMissedBackupAnnouncement();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (SharedNothingLiveActivation.this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STARTED) {
                            ActiveMQServerLogger.LOGGER.errorStartingReplication(e);
                        }
                        try {
                            ActiveMQServerImpl.stopComponent(SharedNothingLiveActivation.this.replicationManager);
                        }
                        catch (Exception amqe) {
                            ActiveMQServerLogger.LOGGER.errorStoppingReplication(amqe);
                        }
                        finally {
                            Object object = SharedNothingLiveActivation.this.replicationLock;
                            synchronized (object) {
                                SharedNothingLiveActivation.this.replicationManager = null;
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    private static TransportConfiguration getLiveConnector(Configuration configuration) {
        String connectorName = configuration.getClusterConfigurations().get(0).getConnectorName();
        TransportConfiguration transportConfiguration = configuration.getConnectorConfigurations().get(connectorName);
        assert (transportConfiguration != null);
        return transportConfiguration;
    }

    private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
        if (isBackup) {
            return new Pair(null, (Object)conn);
        }
        return new Pair((Object)conn, null);
    }

    private boolean isNodeIdUsed() throws Exception {
        SimpleString nodeId0;
        if (this.activeMQServer.getConfiguration().getClusterConfigurations().isEmpty()) {
            return false;
        }
        try {
            nodeId0 = this.activeMQServer.getNodeManager().readNodeId();
        }
        catch (NodeManager.NodeManagerException e) {
            nodeId0 = null;
        }
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.activeMQServer.getConfiguration(), this.replicatedPolicy.getClusterName());
        NodeIdListener listener = new NodeIdListener(nodeId0, this.activeMQServer.getConfiguration().getClusterUser(), this.activeMQServer.getConfiguration().getClusterPassword());
        ServerLocatorInternal locator = this.getLocator(config);
        try {
            locator.addClusterTopologyListener((ClusterTopologyListener)listener);
            locator.setReconnectAttempts(0);
            try (ClientSessionFactoryInternal factory = locator.connectNoWarnings();){
                listener.latch.await(5L, TimeUnit.SECONDS);
            }
            catch (Exception notConnected) {
                if (!(notConnected instanceof ActiveMQException) || ActiveMQExceptionType.INTERNAL_ERROR.equals((Object)((ActiveMQException)((Object)notConnected)).getType())) {
                    ActiveMQServerLogger.LOGGER.failedConnectingToCluster(notConnected);
                }
                boolean bl = false;
                if (locator != null) {
                    locator.close();
                }
                return bl;
            }
            boolean bl = listener.isNodePresent;
            return bl;
        }
        finally {
            if (locator != null) {
                try {
                    locator.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        this.replicationManager = null;
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            if (permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public void sendLiveIsStopping() {
        final ReplicationManager localReplicationManager = this.replicationManager;
        if (localReplicationManager != null) {
            localReplicationManager.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED);
            this.activeMQServer.getScheduledPool().schedule(new Runnable(){

                @Override
                public void run() {
                    localReplicationManager.clearReplicationTokens();
                }
            }, 30L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager getReplicationManager() {
        Object object = this.replicationLock;
        synchronized (object) {
            return this.replicationManager;
        }
    }

    private ServerLocatorInternal getLocator(ClusterConnectionConfiguration config) throws ActiveMQException {
        ServerLocatorInternal locator;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.activeMQServer.getConfiguration().getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                throw ActiveMQMessageBundle.BUNDLE.noDiscoveryGroupFound(dg);
            }
            locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        } else {
            TransportConfiguration[] tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        }
        return locator;
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        return this.activeMQServer.getConfiguration().getTransportConfigurations(connectorNames);
    }

    @Override
    public boolean isReplicaSync() {
        ReplicationManager replicationManager = this.getReplicationManager();
        if (replicationManager == null) {
            return false;
        }
        return !replicationManager.isSynchronizing();
    }

    static final class NodeIdListener
    implements ClusterTopologyListener {
        volatile boolean isNodePresent = false;
        private final SimpleString nodeId;
        private final String user;
        private final String password;
        private final CountDownLatch latch = new CountDownLatch(1);

        NodeIdListener(SimpleString nodeId, String user, String password) {
            this.nodeId = nodeId;
            this.user = user;
            this.password = password;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            boolean isOurNodeId;
            boolean bl = isOurNodeId = this.nodeId != null && this.nodeId.toString().equals(topologyMember.getNodeId());
            if (isOurNodeId && this.isActive(topologyMember.getLive())) {
                this.isNodePresent = true;
            }
            if (isOurNodeId || last) {
                this.latch.countDown();
            }
        }

        private boolean isActive(TransportConfiguration transportConfiguration) {
            boolean result;
            block20: {
                result = false;
                try (ServerLocator serverLocator = ActiveMQClient.createServerLocator((boolean)false, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
                     ClientSessionFactory clientSessionFactory = serverLocator.createSessionFactory();
                     ClientSession clientSession = clientSessionFactory.createSession(this.user, this.password, false, false, false, false, 0);){
                    result = true;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Object)"isActive check failed", (Throwable)e);
                }
            }
            return result;
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            this.handleClose(true);
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void connectionClosed() {
            this.handleClose(false);
        }

        private void handleClose(final boolean failed) {
            ExecutorService executorService = SharedNothingLiveActivation.this.activeMQServer.getThreadPool();
            if (executorService != null) {
                executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SharedNothingLiveActivation.this.replicationLock;
                        synchronized (object) {
                            if (SharedNothingLiveActivation.this.replicationManager != null) {
                                QuorumManager quorumManager;
                                boolean isStillLive;
                                SharedNothingLiveActivation.this.activeMQServer.getStorageManager().stopReplication();
                                SharedNothingLiveActivation.this.replicationManager = null;
                                if (failed && SharedNothingLiveActivation.this.replicatedPolicy.isVoteOnReplicationFailure() && !(isStillLive = (quorumManager = SharedNothingLiveActivation.this.activeMQServer.getClusterManager().getQuorumManager()).isStillLive(SharedNothingLiveActivation.this.activeMQServer.getNodeID().toString(), SharedNothingLiveActivation.getLiveConnector(SharedNothingLiveActivation.this.activeMQServer.getConfiguration()), SharedNothingLiveActivation.this.replicatedPolicy.getQuorumSize(), 5, TimeUnit.SECONDS))) {
                                    try {
                                        Thread startThread = new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    if (logger.isTraceEnabled()) {
                                                        logger.trace((Object)"Calling activeMQServer.stop() to stop the server");
                                                    }
                                                    SharedNothingLiveActivation.this.activeMQServer.stop();
                                                }
                                                catch (Exception e) {
                                                    ActiveMQServerLogger.LOGGER.errorRestartingBackupServer(e, SharedNothingLiveActivation.this.activeMQServer);
                                                }
                                            }
                                        });
                                        startThread.start();
                                        startThread.join();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

