package org.apache.activemq.artemis.core.server;

import java.util.Locale;
import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import java.lang.String;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidQueueConfiguration;
import java.lang.IllegalArgumentException;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQRedirectedException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import java.lang.Long;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import java.io.File;
import java.lang.IllegalStateException;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import java.lang.Number;
import org.apache.activemq.artemis.api.core.ActiveMQUnexpectedRoutingTypeForAddress;
import java.lang.ThreadGroup;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.RoutingType;
import javax.annotation.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException;
import java.lang.Exception;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import java.lang.Thread;
import java.lang.Integer;
import org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage.FileType;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.core.server.JournalType;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-01-26T12:23:49-0500")
public class ActiveMQMessageBundle_$bundle implements ActiveMQMessageBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQMessageBundle_$bundle() {}
    public static final ActiveMQMessageBundle_$bundle INSTANCE = new ActiveMQMessageBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String activationForServer$str() {
        return "AMQ229000: Activation for server {0}";
    }
    @Override
    public final String activationForServer(final org.apache.activemq.artemis.core.server.ActiveMQServer server) {
        return _formatMessage(activationForServer$str(), server);
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String generatingThreadDump$str() {
        return "AMQ229001: Generating thread dump";
    }
    @Override
    public final String generatingThreadDump() {
        return generatingThreadDump$str();
    }
    protected String threadDump$str() {
        return "AMQ229002: Thread {0} name = {1} id = {2} group = {3}";
    }
    @Override
    public final String threadDump(final Thread key, final String name, final Long id, final ThreadGroup threadGroup) {
        return _formatMessage(threadDump$str(), key, name, id, threadGroup);
    }
    protected String endThreadDump$str() {
        return "AMQ229003: End Thread dump";
    }
    @Override
    public final String endThreadDump() {
        return String.format(getLoggingLocale(), endThreadDump$str());
    }
    protected String serverDescribe$str() {
        return "AMQ229004: Information about server {0}\nCluster Connection:{1}";
    }
    @Override
    public final String serverDescribe(final String identity, final String describe) {
        return _formatMessage(serverDescribe$str(), identity, describe);
    }
    protected String connectionsClosedByManagement$str() {
        return "AMQ229005: connections for {0} closed by management";
    }
    @Override
    public final ActiveMQInternalErrorException connectionsClosedByManagement(final String ipAddress) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(connectionsClosedByManagement$str(), ipAddress));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String notJournalImpl$str() {
        return "AMQ229006: journals are not JournalImpl. You can''t set a replicator!";
    }
    @Override
    public final ActiveMQInternalErrorException notJournalImpl() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), notJournalImpl$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationUnhandledError$str() {
        return "AMQ229007: unhandled error during replication";
    }
    @Override
    public final ActiveMQInternalErrorException replicationUnhandledError(final Exception e) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), replicationUnhandledError$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationTooManyJournals$str() {
        return "AMQ229008: Live Node contains more journals than the backup node. Probably a version match error";
    }
    @Override
    public final ActiveMQInternalErrorException replicationTooManyJournals() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), replicationTooManyJournals$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationUnhandledFileType$str() {
        return "AMQ229009: Unhandled file type {0}";
    }
    @Override
    public final ActiveMQInternalErrorException replicationUnhandledFileType(final FileType fileType) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(replicationUnhandledFileType$str(), fileType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationBackupUpToDate$str() {
        return "AMQ229010: Remote Backup can not be up-to-date!";
    }
    @Override
    public final ActiveMQInternalErrorException replicationBackupUpToDate() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), replicationBackupUpToDate$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationUnhandledDataType$str() {
        return "AMQ229011: unhandled data type!";
    }
    @Override
    public final ActiveMQInternalErrorException replicationUnhandledDataType() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), replicationUnhandledDataType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noBindingForDivert$str() {
        return "AMQ229012: No binding for divert {0}";
    }
    @Override
    public final ActiveMQInternalErrorException noBindingForDivert(final SimpleString name) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(noBindingForDivert$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bindingNotDivert$str() {
        return "AMQ229013: Binding {0} is not a divert";
    }
    @Override
    public final ActiveMQInternalErrorException bindingNotDivert(final SimpleString name) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(bindingNotDivert$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientExited$str() {
        return "AMQ229014: Did not receive data from {0} within the {1}ms connection TTL. The connection will now be closed.";
    }
    @Override
    public final ActiveMQConnectionTimedOutException clientExited(final String remoteAddress, final long ttl) {
        final ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(_formatMessage(clientExited$str(), remoteAddress, ttl));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String divertWithNoName$str() {
        return "AMQ229015: Must specify a name for each divert. This one will not be deployed.";
    }
    @Override
    public final ActiveMQInternalErrorException divertWithNoName() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(divertWithNoName$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchQueue$str() {
        return "AMQ229017: Queue {0} does not exist";
    }
    @Override
    public final ActiveMQNonExistentQueueException noSuchQueue(final SimpleString queueName) {
        final ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(_formatMessage(noSuchQueue$str(), queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bindingAlreadyExists1$str() {
        return "AMQ229018: Binding already exists {0}";
    }
    @Override
    public final ActiveMQQueueExistsException bindingAlreadyExists(final Binding binding) {
        final ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(_formatMessage(bindingAlreadyExists1$str(), binding));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueAlreadyExists$str() {
        return "AMQ229019: Queue {0} already exists on address {1}";
    }
    @Override
    public final ActiveMQQueueExistsException queueAlreadyExists(final SimpleString queueName, final SimpleString addressName) {
        final ActiveMQQueueExistsException result = new ActiveMQQueueExistsException(_formatMessage(queueAlreadyExists$str(), queueName, addressName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFilter$str() {
        return "AMQ229020: Invalid filter: {0}";
    }
    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(final Throwable e, final SimpleString filter) {
        final ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(_formatMessage(invalidFilter$str(), filter));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageIdNotAssigned$str() {
        return "AMQ229021: MessageId was not assigned to Message";
    }
    @Override
    public final ActiveMQIllegalStateException messageIdNotAssigned() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), messageIdNotAssigned$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String journalsNotInSync$str() {
        return "AMQ229022: Cannot compare journals if not in sync!";
    }
    @Override
    public final ActiveMQIllegalStateException journalsNotInSync() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), journalsNotInSync$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverNotBackupServer$str() {
        return "AMQ229023: Connected server is not a backup server";
    }
    @Override
    public final ActiveMQIllegalStateException serverNotBackupServer() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), serverNotBackupServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alreadyHaveReplicationServer$str() {
        return "AMQ229024: Backup replication server is already connected to another server";
    }
    @Override
    public final ActiveMQIllegalStateException alreadyHaveReplicationServer() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), alreadyHaveReplicationServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDeleteQueueWithConsumers$str() {
        return "AMQ229025: Cannot delete queue {0} on binding {1} - it has consumers = {2}";
    }
    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueueWithConsumers(final SimpleString name, final SimpleString queueName, final String s) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(cannotDeleteQueueWithConsumers$str(), name, queueName, s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupServerNotInSync$str() {
        return "AMQ229026: Backup Server was not yet in sync with live";
    }
    @Override
    public final ActiveMQIllegalStateException backupServerNotInSync() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), backupServerNotInSync$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String consumerNoReference$str() {
        return "AMQ229027: Could not find reference on consumer ID={0}, messageId = {1} queue = {2}";
    }
    @Override
    public final ActiveMQIllegalStateException consumerNoReference(final Long id, final Long messageID, final SimpleString name) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(consumerNoReference$str(), id, messageID, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String consumerDoesntExist$str() {
        return "AMQ229028: Consumer {0} doesn''t exist on the server";
    }
    @Override
    public final ActiveMQIllegalStateException consumerDoesntExist(final long consumerID) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(consumerDoesntExist$str(), consumerID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAddress$str() {
        return "AMQ229029: No address configured on the Server''s Session";
    }
    @Override
    public final ActiveMQIllegalStateException noAddress() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), noAddress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String largeMessageNotInitialised$str() {
        return "AMQ229030: large-message not initialized on server";
    }
    @Override
    public final ActiveMQIllegalStateException largeMessageNotInitialised() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), largeMessageNotInitialised$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToValidateUser$str() {
        return "AMQ229031: Unable to validate user from {0}. Username: {1}; SSL certificate subject DN: {2}";
    }
    @Override
    public final ActiveMQSecurityException unableToValidateUser(final String remoteAddress, final String user, final String certMessage) {
        final ActiveMQSecurityException result = new ActiveMQSecurityException(_formatMessage(unableToValidateUser$str(), remoteAddress, user, certMessage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userNoPermissions$str() {
        return "AMQ229032: User: {0} does not have permission=''{1}'' on address {2}";
    }
    @Override
    public final ActiveMQSecurityException userNoPermissions(final String username, final CheckType checkType, final SimpleString address) {
        final ActiveMQSecurityException result = new ActiveMQSecurityException(_formatMessage(userNoPermissions$str(), username, checkType, address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleClientServer$str() {
        return "AMQ229033: Server and client versions incompatible";
    }
    @Override
    public final ActiveMQIncompatibleClientServerException incompatibleClientServer() {
        final ActiveMQIncompatibleClientServerException result = new ActiveMQIncompatibleClientServerException(String.format(getLoggingLocale(), incompatibleClientServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverNotStarted$str() {
        return "AMQ229034: Server not started";
    }
    @Override
    public final ActiveMQSessionCreationException serverNotStarted() {
        final ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(String.format(getLoggingLocale(), serverNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateMetadata$str() {
        return "AMQ229035: Metadata {0}={1} had been set already";
    }
    @Override
    public final ActiveMQDuplicateMetaDataException duplicateMetadata(final String key, final String data) {
        final ActiveMQDuplicateMetaDataException result = new ActiveMQDuplicateMetaDataException(_formatMessage(duplicateMetadata$str(), key, data));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidType$str() {
        return "AMQ229036: Invalid type: {0}";
    }
    @Override
    public final IllegalArgumentException invalidType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyOrNull$str() {
        return "AMQ229038: {0} must neither be null nor empty";
    }
    @Override
    public final IllegalArgumentException emptyOrNull(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(emptyOrNull$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanZero2$str() {
        return "AMQ229039: {0}  must be greater than 0 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException greaterThanZero(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(greaterThanZero2$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notPercent$str() {
        return "AMQ229040: {0} must be a valid percentual value between 0 and 100 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException notPercent(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(notPercent$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanMinusOne$str() {
        return "AMQ229041: {0}  must be equals to -1 or greater than 0 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException greaterThanMinusOne(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(greaterThanMinusOne$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanZeroOrMinusOne$str() {
        return "AMQ229042: {0}  must be equals to -1 or greater or equals to 0 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException greaterThanZeroOrMinusOne(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(greaterThanZeroOrMinusOne$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustbeBetween$str() {
        return "AMQ229043: {0} must be between {1} and {2} inclusive (actual value: {3})";
    }
    @Override
    public final IllegalArgumentException mustbeBetween(final String name, final Integer minPriority, final Integer maxPriority, final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(mustbeBetween$str(), name, minPriority, maxPriority, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJournalType$str() {
        return "AMQ229044: Invalid journal type {0}";
    }
    @Override
    public final IllegalArgumentException invalidJournalType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidJournalType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAddressFullPolicyType$str() {
        return "AMQ229045: Invalid address full message policy type {0}";
    }
    @Override
    public final IllegalArgumentException invalidAddressFullPolicyType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidAddressFullPolicyType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String greaterThanZero1$str() {
        return "AMQ229046: invalid value: {0} count must be greater than 0";
    }
    @Override
    public final IllegalArgumentException greaterThanZero(final Integer count) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(greaterThanZero1$str(), count));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String periodMustGreaterThanZero$str() {
        return "AMQ229047: invalid value: {0} sample period must be greater than 0";
    }
    @Override
    public final IllegalArgumentException periodMustGreaterThanZero(final Long newPeriod) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(periodMustGreaterThanZero$str(), newPeriod));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNewPriority$str() {
        return "AMQ229048: invalid new Priority value: {0}. It must be between 0 and 9 (both included)";
    }
    @Override
    public final IllegalArgumentException invalidNewPriority(final Integer period) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidNewPriority$str(), period));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noQueueFound$str() {
        return "AMQ229049: No queue found for {0}";
    }
    @Override
    public final IllegalArgumentException noQueueFound(final String otherQueueName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noQueueFound$str(), otherQueueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJournal$str() {
        return "AMQ229050: Only NIO and AsyncIO are supported journals";
    }
    @Override
    public final IllegalArgumentException invalidJournal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidJournal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJournalType2$str() {
        return "AMQ229051: Invalid journal type {0}";
    }
    @Override
    public final IllegalArgumentException invalidJournalType2(final org.apache.activemq.artemis.core.server.JournalType journalType) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidJournalType2$str(), journalType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateDir$str() {
        return "AMQ229052: Directory {0} does not exist and cannot be created";
    }
    @Override
    public final IllegalArgumentException cannotCreateDir(final String dir) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotCreateDir$str(), dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertToInt$str() {
        return "AMQ229054: Cannot convert to int";
    }
    @Override
    public final IllegalArgumentException cannotConvertToInt() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotConvertToInt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String routeNameIsNull$str() {
        return "AMQ229055: Routing name is null";
    }
    @Override
    public final IllegalArgumentException routeNameIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), routeNameIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clusterNameIsNull$str() {
        return "AMQ229056: Cluster name is null";
    }
    @Override
    public final IllegalArgumentException clusterNameIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), clusterNameIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressIsNull$str() {
        return "AMQ229057: Address is null";
    }
    @Override
    public final IllegalArgumentException addressIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), addressIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bindingTypeNotSpecified$str() {
        return "AMQ229058: Binding type not specified";
    }
    @Override
    public final IllegalArgumentException bindingTypeNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bindingTypeNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bindingIdNotSpecified$str() {
        return "AMQ229059: Binding ID is null";
    }
    @Override
    public final IllegalArgumentException bindingIdNotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bindingIdNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String distancenotSpecified$str() {
        return "AMQ229060: Distance is null";
    }
    @Override
    public final IllegalArgumentException distancenotSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), distancenotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionExists$str() {
        return "AMQ229061: Connection already exists with id {0}";
    }
    @Override
    public final IllegalArgumentException connectionExists(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(connectionExists$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String acceptorExists$str() {
        return "AMQ229062: Acceptor with id {0} already registered";
    }
    @Override
    public final IllegalArgumentException acceptorExists(final Integer id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(acceptorExists$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String acceptorNotExists$str() {
        return "AMQ229063: Acceptor with id {0} not registered";
    }
    @Override
    public final IllegalArgumentException acceptorNotExists(final Integer id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(acceptorNotExists$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownProtocol$str() {
        return "AMQ229064: Unknown protocol {0}";
    }
    @Override
    public final IllegalArgumentException unknownProtocol(final String protocol) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(unknownProtocol$str(), protocol));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeIdNull$str() {
        return "AMQ229065: node id is null";
    }
    @Override
    public final IllegalArgumentException nodeIdNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nodeIdNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueNameIsNull$str() {
        return "AMQ229066: Queue name is null";
    }
    @Override
    public final IllegalArgumentException queueNameIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), queueNameIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindResource$str() {
        return "AMQ229067: Cannot find resource with name {0}";
    }
    @Override
    public final IllegalArgumentException cannotFindResource(final String resourceName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(cannotFindResource$str(), resourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noGetterMethod$str() {
        return "AMQ229068: no getter method for {0}";
    }
    @Override
    public final IllegalArgumentException noGetterMethod(final String resourceName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noGetterMethod$str(), resourceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noOperation$str() {
        return "AMQ229069: no operation {0}/{1}";
    }
    @Override
    public final IllegalArgumentException noOperation(final String operation, final Integer length) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noOperation$str(), operation, length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullMatch$str() {
        return "AMQ229070: match can not be null";
    }
    @Override
    public final IllegalArgumentException nullMatch() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMatch$str() {
        return "AMQ229071: # can only be at end of match";
    }
    @Override
    public final IllegalArgumentException invalidMatch() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullUser$str() {
        return "AMQ229072: User cannot be null";
    }
    @Override
    public final IllegalArgumentException nullUser() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullUser$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullPassword$str() {
        return "AMQ229073: Password cannot be null";
    }
    @Override
    public final IllegalArgumentException nullPassword() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullPassword$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingTransformerClass$str() {
        return "AMQ229074: Error instantiating transformer class {0}";
    }
    @Override
    public final IllegalArgumentException errorCreatingTransformerClass(final Exception e, final String transformerClassName) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(errorCreatingTransformerClass$str(), transformerClassName), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String autoConvertError$str() {
        return "AMQ229075: method autoEncode doesn''t know how to convert {0} yet";
    }
    @Override
    public final IllegalArgumentException autoConvertError(final Class<?> aClass) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(autoConvertError$str(), aClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String destroyConnectionWithSessionMetadataHeader$str() {
        return "AMQ229076: Executing destroyConnection with {0}={1} through management''s request";
    }
    @Override
    public final String destroyConnectionWithSessionMetadataHeader(final String key, final String value) {
        return _formatMessage(destroyConnectionWithSessionMetadataHeader$str(), key, value);
    }
    protected String destroyConnectionWithSessionMetadataClosingConnection$str() {
        return "AMQ229077: Closing connection {0}";
    }
    @Override
    public final String destroyConnectionWithSessionMetadataClosingConnection(final String serverSessionString) {
        return _formatMessage(destroyConnectionWithSessionMetadataClosingConnection$str(), serverSessionString);
    }
    protected String destroyConnectionWithSessionMetadataSendException$str() {
        return "AMQ229078: Disconnected per admin''s request on {0}={1}";
    }
    @Override
    public final ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(final String key, final String value) {
        final ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(_formatMessage(destroyConnectionWithSessionMetadataSendException$str(), key, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String destroyConnectionWithSessionMetadataNoSessionFound$str() {
        return "AMQ229079: No session found with {0}={1}";
    }
    @Override
    public final String destroyConnectionWithSessionMetadataNoSessionFound(final String key, final String value) {
        return _formatMessage(destroyConnectionWithSessionMetadataNoSessionFound$str(), key, value);
    }
    protected String invalidPageIO$str() {
        return "AMQ229080: Invalid Page IO, PagingManager was stopped or closed";
    }
    @Override
    public final ActiveMQIllegalStateException invalidPageIO() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), invalidPageIO$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDiscoveryGroupFound$str() {
        return "AMQ229081: No Discovery Group configuration named {0} found";
    }
    @Override
    public final ActiveMQException noDiscoveryGroupFound(final DiscoveryGroupConfiguration dg) {
        final ActiveMQException result = new ActiveMQException(_formatMessage(noDiscoveryGroupFound$str(), dg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueSubscriptionBelongsToDifferentAddress$str() {
        return "AMQ229082: Queue {0} already exists on another subscription";
    }
    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(final SimpleString queueName) {
        final ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(_formatMessage(queueSubscriptionBelongsToDifferentAddress$str(), queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueSubscriptionBelongsToDifferentFilter$str() {
        return "AMQ229083: Queue {0} has a different filter than requested";
    }
    @Override
    public final ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(final SimpleString queueName) {
        final ActiveMQInvalidTransientQueueUseException result = new ActiveMQInvalidTransientQueueUseException(_formatMessage(queueSubscriptionBelongsToDifferentFilter$str(), queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToValidateClusterUser$str() {
        return "AMQ229099: Unable to authenticate cluster user: {0}";
    }
    @Override
    public final ActiveMQClusterSecurityException unableToValidateClusterUser(final String user) {
        final ActiveMQClusterSecurityException result = new ActiveMQClusterSecurityException(_formatMessage(unableToValidateClusterUser$str(), user));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String journalDirIsFile$str() {
        return "AMQ229100: Trying to move a journal file that refers to a file instead of a directory: {0}";
    }
    @Override
    public final IllegalStateException journalDirIsFile(final File fDir) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(journalDirIsFile$str(), fDir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotMoveJournal$str() {
        return "AMQ229101: error trying to backup journal files at directory: {0}";
    }
    @Override
    public final IllegalStateException couldNotMoveJournal(final File dir) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(couldNotMoveJournal$str(), dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressIsFull$str() {
        return "AMQ229102: Address \"{0}\" is full.";
    }
    @Override
    public final ActiveMQAddressFullException addressIsFull(final String addressName) {
        final ActiveMQAddressFullException result = new ActiveMQAddressFullException(_formatMessage(addressIsFull$str(), addressName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfigurationFoundForScaleDown$str() {
        return "AMQ229103: No Connectors or Discovery Groups configured for Scale Down";
    }
    @Override
    public final ActiveMQException noConfigurationFoundForScaleDown() {
        final ActiveMQException result = new ActiveMQException(String.format(getLoggingLocale(), noConfigurationFoundForScaleDown$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupWhileStopping$str() {
        return "AMQ229104: Server is stopping. Message grouping not allowed";
    }
    @Override
    public final ActiveMQException groupWhileStopping() {
        final ActiveMQException result = new ActiveMQException(String.format(getLoggingLocale(), groupWhileStopping$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSlowConsumerPolicyType$str() {
        return "AMQ229106: Invalid slow consumer policy type {0}";
    }
    @Override
    public final IllegalArgumentException invalidSlowConsumerPolicyType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidSlowConsumerPolicyType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String consumerConnectionsClosedByManagement$str() {
        return "AMQ229107: consumer connections for address {0} closed by management";
    }
    @Override
    public final ActiveMQInternalErrorException consumerConnectionsClosedByManagement(final String address) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(consumerConnectionsClosedByManagement$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionsForUserClosedByManagement$str() {
        return "AMQ229108: connections for user {0} closed by management";
    }
    @Override
    public final ActiveMQInternalErrorException connectionsForUserClosedByManagement(final String userName) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(connectionsForUserClosedByManagement$str(), userName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedHAPolicyConfiguration$str() {
        return "AMQ229109: unsupported HA Policy Configuration {0}";
    }
    @Override
    public final ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(final Object o) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(unsupportedHAPolicyConfiguration$str(), o));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionLimitReached$str() {
        return "AMQ229110: Too many sessions for user ''{0}''. Sessions allowed: {1}.";
    }
    @Override
    public final ActiveMQSessionCreationException sessionLimitReached(final String username, final int limit) {
        final ActiveMQSessionCreationException result = new ActiveMQSessionCreationException(_formatMessage(sessionLimitReached$str(), username, limit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueLimitReached$str() {
        return "AMQ229111: Too many queues created by user ''{0}''. Queues allowed: {1}.";
    }
    @Override
    public final ActiveMQSecurityException queueLimitReached(final String username, final int limit) {
        final ActiveMQSecurityException result = new ActiveMQSecurityException(_formatMessage(queueLimitReached$str(), username, limit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetMBeanserver$str() {
        return "AMQ229112: Cannot set MBeanServer during startup or while started";
    }
    @Override
    public final IllegalStateException cannotSetMBeanserver() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSetMBeanserver$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMessageLoadBalancingType$str() {
        return "AMQ229113: Invalid message load balancing type {0}";
    }
    @Override
    public final IllegalArgumentException invalidMessageLoadBalancingType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidMessageLoadBalancingType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicationSynchronizationTimeout$str() {
        return "AMQ229114: Replication synchronization process timed out after waiting {0} milliseconds";
    }
    @Override
    public final ActiveMQReplicationTimeooutException replicationSynchronizationTimeout(final long timeout) {
        final ActiveMQReplicationTimeooutException result = new ActiveMQReplicationTimeooutException(_formatMessage(replicationSynchronizationTimeout$str(), timeout));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String liveBackupMismatch$str() {
        return "AMQ229115: Colocated Policy hasn''t different type live and backup";
    }
    @Override
    public final ActiveMQIllegalStateException liveBackupMismatch() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(liveBackupMismatch$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String acceptorUnavailable$str() {
        return "AMQ229116: Netty Acceptor unavailable";
    }
    @Override
    public final IllegalStateException acceptorUnavailable() {
        final IllegalStateException result = new IllegalStateException(acceptorUnavailable$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String replicatorIsNull$str() {
        return "AMQ229117: Replicator is null. Replication was likely terminated.";
    }
    @Override
    public final ActiveMQIllegalStateException replicatorIsNull() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), replicatorIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String methodNotApplicable$str() {
        return "AMQ229118: Management method not applicable for current server configuration";
    }
    @Override
    public final IllegalStateException methodNotApplicable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), methodNotApplicable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String diskBeyondLimit$str() {
        return "AMQ229119: Free storage space is at {0} of {1} total. Usage rate is {2} which is beyond the configured <max-disk-usage>. System will start blocking producers.";
    }
    @Override
    public final ActiveMQIOErrorException diskBeyondLimit(final String usableSpace, final String totalSpace, final String usage) {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(_formatMessage(diskBeyondLimit$str(), usableSpace, totalSpace, usage));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionWithIDClosedByManagement$str() {
        return "AMQ229120: connection with ID {0} closed by management";
    }
    @Override
    public final ActiveMQInternalErrorException connectionWithIDClosedByManagement(final String ID) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(_formatMessage(connectionWithIDClosedByManagement$str(), ID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String maxConsumerLimitReachedForQueue$str() {
        return "AMQ229200: Maximum Consumer Limit Reached on Queue:(address={0},queue={1})";
    }
    @Override
    public final ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(final SimpleString address, final SimpleString queueName) {
        final ActiveMQQueueMaxConsumerLimitReached result = new ActiveMQQueueMaxConsumerLimitReached(_formatMessage(maxConsumerLimitReachedForQueue$str(), address, queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedRoutingTypeForAddress$str() {
        return "AMQ229201: Expected Routing Type {1} but found {2} for address {0}";
    }
    @Override
    public final ActiveMQUnexpectedRoutingTypeForAddress unexpectedRoutingTypeForAddress(final SimpleString address, final RoutingType expectedRoutingType, final Set<RoutingType> supportedRoutingTypes) {
        final ActiveMQUnexpectedRoutingTypeForAddress result = new ActiveMQUnexpectedRoutingTypeForAddress(_formatMessage(unexpectedRoutingTypeForAddress$str(), address, expectedRoutingType, supportedRoutingTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidQueueConfiguration$str() {
        return "AMQ229202: Invalid Queue Configuration for Queue {0}, Address {1}.  Expected {2} to be {3} but was {4}";
    }
    @Override
    public final ActiveMQInvalidQueueConfiguration invalidQueueConfiguration(final SimpleString address, final SimpleString queueName, final String queuePropertyName, final Object expectedValue, final Object actualValue) {
        final ActiveMQInvalidQueueConfiguration result = new ActiveMQInvalidQueueConfiguration(_formatMessage(invalidQueueConfiguration$str(), address, queueName, queuePropertyName, expectedValue, actualValue));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressDoesNotExist$str() {
        return "AMQ229203: Address Does Not Exist: {0}";
    }
    @Override
    public final ActiveMQAddressDoesNotExistException addressDoesNotExist(final SimpleString address) {
        final ActiveMQAddressDoesNotExistException result = new ActiveMQAddressDoesNotExistException(_formatMessage(addressDoesNotExist$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressAlreadyExists$str() {
        return "AMQ229204: Address already exists: {0}";
    }
    @Override
    public final ActiveMQAddressExistsException addressAlreadyExists(final SimpleString address) {
        final ActiveMQAddressExistsException result = new ActiveMQAddressExistsException(_formatMessage(addressAlreadyExists$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressHasBindings$str() {
        return "AMQ229205: Address {0} has bindings";
    }
    @Override
    public final ActiveMQDeleteAddressException addressHasBindings(final SimpleString address) {
        final ActiveMQDeleteAddressException result = new ActiveMQDeleteAddressException(_formatMessage(addressHasBindings$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMaxConsumers$str() {
        return "AMQ229206: Queue {0} has invalid max consumer setting: {1}";
    }
    @Override
    public final IllegalArgumentException invalidMaxConsumers(final String queueName, final int value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidMaxConsumers$str(), queueName, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingTypeForAddress$str() {
        return "AMQ229207: Can not create queue with routing type: {0}, Supported routing types for address: {1} are {2}";
    }
    @Override
    public final IllegalArgumentException invalidRoutingTypeForAddress(final RoutingType routingType, final String address, final Set<RoutingType> supportedRoutingTypes) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidRoutingTypeForAddress$str(), routingType, address, supportedRoutingTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingType$str() {
        return "AMQ229208: Invalid routing type {0}";
    }
    @Override
    public final IllegalArgumentException invalidRoutingType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidRoutingType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingTypeDelete$str() {
        return "AMQ229209: Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.";
    }
    @Override
    public final IllegalStateException invalidRoutingTypeDelete(final RoutingType routingType, final String address) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidRoutingTypeDelete$str(), routingType, address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMaxConsumersUpdate$str() {
        return "AMQ229210: Can''t update queue {0} with maxConsumers: {1}. Current consumers are {2}.";
    }
    @Override
    public final IllegalStateException invalidMaxConsumersUpdate(final String queueName, final int maxConsumers, final int consumers) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidMaxConsumersUpdate$str(), queueName, maxConsumers, consumers));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingTypeUpdate$str() {
        return "AMQ229211: Can''t update queue {0} with routing type: {1}, Supported routing types for address: {2} are {3}";
    }
    @Override
    public final IllegalStateException invalidRoutingTypeUpdate(final String queueName, final RoutingType routingType, final String address, final Set<RoutingType> supportedRoutingTypes) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidRoutingTypeUpdate$str(), queueName, routingType, address, supportedRoutingTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDeletionPolicyType$str() {
        return "AMQ229212: Invalid deletion policy type {0}";
    }
    @Override
    public final IllegalArgumentException invalidDeletionPolicyType(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidDeletionPolicyType$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userNoPermissionsQueue$str() {
        return "AMQ229213: User: {0} does not have permission=''{1}'' for queue {2} on address {3}";
    }
    @Override
    public final ActiveMQSecurityException userNoPermissionsQueue(final String username, final CheckType checkType, final SimpleString queue, final SimpleString address) {
        final ActiveMQSecurityException result = new ActiveMQSecurityException(_formatMessage(userNoPermissionsQueue$str(), username, checkType, queue, address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notPercentOrMinusOne$str() {
        return "AMQ229214: {0} must be a valid percentage value between 0 and 100 or -1 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException notPercentOrMinusOne(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(notPercentOrMinusOne$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDeleteQueueWithMessages$str() {
        return "AMQ229215: Cannot delete queue {0} on binding {1} - it has {2} messages";
    }
    @Override
    public final ActiveMQIllegalStateException cannotDeleteQueueWithMessages(final SimpleString name, final SimpleString queueName, final long messageCount) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(cannotDeleteQueueWithMessages$str(), name, queueName, messageCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidQueueName$str() {
        return "AMQ229216: Invalid queue name: {0}";
    }
    @Override
    public final ActiveMQIllegalStateException invalidQueueName(final SimpleString queueName) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(invalidQueueName$str(), queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotWriteToClosedFile$str() {
        return "AMQ119217: Cannot write to closed file: {0}";
    }
    @Override
    public final ActiveMQIOErrorException cannotWriteToClosedFile(final SequentialFile file) {
        final ActiveMQIOErrorException result = new ActiveMQIOErrorException(_formatMessage(cannotWriteToClosedFile$str(), file));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLocateConfigURL$str() {
        return "AMQ229218: Failed to locate broker configuration URL";
    }
    @Override
    public final ActiveMQIllegalStateException failedToLocateConfigURL() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), failedToLocateConfigURL$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadSecurityConfig$str() {
        return "AMQ229219: Failed to load security configuration";
    }
    @Override
    public final ActiveMQIllegalStateException failedToLoadSecurityConfig() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), failedToLoadSecurityConfig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadUserFile$str() {
        return "AMQ229220: Failed to load user file: {0}";
    }
    @Override
    public final ActiveMQIllegalStateException failedToLoadUserFile(final String path) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(failedToLoadUserFile$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToLoadRoleFile$str() {
        return "AMQ229221: Failed to load role file: {0}";
    }
    @Override
    public final ActiveMQIllegalStateException failedToLoadRoleFile(final String path) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(failedToLoadRoleFile$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToFindLoginModuleEntry$str() {
        return "AMQ229222: Failed to find login module entry {0} from JAAS configuration";
    }
    @Override
    public final ActiveMQIllegalStateException failedToFindLoginModuleEntry(final String entry) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(failedToFindLoginModuleEntry$str(), entry));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userAlreadyExists$str() {
        return "AMQ229223: User {0} already exists";
    }
    @Override
    public final IllegalArgumentException userAlreadyExists(final String user) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(userAlreadyExists$str(), user));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userDoesNotExist$str() {
        return "AMQ229224: User {0} does not exist";
    }
    @Override
    public final IllegalArgumentException userDoesNotExist(final String user) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(userDoesNotExist$str(), user));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rejectEmptyValidatedUser$str() {
        return "AMQ229225: Validated User is not set";
    }
    @Override
    public final ActiveMQIllegalStateException rejectEmptyValidatedUser() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(rejectEmptyValidatedUser$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inRangeOfPositiveInt$str() {
        return "AMQ229226: {0}  must be greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException inRangeOfPositiveInt(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(inRangeOfPositiveInt$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inRangeOfPositiveIntThanMinusOne$str() {
        return "AMQ229227: {0}  must be equals to -1 or greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException inRangeOfPositiveIntThanMinusOne(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(inRangeOfPositiveIntThanMinusOne$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lessThanOrEqualToOne$str() {
        return "AMQ229228: {0} must be less than or equal to 1 (actual value: {1})";
    }
    @Override
    public final IllegalArgumentException lessThanOrEqualToOne(final String name, final Number val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(lessThanOrEqualToOne$str(), name, val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParseJson$str() {
        return "AMQ229229: Failed to parse JSON queue configuration: {0}";
    }
    @Override
    public final IllegalArgumentException failedToParseJson(final String json) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(failedToParseJson$str(), json));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToBind$str() {
        return "AMQ229230: Failed to bind acceptor {0} to {1}";
    }
    @Override
    public final IllegalStateException failedToBind(final String acceptor, final String hostPort, final Exception e) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(failedToBind$str(), acceptor, hostPort), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String divertDoesNotExist$str() {
        return "AMQ229231: Divert Does Not Exist: {0}";
    }
    @Override
    public final ActiveMQDivertDoesNotExistException divertDoesNotExist(final String divert) {
        final ActiveMQDivertDoesNotExistException result = new ActiveMQDivertDoesNotExistException(_formatMessage(divertDoesNotExist$str(), divert));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateConsumerOnClosedSession$str() {
        return "AMQ229232: Cannot create consumer on {0}. Session is closed.";
    }
    @Override
    public final ActiveMQIllegalStateException cannotCreateConsumerOnClosedSession(final SimpleString queueName) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(cannotCreateConsumerOnClosedSession$str(), queueName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetSecurityManager$str() {
        return "AMQ229233: Cannot set ActiveMQSecurityManager during startup or while started";
    }
    @Override
    public final IllegalStateException cannotSetSecurityManager() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSetSecurityManager$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSlowConsumerThresholdMeasurementUnit$str() {
        return "AMQ229234: Invalid slow consumer threshold measurement unit {0}";
    }
    @Override
    public final IllegalArgumentException invalidSlowConsumerThresholdMeasurementUnit(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidSlowConsumerThresholdMeasurementUnit$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bindingAlreadyExists2$str() {
        return "AMQ229235: Incompatible binding with name {0} already exists: {1}";
    }
    @Override
    public final ActiveMQIllegalStateException bindingAlreadyExists(final String name, final String binding) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(bindingAlreadyExists2$str(), name, binding));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTargetKey$str() {
        return "AMQ229236: Invalid target key {0}";
    }
    @Override
    public final IllegalArgumentException invalidTargetKey(final String val) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidTargetKey$str(), val));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String redirectConnection$str() {
        return "AMQ229237: Connection redirected to {0}";
    }
    @Override
    public final ActiveMQRedirectedException redirectConnection(final TransportConfiguration connector) {
        final ActiveMQRedirectedException result = new ActiveMQRedirectedException(_formatMessage(redirectConnection$str(), connector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRedirect$str() {
        return "AMQ229238: No target to redirect the connection";
    }
    @Override
    public final ActiveMQRedirectedException cannotRedirect() {
        final ActiveMQRedirectedException result = new ActiveMQRedirectedException(String.format(getLoggingLocale(), cannotRedirect$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRetention$str() {
        return "AMQ229239: There is no retention configured. In order to use the replay method you must specify journal-retention-directory element on the broker.xml";
    }
    @Override
    public final IllegalArgumentException noRetention() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRetention$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
