/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import org.apache.activemq.artemis.api.core.DisconnectReason;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQRedirectContext;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.balancing.RedirectHandler;

public class ActiveMQRedirectHandler
extends RedirectHandler<ActiveMQRedirectContext> {
    public ActiveMQRedirectHandler(ActiveMQServer server) {
        super(server);
    }

    public boolean redirect(CoreRemotingConnection connection, CreateSessionMessage message) throws Exception {
        if (!connection.isVersionSupportRedirect()) {
            throw ActiveMQMessageBundle.BUNDLE.incompatibleClientServer();
        }
        return this.redirect(new ActiveMQRedirectContext(connection, message));
    }

    @Override
    public void cannotRedirect(ActiveMQRedirectContext context) throws Exception {
        throw ActiveMQMessageBundle.BUNDLE.cannotRedirect();
    }

    @Override
    public void redirectTo(ActiveMQRedirectContext context) throws Exception {
        context.getConnection().disconnect(DisconnectReason.REDIRECT, context.getTarget().getNodeID(), context.getTarget().getConnector());
        throw ActiveMQMessageBundle.BUNDLE.redirectConnection(context.getTarget().getConnector());
    }
}

