/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.osgi;

import java.util.Arrays;
import org.apache.activemq.artemis.osgi.ActiveMQOsgiLogger;
import org.slf4j.Logger;

public class ActiveMQOsgiLogger_impl
implements ActiveMQOsgiLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQOsgiLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void brokerConfigFound(String name, String protocols) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ581000: Broker config {} found. Tracking protocols {}", (Object)name, (Object)protocols);
        }
    }

    @Override
    public void protocolWasAddedForBroker(String protocol, String name, String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ581001: Required protocol {} was added for broker {}. {}", new Object[]{protocol, name, message});
        }
    }

    @Override
    public void protocolWasRemovedForBroker(String protocol, String name, String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ581002: Required protocol {} was removed for broker {}. {}", new Object[]{protocol, name, message});
        }
    }

    @Override
    public void errorStartingBroker(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ582000: Error starting broker: {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void errorStoppingBroker(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ582001: Error stopping broker: {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void errorGettingDataSourceProviderInfo(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ582002: Error getting dataSource provider infos.", (Throwable)e);
        }
    }
}

