/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge;

import javax.management.ObjectName;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface ActiveMQJMSBridgeLogger
extends BasicLogger {
    public static final ActiveMQJMSBridgeLogger LOGGER = (ActiveMQJMSBridgeLogger)Logger.getMessageLogger(ActiveMQJMSBridgeLogger.class, (String)ActiveMQJMSBridgeLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=341000, value="Failed to set up JMS bridge {1} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {0} ms", format=Message.Format.MESSAGE_FORMAT)
    public void failedToSetUpBridge(long var1, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=341001, value="JMS Bridge {0} succeeded in reconnecting to servers", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeReconnected(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=341002, value="JMSBridge {0} succeeded in connecting to servers", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342000, value="Attempt to start JMS Bridge {0}, but is already started", format=Message.Format.MESSAGE_FORMAT)
    public void errorBridgeAlreadyStarted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342001, value="Failed to start JMS Bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingBridge(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342002, value="Failed to unregisted JMS Bridge {0} - {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorUnregisteringBridge(ObjectName var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342003, value="JMS Bridge {0} unable to set up connections, bridge will be stopped", format=Message.Format.MESSAGE_FORMAT)
    public void errorConnectingBridge(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342004, value="JMS Bridge {1}, will retry after a pause of {0} ms", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeRetry(long var1, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342005, value="JMS Bridge {0} unable to set up connections, bridge will not be started", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeNotStarted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342006, value="JMS Bridge {0}, detected failure on bridge connection", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeFailure(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342009, value="JMS Bridge {0} failed to send + acknowledge batch, closing JMS objects", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeAckError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342010, value="Failed to connect JMS Bridge {0}", format=Message.Format.MESSAGE_FORMAT)
    public void bridgeConnectError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342011, value="Transaction rolled back, retrying TX", format=Message.Format.MESSAGE_FORMAT)
    public void transactionRolledBack(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=344001, value="JMS Bridge {0}, failed to start source connection", format=Message.Format.MESSAGE_FORMAT)
    public void jmsBridgeSrcConnectError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=344002, value="Failed to start JMS Bridge {1}.  QoS Mode: {0} requires a Transaction Manager, none found", format=Message.Format.MESSAGE_FORMAT)
    public void jmsBridgeTransactionManagerMissing(QualityOfServiceMode var1, String var2);
}

