/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public final class Db2SequentialFileDriver
extends JDBCSequentialFileFactoryDriver {
    public Db2SequentialFileDriver() {
    }

    public Db2SequentialFileDriver(DataSource dataSource, SQLProvider provider) {
        super(dataSource, provider);
    }

    public Db2SequentialFileDriver(Connection connection, SQLProvider provider) {
        super(connection, provider);
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.deleteFile = this.connection.prepareStatement(this.sqlProvider.getDeleteFileSQL());
        this.createFile = this.connection.prepareStatement(this.sqlProvider.getInsertFileSQL(), new String[]{"ID"});
        this.selectFileByFileName = this.connection.prepareStatement(this.sqlProvider.getSelectFileByFileName());
        this.copyFileRecord = this.connection.prepareStatement(this.sqlProvider.getCopyFileRecordByIdSQL());
        this.renameFile = this.connection.prepareStatement(this.sqlProvider.getUpdateFileNameByIdSQL());
        this.readLargeObject = this.connection.prepareStatement(this.sqlProvider.getReadLargeObjectSQL());
        this.appendToLargeObject = this.connection.prepareStatement(this.sqlProvider.getAppendToLargeObjectSQL());
        this.selectFileNamesByExtension = this.connection.prepareStatement(this.sqlProvider.getSelectFileNamesByExtensionSQL());
    }

    @Override
    public int writeToFile(JDBCSequentialFile file, byte[] data) throws SQLException {
        if (data == null || data.length == 0) {
            return 0;
        }
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                this.appendToLargeObject.setBytes(1, data);
                this.appendToLargeObject.setLong(2, file.getId());
                int updatesFiles = this.appendToLargeObject.executeUpdate();
                assert (updatesFiles <= 1);
                this.connection.commit();
                int bytesWritten = updatesFiles == 0 ? 0 : data.length;
                return bytesWritten;
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw e;
            }
        }
    }
}

