/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.jms.server.ActiveMQJMSServerLogger */

package org.apache.activemq.artemis.jms.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="12[0-9]{4}", projectCode="AMQ")
public class ActiveMQJMSServerLogger_impl implements ActiveMQJMSServerLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQJMSServerLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=121004, value=\"JMS Server Manager Caching command for {} since the JMS Server is not active.\", level=INFO)
   @Override
   public void serverCachingCommand(java.lang.Object runnable) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ121004: JMS Server Manager Caching command for {} since the JMS Server is not active.", runnable);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122005, value=\"Invalid \\"host\\" value \\"0.0.0.0\\" detected for \\"{}\\" connector. Switching to \\"{}\\". If this new address is incorrect please manually configure the connector to use the proper one.\", level=WARN)
   @Override
   public void invalidHostForConnector(java.lang.String name, java.lang.String newHost) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122005: Invalid \"host\" value \"0.0.0.0\" detected for \"{}\" connector. Switching to \"{}\". If this new address is incorrect please manually configure the connector to use the proper one.", name, newHost);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122007, value=\"Queue {} does not exist on the topic {}. It was deleted manually probably.\", level=WARN)
   @Override
   public void noQueueOnTopic(java.lang.String queueName, java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122007: Queue {} does not exist on the topic {}. It was deleted manually probably.", queueName, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122008, value=\"XA Recovery can not connect to any broker on recovery {}\", level=WARN)
   @Override
   public void recoveryConnectFailed(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122008: XA Recovery can not connect to any broker on recovery {}", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122011, value=\"error unbinding {} from Registry\", level=WARN)
   @Override
   public void bindingsUnbindError(java.lang.String key, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122011: error unbinding {} from Registry", key, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122012, value=\"JMS Server Manager error\", level=WARN)
   @Override
   public void jmsServerError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122012: JMS Server Manager error", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122013, value=\"Error in XA Recovery recover\", level=WARN)
   @Override
   public void xaRecoverError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122013: Error in XA Recovery recover", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122014, value=\"Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass\", level=WARN)
   @Override
   public void xaRecoverConnectionError(org.apache.activemq.artemis.api.core.client.ClientSessionFactory csf, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122014: Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass", csf, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122016, value=\"Error in XA Recovery\", level=DEBUG)
   @Override
   public void xaRecoveryError(java.lang.Exception e) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ122016: Error in XA Recovery", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122017, value=\"Tried to correct invalid \\"host\\" value \\"0.0.0.0\\" for \\"{}\\" connector, but received an exception.\", level=WARN)
   @Override
   public void failedToCorrectHost(java.lang.String name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{}\" connector, but received an exception.", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122018, value=\"Failed to send notification: {}\", level=WARN)
   @Override
   public void failedToSendNotification(java.lang.String notification) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122018: Failed to send notification: {}", notification);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=122019, value=\"Unable to deactivate server\", level=WARN)
   @Override
   public void failedToDeactivateServer(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ122019: Unable to deactivate server", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=123000, value=\"JMS Server Manager Running cached command for {}.(In the event of failover after failback has occurred, this message may be output multiple times.)\", level=DEBUG)
   @Override
   public void serverRunningCachedCommand(java.lang.Runnable run) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ123000: JMS Server Manager Running cached command for {}.(In the event of failover after failback has occurred, this message may be output multiple times.)", run);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=124000, value=\"key attribute missing for JMS configuration {}\", level=ERROR)
   @Override
   public void jmsConfigMissingKey(org.w3c.dom.Node e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ124000: key attribute missing for JMS configuration {}", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=124002, value=\"Failed to start JMS deployer\", level=ERROR)
   @Override
   public void jmsDeployerStartError(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ124002: Failed to start JMS deployer", e);
      }
   }

}
