/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRABytesMessage
extends ActiveMQRAMessage
implements BytesMessage {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ActiveMQRABytesMessage(BytesMessage message, ActiveMQRASession session) {
        super((Message)message, session);
        logger.trace("constructor({}, {})", (Object)message, (Object)session);
    }

    public long getBodyLength() throws JMSException {
        logger.trace("getBodyLength()");
        return ((BytesMessage)this.message).getBodyLength();
    }

    public boolean readBoolean() throws JMSException {
        logger.trace("readBoolean()");
        return ((BytesMessage)this.message).readBoolean();
    }

    public byte readByte() throws JMSException {
        logger.trace("readByte()");
        return ((BytesMessage)this.message).readByte();
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("readBytes({}, {})", (Object)Arrays.toString(value), (Object)length);
        }
        return ((BytesMessage)this.message).readBytes(value, length);
    }

    public int readBytes(byte[] value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("readBytes({})", (Object)Arrays.toString(value));
        }
        return ((BytesMessage)this.message).readBytes(value);
    }

    public char readChar() throws JMSException {
        logger.trace("readChar()");
        return ((BytesMessage)this.message).readChar();
    }

    public double readDouble() throws JMSException {
        logger.trace("readDouble()");
        return ((BytesMessage)this.message).readDouble();
    }

    public float readFloat() throws JMSException {
        logger.trace("readFloat()");
        return ((BytesMessage)this.message).readFloat();
    }

    public int readInt() throws JMSException {
        logger.trace("readInt()");
        return ((BytesMessage)this.message).readInt();
    }

    public long readLong() throws JMSException {
        logger.trace("readLong()");
        return ((BytesMessage)this.message).readLong();
    }

    public short readShort() throws JMSException {
        logger.trace("readShort()");
        return ((BytesMessage)this.message).readShort();
    }

    public int readUnsignedByte() throws JMSException {
        logger.trace("readUnsignedByte()");
        return ((BytesMessage)this.message).readUnsignedByte();
    }

    public int readUnsignedShort() throws JMSException {
        logger.trace("readUnsignedShort()");
        return ((BytesMessage)this.message).readUnsignedShort();
    }

    public String readUTF() throws JMSException {
        logger.trace("readUTF()");
        return ((BytesMessage)this.message).readUTF();
    }

    public void reset() throws JMSException {
        logger.trace("reset()");
        ((BytesMessage)this.message).reset();
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBoolean({})", (Object)value);
        }
        ((BytesMessage)this.message).writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeByte({})", (Object)value);
        }
        ((BytesMessage)this.message).writeByte(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBytes({}, {}, {})", new Object[]{Arrays.toString(value), offset, length});
        }
        ((BytesMessage)this.message).writeBytes(value, offset, length);
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeBytes({})", (Object)Arrays.toString(value));
        }
        ((BytesMessage)this.message).writeBytes(value);
    }

    public void writeChar(char value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeChar({})", (Object)Character.valueOf(value));
        }
        ((BytesMessage)this.message).writeChar(value);
    }

    public void writeDouble(double value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeDouble({})", (Object)value);
        }
        ((BytesMessage)this.message).writeDouble(value);
    }

    public void writeFloat(float value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeFloat({})", (Object)Float.valueOf(value));
        }
        ((BytesMessage)this.message).writeFloat(value);
    }

    public void writeInt(int value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeInt({})", (Object)value);
        }
        ((BytesMessage)this.message).writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeLong({})", (Object)value);
        }
        ((BytesMessage)this.message).writeLong(value);
    }

    public void writeObject(Object value) throws JMSException {
        logger.trace("writeObject({})", value);
        ((BytesMessage)this.message).writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("writeShort({})", (Object)value);
        }
        ((BytesMessage)this.message).writeShort(value);
    }

    public void writeUTF(String value) throws JMSException {
        logger.trace("writeUTF({})", (Object)value);
        ((BytesMessage)this.message).writeUTF(value);
    }
}

