/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.util.Hashtable;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class ActiveMQRAProperties
extends ConnectionFactoryProperties
implements Serializable {
    static final long serialVersionUID = -2772367477755473248L;
    protected boolean allowLocalTransactions;
    protected boolean useTopologyForLoadBalancing = true;
    private String userName;
    private String password = null;
    private Boolean localTx = false;
    private static final int DEFAULT_SETUP_ATTEMPTS = -1;
    private static final long DEFAULT_SETUP_INTERVAL = 2000L;
    private int setupAttempts = -1;
    private long setupInterval = 2000L;
    private Hashtable<?, ?> jndiParams;
    private boolean useJNDI;
    private Boolean useMaskedPassword = null;
    private String passwordCodec;
    private boolean initialized = false;
    private String jgroupsChannelLocatorClass;
    private String jgroupsChannelRefName;

    public ActiveMQRAProperties() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
    }

    public String getUserName() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public boolean isUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(Boolean value) {
        this.useJNDI = value;
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.jndiParams;
    }

    public void setParsedJndiParams(Hashtable<?, ?> params) {
        this.jndiParams = params;
    }

    public Boolean getUseLocalTx() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getUseLocalTx()");
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setUseLocalTx(" + localTx + ")");
        }
        this.localTx = localTx;
    }

    public int getSetupAttempts() {
        return this.setupAttempts;
    }

    public void setSetupAttempts(Integer setupAttempts) {
        this.setupAttempts = setupAttempts;
    }

    public long getSetupInterval() {
        return this.setupInterval;
    }

    public void setSetupInterval(Long setupInterval) {
        this.setupInterval = setupInterval;
    }

    public Boolean isUseMaskedPassword() {
        return this.useMaskedPassword;
    }

    public void setUseMaskedPassword(Boolean useMaskedPassword) {
        this.useMaskedPassword = useMaskedPassword;
    }

    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    public void setPasswordCodec(String codecs) {
        this.passwordCodec = codecs;
    }

    public String toString() {
        return "ActiveMQRAProperties[localTx=" + this.localTx + ", userName=" + this.userName + ", password=****]";
    }

    public synchronized void init() throws ActiveMQException {
        if (this.initialized) {
            return;
        }
        if (this.password != null) {
            try {
                this.password = PasswordMaskingUtil.resolveMask((Boolean)this.useMaskedPassword, (String)this.password, (String)this.passwordCodec);
            }
            catch (Exception e) {
                throw ActiveMQRABundle.BUNDLE.errorDecodingPassword(e);
            }
        }
        this.initialized = true;
    }

    public void setUseTopologyForLoadBalancing(boolean useTopologyForLoadBalancing) {
        this.useTopologyForLoadBalancing = useTopologyForLoadBalancing;
    }

    public boolean isUseTopologyForLoadBalancing() {
        return this.useTopologyForLoadBalancing;
    }

    public String getCodec() {
        return this.passwordCodec;
    }

    public String getJgroupsChannelLocatorClass() {
        return this.jgroupsChannelLocatorClass;
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.jgroupsChannelLocatorClass = jgroupsChannelLocatorClass;
    }

    public String getJgroupsChannelRefName() {
        return this.jgroupsChannelRefName;
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.jgroupsChannelRefName = jgroupsChannelRefName;
    }

    public boolean isAllowLocalTransactions() {
        return this.allowLocalTransactions;
    }

    public void setAllowLocalTransactions(boolean allowLocalTransactions) {
        this.allowLocalTransactions = allowLocalTransactions;
    }
}

