/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.logs.AuditLogger */

package org.apache.activemq.artemis.logs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="60[0-9]{4}", projectCode="AMQ")
public class AuditLogger_impl implements AuditLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public AuditLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.GetLogger()
   @Override
   public Logger getLogger() {
      return logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601000, value=\"User {} is getting routing type property on target resource: {}\", level=INFO)
   @Override
   public void getRoutingTypes(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601000: User {} is getting routing type property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601001, value=\"User {} is getting routing type property as json on target resource: {}\", level=INFO)
   @Override
   public void getRoutingTypesAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601001: User {} is getting routing type property as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601002, value=\"User {} is getting queue names on target resource: {} {}\", level=INFO)
   @Override
   public void getQueueNames(java.lang.String user, java.lang.Object source, java.lang.String parameters) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601002: User {} is getting queue names on target resource: {} {}", user, source, parameters);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601003, value=\"User {} is getting binding names on target resource: {}\", level=INFO)
   @Override
   public void getBindingNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601003: User {} is getting binding names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601004, value=\"User {} is getting roles on target resource: {} {}\", level=INFO)
   @Override
   public void getRoles(java.lang.String user, java.lang.Object source, java.lang.String parameters) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601004: User {} is getting roles on target resource: {} {}", user, source, parameters);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601005, value=\"User {} is getting roles as json on target resource: {} {}\", level=INFO)
   @Override
   public void getRolesAsJSON(java.lang.String user, java.lang.Object source, java.lang.String parameters) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601005: User {} is getting roles as json on target resource: {} {}", user, source, parameters);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601006, value=\"User {} is getting number of bytes per page on target resource: {}\", level=INFO)
   @Override
   public void getNumberOfBytesPerPage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601006: User {} is getting number of bytes per page on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601007, value=\"User {} is getting address size on target resource: {}\", level=INFO)
   @Override
   public void getAddressSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601007: User {} is getting address size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601008, value=\"User {} is getting number of messages on target resource: {}\", level=INFO)
   @Override
   public void getNumberOfMessages(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601008: User {} is getting number of messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601009, value=\"User {} is getting isPaging on target resource: {}\", level=INFO)
   @Override
   public void isPaging(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601009: User {} is getting isPaging on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601010, value=\"User {} is getting number of pages on target resource: {}\", level=INFO)
   @Override
   public void getNumberOfPages(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601010: User {} is getting number of pages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601011, value=\"User {} is getting routed message count on target resource: {}\", level=INFO)
   @Override
   public void getRoutedMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601011: User {} is getting routed message count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601012, value=\"User {} is getting unrouted message count on target resource: {}\", level=INFO)
   @Override
   public void getUnRoutedMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601012: User {} is getting unrouted message count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601013, value=\"User {} is sending a message on target resource: {} {}\", level=INFO)
   @Override
   public void sendMessageThroughManagement(java.lang.String user, java.lang.Object source, java.lang.String parameters) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601013: User {} is sending a message on target resource: {} {}", user, source, parameters);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601014, value=\"User {} is getting name on target resource: {}\", level=INFO)
   @Override
   public void getName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601014: User {} is getting name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601015, value=\"User {} is getting address on target resource: {}\", level=INFO)
   @Override
   public void getAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601015: User {} is getting address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601016, value=\"User {} is getting filter on target resource: {}\", level=INFO)
   @Override
   public void getFilter(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601016: User {} is getting filter on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601017, value=\"User {} is getting durable property on target resource: {}\", level=INFO)
   @Override
   public void isDurable(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601017: User {} is getting durable property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601018, value=\"User {} is getting message count on target resource: {}\", level=INFO)
   @Override
   public void getMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601018: User {} is getting message count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601019, value=\"User {} is getting mbean info on target resource: {}\", level=INFO)
   @Override
   public void getMBeanInfo(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601019: User {} is getting mbean info on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601020, value=\"User {} is getting factory class name on target resource: {}\", level=INFO)
   @Override
   public void getFactoryClassName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601020: User {} is getting factory class name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601021, value=\"User {} is getting parameters on target resource: {}\", level=INFO)
   @Override
   public void getParameters(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601021: User {} is getting parameters on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601022, value=\"User {} is doing reload on target resource: {}\", level=INFO)
   @Override
   public void reload(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601022: User {} is doing reload on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601023, value=\"User {} is querying isStarted on target resource: {}\", level=INFO)
   @Override
   public void isStarted(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601023: User {} is querying isStarted on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601024, value=\"User {} is starting an acceptor on target resource: {}\", level=INFO)
   @Override
   public void startAcceptor(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601024: User {} is starting an acceptor on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601025, value=\"User {} is stopping an acceptor on target resource: {}\", level=INFO)
   @Override
   public void stopAcceptor(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601025: User {} is stopping an acceptor on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601026, value=\"User {} is getting version on target resource: {}\", level=INFO)
   @Override
   public void getVersion(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601026: User {} is getting version on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601027, value=\"User {} is querying isBackup on target resource: {}\", level=INFO)
   @Override
   public void isBackup(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601027: User {} is querying isBackup on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601028, value=\"User {} is querying isSharedStore on target resource: {}\", level=INFO)
   @Override
   public void isSharedStore(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601028: User {} is querying isSharedStore on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601029, value=\"User {} is getting bindings directory on target resource: {}\", level=INFO)
   @Override
   public void getBindingsDirectory(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601029: User {} is getting bindings directory on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601030, value=\"User {} is getting incoming interceptor class names on target resource: {}\", level=INFO)
   @Override
   public void getIncomingInterceptorClassNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601030: User {} is getting incoming interceptor class names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601031, value=\"User {} is getting outgoing interceptor class names on target resource: {}\", level=INFO)
   @Override
   public void getOutgoingInterceptorClassNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601031: User {} is getting outgoing interceptor class names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601032, value=\"User {} is getting journal buffer size on target resource: {}\", level=INFO)
   @Override
   public void getJournalBufferSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601032: User {} is getting journal buffer size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601033, value=\"User {} is getting journal buffer timeout on target resource: {}\", level=INFO)
   @Override
   public void getJournalBufferTimeout(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601033: User {} is getting journal buffer timeout on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601034, value=\"User {} is setting failover on server shutdown on target resource: {} {}\", level=INFO)
   @Override
   public void setFailoverOnServerShutdown(java.lang.String user, java.lang.Object source, java.lang.String parameters) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601034: User {} is setting failover on server shutdown on target resource: {} {}", user, source, parameters);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601035, value=\"User {} is querying is-failover-on-server-shutdown on target resource: {}\", level=INFO)
   @Override
   public void isFailoverOnServerShutdown(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601035: User {} is querying is-failover-on-server-shutdown on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601036, value=\"User {} is getting journal's max io on target resource: {}\", level=INFO)
   @Override
   public void getJournalMaxIO(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601036: User {} is getting journal's max io on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601037, value=\"User {} is getting journal directory on target resource: {}\", level=INFO)
   @Override
   public void getJournalDirectory(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601037: User {} is getting journal directory on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601038, value=\"User {} is getting journal file size on target resource: {}\", level=INFO)
   @Override
   public void getJournalFileSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601038: User {} is getting journal file size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601039, value=\"User {} is getting journal min files on target resource: {}\", level=INFO)
   @Override
   public void getJournalMinFiles(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601039: User {} is getting journal min files on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601040, value=\"User {} is getting journal compact min files on target resource: {}\", level=INFO)
   @Override
   public void getJournalCompactMinFiles(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601040: User {} is getting journal compact min files on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601041, value=\"User {} is getting journal compact percentage on target resource: {}\", level=INFO)
   @Override
   public void getJournalCompactPercentage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601041: User {} is getting journal compact percentage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601042, value=\"User {} is querying persistence enabled on target resource: {}\", level=INFO)
   @Override
   public void isPersistenceEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601042: User {} is querying persistence enabled on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601043, value=\"User {} is getting journal type on target resource: {}\", level=INFO)
   @Override
   public void getJournalType(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601043: User {} is getting journal type on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601044, value=\"User {} is getting paging directory on target resource: {}\", level=INFO)
   @Override
   public void getPagingDirectory(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601044: User {} is getting paging directory on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601045, value=\"User {} is getting scheduled threadpool max size on target resource: {}\", level=INFO)
   @Override
   public void getScheduledThreadPoolMaxSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601045: User {} is getting scheduled threadpool max size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601046, value=\"User {} is getting threadpool max size on target resource: {}\", level=INFO)
   @Override
   public void getThreadPoolMaxSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601046: User {} is getting threadpool max size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601047, value=\"User {} is getting security invalidation interval on target resource: {}\", level=INFO)
   @Override
   public void getSecurityInvalidationInterval(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601047: User {} is getting security invalidation interval on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601048, value=\"User {} is querying is-clustered on target resource: {}\", level=INFO)
   @Override
   public void isClustered(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601048: User {} is querying is-clustered on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601049, value=\"User {} is querying is-create-bindings-dir on target resource: {}\", level=INFO)
   @Override
   public void isCreateBindingsDir(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601049: User {} is querying is-create-bindings-dir on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601050, value=\"User {} is querying is-create-journal-dir on target resource: {}\", level=INFO)
   @Override
   public void isCreateJournalDir(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601050: User {} is querying is-create-journal-dir on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601051, value=\"User {} is querying is-journal-sync-non-transactional on target resource: {}\", level=INFO)
   @Override
   public void isJournalSyncNonTransactional(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601051: User {} is querying is-journal-sync-non-transactional on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601052, value=\"User {} is querying is-journal-sync-transactional on target resource: {}\", level=INFO)
   @Override
   public void isJournalSyncTransactional(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601052: User {} is querying is-journal-sync-transactional on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601053, value=\"User {} is querying is-security-enabled on target resource: {}\", level=INFO)
   @Override
   public void isSecurityEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601053: User {} is querying is-security-enabled on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601054, value=\"User {} is querying is-async-connection-execution-enabled on target resource: {}\", level=INFO)
   @Override
   public void isAsyncConnectionExecutionEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601054: User {} is querying is-async-connection-execution-enabled on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601055, value=\"User {} is getting disk scan period on target resource: {}\", level=INFO)
   @Override
   public void getDiskScanPeriod(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601055: User {} is getting disk scan period on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601056, value=\"User {} is getting max disk usage on target resource: {}\", level=INFO)
   @Override
   public void getMaxDiskUsage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601056: User {} is getting max disk usage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601057, value=\"User {} is getting global max size on target resource: {}\", level=INFO)
   @Override
   public void getGlobalMaxSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601057: User {} is getting global max size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601058, value=\"User {} is getting address memory usage on target resource: {}\", level=INFO)
   @Override
   public void getAddressMemoryUsage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601058: User {} is getting address memory usage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601059, value=\"User {} is getting address memory usage percentage on target resource: {}\", level=INFO)
   @Override
   public void getAddressMemoryUsagePercentage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601059: User {} is getting address memory usage percentage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601060, value=\"User {} is freezing replication on target resource: {}\", level=INFO)
   @Override
   public void freezeReplication(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601060: User {} is freezing replication on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601061, value=\"User {} is creating an address on target resource: {} {}\", level=INFO)
   @Override
   public void createAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601061: User {} is creating an address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601062, value=\"User {} is updating an address on target resource: {} {}\", level=INFO)
   @Override
   public void updateAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601062: User {} is updating an address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601063, value=\"User {} is deleting an address on target resource: {} {}\", level=INFO)
   @Override
   public void deleteAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601063: User {} is deleting an address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601064, value=\"User {} is creating a queue on target resource: {} {}\", level=INFO)
   @Override
   public void deployQueue(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601064: User {} is creating a queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601065, value=\"User {} is creating a queue on target resource: {} {}\", level=INFO)
   @Override
   public void createQueue(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601065: User {} is creating a queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601066, value=\"User {} is updating a queue on target resource: {} {}\", level=INFO)
   @Override
   public void updateQueue(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601066: User {} is updating a queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601067, value=\"User {} is getting cluster connection names on target resource: {}\", level=INFO)
   @Override
   public void getClusterConnectionNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601067: User {} is getting cluster connection names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601068, value=\"User {} is getting uptime on target resource: {}\", level=INFO)
   @Override
   public void getUptime(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601068: User {} is getting uptime on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601069, value=\"User {} is getting uptime in milliseconds on target resource: {}\", level=INFO)
   @Override
   public void getUptimeMillis(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601069: User {} is getting uptime in milliseconds on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601070, value=\"User {} is querying is-replica-sync on target resource: {}\", level=INFO)
   @Override
   public void isReplicaSync(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601070: User {} is querying is-replica-sync on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601071, value=\"User {} is getting address names on target resource: {}\", level=INFO)
   @Override
   public void getAddressNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601071: User {} is getting address names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601072, value=\"User {} is deleting a queue on target resource: {} {}\", level=INFO)
   @Override
   public void destroyQueue(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601072: User {} is deleting a queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601073, value=\"User {} is getting address info on target resource: {} {}\", level=INFO)
   @Override
   public void getAddressInfo(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601073: User {} is getting address info on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601074, value=\"User {} is listing bindings for address on target resource: {} {}\", level=INFO)
   @Override
   public void listBindingsForAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601074: User {} is listing bindings for address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601075, value=\"User {} is listing addresses on target resource: {} {}\", level=INFO)
   @Override
   public void listAddresses(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601075: User {} is listing addresses on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601076, value=\"User {} is getting connection count on target resource: {} {}\", level=INFO)
   @Override
   public void getConnectionCount(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601076: User {} is getting connection count on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601077, value=\"User {} is getting total connection count on target resource: {}\", level=INFO)
   @Override
   public void getTotalConnectionCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601077: User {} is getting total connection count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601078, value=\"User {} is getting total message count on target resource: {}\", level=INFO)
   @Override
   public void getTotalMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601078: User {} is getting total message count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601079, value=\"User {} is getting total messages added on target resource: {}\", level=INFO)
   @Override
   public void getTotalMessagesAdded(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601079: User {} is getting total messages added on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601080, value=\"User {} is getting total messages acknowledged on target resource: {}\", level=INFO)
   @Override
   public void getTotalMessagesAcknowledged(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601080: User {} is getting total messages acknowledged on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601081, value=\"User {} is getting total consumer count on target resource: {}\", level=INFO)
   @Override
   public void getTotalConsumerCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601081: User {} is getting total consumer count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601082, value=\"User {} is enabling message counters on target resource: {}\", level=INFO)
   @Override
   public void enableMessageCounters(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601082: User {} is enabling message counters on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601083, value=\"User {} is disabling message counters on target resource: {}\", level=INFO)
   @Override
   public void disableMessageCounters(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601083: User {} is disabling message counters on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601084, value=\"User {} is resetting all message counters on target resource: {}\", level=INFO)
   @Override
   public void resetAllMessageCounters(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601084: User {} is resetting all message counters on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601085, value=\"User {} is resetting all message counter histories on target resource: {}\", level=INFO)
   @Override
   public void resetAllMessageCounterHistories(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601085: User {} is resetting all message counter histories on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601086, value=\"User {} is querying is-message-counter-enabled on target resource: {}\", level=INFO)
   @Override
   public void isMessageCounterEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601086: User {} is querying is-message-counter-enabled on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601087, value=\"User {} is getting message counter sample period on target resource: {}\", level=INFO)
   @Override
   public void getMessageCounterSamplePeriod(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601087: User {} is getting message counter sample period on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601088, value=\"User {} is setting message counter sample period on target resource: {} {}\", level=INFO)
   @Override
   public void setMessageCounterSamplePeriod(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601088: User {} is setting message counter sample period on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601089, value=\"User {} is getting message counter max day count on target resource: {}\", level=INFO)
   @Override
   public void getMessageCounterMaxDayCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601089: User {} is getting message counter max day count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601090, value=\"User {} is setting message counter max day count on target resource: {} {}\", level=INFO)
   @Override
   public void setMessageCounterMaxDayCount(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601090: User {} is setting message counter max day count on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601091, value=\"User {} is listing prepared transactions on target resource: {}\", level=INFO)
   @Override
   public void listPreparedTransactions(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601091: User {} is listing prepared transactions on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601092, value=\"User {} is listing prepared transaction details as json on target resource: {}\", level=INFO)
   @Override
   public void listPreparedTransactionDetailsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601092: User {} is listing prepared transaction details as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601093, value=\"User {} is listing prepared transaction details as HTML on target resource: {} {}\", level=INFO)
   @Override
   public void listPreparedTransactionDetailsAsHTML(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601093: User {} is listing prepared transaction details as HTML on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601094, value=\"User {} is listing heuristic committed transactions on target resource: {}\", level=INFO)
   @Override
   public void listHeuristicCommittedTransactions(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601094: User {} is listing heuristic committed transactions on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601095, value=\"User {} is listing heuristic rolled back transactions on target resource: {}\", level=INFO)
   @Override
   public void listHeuristicRolledBackTransactions(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601095: User {} is listing heuristic rolled back transactions on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601096, value=\"User {} is commiting prepared transaction on target resource: {} {}\", level=INFO)
   @Override
   public void commitPreparedTransaction(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601096: User {} is commiting prepared transaction on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601097, value=\"User {} is rolling back prepared transaction on target resource: {} {}\", level=INFO)
   @Override
   public void rollbackPreparedTransaction(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601097: User {} is rolling back prepared transaction on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601098, value=\"User {} is listing remote addresses on target resource: {} {}\", level=INFO)
   @Override
   public void listRemoteAddresses(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601098: User {} is listing remote addresses on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601099, value=\"User {} is closing connections for address on target resource: {} {}\", level=INFO)
   @Override
   public void closeConnectionsForAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601099: User {} is closing connections for address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601100, value=\"User {} is closing consumer connections for address on target resource: {} {}\", level=INFO)
   @Override
   public void closeConsumerConnectionsForAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601100: User {} is closing consumer connections for address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601101, value=\"User {} is closing connections for user on target resource: {} {}\", level=INFO)
   @Override
   public void closeConnectionsForUser(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601101: User {} is closing connections for user on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601102, value=\"User {} is closing a connection by ID on target resource: {} {}\", level=INFO)
   @Override
   public void closeConnectionWithID(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601102: User {} is closing a connection by ID on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601103, value=\"User {} is closing session with id on target resource: {} {}\", level=INFO)
   @Override
   public void closeSessionWithID(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601103: User {} is closing session with id on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601104, value=\"User {} is closing consumer with id on target resource: {} {}\", level=INFO)
   @Override
   public void closeConsumerWithID(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601104: User {} is closing consumer with id on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601105, value=\"User {} is listing connection IDs on target resource: {}\", level=INFO)
   @Override
   public void listConnectionIDs(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601105: User {} is listing connection IDs on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601106, value=\"User {} is listing sessions on target resource: {} {}\", level=INFO)
   @Override
   public void listSessions(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601106: User {} is listing sessions on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601107, value=\"User {} is listing producers info as json on target resource: {}\", level=INFO)
   @Override
   public void listProducersInfoAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601107: User {} is listing producers info as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601108, value=\"User {} is listing connections on target resource: {} {}\", level=INFO)
   @Override
   public void listConnections(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601108: User {} is listing connections on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601109, value=\"User {} is listing consumers on target resource: {} {}\", level=INFO)
   @Override
   public void listConsumers(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601109: User {} is listing consumers on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601110, value=\"User {} is listing queues on target resource: {} {}\", level=INFO)
   @Override
   public void listQueues(java.lang.String user, java.lang.Object source, java.lang.String arg) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601110: User {} is listing queues on target resource: {} {}", user, source, arg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601111, value=\"User {} is listing producers on target resource: {} {}\", level=INFO)
   @Override
   public void listProducers(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601111: User {} is listing producers on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601112, value=\"User {} is listing connections as json on target resource: {}\", level=INFO)
   @Override
   public void listConnectionsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601112: User {} is listing connections as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601113, value=\"User {} is listing sessions as json on target resource: {} {}\", level=INFO)
   @Override
   public void listSessionsAsJSON(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601113: User {} is listing sessions as json on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601114, value=\"User {} is listing all sessions as json on target resource: {}\", level=INFO)
   @Override
   public void listAllSessionsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601114: User {} is listing all sessions as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601115, value=\"User {} is listing consumers as json on target resource: {} {}\", level=INFO)
   @Override
   public void listConsumersAsJSON(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601115: User {} is listing consumers as json on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601116, value=\"User {} is listing all consumers as json on target resource: {}\", level=INFO)
   @Override
   public void listAllConsumersAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601116: User {} is listing all consumers as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601117, value=\"User {} is getting connectors on target resource: {}\", level=INFO)
   @Override
   public void getConnectors(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601117: User {} is getting connectors on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601118, value=\"User {} is getting connectors as json on target resource: {}\", level=INFO)
   @Override
   public void getConnectorsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601118: User {} is getting connectors as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601119, value=\"User {} is adding security settings on target resource: {} {}\", level=INFO)
   @Override
   public void addSecuritySettings(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601119: User {} is adding security settings on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601120, value=\"User {} is removing security settings on target resource: {} {}\", level=INFO)
   @Override
   public void removeSecuritySettings(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601120: User {} is removing security settings on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601121, value=\"User {} is getting address settings as json on target resource: {} {}\", level=INFO)
   @Override
   public void getAddressSettingsAsJSON(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601121: User {} is getting address settings as json on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601122, value=\"User {} is adding addressSettings on target resource: {} {}\", level=INFO)
   @Override
   public void addAddressSettings(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601122: User {} is adding addressSettings on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601123, value=\"User {} is removing address settings on target resource: {} {}\", level=INFO)
   @Override
   public void removeAddressSettings(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601123: User {} is removing address settings on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601124, value=\"User {} is getting divert names on target resource: {}\", level=INFO)
   @Override
   public void getDivertNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601124: User {} is getting divert names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601125, value=\"User {} is creating a divert on target resource: {} {}\", level=INFO)
   @Override
   public void createDivert(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601125: User {} is creating a divert on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601126, value=\"User {} is destroying a divert on target resource: {} {}\", level=INFO)
   @Override
   public void destroyDivert(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601126: User {} is destroying a divert on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601127, value=\"User {} is getting bridge names on target resource: {}\", level=INFO)
   @Override
   public void getBridgeNames(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601127: User {} is getting bridge names on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601128, value=\"User {} is creating a bridge on target resource: {} {}\", level=INFO)
   @Override
   public void createBridge(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601128: User {} is creating a bridge on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601129, value=\"User {} is destroying a bridge on target resource: {} {}\", level=INFO)
   @Override
   public void destroyBridge(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601129: User {} is destroying a bridge on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601130, value=\"User {} is creating connector service on target resource: {} {}\", level=INFO)
   @Override
   public void createConnectorService(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601130: User {} is creating connector service on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601131, value=\"User {} is destroying connector service on target resource: {} {}\", level=INFO)
   @Override
   public void destroyConnectorService(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601131: User {} is destroying connector service on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601132, value=\"User {} is getting connector services on target resource: {} {}\", level=INFO)
   @Override
   public void getConnectorServices(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601132: User {} is getting connector services on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601133, value=\"User {} is forceing a failover on target resource: {}\", level=INFO)
   @Override
   public void forceFailover(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601133: User {} is forceing a failover on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601134, value=\"User {} is performing scale down on target resource: {} {}\", level=INFO)
   @Override
   public void scaleDown(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601134: User {} is performing scale down on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601135, value=\"User {} is listing network topology on target resource: {}\", level=INFO)
   @Override
   public void listNetworkTopology(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601135: User {} is listing network topology on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601136, value=\"User {} is removing notification listener on target resource: {} {}\", level=INFO)
   @Override
   public void removeNotificationListener(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601136: User {} is removing notification listener on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601137, value=\"User {} is adding notification listener on target resource: {} {}\", level=INFO)
   @Override
   public void addNotificationListener(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601137: User {} is adding notification listener on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601138, value=\"User {} is getting notification info on target resource: {}\", level=INFO)
   @Override
   public void getNotificationInfo(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601138: User {} is getting notification info on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601139, value=\"User {} is getting connection ttl override on target resource: {}\", level=INFO)
   @Override
   public void getConnectionTTLOverride(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601139: User {} is getting connection ttl override on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601140, value=\"User {} is getting ID cache size on target resource: {}\", level=INFO)
   @Override
   public void getIDCacheSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601140: User {} is getting ID cache size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601141, value=\"User {} is getting large message directory on target resource: {}\", level=INFO)
   @Override
   public void getLargeMessagesDirectory(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601141: User {} is getting large message directory on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601142, value=\"User {} is getting management address on target resource: {}\", level=INFO)
   @Override
   public void getManagementAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601142: User {} is getting management address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601143, value=\"User {} is getting node ID on target resource: {}\", level=INFO)
   @Override
   public void getNodeID(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601143: User {} is getting node ID on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601144, value=\"User {} is getting management notification address on target resource: {}\", level=INFO)
   @Override
   public void getManagementNotificationAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601144: User {} is getting management notification address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601145, value=\"User {} is getting message expiry scan period on target resource: {}\", level=INFO)
   @Override
   public void getMessageExpiryScanPeriod(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601145: User {} is getting message expiry scan period on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601146, value=\"User {} is getting message expiry thread priority on target resource: {}\", level=INFO)
   @Override
   public void getMessageExpiryThreadPriority(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601146: User {} is getting message expiry thread priority on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601147, value=\"User {} is getting transaction timeout on target resource: {}\", level=INFO)
   @Override
   public void getTransactionTimeout(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601147: User {} is getting transaction timeout on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601148, value=\"User {} is getting transaction timeout scan period on target resource: {}\", level=INFO)
   @Override
   public void getTransactionTimeoutScanPeriod(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601148: User {} is getting transaction timeout scan period on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601149, value=\"User {} is querying is-persist-delivery-before-delivery on target resource: {}\", level=INFO)
   @Override
   public void isPersistDeliveryCountBeforeDelivery(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601149: User {} is querying is-persist-delivery-before-delivery on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601150, value=\"User {} is querying is-persist-id-cache on target resource: {}\", level=INFO)
   @Override
   public void isPersistIDCache(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601150: User {} is querying is-persist-id-cache on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601151, value=\"User {} is querying is-wildcard-routing-enabled on target resource: {}\", level=INFO)
   @Override
   public void isWildcardRoutingEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601151: User {} is querying is-wildcard-routing-enabled on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601152, value=\"User {} is adding a user on target resource: {} {}\", level=INFO)
   @Override
   public void addUser(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601152: User {} is adding a user on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601153, value=\"User {} is listing a user on target resource: {} {}\", level=INFO)
   @Override
   public void listUser(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601153: User {} is listing a user on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601154, value=\"User {} is removing a user on target resource: {} {}\", level=INFO)
   @Override
   public void removeUser(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601154: User {} is removing a user on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601155, value=\"User {} is resetting a user on target resource: {} {}\", level=INFO)
   @Override
   public void resetUser(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601155: User {} is resetting a user on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601156, value=\"User {} is getting user property on target resource: {}\", level=INFO)
   @Override
   public void getUser(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601156: User {} is getting user property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601157, value=\"User {} is getting routing type property on target resource: {}\", level=INFO)
   @Override
   public void getRoutingType(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601157: User {} is getting routing type property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601158, value=\"User {} is getting temporary property on target resource: {}\", level=INFO)
   @Override
   public void isTemporary(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601158: User {} is getting temporary property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601159, value=\"User {} is getting persistent size on target resource: {}\", level=INFO)
   @Override
   public void getPersistentSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601159: User {} is getting persistent size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601160, value=\"User {} is getting durable message count on target resource: {}\", level=INFO)
   @Override
   public void getDurableMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601160: User {} is getting durable message count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601161, value=\"User {} is getting durable persist size on target resource: {}\", level=INFO)
   @Override
   public void getDurablePersistSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601161: User {} is getting durable persist size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601162, value=\"User {} is getting consumer count on target resource: {}\", level=INFO)
   @Override
   public void getConsumerCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601162: User {} is getting consumer count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601163, value=\"User {} is getting delivering count on target resource: {}\", level=INFO)
   @Override
   public void getDeliveringCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601163: User {} is getting delivering count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601164, value=\"User {} is getting delivering size on target resource: {}\", level=INFO)
   @Override
   public void getDeliveringSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601164: User {} is getting delivering size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601165, value=\"User {} is getting durable delivering count on target resource: {}\", level=INFO)
   @Override
   public void getDurableDeliveringCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601165: User {} is getting durable delivering count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601166, value=\"User {} is getting durable delivering size on target resource: {}\", level=INFO)
   @Override
   public void getDurableDeliveringSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601166: User {} is getting durable delivering size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601167, value=\"User {} is getting messages added on target resource: {}\", level=INFO)
   @Override
   public void getMessagesAdded(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601167: User {} is getting messages added on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601168, value=\"User {} is getting messages acknowledged on target resource: {}\", level=INFO)
   @Override
   public void getMessagesAcknowledged(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601168: User {} is getting messages acknowledged on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601169, value=\"User {} is getting messages expired on target resource: {}\", level=INFO)
   @Override
   public void getMessagesExpired(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601169: User {} is getting messages expired on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601170, value=\"User {} is getting messages killed on target resource: {}\", level=INFO)
   @Override
   public void getMessagesKilled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601170: User {} is getting messages killed on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601171, value=\"User {} is getting ID on target resource: {}\", level=INFO)
   @Override
   public void getID(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601171: User {} is getting ID on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601172, value=\"User {} is getting scheduled count on target resource: {}\", level=INFO)
   @Override
   public void getScheduledCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601172: User {} is getting scheduled count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601173, value=\"User {} is getting scheduled size on target resource: {}\", level=INFO)
   @Override
   public void getScheduledSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601173: User {} is getting scheduled size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601174, value=\"User {} is getting durable scheduled count on target resource: {}\", level=INFO)
   @Override
   public void getDurableScheduledCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601174: User {} is getting durable scheduled count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601175, value=\"User {} is getting durable scheduled size on target resource: {}\", level=INFO)
   @Override
   public void getDurableScheduledSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601175: User {} is getting durable scheduled size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601176, value=\"User {} is getting dead letter address on target resource: {}\", level=INFO)
   @Override
   public void getDeadLetterAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601176: User {} is getting dead letter address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601177, value=\"User {} is getting expiry address on target resource: {}\", level=INFO)
   @Override
   public void getExpiryAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601177: User {} is getting expiry address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601178, value=\"User {} is getting max consumers on target resource: {}\", level=INFO)
   @Override
   public void getMaxConsumers(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601178: User {} is getting max consumers on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601179, value=\"User {} is getting purge-on-consumers property on target resource: {}\", level=INFO)
   @Override
   public void isPurgeOnNoConsumers(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601179: User {} is getting purge-on-consumers property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601180, value=\"User {} is getting configuration-managed property on target resource: {}\", level=INFO)
   @Override
   public void isConfigurationManaged(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601180: User {} is getting configuration-managed property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601181, value=\"User {} is getting exclusive property on target resource: {}\", level=INFO)
   @Override
   public void isExclusive(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601181: User {} is getting exclusive property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601182, value=\"User {} is getting last-value property on target resource: {}\", level=INFO)
   @Override
   public void isLastValue(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601182: User {} is getting last-value property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601183, value=\"User {} is listing scheduled messages on target resource: {}\", level=INFO)
   @Override
   public void listScheduledMessages(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601183: User {} is listing scheduled messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601184, value=\"User {} is listing scheduled messages as json on target resource: {}\", level=INFO)
   @Override
   public void listScheduledMessagesAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601184: User {} is listing scheduled messages as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601185, value=\"User {} is listing delivering messages on target resource: {}\", level=INFO)
   @Override
   public void listDeliveringMessages(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601185: User {} is listing delivering messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601186, value=\"User {} is listing delivering messages as json on target resource: {}\", level=INFO)
   @Override
   public void listDeliveringMessagesAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601186: User {} is listing delivering messages as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601187, value=\"User {} is listing messages on target resource: {} {}\", level=INFO)
   @Override
   public void listMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601187: User {} is listing messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601188, value=\"User {} is listing messages as json on target resource: {}\", level=INFO)
   @Override
   public void listMessagesAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601188: User {} is listing messages as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601189, value=\"User {} is getting first message on target resource: {}\", level=INFO)
   @Override
   public void getFirstMessage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601189: User {} is getting first message on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601190, value=\"User {} is getting first message as json on target resource: {}\", level=INFO)
   @Override
   public void getFirstMessageAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601190: User {} is getting first message as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601191, value=\"User {} is getting first message's timestamp on target resource: {}\", level=INFO)
   @Override
   public void getFirstMessageTimestamp(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601191: User {} is getting first message's timestamp on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601192, value=\"User {} is getting first message's age on target resource: {}\", level=INFO)
   @Override
   public void getFirstMessageAge(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601192: User {} is getting first message's age on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601193, value=\"User {} is counting messages on target resource: {} {}\", level=INFO)
   @Override
   public void countMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601193: User {} is counting messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601194, value=\"User {} is counting delivery messages on target resource: {} {}\", level=INFO)
   @Override
   public void countDeliveringMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601194: User {} is counting delivery messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601195, value=\"User {} is removing a message on target resource: {} {}\", level=INFO)
   @Override
   public void removeMessage(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601195: User {} is removing a message on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601196, value=\"User {} is removing messages on target resource: {} {}\", level=INFO)
   @Override
   public void removeMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601196: User {} is removing messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601197, value=\"User {} is expiring messages on target resource: {} {}\", level=INFO)
   @Override
   public void expireMessage(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601197: User {} is expiring messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601198, value=\"User {} is expiring messages on target resource: {} {}\", level=INFO)
   @Override
   public void expireMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601198: User {} is expiring messages on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601199, value=\"User {} is retry sending message on target resource: {} {}\", level=INFO)
   @Override
   public void retryMessage(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601199: User {} is retry sending message on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601200, value=\"User {} is retry sending messages on target resource: {}\", level=INFO)
   @Override
   public void retryMessages(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601200: User {} is retry sending messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601201, value=\"User {} is moving a message to another queue on target resource: {} {}\", level=INFO)
   @Override
   public void moveMessage(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601201: User {} is moving a message to another queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601202, value=\"User {} is moving messages to another queue on target resource: {} {}\", level=INFO)
   @Override
   public void moveMessages(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601202: User {} is moving messages to another queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601203, value=\"User {} is sending messages to dead letter address on target resource: {} {}\", level=INFO)
   @Override
   public void sendMessagesToDeadLetterAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601203: User {} is sending messages to dead letter address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601204, value=\"User {} is sending messages to dead letter address on target resource: {} {}\", level=INFO)
   @Override
   public void sendMessageToDeadLetterAddress(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601204: User {} is sending messages to dead letter address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601205, value=\"User {} is changing message's priority on target resource: {} {}\", level=INFO)
   @Override
   public void changeMessagesPriority(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601205: User {} is changing message's priority on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601206, value=\"User {} is changing a message's priority on target resource: {} {}\", level=INFO)
   @Override
   public void changeMessagePriority(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601206: User {} is changing a message's priority on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601207, value=\"User {} is listing message counter on target resource: {}\", level=INFO)
   @Override
   public void listMessageCounter(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601207: User {} is listing message counter on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601208, value=\"User {} is resetting message counter on target resource: {}\", level=INFO)
   @Override
   public void resetMessageCounter(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601208: User {} is resetting message counter on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601209, value=\"User {} is listing message counter as HTML on target resource: {}\", level=INFO)
   @Override
   public void listMessageCounterAsHTML(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601209: User {} is listing message counter as HTML on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601210, value=\"User {} is listing message counter history on target resource: {}\", level=INFO)
   @Override
   public void listMessageCounterHistory(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601210: User {} is listing message counter history on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601211, value=\"User {} is listing message counter history as HTML on target resource: {}\", level=INFO)
   @Override
   public void listMessageCounterHistoryAsHTML(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601211: User {} is listing message counter history as HTML on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601212, value=\"User {} is pausing on target resource: {} {}\", level=INFO)
   @Override
   public void pause(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601212: User {} is pausing on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601213, value=\"User {} is resuming on target resource: {}\", level=INFO)
   @Override
   public void resume(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601213: User {} is resuming on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601214, value=\"User {} is getting paused property on target resource: {}\", level=INFO)
   @Override
   public void isPaused(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601214: User {} is getting paused property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601215, value=\"User {} is browsing a queue on target resource: {} {}\", level=INFO)
   @Override
   public void browse(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601215: User {} is browsing a queue on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601216, value=\"User {} is flushing executor on target resource: {}\", level=INFO)
   @Override
   public void flushExecutor(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601216: User {} is flushing executor on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601217, value=\"User {} is resetting all groups on target resource: {}\", level=INFO)
   @Override
   public void resetAllGroups(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601217: User {} is resetting all groups on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601218, value=\"User {} is resetting group on target resource: {} {}\", level=INFO)
   @Override
   public void resetGroup(java.lang.String user, java.lang.Object source, java.lang.String arg) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601218: User {} is resetting group on target resource: {} {}", user, source, arg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601219, value=\"User {} is getting group count on target resource: {} {}\", level=INFO)
   @Override
   public void getGroupCount(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601219: User {} is getting group count on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601220, value=\"User {} is listing groups as json on target resource: {}\", level=INFO)
   @Override
   public void listGroupsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601220: User {} is listing groups as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601221, value=\"User {} is resetting added messages on target resource: {}\", level=INFO)
   @Override
   public void resetMessagesAdded(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601221: User {} is resetting added messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601222, value=\"User {} is resetting acknowledged messages on target resource: {}\", level=INFO)
   @Override
   public void resetMessagesAcknowledged(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601222: User {} is resetting acknowledged messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601223, value=\"User {} is resetting expired messages on target resource: {}\", level=INFO)
   @Override
   public void resetMessagesExpired(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601223: User {} is resetting expired messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601224, value=\"User {} is resetting killed messages on target resource: {}\", level=INFO)
   @Override
   public void resetMessagesKilled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601224: User {} is resetting killed messages on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601225, value=\"User {} is getting static connectors on target resource: {}\", level=INFO)
   @Override
   public void getStaticConnectors(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601225: User {} is getting static connectors on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601226, value=\"User {} is getting forwarding address on target resource: {}\", level=INFO)
   @Override
   public void getForwardingAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601226: User {} is getting forwarding address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601227, value=\"User {} is getting the queue name on target resource: {}\", level=INFO)
   @Override
   public void getQueueName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601227: User {} is getting the queue name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601228, value=\"User {} is getting discovery group name on target resource: {}\", level=INFO)
   @Override
   public void getDiscoveryGroupName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601228: User {} is getting discovery group name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601229, value=\"User {} is getting filter string on target resource: {}\", level=INFO)
   @Override
   public void getFilterString(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601229: User {} is getting filter string on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601230, value=\"User {} is getting reconnect attempts on target resource: {}\", level=INFO)
   @Override
   public void getReconnectAttempts(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601230: User {} is getting reconnect attempts on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601231, value=\"User {} is getting retry interval on target resource: {}\", level=INFO)
   @Override
   public void getRetryInterval(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601231: User {} is getting retry interval on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601232, value=\"User {} is getting retry interval multiplier on target resource: {}\", level=INFO)
   @Override
   public void getRetryIntervalMultiplier(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601232: User {} is getting retry interval multiplier on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601233, value=\"User {} is getting transformer class name on target resource: {}\", level=INFO)
   @Override
   public void getTransformerClassName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601233: User {} is getting transformer class name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601234, value=\"User {} is getting transformer properties as json on target resource: {}\", level=INFO)
   @Override
   public void getTransformerPropertiesAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601234: User {} is getting transformer properties as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601235, value=\"User {} is getting transformer properties on target resource: {}\", level=INFO)
   @Override
   public void getTransformerProperties(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601235: User {} is getting transformer properties on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601236, value=\"User {} is checking if bridge started on target resource: {}\", level=INFO)
   @Override
   public void isStartedBridge(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601236: User {} is checking if bridge started on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601237, value=\"User {} is querying use duplicate detection on target resource: {}\", level=INFO)
   @Override
   public void isUseDuplicateDetection(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601237: User {} is querying use duplicate detection on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601238, value=\"User {} is querying isHA on target resource: {}\", level=INFO)
   @Override
   public void isHA(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601238: User {} is querying isHA on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601239, value=\"User {} is starting a bridge on target resource: {}\", level=INFO)
   @Override
   public void startBridge(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601239: User {} is starting a bridge on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601240, value=\"User {} is stopping a bridge on target resource: {}\", level=INFO)
   @Override
   public void stopBridge(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601240: User {} is stopping a bridge on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601241, value=\"User {} is getting messages pending acknowledgement on target resource: {}\", level=INFO)
   @Override
   public void getMessagesPendingAcknowledgement(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601241: User {} is getting messages pending acknowledgement on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601242, value=\"User {} is getting metrics on target resource: {}\", level=INFO)
   @Override
   public void getMetrics(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601242: User {} is getting metrics on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601243, value=\"User {} is getting broadcast period on target resource: {}\", level=INFO)
   @Override
   public void getBroadcastPeriod(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601243: User {} is getting broadcast period on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601244, value=\"User {} is getting connector pairs on target resource: {}\", level=INFO)
   @Override
   public void getConnectorPairs(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601244: User {} is getting connector pairs on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601245, value=\"User {} is getting connector pairs as json on target resource: {}\", level=INFO)
   @Override
   public void getConnectorPairsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601245: User {} is getting connector pairs as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601246, value=\"User {} is getting group address on target resource: {}\", level=INFO)
   @Override
   public void getGroupAddress(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601246: User {} is getting group address on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601247, value=\"User {} is getting group port on target resource: {}\", level=INFO)
   @Override
   public void getGroupPort(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601247: User {} is getting group port on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601248, value=\"User {} is getting local binding port on target resource: {}\", level=INFO)
   @Override
   public void getLocalBindPort(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601248: User {} is getting local binding port on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601249, value=\"User {} is starting broadcasting group on target resource: {}\", level=INFO)
   @Override
   public void startBroadcastGroup(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601249: User {} is starting broadcasting group on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601250, value=\"User {} is stopping broadcasting group on target resource: {}\", level=INFO)
   @Override
   public void stopBroadcastGroup(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601250: User {} is stopping broadcasting group on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601251, value=\"User {} is getting max hops on target resource: {}\", level=INFO)
   @Override
   public void getMaxHops(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601251: User {} is getting max hops on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601252, value=\"User {} is getting static connectors as json on target resource: {}\", level=INFO)
   @Override
   public void getStaticConnectorsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601252: User {} is getting static connectors as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601253, value=\"User {} is querying use duplicate detection on target resource: {}\", level=INFO)
   @Override
   public void isDuplicateDetection(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601253: User {} is querying use duplicate detection on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601254, value=\"User {} is getting message loadbalancing type on target resource: {}\", level=INFO)
   @Override
   public void getMessageLoadBalancingType(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601254: User {} is getting message loadbalancing type on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601255, value=\"User {} is getting topology on target resource: {}\", level=INFO)
   @Override
   public void getTopology(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601255: User {} is getting topology on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601256, value=\"User {} is getting nodes on target resource: {}\", level=INFO)
   @Override
   public void getNodes(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601256: User {} is getting nodes on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601257, value=\"User {} is start cluster connection on target resource: {}\", level=INFO)
   @Override
   public void startClusterConnection(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601257: User {} is start cluster connection on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601258, value=\"User {} is stop cluster connection on target resource: {}\", level=INFO)
   @Override
   public void stopClusterConnection(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601258: User {} is stop cluster connection on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601259, value=\"User {} is getting bridge metrics on target resource: {} {}\", level=INFO)
   @Override
   public void getBridgeMetrics(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601259: User {} is getting bridge metrics on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601260, value=\"User {} is getting routing name on target resource: {}\", level=INFO)
   @Override
   public void getRoutingName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601260: User {} is getting routing name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601261, value=\"User {} is getting unique name on target resource: {}\", level=INFO)
   @Override
   public void getUniqueName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601261: User {} is getting unique name on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601262, value=\"User {} is creating address on target resource: {} {}\", level=INFO)
   @Override
   public void serverSessionCreateAddress2(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601262: User {} is creating address on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601263, value=\"User {} is handling a management message on target resource {} {}\", level=INFO)
   @Override
   public void handleManagementMessage2(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601263: User {} is handling a management message on target resource {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601264, value=\"User {} gets security check failure, reason = {}\", level=INFO)
   @Override
   public void securityFailure(java.lang.String user, java.lang.String reason, java.lang.Throwable cause) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601264: User {} gets security check failure, reason = {}", user, reason, cause);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601265, value=\"User {} is creating a core consumer on target resource {} {}\", level=INFO)
   @Override
   public void createCoreConsumer(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601265: User {} is creating a core consumer on target resource {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601266, value=\"User {} is creating a shared queue on target resource {} {}\", level=INFO)
   @Override
   public void createSharedQueue(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601266: User {} is creating a shared queue on target resource {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601267, value=\"User {} is creating a core session on target resource {} {}\", level=INFO)
   @Override
   public void createCoreSession(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601267: User {} is creating a core session on target resource {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601269, value=\"User {} is getting messages acknowledged attempts on target resource: {} {}\", level=INFO)
   @Override
   public void getAcknowledgeAttempts(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601269: User {} is getting messages acknowledged attempts on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601270, value=\"User {} is getting ring size on target resource: {} {}\", level=INFO)
   @Override
   public void getRingSize(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601270: User {} is getting ring size on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601271, value=\"User {} is getting retroactiveResource property on target resource: {}\", level=INFO)
   @Override
   public void isRetroactiveResource(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601271: User {} is getting retroactiveResource property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601272, value=\"User {} is getting disk store usage on target resource: {}\", level=INFO)
   @Override
   public void getDiskStoreUsage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601272: User {} is getting disk store usage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601273, value=\"User {} is getting disk store usage percentage on target resource: {}\", level=INFO)
   @Override
   public void getDiskStoreUsagePercentage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601273: User {} is getting disk store usage percentage on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601274, value=\"User {} is getting group rebalance property on target resource: {}\", level=INFO)
   @Override
   public void isGroupRebalance(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601274: User {} is getting group rebalance property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601275, value=\"User {} is getting group buckets on target resource: {}\", level=INFO)
   @Override
   public void getGroupBuckets(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601275: User {} is getting group buckets on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601276, value=\"User {} is getting group first key on target resource: {}\", level=INFO)
   @Override
   public void getGroupFirstKey(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601276: User {} is getting group first key on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601509, value=\"User {} is getting currentDuplicateIdCacheSize property on target resource: {}\", level=INFO)
   @Override
   public void getCurrentDuplicateIdCacheSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601509: User {} is getting currentDuplicateIdCacheSize property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601510, value=\"User {} is clearing duplicate ID cache on target resource: {}\", level=INFO)
   @Override
   public void clearDuplicateIdCache(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601510: User {} is clearing duplicate ID cache on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601511, value=\"User {} is getting channelName property on target resource: {}\", level=INFO)
   @Override
   public void getChannelName(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601511: User {} is getting channelName property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601512, value=\"User {} is getting fileContents property on target resource: {}\", level=INFO)
   @Override
   public void getFileContents(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601512: User {} is getting fileContents property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601513, value=\"User {} is getting file property on target resource: {}\", level=INFO)
   @Override
   public void getFile(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601513: User {} is getting file property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601514, value=\"User {} is getting preparedTransactionMessageCount property on target resource: {}\", level=INFO)
   @Override
   public void getPreparedTransactionMessageCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601514: User {} is getting preparedTransactionMessageCount property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601500, value=\"User {} sent a message {}, context: {}, transaction: {}\", level=INFO)
   @Override
   public void coreSendMessage(java.lang.String user, java.lang.String messageToString, java.lang.Object context, java.lang.String tx) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601500: User {} sent a message {}, context: {}, transaction: {}", user, messageToString, context, tx);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601501, value=\"User {} is consuming a message from {}: {}\", level=INFO)
   @Override
   public void consumeMessage(java.lang.String user, java.lang.String address, java.lang.String message) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601501: User {} is consuming a message from {}: {}", user, address, message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601502, value=\"User {} acknowledged message from {}: {}, transaction: {}\", level=INFO)
   @Override
   public void coreAcknowledgeMessage(java.lang.String user, java.lang.String queue, java.lang.String message, java.lang.String tx) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601502: User {} acknowledged message from {}: {}, transaction: {}", user, queue, message, tx);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601701, value=\"User {} successfully created address: {} with routing types {}\", level=INFO)
   @Override
   public void createAddressSuccess(java.lang.String user, java.lang.String name, java.lang.String routingTypes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601701: User {} successfully created address: {} with routing types {}", user, name, routingTypes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601702, value=\"User {} failed to created address: {} with routing types {}\", level=INFO)
   @Override
   public void createAddressFailure(java.lang.String user, java.lang.String name, java.lang.String routingTypes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601702: User {} failed to created address: {} with routing types {}", user, name, routingTypes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601703, value=\"User {} successfully updated address: {} with routing types {}\", level=INFO)
   @Override
   public void updateAddressSuccess(java.lang.String user, java.lang.String name, java.lang.String routingTypes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601703: User {} successfully updated address: {} with routing types {}", user, name, routingTypes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601704, value=\"User {} successfully updated address: {} with routing types {}\", level=INFO)
   @Override
   public void updateAddressFailure(java.lang.String user, java.lang.String name, java.lang.String routingTypes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601704: User {} successfully updated address: {} with routing types {}", user, name, routingTypes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601705, value=\"User {} successfully deleted address: {}\", level=INFO)
   @Override
   public void deleteAddressSuccess(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601705: User {} successfully deleted address: {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601706, value=\"User {} failed to deleted address: {}\", level=INFO)
   @Override
   public void deleteAddressFailure(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601706: User {} failed to deleted address: {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601707, value=\"User {} successfully created queue: {} on address: {} with routing type {}\", level=INFO)
   @Override
   public void createQueueSuccess(java.lang.String user, java.lang.String name, java.lang.String address, java.lang.String routingType) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601707: User {} successfully created queue: {} on address: {} with routing type {}", user, name, address, routingType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601708, value=\"User {} failed to create queue: {} on address: {} with routing type {}\", level=INFO)
   @Override
   public void createQueueFailure(java.lang.String user, java.lang.String name, java.lang.String address, java.lang.String routingType) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601708: User {} failed to create queue: {} on address: {} with routing type {}", user, name, address, routingType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601709, value=\"User {} successfully updated queue: {} with routing type {}\", level=INFO)
   @Override
   public void updateQueueSuccess(java.lang.String user, java.lang.String name, java.lang.String routingType) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601709: User {} successfully updated queue: {} with routing type {}", user, name, routingType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601710, value=\"User {} failed to update queue: {} with routing type {}\", level=INFO)
   @Override
   public void updateQueueFailure(java.lang.String user, java.lang.String name, java.lang.String routingType) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601710: User {} failed to update queue: {} with routing type {}", user, name, routingType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601711, value=\"User {} successfully deleted queue: {}\", level=INFO)
   @Override
   public void destroyQueueSuccess(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601711: User {} successfully deleted queue: {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601712, value=\"User {} failed to delete queue: {}\", level=INFO)
   @Override
   public void destroyQueueFailure(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601712: User {} failed to delete queue: {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601713, value=\"User {} has removed {} messages from queue: {}\", level=INFO)
   @Override
   public void removeMessagesSuccess(java.lang.String user, int removed, java.lang.String queue) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601713: User {} has removed {} messages from queue: {}", user, removed, queue);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601714, value=\"User {} failed to remove messages from queue: {}\", level=INFO)
   @Override
   public void removeMessagesFailure(java.lang.String user, java.lang.String queue) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601714: User {} failed to remove messages from queue: {}", user, queue);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601715, value=\"User {} successfully authenticated on connection {}\", level=INFO)
   @Override
   public void userSuccesfullyAuthenticated(java.lang.String caller, java.lang.String connectionID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601715: User {} successfully authenticated on connection {}", caller, connectionID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601716, value=\"User {} failed authentication on connection {}, reason: {}\", level=INFO)
   @Override
   public void userFailedAuthentication(java.lang.String user, java.lang.String connectionID, java.lang.String reason) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601716: User {} failed authentication on connection {}, reason: {}", user, connectionID, reason);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601717, value=\"User {} accessed {} on management object {}\", level=INFO)
   @Override
   public void objectInvokedSuccessfully(java.lang.String caller, javax.management.ObjectName objectName, java.lang.String operationName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601717: User {} accessed {} on management object {}", caller, objectName, operationName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601718, value=\"User {} does not have correct role to access {} on management object {}\", level=INFO)
   @Override
   public void objectInvokedFailure(java.lang.String caller, javax.management.ObjectName objectName, java.lang.String operationName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601718: User {} does not have correct role to access {} on management object {}", caller, objectName, operationName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601719, value=\"User {} has paused queue {}\", level=INFO)
   @Override
   public void pauseQueueSuccess(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601719: User {} has paused queue {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601720, value=\"User {} failed to pause queue {}\", level=INFO)
   @Override
   public void pauseQueueFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601720: User {} failed to pause queue {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601721, value=\"User {} has resumed queue {}\", level=INFO)
   @Override
   public void resumeQueueSuccess(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601721: User {} has resumed queue {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601722, value=\"User {} failed to resume queue {}\", level=INFO)
   @Override
   public void resumeQueueFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601722: User {} failed to resume queue {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601723, value=\"User {} sent message to {} as user {}\", level=INFO)
   @Override
   public void sendMessageSuccess(java.lang.String user, java.lang.String queueName, java.lang.String sendUser) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601723: User {} sent message to {} as user {}", user, queueName, sendUser);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601724, value=\"User {} failed to send message to {} as user {}\", level=INFO)
   @Override
   public void sendMessageFailure(java.lang.String user, java.lang.String queueName, java.lang.String sendUser) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601724: User {} failed to send message to {} as user {}", user, queueName, sendUser);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601725, value=\"User {} browsed {} messages from queue {}\", level=INFO)
   @Override
   public void browseMessagesSuccess(java.lang.String user, int numMessages, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601725: User {} browsed {} messages from queue {}", user, numMessages, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601726, value=\"User {} failed to browse messages from queue {}\", level=INFO)
   @Override
   public void browseMessagesFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601726: User {} failed to browse messages from queue {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601727, value=\"User {} is updating a divert on target resource: {} {}\", level=INFO)
   @Override
   public void updateDivert(java.lang.String user, java.lang.Object source, java.lang.String arg) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601727: User {} is updating a divert on target resource: {} {}", user, source, arg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601728, value=\"User {} is getting enabled property on target resource: {}\", level=INFO)
   @Override
   public void isEnabled(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601728: User {} is getting enabled property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601729, value=\"User {} is disabling on target resource: {} {}\", level=INFO)
   @Override
   public void disable(java.lang.String user, java.lang.Object source, java.lang.String arg) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601729: User {} is disabling on target resource: {} {}", user, source, arg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601730, value=\"User {} is enabling on target resource: {}\", level=INFO)
   @Override
   public void enable(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601730: User {} is enabling on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601731, value=\"User {} has paused address {}\", level=INFO)
   @Override
   public void pauseAddressSuccess(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601731: User {} has paused address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601732, value=\"User {} failed to pause address {}\", level=INFO)
   @Override
   public void pauseAddressFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601732: User {} failed to pause address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601733, value=\"User {} has resumed address {}\", level=INFO)
   @Override
   public void resumeAddressSuccess(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601733: User {} has resumed address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601734, value=\"User {} failed to resume address {}\", level=INFO)
   @Override
   public void resumeAddressFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601734: User {} failed to resume address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601735, value=\"User {} is getting group rebalance pause dispatch property on target resource: {}\", level=INFO)
   @Override
   public void isGroupRebalancePauseDispatch(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601735: User {} is getting group rebalance pause dispatch property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601736, value=\"User {} is getting authentication cache size on target resource: {}\", level=INFO)
   @Override
   public void getAuthenticationCacheSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601736: User {} is getting authentication cache size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601737, value=\"User {} is getting authorization cache size on target resource: {}\", level=INFO)
   @Override
   public void getAuthorizationCacheSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601737: User {} is getting authorization cache size on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601738, value=\"User {} is requesting a list of broker connections\", level=INFO)
   @Override
   public void listBrokerConnections(java.lang.String user) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601738: User {} is requesting a list of broker connections", user);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601739, value=\"User {} is requesting to stop broker connection {}\", level=INFO)
   @Override
   public void stopBrokerConnection(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601739: User {} is requesting to stop broker connection {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601740, value=\"User {} is requesting to start broker connection {}\", level=INFO)
   @Override
   public void startBrokerConnection(java.lang.String user, java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601740: User {} is requesting to start broker connection {}", user, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601741, value=\"User {} is getting address count on target resource: {}\", level=INFO)
   @Override
   public void getAddressCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601741: User {} is getting address count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601742, value=\"User {} is getting the queue count on target resource: {}\", level=INFO)
   @Override
   public void getQueueCount(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601742: User {} is getting the queue count on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601743, value=\"User {} is getting last-value-key property on target resource: {}\", level=INFO)
   @Override
   public void lastValueKey(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601743: User {} is getting last-value-key property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601744, value=\"User {} is getting consumers-before-dispatch property on target resource: {}\", level=INFO)
   @Override
   public void consumersBeforeDispatch(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601744: User {} is getting consumers-before-dispatch property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601745, value=\"User {} is getting delay-before-dispatch property on target resource: {}\", level=INFO)
   @Override
   public void delayBeforeDispatch(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601745: User {} is getting delay-before-dispatch property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601746, value=\"User {} is getting internal property on target resource: {}\", level=INFO)
   @Override
   public void isInternal(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601746: User {} is getting internal property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601747, value=\"User {} is getting auto-created property on target resource: {}\", level=INFO)
   @Override
   public void isAutoCreated(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601747: User {} is getting auto-created property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601748, value=\"User {} is getting max retry interval on target resource: {}\", level=INFO)
   @Override
   public void getMaxRetryInterval(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601748: User {} is getting max retry interval on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601749, value=\"User {} is getting activation sequence on target resource: {}\", level=INFO)
   @Override
   public void getActivationSequence(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601749: User {} is getting activation sequence on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601750, value=\"User {} is purging target resource: {}\", level=INFO)
   @Override
   public void purge(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601750: User {} is purging target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601751, value=\"User {} has purged address {}\", level=INFO)
   @Override
   public void purgeAddressSuccess(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601751: User {} has purged address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601752, value=\"User {} failed to purge address {}\", level=INFO)
   @Override
   public void purgeAddressFailure(java.lang.String user, java.lang.String queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601752: User {} failed to purge address {}", user, queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601753, value=\"User {} is getting address limit %  on target resource: {}\", level=INFO)
   @Override
   public void getAddressLimitPercent(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601753: User {} is getting address limit %  on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601754, value=\"User {} is blocking target resource: {}\", level=INFO)
   @Override
   public void block(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601754: User {} is blocking target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601755, value=\"User {} is unblocking target resource: {}\", level=INFO)
   @Override
   public void unBlock(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601755: User {} is unblocking target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601756, value=\"User {} is getting acceptors on target resource: {}\", level=INFO)
   @Override
   public void getAcceptors(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601756: User {} is getting acceptors on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601757, value=\"User {} is getting acceptors as json on target resource: {}\", level=INFO)
   @Override
   public void getAcceptorsAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601757: User {} is getting acceptors as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601758, value=\"User {} is calling schedulePageCleanup on address: {}\", level=INFO)
   @Override
   public void schedulePageCleanup(java.lang.String user, java.lang.Object address) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601758: User {} is calling schedulePageCleanup on address: {}", user, address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601759, value=\"User {} added acknowledgement of a message from {}: {} to transaction: {}\", level=INFO)
   @Override
   public void addAckToTransaction(java.lang.String user, java.lang.String queue, java.lang.String message, java.lang.String tx) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601759: User {} added acknowledgement of a message from {}: {} to transaction: {}", user, queue, message, tx);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601760, value=\"User {} added a message send for: {} to transaction: {}\", level=INFO)
   @Override
   public void addSendToTransaction(java.lang.String user, java.lang.String messageToString, java.lang.String tx) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601760: User {} added a message send for: {} to transaction: {}", user, messageToString, tx);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601761, value=\"User {} rolled back transaction {} involving {}\", level=INFO)
   @Override
   public void rolledBackTransaction(java.lang.String user, java.lang.String tx, java.lang.String resource) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601761: User {} rolled back transaction {} involving {}", user, tx, resource);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601762, value=\"User {} is adding a connector on target resource: {} {}\", level=INFO)
   @Override
   public void addConnector(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601762: User {} is adding a connector on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601763, value=\"User {} is removing a connector on target resource: {} {}\", level=INFO)
   @Override
   public void removeConnector(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601763: User {} is removing a connector on target resource: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601764, value=\"User {} is calling deliverScheduledMessage on queue: {} {}\", level=INFO)
   @Override
   public void deliverScheduledMessage(java.lang.String user, java.lang.Object source, java.lang.String args) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601764: User {} is calling deliverScheduledMessage on queue: {} {}", user, source, args);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601765, value=\"User {} is getting status on target resource: {}\", level=INFO)
   @Override
   public void getStatus(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601765: User {} is getting status on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601766, value=\"User {} is getting auto-delete property on target resource: {}\", level=INFO)
   @Override
   public void isAutoDelete(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601766: User {} is getting auto-delete property on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601767, value=\"{} connection {} for user {} created\", level=INFO)
   @Override
   public void createdConnection(java.lang.String protocol, java.lang.String connectionID, java.lang.String user) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601767: {} connection {} for user {} created", protocol, connectionID, user);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601768, value=\"{} connection {} for user {} destroyed\", level=INFO)
   @Override
   public void destroyedConnection(java.lang.String protocol, java.lang.String connectionID, java.lang.String user) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601768: {} connection {} for user {} destroyed", protocol, connectionID, user);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601769, value=\"User {} is clearing authentication cache on target resource: {}\", level=INFO)
   @Override
   public void clearAuthenticationCache(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601769: User {} is clearing authentication cache on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601770, value=\"User {} is clearing authorization cache on target resource: {}\", level=INFO)
   @Override
   public void clearAuthorizationCache(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601770: User {} is clearing authorization cache on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601771, value=\"User {} is getting name on target resource: {}\", level=INFO)
   @Override
   public void getCurrentTimeMillis(java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601771: User {} is getting name on target resource: {}", source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601772, value=\"User {} is getting producerWindowSize on target resource: {}\", level=INFO)
   @Override
   public void getProducerWindowSize(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601772: User {} is getting producerWindowSize on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601773, value=\"User {} is getting first scheduled message on target resource: {}\", level=INFO)
   @Override
   public void peekFirstScheduledMessage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601773: User {} is getting first scheduled message on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601774, value=\"User {} is getting first scheduled message as json on target resource: {}\", level=INFO)
   @Override
   public void peekFirstScheduledMessageAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601774: User {} is getting first scheduled message as json on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601775, value=\"User {} is getting first message on target resource: {}\", level=INFO)
   @Override
   public void peekFirstMessage(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601775: User {} is getting first message on target resource: {}", user, source);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=601776, value=\"User {} is getting first message as json on target resource: {}\", level=INFO)
   @Override
   public void peekFirstMessageAsJSON(java.lang.String user, java.lang.Object source) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ601776: User {} is getting first message as json on target resource: {}", user, source);
      }
   }

}
