/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.jboss.logging.Logger;

public class CriticalMeasure {
    private static final Logger logger = Logger.getLogger(CriticalMeasure.class);
    private volatile Exception traceEnter;
    static final AtomicIntegerFieldUpdater<CriticalMeasure> CURRENT_MEASURING = AtomicIntegerFieldUpdater.newUpdater(CriticalMeasure.class, "measuring");
    private final CriticalCloseable autoCloseable = new CriticalCloseable(){
        ArtemisCloseable beforeClose;

        @Override
        public void beforeClose(ArtemisCloseable closeable) {
            this.beforeClose = closeable;
        }

        @Override
        public void close() {
            try {
                if (this.beforeClose != null) {
                    this.beforeClose.close();
                    this.beforeClose = null;
                }
            }
            finally {
                CriticalMeasure.this.leaveCritical();
                CURRENT_MEASURING.set(CriticalMeasure.this, 0);
            }
        }
    };
    protected static final CriticalCloseable dummyCloseable = new CriticalCloseable(){

        @Override
        public void beforeClose(ArtemisCloseable runnable) {
            throw new IllegalStateException("The dummy closeable does not support beforeClose. Check before CriticalMeasure.isDummy(closeable) before you call beforeClose(runnable)");
        }

        @Override
        public void close() {
        }
    };
    protected volatile int measuring;
    protected volatile long timeEnter;
    private final int id;
    private final CriticalComponent component;

    public static boolean isDummy(ArtemisCloseable closeable) {
        return closeable == dummyCloseable;
    }

    public CriticalMeasure(CriticalComponent component, int id) {
        this.id = id;
        this.component = component;
        this.timeEnter = 0L;
    }

    public CriticalCloseable measure() {
        if (CURRENT_MEASURING.compareAndSet(this, 0, 1)) {
            this.enterCritical();
            return this.autoCloseable;
        }
        return dummyCloseable;
    }

    protected void enterCritical() {
        this.timeEnter = System.nanoTime();
        if (logger.isTraceEnabled()) {
            this.traceEnter = new Exception("entered");
        }
    }

    protected void leaveCritical() {
        if (logger.isTraceEnabled()) {
            long nanoTimeout;
            CriticalAnalyzer analyzer;
            CriticalAnalyzer criticalAnalyzer = analyzer = this.component != null ? this.component.getCriticalAnalyzer() : null;
            if (analyzer != null && this.checkExpiration(nanoTimeout = analyzer.getTimeoutNanoSeconds(), false)) {
                logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, leaving at"), (Throwable)new Exception("left"));
                logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, entered at"), (Throwable)this.traceEnter);
            }
            this.traceEnter = null;
        }
        this.timeEnter = 0L;
    }

    protected String getComponentName() {
        if (this.component == null) {
            return "null";
        }
        return this.component.getClass().getName();
    }

    public boolean checkExpiration(long timeout, boolean reset) {
        long thisTimeEnter = this.timeEnter;
        if (thisTimeEnter != 0L) {
            boolean expired;
            long time = System.nanoTime();
            boolean bl = expired = time - thisTimeEnter > timeout;
            if (expired) {
                Exception lastTraceEnter = this.traceEnter;
                if (lastTraceEnter != null) {
                    logger.warn((Object)("Component " + this.getComponentName() + " is expired on path " + this.id), (Throwable)lastTraceEnter);
                } else {
                    logger.warn((Object)("Component " + this.getComponentName() + " is expired on path " + this.id));
                }
                if (reset) {
                    this.timeEnter = 0L;
                }
            }
            return expired;
        }
        return false;
    }
}

