/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPRemoteBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationCapabilities;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationManagementSupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;

public class AMQPFederationTarget
extends AMQPFederation {
    private final AMQPRemoteBrokerConnection brokerConnection;
    private final AMQPConnectionContext connection;
    private final AMQPFederationConfiguration configuration;
    private final AMQPFederationCapabilities capabilities;

    public AMQPFederationTarget(AMQPRemoteBrokerConnection brokerConnection, String name, AMQPFederationConfiguration configuration, AMQPFederationCapabilities capabilities, AMQPSessionContext session) {
        super(name, brokerConnection.getServer());
        Objects.requireNonNull(session, "Provided session instance cannot be null");
        this.brokerConnection = brokerConnection;
        this.session = session;
        this.connection = session.getAMQPConnectionContext();
        this.connection.addLinkRemoteCloseListener(this.getName(), this::handleLinkRemoteClose);
        this.configuration = configuration;
        this.capabilities = capabilities;
        this.connected = true;
    }

    @Override
    public AMQPConnectionContext getConnectionContext() {
        return this.connection;
    }

    @Override
    public AMQPFederationCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public AMQPSessionContext getSessionContext() {
        return this.session;
    }

    @Override
    public synchronized AMQPFederationConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void handleFederationInitialized() throws ActiveMQException {
        try {
            this.session.getSessionSPI().addMetaData("federation-name", this.getName());
        }
        catch (ActiveMQAMQPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActiveMQAMQPInternalErrorException("Error while configuring internal session metadata");
        }
        super.handleFederationInitialized();
    }

    private void handleLinkRemoteClose(Link link) {
        Connection protonConnection = link.getSession().getConnection();
        if (protonConnection.getLocalState() != EndpointState.ACTIVE) {
            return;
        }
        if (link.getLocalState() != EndpointState.ACTIVE) {
            return;
        }
        if (!this.invokeLinkClosedInterceptors(link)) {
            this.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Federation link closed unexpectedly: " + link.getName())));
        }
    }

    @Override
    protected void signalResourceCreateError(Exception cause) {
        this.signalError(cause);
    }

    @Override
    protected void signalError(Exception cause) {
        Symbol condition;
        String description = cause.getMessage();
        if (cause instanceof ActiveMQAMQPException) {
            ActiveMQAMQPException exception = (ActiveMQAMQPException)((Object)cause);
            condition = exception.getAmqpError();
        } else {
            condition = AmqpError.INTERNAL_ERROR;
        }
        this.connected = false;
        this.connection.close(new ErrorCondition(condition, description));
    }

    @Override
    void registerFederationManagement() throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.registerFederationTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), this);
        }
    }

    @Override
    void unregisterFederationManagement() throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.unregisterFederationTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), this);
        }
    }

    @Override
    void registerLocalPolicyManagement(AMQPFederationLocalPolicyManager manager) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.registerLocalPolicyOnTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), manager);
        }
    }

    @Override
    void unregisterLocalPolicyManagement(AMQPFederationLocalPolicyManager manager) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.unregisterLocalPolicyOnTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), manager);
        }
    }

    @Override
    void registerRemotePolicyManagement(AMQPFederationRemotePolicyManager manager) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.registerRemotePolicyOnTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), manager);
        }
    }

    @Override
    void unregisterRemotePolicyManagement(AMQPFederationRemotePolicyManager manager) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.unregisterRemotePolicyOnTarget(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), manager);
        }
    }

    @Override
    void registerFederationConsumerManagement(AMQPFederationConsumer consumer) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.registerFederationTargetConsumer(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), consumer);
        }
    }

    @Override
    void unregisterFederationConsumerManagement(AMQPFederationConsumer consumer) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.unregisterFederationTargetConsumer(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), consumer);
        }
    }

    @Override
    void registerFederationProducerManagement(AMQPFederationSenderController sender) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.registerFederationTargetProducer(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), sender);
        }
    }

    @Override
    void unregisterFederationProducerManagement(AMQPFederationSenderController sender) throws Exception {
        if (this.brokerConnection.isManagable()) {
            AMQPFederationManagementSupport.unregisterFederationTargetProducer(this.brokerConnection.getNodeId(), this.brokerConnection.getName(), sender);
        }
    }
}

