/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromResourcePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationType;

public class FederationReceiveFromAddressPolicy
implements FederationReceiveFromResourcePolicy,
BiPredicate<String, RoutingType> {
    private final Set<AddressMatcher> includesMatchers = new LinkedHashSet<AddressMatcher>();
    private final Set<AddressMatcher> excludesMatchers = new LinkedHashSet<AddressMatcher>();
    private final Collection<String> includes;
    private final Collection<String> excludes;
    private final String policyName;
    private final boolean autoDelete;
    private final long autoDeleteDelay;
    private final long autoDeleteMessageCount;
    private final int maxHops;
    private final boolean enableDivertBindings;
    private final Map<String, Object> properties;
    private final TransformerConfiguration transformerConfig;

    public FederationReceiveFromAddressPolicy(String name, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, int maxHops, boolean enableDivertBindings, Collection<String> includeAddresses, Collection<String> excludeAddresses, Map<String, Object> properties, TransformerConfiguration transformerConfig, WildcardConfiguration wildcardConfig) {
        Objects.requireNonNull(name, "The provided policy name cannot be null");
        Objects.requireNonNull(wildcardConfig, "The provided wild card configuration cannot be null");
        this.policyName = name;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.maxHops = maxHops;
        this.enableDivertBindings = enableDivertBindings;
        this.transformerConfig = transformerConfig;
        this.includes = Collections.unmodifiableCollection(includeAddresses == null ? Collections.EMPTY_LIST : includeAddresses);
        this.excludes = Collections.unmodifiableCollection(excludeAddresses == null ? Collections.EMPTY_LIST : excludeAddresses);
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        this.includes.forEach(address -> this.includesMatchers.add(new AddressMatcher((String)address, wildcardConfig)));
        this.excludes.forEach(address -> this.excludesMatchers.add(new AddressMatcher((String)address, wildcardConfig)));
    }

    @Override
    public FederationType getPolicyType() {
        return FederationType.ADDRESS_FEDERATION;
    }

    @Override
    public String getPolicyName() {
        return this.policyName;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public boolean isEnableDivertBindings() {
        return this.enableDivertBindings;
    }

    public Collection<String> getIncludes() {
        return this.includes;
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    public boolean test(AddressInfo addressInfo) {
        if (addressInfo != null) {
            return this.test(addressInfo.getName().toString(), addressInfo.getRoutingType());
        }
        return false;
    }

    @Override
    public boolean test(String address, RoutingType type) {
        if (RoutingType.MULTICAST.equals((Object)type)) {
            for (AddressMatcher matcher : this.excludesMatchers) {
                if (!matcher.test(address)) continue;
                return false;
            }
            for (AddressMatcher matcher : this.includesMatchers) {
                if (!matcher.test(address)) continue;
                return true;
            }
        }
        return false;
    }

    private static class AddressMatcher
    implements Predicate<String> {
        private final Predicate<String> matcher;

        AddressMatcher(String address, WildcardConfiguration wildcardConfig) {
            this.matcher = address == null || address.isEmpty() ? target -> true : new Match(address, null, wildcardConfig).getPattern().asPredicate();
        }

        @Override
        public boolean test(String address) {
            return this.matcher.test(address);
        }
    }
}

