/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramServerFunctionality;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramServerFunctionalityImpl;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;
import org.apache.activemq.artemis.spi.core.security.scram.UserData;

public abstract class SCRAMServerSASL
implements ServerSASL {
    protected final ScramServerFunctionality scram;
    protected final SCRAM mechanism;
    private SASLResult result;

    public SCRAMServerSASL(SCRAM mechanism) throws NoSuchAlgorithmException {
        this(mechanism, UUID.randomUUID().toString());
    }

    protected SCRAMServerSASL(SCRAM mechanism, String nonce) throws NoSuchAlgorithmException {
        this.mechanism = mechanism;
        this.scram = new ScramServerFunctionalityImpl(mechanism.getDigest(), mechanism.getHmac(), nonce);
    }

    @Override
    public String getName() {
        return this.mechanism.getName();
    }

    @Override
    public byte[] processSASL(byte[] bytes) {
        String message = new String(bytes, StandardCharsets.US_ASCII);
        try {
            switch (this.scram.getState()) {
                case INITIAL: {
                    String userName = this.scram.handleClientFirstMessage(message);
                    UserData userData = this.aquireUserData(userName);
                    this.result = new SCRAMSASLResult(userName, this.scram, this.createSaslSubject(userName, userData));
                    String challenge = this.scram.prepareFirstMessage(userData);
                    return challenge.getBytes(StandardCharsets.US_ASCII);
                }
                case PREPARED_FIRST: {
                    String finalMessage = this.scram.prepareFinalMessage(message);
                    return finalMessage.getBytes(StandardCharsets.US_ASCII);
                }
            }
            this.result = new SCRAMFailedSASLResult();
        }
        catch (RuntimeException | GeneralSecurityException | ScramException e) {
            this.result = new SCRAMFailedSASLResult();
            this.failed((Exception)e);
        }
        return null;
    }

    protected abstract UserData aquireUserData(String var1) throws LoginException;

    protected abstract void failed(Exception var1);

    protected Subject createSaslSubject(String userName, UserData userData) {
        UserPrincipal userPrincipal = new UserPrincipal(userName);
        Subject saslSubject = new Subject(true, Collections.singleton(userPrincipal), Collections.singleton(userData), Collections.emptySet());
        return saslSubject;
    }

    @Override
    public SASLResult result() {
        if (this.result instanceof SCRAMSASLResult) {
            return this.scram.isEnded() ? this.result : null;
        }
        return this.result;
    }

    public boolean isEnded() {
        return this.scram.isEnded();
    }

    private static final class SCRAMFailedSASLResult
    implements SASLResult {
        private SCRAMFailedSASLResult() {
        }

        @Override
        public String getUser() {
            return null;
        }

        @Override
        public Subject getSubject() {
            return null;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        public String toString() {
            return "SCRAMFailedSASLResult";
        }
    }

    private static final class SCRAMSASLResult
    implements SASLResult {
        private final String userName;
        private final ScramServerFunctionality scram;
        private final Subject subject;

        SCRAMSASLResult(String userName, ScramServerFunctionality scram, Subject subject) {
            this.userName = userName;
            this.scram = scram;
            this.subject = subject;
        }

        @Override
        public String getUser() {
            return this.userName;
        }

        @Override
        public Subject getSubject() {
            return this.subject;
        }

        @Override
        public boolean isSuccess() {
            return this.userName != null && this.scram.isEnded() && this.scram.isSuccessful();
        }

        public String toString() {
            return "SCRAMSASLResult: userName = " + this.userName + ", state = " + this.scram.getState();
        }
    }
}

