/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPTunneledCoreMessageWriter
implements MessageWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final byte DATA_DESCRIPTOR = 117;
    private static final int DATA_SECTION_ENCODING_BYTES = 8;
    private final ProtonServerSenderContext serverSender;
    private final Sender protonSender;

    public AMQPTunneledCoreMessageWriter(ProtonServerSenderContext serverSender) {
        this.serverSender = serverSender;
        this.protonSender = serverSender.getSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(MessageReference messageReference) {
        if (this.protonSender.getLocalState() == EndpointState.CLOSED) {
            logger.debug("Not delivering message {} as the sender is closed and credits were available, if you see too many of these it means clients are issuing credits and closing the connection with pending credits a lot of times", (Object)messageReference);
            return;
        }
        try {
            ICoreMessage message = (ICoreMessage)messageReference.getMessage();
            int encodedSize = message.getPersistSize();
            ByteBuf buffer = Unpooled.buffer((int)(encodedSize + 8));
            Delivery delivery = this.serverSender.createDelivery(messageReference, 1183580416);
            DeliveryAnnotations annotations = (DeliveryAnnotations)messageReference.getProtocolData(DeliveryAnnotations.class);
            if (annotations != null && annotations.getValue() != null && annotations.getValue().size() > 0) {
                EncoderImpl encoder = TLSEncode.getEncoder();
                try {
                    encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
                    encoder.writeObject((Object)annotations);
                }
                finally {
                    encoder.setByteBuffer((WritableBuffer)null);
                }
            }
            buffer.writeByte(0);
            buffer.writeByte(83);
            buffer.writeByte(117);
            buffer.writeByte(-80);
            buffer.writeInt(encodedSize);
            ActiveMQBuffer bufferWrapper = ActiveMQBuffers.wrappedBuffer((ByteBuf)buffer);
            message.persist(bufferWrapper);
            buffer.writerIndex(buffer.writerIndex() + encodedSize);
            this.protonSender.sendNoCopy((ReadableBuffer)new ReadableBuffer.ByteBufferReader(buffer.nioBuffer()));
            this.serverSender.reportDeliveryComplete(this, messageReference, delivery, false);
        }
        catch (Exception deliveryError) {
            this.serverSender.reportDeliveryError(this, messageReference, deliveryError);
        }
    }
}

